{ MULKEY.INC }

{ Hidden constants and types for Mulkey }

CONST
      { --------------------- Btrieve Operation Codes ----------------------- }

                                   { Operation codes sent to Btrieve          }
                                   { ---------------------------------------- }
      AbortTransactionOp   = 21;   { Removes all operations performed since   }
                                   {  the beginning of an active transaction  }
                                   {  and terminates the transaction          }
      BeginTransactionOp   = 19;   { Marks the beginning of a set of          }
                                   {  related Btrieve operations              }
      ClearOwnerOp         = 30;   { Removes the owner name associated with a }
                                   {  Btrieve file                            }
      CloseOp              = 1;    { Closes a Btrieve file                    }
      CreateOp             = 14;   { Creates a Btrieve file                   }
      DeleteOp             = 4;    { Removes an existing record from a file   }
      EndTransactionOp     = 20;   { Completes a transaction and makes the    }
                                   {  appropriate changes to affected files   }
      ExtendOp             = 16;   { Divides a file over two logical drives   }
      GetDirectOp          = 23;   { Retrieves the data record positioned at  }
                                   { a specified physical address in the file }
      GetEqualOp           = 5;    { Retrieves a record corresponding to a    }
                                   {  specific key value                      }
      GetGreaterOp         = 8;    { Retrieves a record corresponding to a    }
                                   {  key value greater than that specified   }
      GetGreaterOrEqualOp  = 9;    { Retrieves a record corresponding to a    }
                                   {  key value greater or equal to the value }
                                   {  specified                               }
      GetHighestOp         = 13;   { Retrieves the record corresponding to    }
                                   {  the highest key value in the file       }
      GetKeyOp             = 50;   { Retrieves only the key information*      }
      GetLessThanOp        = 10;   { Retireves a record corresponding to a    }
                                   {  key value less than that specified      }
      GetLessThanOrEqualOp = 11;   { Retireves a record with a key value less }
                                   {  than or equal to that specified         }
      GetLowestOp          = 12;   { Retrieves the record corresponding to    }
                                   {  lowest key value for that key number    }
      GetNextOp            = 6;    { Retrieves the record which follows the   }
                                   {  current record                          }
      GetPositionOp        = 22;   { Returns the physical position of the     }
                                   {  current record                          }
      GetPreviousOp        = 7;    { Retrieves the record which precedes the  }
                                   {  current record                          }
      InsertOp             = 2;    { Inserts a record into a Btrieve file     }
      OpenOp               = 0;    { Opens a Btrieve file                     }
      ResetOp              = 28;   { Releases all resources held by a station }
      SetOwnerOp           = 29;   { Assigns an owner name to a Btrieve file  }
      StatOp               = 15;   { Retrieves the characteristics of a file  }
      StepDirectOp         = 24;   { Retrieves a record in the location       }
                                   {  physically following the current record }
      UnlockOp             = 27;   { Unlocks records previously locked        }
      UpdateOp             = 3;    { Updates an existing record in a file     }
      VersionOp            = 26;   { Returns the current Btrieve version      }

      { ----------------------- Bit Number Constants ------------------------ }

                                   { File Flags Constants                     }
                                   { ---------------------------------------- }
      VarLenRecsBit        = 0;    { Allow variable length records            }
      BlankCompressBit     = 1;    { Perform blank compression on above       }
      PreAllocateBit       = 2;    { Pre-allocate # pages in Allocation word  }

                                   { Key Flags Constants                      }
                                   { ---------------------------------------- }
      AllowDupsBit         = 0;    { Allow duplicate key values               }
      ModifiableBit        = 1;    { Key is modifiable                        }
                                   { Bit 2 is ignored by Btrieve under Mulkey }
      NullValueBit         = 3;    { Key has null value                       }
      SegmentedBit         = 4;    { Key has another segment following        }
      AltColSeqBit         = 5;    { Key uses alternate collating sequence    }
      DescendingSortBit    = 6;    { Key is sorting in descending sequence    }
      SupplementalIndexBit = 7;    { Key is supplemental index - ret by stat  }
      ExtendedTypeBit      = 8;    { Key is extended type - always in Mulkey  }

                                   { Owner Flags Constants                    }
                                   { ---------------------------------------- }
      ReadOnlyAccessBit    = 0;    { Allow read only access without owner     }
      EncryptBit           = 1;    { Encrypts the data in the file by owner   }

      { -------------------- Btrieve Open Mode Constants -------------------- }

                                   { Values to send the open procedure        }
                                   { ---------------------------------------- }
      NormalOpen           = 0;    { Normal value to open a Btrieve file      }
      AcceleratedOpen      = -1;   { Accelerated mode - defeats the automatic }
                                   {  data recovery mode in Btrieve           }
      ReadOnlyOpen         = -2;   { Allows opening a damaged file for reads  }
      DOSVerifyOpen        = -3;   { Same as normal but forces DOS verify on  }
      ExclusiveOpen        = -4;   { Same as normal but locks entire file     }

      { -------------------- Extended Key Types Constants ------------------- }

                                   { Type of Key (KeyType in KeySpecType)     }
                                   { Mulkey uses only the extended key types, }
                                   {  for more info see MULKEY.DOC            }
                                   { ---------------------------------------- }
      ArrayCharKey         = 0;    { Array of character     1-255 bytes       }
      SignedIntKey         = 1;    { Signed whole number    Even # of bytes   }
      FloatKey             = 2;    { IEEE floating point    4 or 8            }
      DateKey              = 3;    { Date                   4 bytes           }
      TimeKey              = 4;    { Time                   4 bytes           }
      DecimalKey           = 5;    { semi-BCD               1-?? (variable)   }
      MoneyKey             = 6;    { same as Decimal        1-?? (variable)   }
      LogicalKey           = 7;    { Logical key            1 or 2 bytes      }
      NumericKey           = 8;    { Numeric                1-255 variable    }
      BFloatKey            = 9;    { Old Microsoft float    4 or 8 bytes      }
      lStringKey           = 10;   { Pascal string          1-254 (255) bytes }
      NullStringKey        = 11;   { Null terminated string 1-255 bytes       }
      UnsignedIntKey       = 14;   { Unsigned whole number  Even # of bytes   }

      { -------------------- Mulkey version 3.01A --------------------------- }

                                    { Version Control Constants               }
                                    { --------------------------------------- }
      MajorVersion  = 3;            { This version of Mulkey - major version  }
      MinorVersion  = 2;            { This version of Mulkey - minor version  }
      Revision      = 'A';          { The revision (file layout version)      }
      MulkeyDate    = '5-17-1988';  { The date of the release                 }
      FileVersion   = 'MULKEY';     { The file layout version (owner of file) }

      { When opening the master FileDesc file, Mulkey uses a string formed    }
      { by concatenating FileVersion with Revision above as the owner of the  }
      { file.  If you attempt to open a file created under a different        }
      { revision, Btrieve will deny access to the file because of an owner    }
      { mismatch.  Mulkey versions 1 and 2 did not use this method so         }
      { revision A begins with version 3.00.  Make sure FileVersion and       }
      { Revision are not longer than the maximum owner length.                }

      { ----------------- Owner and Environment constants ------------------- }

                                                { --------------------------- }
      EnvVar        : STRING[8] = 'FILEDESC';   { Main Environment Variable   }
                                                {  this is a typed constant   }
                                                {  for changes in MULKEY.EXE  }

      { ----------------- Control and Field Size Constants ------------------ }

                            { If certain of these constants are changed, it   }
                            { will affect your master FileDesc file layouts.  }
                            { ----------------------------------------------- }
      MaxKeys       = 24;   { Maximum number of keys or segments in Btrieve   }
      MaxKeyLen     = 255;  { Maximum length in bytes of any key              }
      MaxMulkey     = 40;   { Maximum number of Mulkey files open at once     }
                            { Make sure MULKEY.ASM has same MaxMulkey number! }
      MaxTries      = 5;    { Maximum number of retries for file errors       }
      MinKSize      = 64;   { Minimum size of some data structures            }
      MinVersion    = 4;    { Minimum Btrieve version number this requires    }
      MinRevision   = 10;   { Minimum Btrieve revision number this requires   }
      NoHandle      = 0;    { The handle passed if error occurs during open   }
      FirstHandle   = 1;    { The first valid handle returned at open         }
      PosBlockLen   = 128;  { Length in bytes for Btrieves Position Block     }
      SpareBytes    = 21;   { Number of spare bytes in a FileDesc record      }
      BtNotFoundErr = 12;   { File not found error number for Btrieve         }
      ExtLaterCode  = 0;    { Extend file when disk is full operation code    }
      ExtNowCode    = 255;  { Extend file now operation code of extend        }
      ColSeqID      = $AC;  { ID byte of an alternate collating sequence      }
      ColNameLen    = 8;    { Length of a Btreive Alt Collating Sequence name }
      ColSeqLen     = 256;  { Number of bytes in an Alt Collating Sequence    }

      { -------------------- FDesc Key Number Constants --------------------- }

                                 { Key number for GetFileDesc procedure       }
                                 { ------------------------------------------ }
      FDescOnlyKey      = 1;     { Key number for the FDesc string only       }
      SystemOnlyKey     = 2;     { Key number for System name string only     }
      FDescAndSystemKey = 3;     { Key number for both FDesc and Sytem string }

      { ------------------------ Error Code Constants ----------------------- }

                              { Error codes for MULKEY only - start at 512    }
                              { --------------------------------------------- }
      NoErr         = 0;      { No error occured                              }
      MulkeyInitErr = 512;    { Could not initialize Mulkey                   }
      NoMemoryErr   = 513;    { Not enough memory                             }
      NoHandlesErr  = 514;    { No more Mulkey handles                        }
      GetOpErr      = 515;    { Error in get operation                        }
      BadHandleErr  = 516;    { Handle not active                             }
      NotActiveErr  = 517;    { Mulkey not initialized                        }
      GetDirectErr  = 518;    { Error in get direct                           }
      InvalidKeyErr = 519;    { Bad key number sent                           }
      OwnerMatchErr = 520;    { Owners did not match                          }

{ ----------------------- Memory and File Layout Types ---------------------- }

TYPE
      MKeyRange     = 1..MaxKeys;
      MKeyLenRange  = 1..MaxKeyLen;
      MulkeyRange   = FirstHandle..MaxMulkey;

      BtVerType     = RECORD
                          Version : WORD;
                          Revision: WORD;
                          Net     : CHAR;
                      END; {BtVerType}

      ColSeqType    = RECORD
                          ColSeqSign: BYTE;              { The signature byte }
                          ColSeqName: ARRAY[1..ColNameLen] OF CHAR;
                          ColSeq    : ARRAY[1..ColSeqLen] OF CHAR;
                      END; {colseqtype}

      PosBlockType  = ARRAY[1..PosBlockLen] OF BYTE; { Btrieve position block }

      SpareData     = ARRAY[1..SpareBytes] OF BYTE;  { extra space in record  }

      KBLType       = BYTE;

      KBuf          = RECORD
                          BufferLen: KBLType;
                          KeyBuffer: ARRAY[MKeyLenRange] OF BYTE;
                      END; {Kbuf}

      KeyBufType    = ARRAY[MKeyRange] OF ^KBuf;

      KeyBufPtr     = ^KeyBufType;

      MulkeyTable   = ARRAY[MulkeyRange] OF ^MemFileType;

      KeySpecType   = RECORD
                         Position: WORD;                { Offset in data 1..  }
                         Len     : WORD;                { Key length in bytes }
                         Flags   : WORD;                { bit flags for key   }
                         NotUsed : ARRAY[1..4] OF BYTE; { fill with 0's       }
                         KeyType : BYTE;                { Key Type see above  }
                         Reserved: ARRAY[1..5] OF BYTE; { fill with 0's       }
                      END; {KeySpecType}

      FileSpecType  = RECORD
                        CASE BYTE OF
                           0: (RecordLen   : WORD;   { Record length in bytes }
                               PageSize    : WORD;   { Page size to use       }
                               NumIndexes  : WORD;   { # of keys NOT segments }
                               NumRecs     : LONGINT;  { # of records in file }
                               FileFlags   : WORD;   { Bit flags for file     }
                               ReservedWord: WORD;   { Fill with $0000        }
                               Allocation  : WORD;   { # pages to preallocate }
                               KeyBuf      : ARRAY[MKeyRange] OF KeySpecType;
                               AltColSeq   : ColSeqType); { Alternate col seq }
                           1: (MinSize     : ARRAY[1..MinKSize] OF BYTE);
                      END; {FileSpecType}

      FileDescType  = RECORD                        { Disk file record layout }
                          TypeName: FDescStr;       { Search name             }
                          SysName : FSystStr;       { System name             }
                          Owner   : FOwnerStr;      { Owner for create ops    }
                          AllowRO : BOOLEAN;        { Read Only OK w/o Owner  }
                          Encrypt : BOOLEAN;        { Encrypt the file        }
                          FileData: FileSpecType;   { Btrieve data            }
                          Spare   : SpareData;      { Extra bytes             }
                      END; {FileDescType}

      MemFileType   = RECORD                        { In memory file info     }
                          PosBlock : PosBlockType;  { Btrieves position block }
                          FileDesc : FileDescType;  { Memory info of the file }
                          Extension: PathStr;       { Extension file (if any) }
                          FileName : PathStr;       { Path & name of the file }
                          OpenMode : BYTE;          { LO() of open mode       }
                          Changed  : BOOLEAN;       { If file length changed  }
                          LastKey  : BYTE;          { we keep SUCC of lastkey }
                          LockAttr : FLockAttrib;   { File locking attributes }
                          KeyPtr   : KeyBufPtr;     { Pointer to key buffers  }
                          KeysAlloc: BYTE;          { # of keys allocated     }
                      END; {MemFileType}
