{ BTRIEVE }

{  Copyright 1988 by Mark R. Boler - All Rights Reserved                      }

{ --------------------------------------------------------------------------- }
{                                                                             }
{  This is a Btrieve interface for Turbo Pascal version 4.xx.                 }
{   It sets up the parameter block expected by Btrieve and issues             }
{   the proper interrupts.  This has been modified for Mulkey.PAS             }
{   to pass the key buffer length to Btrieve.                                 }
{                                                                             }
{  Usage:  Status:= Btrv(Op, PosBlock, Data, DataLen, KBuf, Key, KeyLen);     }
{                                                                             }
{                       Op is a word,                                         }
{                       PosBlock is a 128 byte buffer,                        }
{                       Data is an untyped parameter for the data buffer,     }
{                       DataLen is the length of the data buffer,             }
{                       KBuf is the untyped parameter for the key buffer,     }
{                       Key is a byte,                                        }
{                       KeyLen is a byte                                      }
{                                                                             }
{  Returns: Btrieve status code                                               }
{ --------------------------------------------------------------------------- }

{$B-}    { Boolean complete evaluation off }
{$D+}    { Debug information on            }
{$I-}    { I/O checking off                }
{$L+}    { Linker uses memory for a buffer }
{$N-}    { No numeric coprocessor          }
{$R-}    { Range checking off              }
{$S-}    { Stack checking off              }
{$T-}    { .TPM file generation off        }
{$V-}    { No VAR-String checks            }

UNIT Btrieve;

INTERFACE

FUNCTION Btrv(Op: WORD;
              VAR PosBlock;
              VAR Data;
              VAR DataLen: WORD;
              VAR KBuf;
              Key: BYTE;
              KeyLen: BYTE): WORD;

IMPLEMENTATION

FUNCTION Btrv(Op: WORD;
              VAR PosBlock;
              VAR Data;
              VAR DataLen: WORD;
              VAR KBuf;
              Key: BYTE;
              KeyLen: BYTE): WORD; EXTERNAL;

PROCEDURE InitBtrv; EXTERNAL;

{$L BTRIEVE.OBJ}

BEGIN {Init Btrieve }
      InitBtrv;
END. {Init Btrieve }
