Program LogIt;  { A program to log a Novell LAN users activity }
Uses
  DOS,
  TpString,
  TpCmdLin;
type
  str79        = string[79];
  logentrytype = record
                   PacketLength : Word;
                   Func         : Byte;
                   Message      : Str79;
                 end;  { record }

Var
  ReplyBuff : Word;
  I,N       : Integer;
  Tmp       : string;
  PS        : ^String;

(* **********************************************************************

Generally, this program will do the following:

     Log the date and time that a program is called and
     later, when it was finished.

Usage:
     Call from a batch file or the Novell menu system.
     Ie:  Logit start "Entering Accounting System"
     or   Logit stop "Finished with Word Processing"

A typical menu system entry might look like this:

     1) TCS Accounting
          Logit Start "Entering TCS"
          f:
          pushdir
          cd\tcs
          quick
          popdir
          Logit Stop "Finished with TCS"

************************************************************************ *)

Function GetLoginName : string;
type
  ReqType = record
              PacketLength : Word;
              Func         : Byte;
              CN           : Byte;
            end;   { record }
  RepType = record
              ReturnLength : Word;
              UniqueID     : LongInt;
              Typ          : Word;
              Name         : Array[1..48] of char;
              LogTime      : Array[1..8] of char;
            end;   { record }
              
var
  regs    : registers;
  ReqBuff : ReqType;
  RepBuff : Reptype;
  NameStr : string;
begin
  with regs do
    begin
      AH := $DC;
      MSDOS(regs);

      ReqBuff.PacketLength := 2;
      ReqBuff.Func := $16;
      ReqBuff.CN := AL;
      AH := $E3;
      DS := Seg(ReqBuff);
      SI := Ofs(ReqBuff);
      ES := Seg(RepBuff);
      DI := Ofs(RepBuff);

      MSDOS(regs);

      i := 0;
      Repeat
        i := succ(i);
        namestr[i] := repbuff.Name[i];
      Until RepBuff.Name[i] = #0;
      namestr[0] := chr(i);
      GetLoginName := namestr;
    end;
end;  { function GetLoginName }  

procedure Log(action : byte; entry : str79);
var
  regs     : registers;
  logentry : logentrytype;
  tmpstr   : string;
  pl       : word;
begin
  with regs do
    begin
      AH := $E3;
      DS := Seg(logentry);
      SI := Ofs(logentry);
      ES := Seg(ReplyBuff);
      DI := Ofs(ReplyBuff);
      logentry.Func := $0D;
      case action of
        1 : TmpStr := GetLoginName + ' | Begin | ' + entry;
        2 : TmpStr := GetLoginName + ' | End   | ' + entry;
      else
        TmpStr := GetLoginName + ' |       | ' + entry;
      end;  { of case }
      if length(TmpStr) > 79 Then
        TmpStr[0] := #79;
      pl := length(TmpStr) + 2;
      LogEntry.PacketLength := pl;
      LogEntry.Message := TmpStr;

      MSDOS(regs);
    end;  { with regs }
end;  { procedure log }

Procedure QuitAndHelp;
Begin
  WriteLn;
  WriteLn;
  Writeln('     LogIt (C) 1988 by Micro Networks of America, Inc.');
  Writeln;
  WriteLn('     Usage:  LogIt [Action] "Text"');
  WriteLn;
  WriteLn('     Where Action is optional.  Valid Actions are Start or Stop.');
  WriteLn;
  WriteLn('     Text is the actual comment to log.  Maximum length is 40 characters.');
  WriteLn;
  WriteLn('     Examples:  LogIt Start "Accounting Software"  ');
  WriteLn('                LogIt Stop  "Accounting Software" ');
  WriteLn;
  WriteLn('     A supervisor level user may view the log by nprinting, ');
  WriteLn('     typing, or using an ascii text editor to view a file in ');
  WriteLn('     the SYS:SYSTEM directory called NET$LOG.MSG ');
  WriteLn;
  Halt(1);
End;

Begin
  PS := Ptr(PrefixSeg, $80);
  N := ParamCnt(PS^);
  If N > 0 then
    begin
      I := 0;
      tmp := StUpCase(GetArgString(I,False,False));
      I := 1;
      if tmp = 'START' Then
        Log(1,GetArgString(I,True,False));
      if tmp = 'STOP' Then
        Log(2,GetArgString(I,True,False));
    end
  else
    QuitAndHelp;
End.
