Program SetDrive; { Author: David Bennett / Date 6/28/88 / Version 1.0 }

{ This sets the current Novell Drive on the system

  EX.

  SETDRIVE 2 - Will set the current drive to the second Novell assigned
               drive on the system.
}

Uses
  Crt, Dos;

{ * This routine prints an error message and aborts the program
{ *
}
Procedure Err(ErrSt : String);
Begin
  WriteLn('Error - ', ErrSt);
  Halt(1);
End;

{ * This procedure explains the program to the screen
{ *
}
Procedure Explain;
Begin
  ClrScr;
  WriteLn;
  WriteLn('Program: SETDRIVE / Author: Dave Bennett / Date: 6-28-88 / Version: 1.0');
  WriteLn;
  WriteLn('Description:');
  WriteLn;
  WriteLn('  This program sets the default drive to the sequential Novell drive specified.');
  WriteLn('  This program and it''s source code have been relased to the public domain');
  WriteLn('  by the author. DHB.');
  WriteLn;
  WriteLn('Example:');
  WriteLn;
  WriteLn('  SETDRIVE 2 - Will log to the systems second Novell drive.');
  WriteLn;
End;

{ * This Novell function returns the number of local disk drives
{ *
}
Function LocalDrives : Byte;
Var
  Regs : Registers;
Begin
  With Regs Do Begin
    AH := $DB;
    MsDos(Regs);
    LocalDrives := AL;
  End;
End;

{ * This MSDOS function selects the default drive (A = 0, B = 1,...)
{ *
}
Procedure SelectDrive(Drive : Byte);
Var
  Regs : Registers;
Begin
  With Regs Do Begin
    AH := $0E;
    DL := Drive;
    MsDos(Regs);
  End;
End;

Var
 Drive : Byte;
 P     : Integer;

{ *** MAIN PROGRAM *** }

Begin
  If ParamCount < 1 Then Begin           { If no command line params then  }
    Explain;                             {   Explain the program           }
    Write('Drive Number To Select : ');  {   Get the drive number from     }
    {$I-} ReadLn(Drive); {$I+}           {     the user.                   }
    If (IOResult <> 0) Then              {   If invalid drive number then  }
      Err('Invalid drive specified!');   {     Show an error and halt      }
  End Else Begin                         { If parameter found then         }
    Val(ParamStr(1), Drive, P);          {   Make parameter a value        }
    If P > 0 Then                        {   If invalid value string then  }
      Err('Invalid drive specified!');   {     Show error and halt         }
  End;                                   {                                 }
  If Drive < 1 Then                      {  Make sure drive is 1 or >      }
    Err('Invalid drive specified!');     {                                 }
  Drive := Drive - 1;                    {  Subtract 1 for MSDOS 0Eh func. }
  Drive := Drive + LocalDrives;          {  Add number of local drives     }
  SelectDrive(Drive);                    {  Goto the drive                 }
End. {SetDrive}

