{************************************************************************

  FILESHAR - A unit to allow files to be flagged as sharable
  Version 1.0 4/16/88
  by Richard S. Sadowsky   CIS: 74017,1670

  This unit requires that SHARE.EXE or a network operating system be
  loaded when these routines are used.  Without SHARE.EXE or equivelent,
  the SHARE bit has no meaning, rendering these routines useless.
  See the file NFLAG.PAS for a sample usage of this unit.

  This unit is known to be compatable with Novell's Advanced
  NetWare, and is compatable with ANY other network that uses
  the DOS 3 standard of setting the high bit to signify a
  "sharable" file.

  This unit was extracted from a soon to be released commercial
  package of Turbo Pascal 4 networking tools.  Send EASYPLEX to
  74017,1670 for more information.

  These routines are provided as is by the author, and donated to
  the public domain.  Feel free to post suggestions and enhancements
  regarding this unit in Borland's BPROGA DL16 - Turbo Pascal and
  Networks.

************************************************************************}

unit FileShar;

interface

uses DOS; { needed to get and set file attributes }

const
  _SHAREABLE       = $80;  { corresponds to the SHARE bit of the file att }

function FileIsSharable(Path : String; var FAttr : Word; var ErrCode : Word)
                       : Boolean;
{ Return TRUE if file is flagged as shareable, return file attrib in FAttr }
{ return DOS error in ErrCode }

function MakeFileSharable(Path : String) : Word;
{ make a file sharable (SHARE bit of file attribute is set) }


{**************************************************************************}
implementation
{**************************************************************************}

function FileIsSharable(Path : String; var FAttr : Word; var ErrCode : Word)
                       : Boolean;

var
  F                : File;

begin
  Assign(F,Path);
  GetFAttr(F,FAttr);    { use DOS unit to get the file attribute }
  ErrCode := DOSError;  { pass any error info to calling routine }
  FileIsSharable := (FAttr and _SHAREABLE) <> 0   { see if SHARE }
                                                  { bit set.     }
end;

function MakeFileSharable(Path : String) : Word;

var
  F                : File;
  Attr             : Word;
  ErrCode          : Word;
  Share            : Boolean;

begin
  { first, see if the file is already sharable (and that it exists), }
  { if it exists and is NOT already flagged to sharable, the SHARE   }
  { bit is set by ORing $80 with the file's attribute }
  Share := FileIsSharable(Path,Attr,ErrCode);  { is it sharable? }
  if (ErrCode = 0) and (not Share) then begin
    Assign(F,Path);
    SetFAttr(F,Attr or _SHAREABLE); { OR existing at with SHARE bit }
    ErrCode := DOSError;
  end;
  MakeFileSharable := ErrCode;
end;
end. { of Unit FileShar }
