{
  NFlag - Program to set files to sharable on a network
  version 1.0 4/16/88
  by Richard S. Sadowsky 74017,1670

  Released as is to the public domain

  This program sets files matching the specified filespec(s) to sharable.
  Other than setting the Share bit, the attributes are unchanged.  The
  specified files must be in the current directory.

  You may specify more than one filename on the command line if desired,
  and the filenames may optionally include wildcards.  Examples:

  NFLAG DAT??.* FIL??.FIL *.PRG MEDAPP*.C??
  NFLAG TPSPOOL.EXE
  NFLAG *.*

  To see how this neat command line argument expansion is done, see
  XArgs.Pas for the source.

  This program is remotely similar to the much more powerful
  NetWare FLAG program.  Of course, FLAG is restricted to use under
  NetWare, where as NFLAG is not.

  This unit was extracted from a soon to be released commercial
  package of Turbo Pascal 4 networking tools.  Send EASYPLEX to
  74017,1670 for more information.
}
{$R-,S-,I-,V-}  { no stack or range checking, do not abort on I/O error, }
                { and relax string type checking }

{$M 16384,0,0}  { no heap needed }

program NFlag;

uses DOS,XArgs,FileShar;

{ I extracted the following from a message by Sam Denton 76314,1512 }
{ it is a fast routine for displaying bytes as a hex string. }
function Nybble(x : Byte): Char;
inline($58/            {  POP     AX     }
       $24/$0F/        {  AND     AL,0F  }
       $04/$90/        {  ADD     AL,90  }
       $27/            {  DAA            }
       $14/$40/        {  ADC     AL,40  }
       $27/            {  DAA            }
       $24/$7F);       {  AND     AL,7F  }

function HexByte(H : Byte): String;

begin
  HexByte[0] := #2;
  HexByte[1] := Nybble(H shr 4);
  HexByte[2] := Nybble(H);
end;


procedure ShowAtt(P : String);
{ Show user the file's attributes }
var
  F                : File;
  Att              : Word;

begin
  Assign(F,P);
  GetFAttr(F,Att);
  WriteLn(P,' is flagged as: ',HexByte(Byte(Att)),'h');
  Write('  ');
  if Att and ReadOnly <> 0 then
    Write('ReadOnly ');
  if Att and Hidden <> 0 then
    Write('Hidden ');
  if Att and SysFile <> 0 then
    Write('SysFile ');
  if Att and VolumeID <> 0 then
    Write('VolumeID ');
  if Att and Directory <> 0 then
    Write('Directory ');
  if Att and Archive <> 0 then
    Write('Archive ');
  if Att and _SHAREABLE <> 0 then
    Write('Shareable');
  WriteLn;
end;

procedure FlagShare(P : String);

var
  E : Word;

begin
  E := MakeFileSharable(P);   { Try to flag it to shareable }
  if E <> 0 then
    WriteLn('MakeFileSharable error = ',E,' attempting to flag ',P);
  ShowAtt(P);                 { show after }
end;

var
  I : Word;

begin
  WriteLn('NFLAG - Flags files as sharable');
  WriteLn('Version 1.0   4/16/88   Public Domain');
  WriteLn;
  if ParamCount < 1 then begin
    WriteLn('syntax: NFLAG FileName1 FileName2...');
    WriteLn('  the filename(s) may include the wildcards * and/or ?');
    WriteLn('  the specified filenames must be in the current directory.');
    WriteLn('  ex. NFLAG *.DAT RS*.EXE SPOOL??.* Q.EXE<cr>');
    WriteLn('  ex. NFLAG *.*<cr>');
    Halt(1)
  end;
  { Args and NArgs are set by the initialization code of the XArgs Unit }
  for I := 1 to NArgs do { for each file matching some command line spec }
    FlagShare(Args[I]);  { call the routine to flag the file to share }
end. { We're out of here! }
