{
  XArgs - A unit to expand filespecs on the command line
  version 1.0 4/16/88
  by Richard S. Sadowsky    CIS: 74017,1670

  Released as is to the public domain by the author.

  This program expands all the filespecs on the command line and puts them
  in a single list, Args.  The Word Var NArgs returns the number of filespecs
  in the list (Args).  Any number of filespecs may be given and they may
  contain wildcards (* and ?).

  Will abort program if too many files are found (maximum specified by constant
  MAX_ARGS).  You don't see more than 1000 files in a single directory often,
  but if this is the case, you can increase the size of MAX_ARGS.
  NOTE: Doing so will increase the data size of any program that uses this
  unit.  It already uses a good chunk or memory (about 12K of data space)!
  This is really a quick and dirty approach useful in a command line utility
  program (like NFLAG.PAS).  A linked list on the heap might consume energy
  more efficiently, but this suits our purpose just the same.  This unit will
  only work with filespecs in the current directory, no path portion of the
  filespec may be specified.

}
{$S-,I-,V-}

unit XArgs;

interface

uses DOS;

const
  MAX_ARGS         = 1024; { this number determines the maximum number    }
                           { of file names that can be held in the list.  }
                           { Since it is used as a ceiling for the array, }
                           { this number determines the amount of RAM     }
                           { eaten up by the Args Array. }
type
  FileName         = String[12];
  ArgsType         = Array[1..MAX_ARGS] of FileName;  { list type to hold }
                                                      { the expanded file }
                                                      { names }

var
  Args             : ArgsType;  { this is where the expanded filenames    }
                                { are held, allowing them to accessed     }
                                { by a program that USES this unit.       }

  NArgs            : Word;      { number of file names in the Args list   }

implementation

function ExpandArgs(var Args : ArgsType) : Word;
{ expand any wildcards on the command line into file names.  All file names, }
{ whether specified explicitly or via a wildcard expansion, are added to the }
{ global var Args.  The var NArgs specifies the number of filenames in the   }
{ list }
var
  I,Num            : Word;
  S,FName          : String;
  DirInfo          : SearchRec;

procedure AddArgs(var FName : FileName);
{ add the file name to Args and increment NArgs }
begin
  Inc(Num);
  if Num > MAX_ARGS then begin { check for overflow, since Range checking }
                               { turned off }
    WriteLn('Argument overflow - Too many files found');
    Halt(1);
  end;
  Args[Num] := FName
end;

begin
  Num := 0;
  for I := 1 to ParamCount do begin
    FName := ParamStr(I);
    if (Pos('*',FName) > 0) or (Pos('?',FName) > 0) then begin
      { expand filename w/wildcard }
      FindFirst(FName,Archive,DirInfo);
      while DOSError = 0 do begin
        AddArgs(DirInfo.Name);    { add each file matching filespec to }
                                  { Args }
        FindNext(DirInfo);
      end; {while}
    end
    else
      AddArgs(FName); { no wildcard so just add the file to Args }
  end;
  ExpandArgs := Num
end;

begin { of Unit XArgs }
  NArgs := ExpandArgs(Args);  { expand the command line and export the }
                              { results }
end. { of Unit XArgs }
