{$R-}    {Range checking off}
program usage;

{
  Utility program for Novell networks.

  Show disk utilization statistics for all users of all volumes.

  This program makes Novell function calls through interrupt 21h. These
  calls are not compatible with any other network, as far as I know.
  There are probably equivalent calls in 3com 3+, but I don't know them.

  This program will only list volumes on the current server.

  Written by:
    Mark Sersen
    Austin Consulting
    9801 W. Higgins Rd.
    Rosemont, IL  60018

  CompuServe 71121,3177

  Released to the Public Domain, February 1988.

  Use this program any way you wish. The author retains the right to forget
  that he ever wrote this. (No warranty whatsoever.)

}


uses
  dos;

const
  maxvols = 10;             { increase if you have more than 10 hard disks
                              on your server (!?!?!?) }

type
  idtype = longint;
  string20 = string[20];
  obname = array[1..48] of char;
  obptr = ^objectlist;
  objectlist = record                { record for holder user definitions }
                 id : idtype;
                 name : obname;
                 next : obptr;
               end;

var
  reg : registers;
  volname : array[0..maxvols] of string20;
  volsize, voldirs : array[0..maxvols] of integer;
  volquan, totdirs, totfiles, totblocks : integer;
  obfirst, obnext, oblast : obptr;
  cur_vol, charnum, vol : integer;


function lohi(original:integer):integer;
  { convert lo-byte/hi-byte format to Pascal integer }
  begin
    lohi:=(lo(original) * 256) + hi(original);
  end;


procedure get_vol_stats;
  var
    count : integer;
    done : boolean;

  procedure get_name(count:integer);
    var
      request : record
                  len : integer;     { length of request packet }
                  funct : byte;      { Novell function number }
                  volnum : byte;     { volume # to check }
                end;

      reply : record
                len : integer;        { length of reply packet }
                vol_name : string20;  { name of volume }
              end;

      stats : record
                sectors : integer;          { sectors / block }
                blocks : integer;           { total # of blocks }
                emptyblocks : integer;      { # of empty blocks }
                dirs : integer;             { # of dir entries used }
                emptydirs : integer;        { # of dir entries left }
                volname : array[1..16] of byte;   { vol name again }
                remove : integer;           { removable media flag }
              end;

    begin
      request.len:=2;                      { see of there is a volume 'count' }
      request.funct:=6;
      request.volnum:=count;
      reply.len:=21;
      reply.vol_name:='xx';                { someting to take up space }
      reg.ax:=$E200;
      reg.ds:=seg(request);                { setup for Novell call }
      reg.si:=ofs(request);
      reg.es:=seg(reply);
      reg.di:=ofs(reply);
      msdos(dos.registers(reg));
      if length(reply.vol_name) <> 0 then   { is there a volume? }
        begin
          { get statistics for found volume }
          volname[count]:=reply.vol_name;
          reg.ax:=$DA00;
          reg.dx:=lo(count);
          reg.es:=seg(stats);
          reg.di:=ofs(stats);
          msdos(Dos.Registers(reg));
          volsize[count]:=lohi(stats.blocks);      { size in 128 byte blocks }
          voldirs[count]:=lohi(stats.emptydirs);   { # of remaining dir slots }
        end
      else
        done:=true;     { no volume 'count'; stop looking }
    end;

  begin
    done:=false;
    count:=0;
    repeat                                 { find all volumes (10 max) }
      get_name(count);
      if not done then
        count:=count+1;
    until done;
    volquan:=count;                        { number of volumes found }
  end;

procedure object_list;
  var
    request : record                       { Novell request packet for }
                len : integer;             { scan bindery objects (users) }
                funct : byte;
                lastob : idtype;           { last object found }
                pat_type:integer;          { type of object we're looking for }
                pat_len : byte;            { length of match pattern }
                pattern : char;
              end;
    reply : record
              len : integer;               { length of reply packet }
              id : idtype;                 { id found }
              ptype : integer;             { type of object }
              name : obname;               { object's name }
              flag,sec,prop : byte;        { particulars about object }
            end;

    done : boolean;
    last : idtype;
    count : integer;

  begin
    obfirst:=nil;
    obnext:=nil;
    done:=false;
    last:=$FFFFFFFF;              { $FFFFFFFF = find first }
    repeat
      request.len:=9;
      request.funct:=55;
      request.lastob:=last;
      request.pat_type:=$0100;    { type 1 = net_user }
      request.pat_len:=1;
      request.pattern:='*';       { any name }
      reply.len:=57;
      reg.ax:=$E300;
      reg.ds:=seg(request);
      reg.si:=ofs(request);
      reg.es:=seg(reply);
      reg.di:=ofs(reply);
      msdos(Dos.Registers(reg));
      if lo(reg.ax) <> 0 then              { ax <> 0 means no find }
        done:=true
      else
        begin
          new(obnext);
          obnext^.id:=reply.id;            { put id and name into linked list }
          obnext^.name:=reply.name;
          obnext^.next:=nil;
          if obfirst = nil then            { increment list pointers }
            obfirst:=obnext
          else
            oblast^.next:=obnext;
          oblast:=obnext;
          last:=reply.id;                  { start next search with new id }
        end;
    until done;
  end;

procedure get_util(s_id:idtype);
  { get stats for user 's_id'.
    add user stats to grand total stats.
    print user stats. }
  var
    request : record                    { request packet for Novell call: }
                len : integer;          { Get Objects Disk Utilization Stats } 
                funct : byte;
                volume : byte;          { which Novell drive }
                id : idtype;            { which user id }
              end;

    reply : record
              len : integer;
              volume : byte;            { which Novell drive }
              id : idtype;              { which user id }
              numdirs, numfiles, numblocks : integer;   { returned stats }
            end;

  begin
    request.len:=6;
    request.funct:=14;
    request.volume:=cur_vol;        { set in main loop }
    request.id:=s_id;               { passed by main loop }
    reply.len:=11;
    reg.ax:=$E300;
    reg.ds:=seg(request);
    reg.si:=ofs(request);
    reg.es:=seg(reply);
    reg.di:=ofs(reply);
    msdos(Dos.Registers(reg));
    totdirs:=totdirs + lohi(reply.numdirs);        { increment volume totals }
    totfiles:=totfiles + lohi(reply.numfiles);
    totblocks:=totblocks + lohi(reply.numblocks);
    write(lohi(reply.numdirs):4,' Directories  ');   { print user stats }
    write(lohi(reply.numfiles):6,' Files  ');
    write(lohi(reply.numblocks):4,' Blocks Used  ');
    write(100*(lohi(reply.numblocks) / volsize[cur_vol]):5:2,'% of Disk');
  end;


begin
  writeln('Disk Utilization Statistics v2.2');
  get_vol_stats;                   { get # of volumes & stats for each }
  object_list;                     { put all users in system into list }
  for vol:=1 to volquan do
    begin
      cur_vol:=vol - 1;            { actual volume # is 1 less than total }
      writeln;
      writeln('Volume ',volname[cur_vol]);
      totdirs:=0;                  { initialize totals for this volume }
      totfiles:=0;
      totblocks:=0;
      obnext:=obfirst;             { set pointer to first user }
      while obnext <> nil do
        with obnext^ do
          begin
            for charnum:=1 to 12 do   { name passed as array- }
              write(name[charnum]);   { must print string!    }
            get_util(id);          { print stats for each user }
            writeln;
            obnext:=next;
          end;
      { print totals for volume }
      write('Totals      ',totdirs:4,' Directories  ',totfiles:6,' Files  ',totblocks:4,' Blocks Used  ');
      writeln((totblocks / volsize[cur_vol]) * 100:5:2,'% of Disk');
    end;
end.



