#
#  The main makefile for the NetWare loadable modules making
#  on Linux and Win32 (Cygwin) platforms with the GNU utilities
#
#  Written by Pavel Novy <novy@feld.cvut.cz>
#  Version 1.0.21 (2001-12-23)
#

NDK           := $(NDK)#?/ndk

NLMSTUFF_VER   = 1.0.21
NLMSTUFF_REV   =
NLMSTUFF_MKF   = $(NLMSTUFF)/Makefile.GNU
NLMSTUFF_SIGN  = GNU build# $(NLMSTUFF_VER)

NKS            = $(NDK)/nks
NWSDK          = $(NDK)/nwsdk
LIBC           = $(NDK)/libc
WINSOCK        = $(NDK)/winsock

ifeq ($(NDKLIB), $(LIBC))
NLMSTUFF_INC   = -I$(NLMSTUFF)/include \
		 -I$(LIBC)/include \
		 -I$(WINSOCK)/include
IMPORTBASE     = $(LIBC)/imports
else
NLMSTUFF_INC   = -I$(NLMSTUFF)/include \
		 -I$(NWSDK)/include \
		 -I$(NWSDK)/include/nlm \
		 -I$(WINSOCK)/include
IMPORTBASE     = $(NWSDK)/imports
endif

ifeq (, $(wildcard $(NLMSTUFF)/LITE))
  GNU_PATH     = $(NLMSTUFF)/bin/
endif

# on Linux: if you have correct nlmconv (with the copyright issue fixed)
# in your path, you can comment out the next line
NLMCONV_PATH   = $(NLMSTUFF)/bin/

ifeq ($(OSTYPE), cygwin)
  OS_EXT       = .exe
  OS_BIN       = $(NLMSTUFF)/bin/
endif

ifneq (, $(GNU_PATH))
  NLM_BIN      = -B $(GNU_PATH)
endif

ifdef BUILD
  ifneq (, $(wildcard $(TARGET).b))
    include $(TARGET).b
  endif
  DEFINES     := $(DEFINES) -DBUILD=$(BUILD)
endif

ifdef SOURCES
  OBJS        := $(filter %.c %.cc, $(SOURCES))
  OBJS        := $(OBJS:.c=.o)
  OBJS        := $(OBJS:.cc=.o)
endif
  
CPPFLAGS       = $(NLM_BIN) $(NLMSTUFF_INC) -nostdinc \
		 -include $(NLMSTUFF)/include/nlmstuff.h \
		 $(CFLAGS) $(INCLUDES) $(DEFINES)

NLM_CFLAGS     = -c $(CPPFLAGS) -fno-builtin -O2 -Wall \
		 -fshort-enums -fpack-struct -fpcc-struct-return \
		 -fno-implicit-templates -fno-exceptions -fno-rtti

DEPEND         = $(OBJS:.o=.d)
INCDEP         = $(wildcard $(DEPEND))

CC             = $(GNU_PATH)gcc$(OS_EXT)
LD             = $(GNU_PATH)ld$(OS_EXT)
NLMCONV        = $(NLMCONV_PATH)nlmconv$(OS_EXT)
AR             = $(GNU_PATH)ar$(OS_EXT)
RANLIB         = $(GNU_PATH)ranlib$(OS_EXT)

SED            = $(OS_BIN)sed$(OS_EXT)
ECHO           = $(OS_BIN)echo$(OS_EXT)
RM             = $(OS_BIN)rm$(OS_EXT) -f

define WARNING
  $(ECHO) "#" >>$@
  $(ECHO) "# WARNING: Don't edit this file, it is generated automatically." >>$@
  $(ECHO) "#          Any changes made here will be lost." >>$@
  $(ECHO) "#" >>$@
endef

%.o:	%.c %.d $(SOURCE_DEP) $(MAKEFILE) $(NLMSTUFF_MKF)
	$(CC) $(NLM_CFLAGS) $< -o $@

%.d:	%.c $(MAKEFILE) $(NLMSTUFF_MKF)
	@$(RM) $@
	@$(CC) -M $(CPPFLAGS) $< \
	  | $(SED) -e 's;^\(.*\.o\):;\1 $@:;' >>$@ ;\
	  if [ ! -s $@ ] ; then $(RM) $@ ; exit 1 ; fi
	@$(WARNING)

%.o:	%.cc %.d $(SOURCE_DEP) $(MAKEFILE) $(NLMSTUFF_MKF)
	$(CC) $(NLM_CFLAGS) $< -o $@

%.d:	%.cc $(MAKEFILE) $(NLMSTUFF_MKF)
	@$(RM) $@
	@$(CC) -M $(CPPFLAGS) $< \
	  | $(SED) -e 's;^\(.*\.o\):;\1 $@:;' >>$@ ;\
	  if [ ! -s $@ ] ; then $(RM) $@ ; exit 1 ; fi
	@$(WARNING)

all:	$(TARGET).$(TYPE)

.PHONY: clean dist

clean:
	@$(RM) $(OBJS) $(DEPEND) $(TARGET).def $(TARGET).$(TYPE)
	@$(RM) $(notdir $(OBJS:.o=.i) $(OBJS:.o=.ii) $(OBJS:.o=.s))

dist:
	@$(RM) $(OBJS) $(DEPEND) $(TARGET).def
	@$(RM) $(notdir $(OBJS:.o=.i) $(OBJS:.o=.ii) $(OBJS:.o=.s))

$(TARGET).: $(OBJS) $(MAKEFILE) $(NLMSTUFF_MKF)

$(TARGET).lan $(TARGET).nlm $(TARGET).dsk $(TARGET).nam: $(OBJS) $(LIBRARIES) $(PRELUDE) $(TARGET).def
	$(NLMCONV) -T $(TARGET).def -l $(LD)
ifdef BUILD
  ifeq (, $(wildcard $(TARGET).b))
	@$(ECHO) BUILD=$(BUILD) >$(TARGET).b
  endif
  ifeq ($@, $(wildcard $@))
	@$(NLMSTUFF)/bin/_counter $(TARGET).b $(BUILD)
  endif
endif

$(TARGET).a: $(OBJS) $(MAKEFILE) $(NLMSTUFF_MKF)
	@$(RM) $@
	$(AR) cr $@ $(OBJS)
	$(RANLIB) $@

$(TARGET).so: $(OBJS) $(LIBRARIES) $(MAKEFILE) $(NLMSTUFF_MKF)
	@$(LD) -shared -o $@ $(OBJS) $(LIBRARIES)

$(TARGET).def: $(OBJS) $(LIBRARIES) $(TARGET_DEP) $(MAKEFILE) $(NLMSTUFF_MKF) $(PRELUDE)
	@$(RM) $@
	@$(WARNING)
	@$(ECHO) output $(TARGET).$(TYPE) >>$@
	@if [ "$(DESCRIPTION)" ] ; then $(ECHO) description \"$(DESCRIPTION)\" >>$@ ; fi
	@if [ "$(VERSION)" ] ; then $(ECHO) version $(VERSION) >>$@ ; fi
	@if [ "$(DATE)" ] ; then $(ECHO) date $(DATE) >>$@ ; fi
	@if [ "$(COPYRIGHT)" ] ; then $(ECHO) copyright \"$(COPYRIGHT)\" >>$@ ; fi
	@if [ "$(THREADNAME)" ] ; then $(ECHO) threadname \"$(THREADNAME)\" >>$@ ; fi
	@if [ "$(SCREENNAME)" ] ; then $(ECHO) screenname \"$(SCREENNAME)\" >>$@ ; fi
	@case $(TYPE)"" in nlm) t=0 ;; lan) t=1 ;; dsk) t=2 ;; nam) t=3 ;; \
	   *) $(ECHO) Error: Unknown TYPE assigned. ; exit 1 ;; \
	 esac ;\
	 $(ECHO) type $$t >>$@
	@if [ "$(OPTIONS)" ] ; then for o in $(OPTIONS)"" ; do $(ECHO) $$o >>$@ ; done fi
	@if [ "$(FLAG_ON)" ] ; then $(ECHO) flag_on $(FLAG_ON) >>$@ ; fi
	@if [ "$(XDCDATA)" ] ; then $(ECHO) xdcdata $(XDCDATA) >>$@ ; fi
	@if [ "$(START)" ] ; then $(ECHO) start $(START) >>$@ ; fi
	@if [ "$(EXIT)" ] ; then $(ECHO) exit $(EXIT) >>$@ ; fi
	@if [ "$(CHECK)" ] ; then $(ECHO) check $(CHECK) >>$@ ; fi
	@if [ "$(STACK)" ] ; then $(ECHO) stack $(STACK) >>$@ ; fi
	@if [ "$(PRELUDE)" ] ; then $(ECHO) input $(PRELUDE) >>$@ ; fi
	@if [ "$(OBJS)" ] ; then for f in $(OBJS)"" ; do $(ECHO) input $$f >>$@ ; done fi
	@if [ "$(LIBRARIES)" ] ; then for l in $(LIBRARIES)"" ; do $(ECHO) input $$l >>$@ ; done fi
	@if [ "$(EXPORTS)" ] ; then for e in $(EXPORTS)"" ; do $(ECHO) export $$e >>$@ ; done fi
	@if [ "$(IMPORTS)" ] ; then for i in $(IMPORTS)"" ; do $(ECHO) import $$i >>$@ ; done fi
	@if [ "$(EXPORTFILES)" ] ; then for e in $(EXPORTFILES)"" ; do $(ECHO) export @$$e >>$@ ; done fi
	@if [ "$(IMPORTFILES)" ] ; then for i in $(IMPORTFILES)"" ; do $(ECHO) import @$(IMPORTBASE)/$$i.imp >>$@ ; done fi
	@if [ "$(MODULES)" ] ; then for m in $(MODULES)"" ; do $(ECHO) module $$m >>$@ ; done fi
###	@if [ "$(SHARELIBS)" ] ; then for l in $(SHARELIBS)"" ; do $(ECHO) sharelib $$l >>$@ ; done fi

dep:    $(DEPEND)

ifeq (, $(MAKECMDGOALS)) 
  ifneq (, $(INCDEP))
    include $(INCDEP)
  endif
else
  ifeq (all, $(MAKECMDGOALS))
    ifneq (, $(INCDEP))
      include $(INCDEP)
    endif
  endif
endif
