/*
   cw.c - CodeWarrior alignment issue
*/

#include <stdio.h>

typedef struct
{
  unsigned short a;
  unsigned b;
} cw;

typedef struct
{
  unsigned short a;
  unsigned b:1;
} cwbit;

static cw aa = { 0, 0 };
static cwbit bb = { 0, 0 };

int main (void)
{
  unsigned short p;
  p = aa.a + aa.b;
  p = bb.a + bb.b;
  printf ("%d vs. %d\n", sizeof(aa), sizeof(bb));
  return 0;
}

/*

assembler code produced:
------------------------
mov dx,word ptr aa
add dx,word ptr aa+2     // No alignment, sizeof(unsigned short) = 2.
mov word ptr [ebp-2],dx
mov dl,byte ptr bb+4     // An 'a' structure element aligned to 4 bytes...
and dl,1
and edx,255
add dx,word ptr bb
mov word ptr [ebp-2],dx

program output:
---------------
6 vs. 8         // Additionally, a 'bit' structure element is always aligned
                // to 4 bytes, even if "Byte Alignment" is set to 1...
		
(6 vs. 3 if compiled by gcc)

*/
