/*
   struct.c - Structure alignment issues
*/

#include <stdio.h>                      // printf

typedef struct
{
  char a;
  short b;
  long c;
  char d[6];
} STRUCT;

enum _e { E=0xff };
enum _f { F=0xffff };
enum _g { G=0xffffff };
enum _h { H=0xffffffff };

typedef struct
{
  unsigned a:1;
  unsigned b:1;
  unsigned c:1;
} bits;

typedef struct
{
  void *p;
  unsigned short s;
  unsigned a:1;
  unsigned b:1;
  unsigned c:1;
} bits2;

static STRUCT s;
static enum _e e;
static enum _f f;
static enum _g g;
static enum _h h;

int main (int argc, char *argv[])
{
  int i;

  printf ("A -fpack-struct option verification:\n");
  printf ("------------------------------------\n");
  i = (char *)&s.b - (char *)&s.a;
  printf ("space used by a    char structure element (should be  1):  %u ", i);
  if (i == 1) printf ("OK\n"); else printf ("aligned!\n"); 
  i = (char *)&s.c - (char *)&s.b;
  printf ("space used by a   short structure element (should be  2):  %u ", i);
  if (i == 2) printf ("OK\n"); else printf ("aligned!\n"); 
  i = (char *)&s.d - (char *)&s.c;
  printf ("space used by a    long structure element (should be  4):  %u ", i);
  if (i == 4) printf ("OK\n"); else printf ("aligned!\n"); 
  i = (char *)(&s + 1) - (char *)&s.d;
  printf ("space used by a char[6] structure element (should be  6):  %u ", i);
  if (i == 6) printf ("OK\n"); else printf ("aligned!\n"); 
  i = sizeof(s);
  printf ("space used by (size of) a whole structure (should be 13): %u ", i);
  if (i == 13) printf ("OK\n"); else printf ("aligned!\n"); 
  printf ("\n");
  printf ("A -fshort-enums option verification:\n");
  printf ("------------------------------------\n");
  printf ("size of enum <=       0xFF (should be 1): %d ", sizeof(e));
  if (sizeof(e) == 1) printf ("OK\n"); else printf ("aligned!\n"); 
  printf ("size of enum <=     0xFFFF (should be 2): %d ", sizeof(f));
  if (sizeof(f) == 2) printf ("OK\n"); else printf ("aligned!\n"); 
  printf ("size of enum <=   0xFFFFFF (should be 4): %d ", sizeof(g));
  if (sizeof(g) == 4) printf ("OK\n"); else printf ("aligned!\n"); 
  printf ("size of enum <= 0xFFFFFFFF (should be 4): %d ", sizeof(h));
  if (sizeof(h) == 4) printf ("OK\n"); else printf ("aligned!\n"); 
  printf ("\n");
  printf ("A 'bit' structures verification:\n");
  printf ("--------------------------------\n");
  i = sizeof(bits);
  printf ("space used by (size of) of 'bit' structure (should be 1): %u ", i);
  if (i == 1) printf ("OK\n"); else printf ("aligned!\n"); 
  i = sizeof(bits2);
  printf ("space used by (size of) of 'bit' structure (should be 7): %u ", i);
  if (i == 7) printf ("OK\n"); else printf ("aligned!\n"); 
  return 0;
}
