unit nwlistvw;

interface

uses
  SysUtils, 
  WinTypes, 
  WinProcs, 
  Messages, 
  Classes, 
  Graphics, 
  Controls,
  ExtCtrls,
  Forms, 
  Dialogs, 
  StdCtrls,
  comCtrls,
  nwBase,
  nwTools,
  nwLib,
  nwServer,
  nwNDS,
  nwPrint ;

{$IFNDEF Ver100}  
{$IFNDEF Ver90}
{$IFNDEF Ver80}
  {$ObjExportAll On}
{$ENDIF}
{$ENDIF}
{$ENDIF}

type
  TNWListView = class(TListView)
  private
    FNWBase        : TNWBase ;
    FObjType       : TNWObjListType ;
    FLastItem,
    FDataField     : string ;
    procedure _populate ;
    procedure _setNWBase(value : TNWBase) ;
    procedure _setObjType(value : TNWObjListType) ;
  protected        
    procedure Notification(AComponent: TComponent;
                           Operation: TOperation); override;
    procedure loaded ; override ;                       
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN ;
    procedure NWMBaseServerChange(var Message : TMessage) ; message NWM_BASESERVERCHANGE ;
  published
    property NWBase        : TNWBase        read FNWBase        write _setNWBase ;
    property ShowObjType   : TNWObjListType read FObjType       write _setObjType default nwlNone ;
    property LastItem      : string         read FLastItem ;
  end;        


implementation

{************************* Component Implementation ****************************}  
procedure TNWListView.Notification(AComponent: TComponent;
                                      Operation: TOperation);
  begin
    inherited Notification(AComponent, Operation);
    if (Operation = opRemove) then
      begin
        if (NWBase <> nil) and (AComponent = NWBase) then
          NWBase := nil ;
      end;
  end;

procedure TNWListView.loaded ;
  begin
    inherited loaded ;
    _populate ;  
  end;  

procedure TNWListView.NWMBaseServerChange(var Message : TMessage) ; 
  begin
    _populate ;
  end;
  
procedure TNWListView.WMLButtonDown(var Message: TWMLButtonDown);
  var
    i        : integer ;
    tempList : TStringList ;
    newItem  : TListItem ;
  begin
    inherited ;
    if (itemFocused = nil) then
      exit ;
    FLastItem := itemFocused.caption ;  {support 'back' feature}
    if (showObjType in [nwlNDSTree,nwlNDSObjList]) then
      begin
        items.clear ;
        tempList := ndsList('',FLastItem) ;
        try
          for i := 0 to (tempList.count -1) do begin
            newItem := items.add ;
            with newItem do begin
              caption    := tempList[i] ;
              data       := tempList.objects[i] ;
              imageIndex := longint(tempList.objects[i]) ;
            end;
          end;
        finally
          tempList.free ;
        end;
      end;
  end;
  

{*********************** Property Write Implementation *************************}  
procedure TNWListView._setNWBase(value : TNWBase) ;
  begin
    if (value <> FNWBase) then
      FNWBase := value ;
    _populate ;
  end;

procedure TNWListView._setObjType(value : TNWObjListType) ;
  begin
    if (value <> FObjType) then
      begin
        FObjType := value ;  
        _populate ;
      end;  
  end;
  
{*************************** Internal Functions ********************************}  

procedure TNWListView._populate ;
  var
    i        : integer ;
    tempList : TStringList ;
    newItem  : TListItem ;
  begin
    if (csLoading in componentState) then
      {nothing}
    else if (showObjType = nwlNone) then
      items.clear 
    else if (FNWBase <> nil) then
      begin
        tempList := FNWBase.getObjectList(showObjType) ;
        items.clear ;
        try
          for i := 0 to (tempList.count -1) do begin
            newItem := items.add ;
            with newItem do begin
              caption    := tempList[i] ;
              data       := tempList.objects[i] ;
              imageIndex := ord(showObjType) ;
            end;
          end;
        finally
          tempList.free ;
        end;  
      end;  
  end;
 
end.
 