unit nwAtEdit;

interface

uses
  SysUtils, 
  WinTypes, 
  WinProcs, 
  Messages, 
  Classes, 
  Graphics, 
  Controls,
  ExtCtrls,
  Forms, 
  Dialogs, 
  StdCtrls,
  nwBase,
  nwTools,
  nwLib,
  nwNDS ;

{$IFDEF Ver110}  
  {$ObjExportAll On}
{$ENDIF}

type
  TNWNDSAttrEdit = class(TEdit)
  private
    FBoolValue     : boolean ;
    FIntValue      : longint ;
    FNWBase        : TNWBase ;
    FPathInfo      : TNWPathInfo ;
    FNDSPathInfo   : TNWDSPathInfo ;
    FAttrType      : TNWDSAttrType ;
    FStrValue      : string ;
    procedure _populate ;
    procedure _setNWBase(value : TNWBase) ;
    procedure _setAttrType(value : TNWDSAttrType) ;
    function  _textToBool(value : string) : boolean ;
  protected        
    procedure Notification(AComponent: TComponent;
                           Operation: TOperation); override;
    procedure loaded ; override ;                       
    procedure NWMBaseUserChange(var Message : TMessage) ; message NWM_BASEUSERCHANGE ;
  public                  
    constructor create(AOwner : TComponent) ; override ;
    function post : boolean ;
  published
    property NWBase       : TNWBase        read FNWBase      write _setNWBase ;
    property NDSAttribute : TNWDSAttrType  read FAttrType    write _setAttrType ;
  end;


implementation

{************************* Component Implementation ****************************}  
constructor TNWNDSAttrEdit.create(AOwner : TComponent) ;
  begin
    inherited create(AOwner) ;
    FStrValue  := '' ;
    FIntValue  := 0  ;
    FBoolValue := false ;
    _populate ;
  end;

procedure TNWNDSAttrEdit.Notification(AComponent: TComponent;
                                      Operation: TOperation);
  begin
    inherited Notification(AComponent, Operation);
    if (Operation = opRemove) then
      begin
        if (NWBase <> nil) and (AComponent = NWBase) then
          NWBase := nil ;
      end;
  end;

procedure TNWNDSAttrEdit.loaded ;
  begin
    inherited loaded ;
    _populate ;  
  end;  

procedure TNWNDSAttrEdit.NWMBaseUserChange(var Message : TMessage) ; 
  begin
    _populate ;
  end;

  
{*********************** Property Read Implementation **************************}  


{*********************** Property Write Implementation *************************}  

procedure TNWNDSAttrEdit._setNWBase(value : TNWBase) ;
  begin
    if (value <> FNWBase) then
      FNWBase := value ;
    _populate ;
  end;

procedure TNWNDSAttrEdit._setAttrType(value : TNWDSAttrType) ;
  begin
    if (value <> FAttrType) then
      FAttrType := value ;
    _populate ;  
  end;  

{*************************** Internal Functions ********************************}  

function TNWNDSAttrEdit.post : boolean ;
  begin
    result := false ;
    if (NWBase = nil) then
      exit ;
    case _ndsGetSynType(FAttrType) of
      SYN_BOOLEAN   :  
        result := ndsModifyBooleanAttr('',NWBase.loginID,NDSAttribute,_textToBool(text)) ;
      SYN_INTEGER, SYN_COUNTER :
        result := ndsModifyIntegerAttr('',NWBase.loginID,NDSAttribute,strToIntDef(text,0)) ;
      SYN_CI_STRING, SYN_DIST_NAME :     
        result := ndsModifyStringAttr('',NWBase.loginID,NDSAttribute,text) ;  
      SYN_PATH :
        begin
          if parseNetwarePath(NWBase.serverHandle,text,FPathInfo) then
            begin
              with FNDSPathInfo do begin
                volumeName := FPathInfo.volumeName ;
                path       := FPathInfo.pathOnly ;
              end;
              result := ndsModifyPathAttr('',NWBase.loginID,NDSAttribute,FNDSPathInfo) ;  
            end;
        end;  
    end;    
  end;  
  
procedure TNWNDSAttrEdit._populate ;
  begin
    text := '' ;  
    if (NWBase = nil) then
      exit ;
    case _ndsGetSynType(FAttrType) of
      SYN_BOOLEAN   :  
        begin
          if ndsGetBooleanAttr('',NWBase.loginID,NDSAttribute,FBoolValue) then
            text := iif(FBoolValue,'True','False') ;
        end;    
      SYN_CI_STRING, SYN_DIST_NAME :  
        begin
          if ndsGetStringAttr('',NWBase.loginID,NDSAttribute,FStrValue) then
            text := FStrValue ;
        end;
      SYN_INTEGER, SYN_COUNTER :
        begin
          if ndsGetIntegerAttr('',NWBase.loginID,NDSAttribute,FIntValue) then
            text := intToStr(FIntValue) ;
        end;  
      SYN_PATH :
        begin
          if ndsGetPathAttr('',NWBase.loginID,NDSAttribute,FNDSPathInfo) then
            text := FNDSPathInfo.volumeName + '\' + FNDSPathInfo.path ;
        end;  
    end;  
    refresh ;
  end;

function TNWNDSAttrEdit._textToBool(value : string) : boolean ;
  begin
    result := false ;
    value  := uppercase(value) ;
    result := (value[1] in ['T','Y','1','+'])  ;
  end;
 
end.
 