unit nwcombo;

interface 

uses
  SysUtils, 
  WinTypes, 
  WinProcs, 
  Messages, 
  Classes, 
  Graphics, 
  Controls,
  Forms, 
  Dialogs, 
  StdCtrls,
  nwBase,
  nwlib,
  nwtools,
  nwnds ;

{$IFDEF Ver110}  
  {$ObjExportAll On}
{$ENDIF}

type
  TNWCombo = class(TComboBox)
  private
    FNWBase  : TNWBase ;
    FObjType : TNWObjListType ;
    procedure _populate ;
    procedure _setObjType(value : TNWObjListType) ;
    procedure _setNWBase(value : TNWBase) ;
  protected              
    procedure Notification(AComponent: TComponent;
                           Operation: TOperation); override;
    procedure loaded ; override ;                       
    procedure NWMBaseServerChange(var Message : TMessage) ; message NWM_BASESERVERCHANGE ;
    procedure WMPaint(var Message : TMessage) ; message WM_PAINT ;
  public  
    constructor create(AOwner : TComponent); override ;
  published           
    property ShowObjType : TNWObjListType read FObjType       write _setObjType default nwlNone ;
    property NWBase      : TNWBase        read FNWBase        write _setNWBase ;
  end;      


implementation

{************************* Component Implementation ****************************}  
constructor TNWCombo.create(AOwner : TComponent) ;
  begin
    inherited create(AOwner) ;
    style := csDropDownList ;
  end;

procedure TNWCombo.Notification(AComponent: TComponent;
                                  Operation: TOperation);
  begin
    inherited Notification(AComponent, Operation);
    if (Operation = opRemove) then
      begin
        if (NWBase <> nil) and (AComponent = NWBase) then
          NWBase := nil ;
      end;
  end;

procedure TNWCombo.loaded ;
  begin
    inherited loaded ;
    _populate ;  
  end;  

procedure TNWCombo.NWMBaseServerChange(var Message : TMessage) ; 
  begin
    _populate ;
  end;
  
procedure TNWCombo.WMPaint(var Message : TMessage) ;
  begin
    inherited ;
    {ensure something shows up in edit control}
    if (items.count < 1) then
      exit ;
    if (style = csDropDownList) then
      begin
        if (itemIndex < 0) then
          begin
            if (FNWBase <> nil) then
              itemIndex := items.indexOf(FNWBase.serverName) ;
          end;  
        if (itemIndex < 0) then  
          itemIndex := 0 ;  
      end
    else if (style = csDropDown) then
      begin
        if (length(text) < 1) then
          text := items[0] ;
      end;  
  end;
    
{*********************** Property Write Implementation *************************}  
procedure TNWCombo._setNWBase(value : TNWBase) ;
  begin
    if (value <> FNWBase) then
      FNWBase := value ;
    _populate ;
  end;

procedure TNWCombo._setObjType(value : TNWObjListType) ;
  begin
    if (value <> FObjType) then
      begin
        FObjType := value ;  
        _populate ;
      end;  
  end;

{*************************** Internal Functions ********************************}  
procedure TNWCombo._populate ;
  {populate items list}
  begin
    if (csLoading in componentState) then
      {nothing}
    else if (showObjType = nwlNone) then
      begin
        items.clear ;
        exit ;
      end  
    else if (FNWBase <> nil) then
      with items do begin
        beginUpdate ;
        clear ;
        addStrings(FNWBase.getObjectList(showObjType)) ;
        endUpdate ;
      end;
  end;  
 

end.
 