unit nwipedit;

interface

uses
  SysUtils, 
  WinTypes, 
  WinProcs, 
  Messages, 
  Classes, 
  Graphics, 
  Controls,
  ExtCtrls,
  Forms, 
  Dialogs, 
  StdCtrls,
  nwBase,
  nwTools,
  nwLib,
  nwProp ;

{$IFDEF Ver110}  
  {$ObjExportAll On}
{$ENDIF}

type
  TNWItemPropEdit = class(TEdit)
  private
    FNWBase        : TNWBase ;
    FPropertyName  : string ;
    procedure _populate ;
    procedure _setNWBase(value : TNWBase) ;
    procedure _setPropertyName(value : string) ;
  protected        
    procedure Notification(AComponent: TComponent;
                           Operation: TOperation); override;
    procedure loaded ; override ;                       
    procedure NWMBaseUserChange(var Message : TMessage) ; message NWM_BASEUSERCHANGE ;
  public    
    constructor create(AOwner : TComponent) ; override ;
    function post : boolean ;
  published
    property NWBase              : TNWBase  read FNWBase        write _setNWBase ;
    property BinderyPropertyName : string   read FPropertyName  write _setPropertyName ;
  end;


implementation

{************************* Component Implementation ****************************}  
constructor TNWItemPropEdit.create(AOwner : TComponent) ;
  begin
    inherited create(AOwner) ;
    _populate ;
  end;

procedure TNWItemPropEdit.Notification(AComponent: TComponent;
                                      Operation: TOperation);
  begin
    inherited Notification(AComponent, Operation);
    if (Operation = opRemove) then
      begin
        if (NWBase <> nil) and (AComponent = NWBase) then
          NWBase := nil ;
      end;
  end;

procedure TNWItemPropEdit.loaded ;
  begin
    inherited loaded ;
    _populate ;  
  end;  

procedure TNWItemPropEdit.NWMBaseUserChange(var Message : TMessage) ; 
  begin
    _populate ;
  end;
  
  
{*********************** Property Read Implementation **************************}  


{*********************** Property Write Implementation *************************}  

procedure TNWItemPropEdit._setPropertyName(value : string) ;
  begin
    value := upperCase(value) ;
    if (value <> FPropertyName) then
      FPropertyName := value ;
    _populate ;
  end;
  
procedure TNWItemPropEdit._setNWBase(value : TNWBase) ;
  begin
    if (value <> FNWBase) then
      FNWBase := value ;
    _populate ;
  end;

{*************************** Internal Functions ********************************}  

function TNWItemPropEdit.post : boolean ;
  begin
    result := false ;
    if (NWBase <> nil) then
      result := writeItemProperty(NWBase.serverHandle,
                                  NWBase.loginID,
                                  NWBase.NWObjectType,
                                  BinderyPropertyName,
                                  text) ;                    
  end;
  
procedure TNWItemPropEdit._populate ;
  begin
    if (NWBase <> nil) then
      text := readItemProperty(NWBase.serverHandle,
                               NWBase.loginID,
                               NWBase.NWObjectType,
                               BinderyPropertyName) ;
    refresh ;
  end;
 
end.
 