unit dbcombox;

interface 

uses
  SysUtils, 
  WinTypes, 
  WinProcs, 
  Messages, 
  Classes, 
  Graphics, 
  Controls,
  Forms, 
  Dialogs, 
  StdCtrls,
  DB,
  DBCtrls,
  {$IFNDEF Ver110}
  DBTables,
  {$ENDIF}
  nwcombo ;
  
{$IFDEF Ver110}  
  {$ObjExportAll On}
{$ENDIF}


type
  TNWDBCombo = class(TNWCombo)
  private
    FGetFieldValue : boolean ;
    FDataSource    : TDataSource ;
    FDataLink      : TFieldDataLink ;
    FDataField     : string ;
    procedure _dataUpdate(sender : TObject) ;
    procedure _setDataSource(value : TDataSource) ;
    procedure _setDataField(value : string) ;
    procedure _setGetFieldValue(value : boolean) ;
  protected              
    procedure Notification(AComponent: TComponent;
                           Operation: TOperation); override;
    procedure WMPaint(var Message : TMessage) ; 
  public            
    { Public declarations }
    constructor create(AOwner: TComponent); override;
    destructor destroy ; override ;
  published           
    { Published declarations }
    property GetFieldValue : boolean     read FGetFieldValue write _setGetFieldValue default false ;
    property DataSource    : TDataSource read FDataSource    write _setDataSource ;
    property DataField     : string      read FDataField     write _setDataField ;
  end;      


implementation

{************************* Component Implementation ****************************}  
constructor TNWDBCombo.create(AOwner : TComponent) ;
  begin
    inherited create(AOwner) ;
    FDataLink := TFieldDataLink.create ;
    FDataLink.onDataChange := _dataUpdate ;
    FGetFieldValue := false ;
  end;

destructor TNWDBCombo.destroy ;
  begin
    if assigned(FDataLink) then
      FDataLink.free ;
    FDataLink := nil ;
    inherited destroy ;
  end;  

procedure TNWDBCombo.Notification(AComponent: TComponent;
                                  Operation: TOperation);
  begin
    inherited Notification(AComponent, Operation);
    if (Operation = opRemove) then
      begin
        if (FDataSource <> nil) and (AComponent = FDataSource) then 
          DataSource := nil ;
      end;
  end;

procedure TNWDBCombo._dataUpdate(sender : TObject) ;
  begin
    {on state changes, etc.}
    if (not (csDestroying in componentState)) and 
       (FDataSource <> nil) and
       (FDataSource.dataSet <> nil) and
       (FDataSource.dataSet.active) then
      refresh ;
  end;

{*********************** Property Write Implementation *************************}  
procedure TNWDBCombo._setDataSource(value : TDataSource) ;
  begin
    if (value <> FDataSource) then
      begin
        FDataSource := value ;
        FDataLink.dataSource := value ;
      end;
    refresh ;  
  end;

procedure TNWDBCombo._setDataField(value : string) ;
  begin
    if (value <> FDataField) then
      begin
        FDataField := value ;
        if (FDataLink <> nil) then
          FDataLink.fieldName := FDataField ;
      end;  
    refresh ;  
  end;  

procedure TNWDBCombo._setGetFieldValue(value : boolean) ;
  begin
    if ((FDataSource <> nil) and
        (FDataSource.dataSet <> nil)) then
      FGetFieldValue := value ;
    refresh ;  
  end;  
  
 procedure TNWDBCombo.WMPaint(var Message : TMessage) ; 
   begin
     if ((items.count < 1) or (not getFieldValue)) or
        ((FDataSource = nil) or (FDataSource.dataSet = nil) or 
         (not FDataSource.dataSet.active) or (FDataLink.field = nil)) then
       exit ;
     if (style in [csDropDownList]) then
       begin
         if (itemIndex < 0) then
           itemIndex := items.indexOf(FDataLink.field.asString) ;
         if (itemIndex < 0) then
           itemIndex := 0 ;  
       end    
     else if (style in [csSImple,csDropDown]) then
       begin
         if (length(text) < 1) then
           text := FDataLink.field.asString ;
       end;    
   end;

end.
 
