unit dbout;

interface

uses
  SysUtils, 
  WinTypes, 
  WinProcs, 
  Messages, 
  Classes, 
  Graphics, 
  Controls,
  ExtCtrls,
  Outline,
  menus,
  Forms, 
  Dialogs, 
  grids,
  StdCtrls,
  DB,
  DBCtrls,
  {$IFNDEF Ver110}
  DBTables,
  {$ENDIF}
  nwout ;

{$IFDEF Ver110}  
  {$ObjExportAll On}
{$ENDIF}

type
  TNWDBOutline = class(TNWOutline)
  private
    FDataSource : TDataSource ;
    FDataLink   : TFieldDataLink ;
    FDataField  : string ;
    procedure _dataUpdate(sender : TObject) ;
    procedure _setDataSource(value : TDataSource) ;
    procedure _setDataField(value : string) ;
  protected
    procedure Notification(AComponent: TComponent;
                           Operation: TOperation); override;
    procedure selectOutlineItem ; override ;
  public      
    constructor create(AOwner : TComponent) ; override ;
    destructor destroy ; override ;
  published     
    property DataSource : TDataSource read FDataSource write _setDataSource ;
    property DataField  : string      read FDataField  write _setDataField ;
  end;

implementation

{************************* Component Implementation ****************************}  
constructor TNWDBOutline.create(AOwner : TComponent) ;
  begin
    inherited create(AOwner) ;
    FDataLink := TFieldDataLink.create ;
    FDataLink.onDataChange := _dataUpdate ;
  end;

destructor TNWDBOutline.destroy ;
  begin
    if assigned(FDataLink) then
      FDataLink.free ;
    inherited destroy ;
  end;  

procedure TNWDBOutline.Notification(AComponent: TComponent;
                                  Operation: TOperation);
  begin
    inherited Notification(AComponent, Operation);
    if (Operation = opRemove) then
      begin
        if (FDataSource <> nil) and (AComponent = FDataSource) then 
          DataSource := nil ;
      end;
  end;

procedure TNWDBOutline._dataUpdate(sender : TObject) ;
  begin
    {on state changes, etc.}
    if (not (csDestroying in componentState)) and 
       (FDataSource <> nil) and
       (FDataSource.dataSet <> nil) and
       (FDataSource.dataSet.active) then
      refresh ;
  end;

procedure TNWDBOutline.selectOutlineItem ;
  var
    ctemp : string ;
  begin
    inherited selectOutlineItem ;
    ctemp := items[selectedItem].text ;
    if (FDataLink <> nil) and
       (FDataLink.dataSource <> nil) and 
       (FDataLink.dataSource.dataSet <> nil) and
       (FDataLink.dataSource.dataSet.active) then
      begin
        if (not (FDataLink.dataSource.state in [dsEdit,dsInsert])) then
          FDataLink.edit ;
        FDataLink.field.asString := text ;
      end;    
  end;
  

{*********************** Property Write Implementation *************************}  
procedure TNWDBOutline._setDataSource(value : TDataSource) ;
  begin
    if (value <> FDataSource) then
      begin
        FDataSource := value ;
        FDataLink.dataSource := value ;
      end;
  end;

procedure TNWDBOutline._setDataField(value : string) ;
  begin
    if (value <> FDataField) then
      begin
        FDataField := value ;
        if (FDataLink <> nil) then
          FDataLink.fieldName := FDataField ;
      end;  
  end;  
  
end.
 