unit dbtreevw;

interface

uses
  SysUtils, 
  WinTypes, 
  WinProcs, 
  Messages, 
  Classes, 
  Graphics, 
  Controls,
  ExtCtrls,
  Outline,
  Forms, 
  Dialogs, 
  StdCtrls,
  DB,
  DBCtrls,
  {$IFNDEF ver110}
  DBTables,
  {$ENDIF}
  comCtrls,
  nwTreeVw ;

{$IFDEF Ver110}  
  {$ObjExportAll On}
{$ENDIF}

type
  TNWDBTreeView = class(TNWTreeView)
  private
    FDataSource : TDataSource ;
    FDataLink   : TFieldDataLink ;
    FDataField  : string ;
    procedure _dataUpdate(sender : TObject) ;
    procedure _setDataSource(value : TDataSource) ;
    procedure _setDataField(value : string) ;
  protected        
    procedure Notification(AComponent: TComponent;
                           Operation: TOperation); override;
  public    
    constructor create(AOwner : TComponent) ; override ;
    destructor  destroy ; override ;
  published
    property DataSource : TDataSource    read FDataSource    write _setDataSource ;
    property DataField  : string         read FDataField     write _setDataField ;
  end;


implementation

{************************* Component Implementation ****************************}  
constructor TNWDBTreeView.create(AOwner : TComponent) ;
  begin
    inherited create(AOwner) ;
    FDataLink := TFieldDataLink.create ;
    FDataLink.onDataChange := _dataUpdate ;
  end;

procedure TNWDBTreeView.Notification(AComponent: TComponent;
                                      Operation: TOperation);
  begin
    inherited Notification(AComponent, Operation);
    if (Operation = opRemove) then
      begin
        if (FDataSource <> nil) and (AComponent = FDataSource) then 
          DataSource := nil;
      end;
  end;

destructor TNWDBTreeView.destroy ;
  begin
    if assigned(FDataLink) then
      FDataLink.free ;
    FDataLink := nil ;    
    inherited destroy ;
  end;  

procedure TNWDBTreeView._dataUpdate(sender : TObject) ;
  begin
    {on state changes, etc.}
    if (not (csDestroying in componentState)) and 
       (FDataSource <> nil) and
       (FDataSource.dataSet <> nil) and
       (FDataSource.dataSet.active) then
      refresh ;
  end;

{*********************** Property Write Implementation *************************}  

procedure TNWDBTreeView._setDataSource(value : TDataSource) ;
  begin
    if (value <> FDataSource) then
      begin
        FDataSource := value ;
        FDataLink.dataSource := value ;
      end;
  end;

procedure TNWDBTreeView._setDataField(value : string) ;
  begin
    if (value <> FDataField) then
      begin
        FDataField := value ;
        if (FDataLink <> nil) then
          FDataLink.fieldName := FDataField ;
      end;  
  end;  

 
end.
 