unit dblist;

interface 

uses
  SysUtils, 
  WinTypes, 
  WinProcs, 
  Messages, 
  Classes, 
  Graphics, 
  Controls,
  Forms, 
  Dialogs, 
  StdCtrls,
  DB,
  DBCtrls,
  {$IFNDEF Ver110}
  DBTables,
  {$ENDIF}
  {$IFDEF Ver80}
  DBTables,
  {$ENDIF}
  nwBase,
  nwlib,
  nwnds,
  nwList ;

{$IFDEF Ver110}  
  {$ObjExportAll On}
{$ENDIF}

type
  TNWDBListBox = class(TNWListBox)
  private
    FGetFieldValue : boolean ;
    FDataSource    : TDataSource ;
    FDataLink      : TFieldDataLink ;
    FDataField     : string ;
    procedure _dataUpdate(sender : TObject) ;
    procedure _setDataSource(value : TDataSource) ;
    procedure _setDataField(value : string) ;
    procedure _setGetFieldValue(value : boolean) ;
  protected              
    procedure Notification(AComponent: TComponent;
                           Operation: TOperation); override;
  public            
    constructor create(AOwner: TComponent); override;
    destructor  destroy ; override ;
    procedure WMPaint(var Message : TMessage) ; 
  published           
    property GetFieldValue : boolean     read FGetFieldValue write _setGetFieldValue default false ;
    property DataSource    : TDataSource read FDataSource    write _setDataSource ;
    property DataField     : string      read FDataField     write _setDataField ;
  end;      

implementation

{************************* Component Implementation ****************************}  
constructor TNWDBListBox.create(AOwner : TComponent) ;
  begin
    inherited create(AOwner) ;
    FDataLink := TFieldDataLink.create ;
    FDataLink.onDataChange := _dataUpdate ;
    getFieldValue := false ;
  end;

procedure TNWDBListBox.Notification(AComponent: TComponent;
                                      Operation: TOperation);
  begin
    inherited Notification(AComponent, Operation);
    if (Operation = opRemove) then
      begin
        if (FDataSource <> nil) and (AComponent = FDataSource) then 
          DataSource := nil;
      end;
  end;

destructor TNWDBListBox.destroy ;
  begin
    if assigned(FDataLink) then
      FDataLink.free ;
    FDataLink := nil ;    
    inherited destroy ;
  end;  


procedure TNWDBListBox.WMPaint(var Message : TMessage) ;
  begin
    if ((items.count < 1) or (not getFieldValue) or (itemIndex > 0)) or
       ((FDataSource = nil) or (FDataLink = nil) or 
        (FDataLink.field = nil)) then
      exit;
    itemIndex := items.indexOf(FDataLink.field.asString) ;
    if (itemIndex < 0) then
      itemIndex := 0 ;  
  end;  

procedure TNWDBListBox._dataUpdate(sender : TObject) ;
  begin
    {on state changes, etc.}
    if (not (csDestroying in componentState)) and 
       (FDataSource <> nil) and
       (FDataSource.dataSet <> nil) and
       (FDataSource.dataSet.active) then
      refresh ;
  end;

  
{*********************** Property Write Implementation *************************}  

procedure TNWDBListBox._setDataSource(value : TDataSource) ;
  begin
    if (value <> FDataSource) then
      begin
        FDataSource := value ;
        FDataLink.dataSource := value ;
      end;
  end;

procedure TNWDBListBox._setDataField(value : string) ;
  begin
    if (value <> FDataField) then
      begin
        FDataField := value ;
        if (FDataLink <> nil) then
          FDataLink.fieldName := FDataField ;
      end;  
  end;  

procedure TNWDBListBox._setGetFieldValue(value : boolean) ;
  begin
    if ((FDataSource <> nil) and
       (FDataSource.dataSet <> nil)) then
      FGetFieldValue := value ;
  end;  

  
end.
 