unit nwlist;

interface 

uses
  SysUtils, 
  WinTypes, 
  WinProcs, 
  Messages, 
  Classes, 
  Graphics, 
  Controls,
  Forms, 
  Dialogs, 
  StdCtrls,
  nwBase,
  nwlib,
  nwnds,
  nwtools ;

{$IFDEF Ver110}  
  {$ObjExportAll On}
{$ENDIF}

type
  TNWListBox = class(TListBox)
  private
    FNWBase  : TNWBase ;
    FObjType : TNWObjListType ;
    procedure _populate ;
    procedure _setObjType(value : TNWObjListType) ;
    procedure _setNWBase(value : TNWBase) ;
    procedure _setText(value : string) ;
    function  _getText : string ;
  protected              
    procedure Notification(AComponent: TComponent;
                           Operation: TOperation); override;
    procedure loaded ; override ;                       
    procedure NWMBaseServerChange(var Message : TMessage) ; message NWM_BASESERVERCHANGE ;
    procedure WMPaint(var Message : TMessage) ;
  published           
    property ShowObjType : TNWObjListType read FObjType write _setObjType default nwlNone ;
    property NWBase      : TNWBase        read FNWBase  write _setNWBase ;
    property Text        : string         read _getText write _setText stored false ;
  end;      

implementation

{************************* Component Implementation ****************************}  
procedure TNWListBox.Notification(AComponent: TComponent;
                                      Operation: TOperation);
  begin
    inherited Notification(AComponent, Operation);
    if (Operation = opRemove) then
      begin
        if (NWBase <> nil) and (AComponent = NWBase) then
          NWBase := nil ;
      end;
  end;

procedure TNWListBox.loaded ;
  begin
    inherited loaded ;
    _populate ;  
  end;  

procedure TNWListBox.NWMBaseServerChange(var Message : TMessage) ; 
  begin
    _populate ;
  end;

procedure TNWListBox.WMPaint(var Message : TMessage) ;
  begin
    if (items.count > 0) and (itemIndex < 1) then
       itemIndex := 0 ;  
  end;
  
{*********************** Property Read Implementation **************************}  
function TNWListBox._getText : string ;
  begin
    result := '' ;
    if (items.count < 1) then
      exit 
    else if (itemIndex < 1) then
      itemIndex := 0 ;
    result := items[itemIndex] ;  
  end;
  
{*********************** Property Write Implementation *************************}  
procedure TNWListBox._setNWBase(value : TNWBase) ;
  begin
    if (value <> FNWBase) then
      FNWBase := value ;
    _populate ;
  end;

procedure TNWListBox._setObjType(value : TNWObjListType) ;
  begin
    if (value <> FObjType) then
      begin
        FObjType := value ;  
        _populate ;
      end;  
  end;

procedure TNWListBox._setText(value : string) ;
  begin
    if (csDesigning in componentState) then
      alertBox('This is a Read-Only Property') ;
  end;  

{*************************** Internal Functions ********************************}  
procedure TNWListBox._populate ;
  {populate items list}
  begin
    if (csLoading in componentState) then
      {nothing}
    else if (showObjType = nwlNone) then
      begin
        items.clear ;
        exit ;
      end
    else if (FNWBase <> nil) then
      with items do begin
        beginUpdate ;
        clear ;
        addStrings(FNWBase.getObjectList(showObjType)) ;
        endUpdate ;
      end;
  end;  
 

end.
 