unit nwlogmem;

interface

uses
  sysUtils,
  winTypes,
  WinProcs,
  Classes,
  Forms,
  Controls,
  messages,
  StdCtrls,
  nwBase,
  nwLib,
  nwNDS,
  nwTools ;

{$IFDEF Ver110}  
  {$ObjExportAll On}
{$ENDIF}

type
  TNWLoginScriptMemo = class(TMemo)
  private
    FSystemLogin : boolean ;
    FAfterPost,
    FBeforePost  : TNotifyEvent ;
    FNWBase      : TNWBase ;
    procedure _setNWBase(value : TNWBase) ;
    procedure _setSystemLogin(value : boolean) ;
    procedure _populate ;
  protected 
    procedure Notification(AComponent: TComponent;
                           Operation: TOperation); override;
    procedure NWMBaseServerChange(var Message : TMessage) ; message NWM_BASESERVERCHANGE ;
    procedure NWMBaseUserChange(var Message : TMessage) ; message NWM_BASEUSERCHANGE ;
    procedure loaded ; override ;                       
  public 
    constructor create(AOwner : TComponent) ; override ;  
    function post : boolean ;
    procedure process(showProgress : boolean) ;
  published              
    property OnAfterPost  : TNotifyEvent read FAfterPost   write FAfterPost ;
    property OnBeforePost : TNotifyEvent read FBeforePost  write FBeforePost ;
    property NWBase       : TNWBase      read FNWBase      write _setNWBase ;
    property SystemLogin  : boolean      read FSystemLogin write _setSystemLogin default false ;
  end;


implementation

{************************* Component Implementation ****************************}  

constructor TNWLoginScriptMemo.create(AOwner : TComponent) ;
  begin
    inherited create(AOwner) ;
    FSystemLogin := false ;
  end;

procedure TNWLoginScriptMemo.Notification(AComponent: TComponent;
                                      Operation: TOperation);
  begin
    inherited Notification(AComponent, Operation);
    if (Operation = opRemove) then
      begin
        if (NWBase <> nil) and (AComponent = NWBase) then
          NWBase := nil ;
      end;
  end;

procedure TNWLoginScriptMemo.loaded ;
  begin
    inherited loaded ;
    _populate ;  
  end;

procedure TNWLoginScriptMemo._populate ;
  {populate items list}
  var
    sysDrive : char ;
    fStream  : THandleStream ;
    nHandle  : integer ;
  begin
    if (not (csLoading in componentState)) then
      with lines do try 
        beginUpdate ;
        clear ;                 
        if (FNWBase = nil) then
          {already cleared}
        else if FSystemLogin then              {read system login script}
          begin
            sysDrive := getNextNetDrive ;
            if map(sysDrive,FNWBase.serverName + '/sys:') then
              try
                if fileExists(sysDrive + ':\public\net$log.dat') then
                  loadFromFile(sysDrive + ':\public\net$log.dat') 
              finally  
                mapDelete(sysDrive) ;  
              end;  
          end  
        else if (FNWBase.loginID  <> '') then
          begin
            if FNWBase.ndsAvailable then  {read nds stream}
              begin
                if ndsOpenAttrStream('',FNWBase.loginID,dsaLoginScript,fStream) then
                  try
                    loadFromStream(fStream)  ;
                  finally  
                    nhandle := fStream.handle ;
                    fStream.free ;
                    fileClose(nhandle) ;
                  end ;
              end  
            else                          {read bindery login script}
              begin
                sysDrive := getNextNetDrive ;
                if map(sysDrive,FNWBase.serverName + '/sys:') then
                  begin
                    if fileExists(sysDrive + ':\mail\' + FNWBase.objectID + '\login') then
                      loadFromFile(sysDrive + ':\mail\' + FNWBase.objectID + '\login') ;
                    mapDelete(sysDrive) ;  
                  end;
              end;  
          end;
      finally    
        endUpdate ;  
      end;    
  end;  
  

{************************* Messaging Implementation ****************************}  
procedure TNWLoginScriptMemo.NWMBaseServerChange(var Message : TMessage) ; 
  begin
    _populate ;
  end;

procedure TNWLoginScriptMemo.NWMBaseUserChange(var Message : TMessage) ; 
  begin
    _populate ;
  end;
  

{*********************** Property Write Implementation *************************}  

procedure TNWLoginScriptMemo._setNWBase(value : TNWBase) ;
  begin
    if (value <> FNWBase) then
      FNWBase := value ;
    _populate ;
  end;

procedure TNWLoginScriptMemo._setSystemLogin(value : boolean) ;
  begin
    FSystemLogin := value ;
    _populate ;
  end;
  
{**************************** Method Implementation ****************************}  
function TNWLoginScriptMemo.post : boolean ;
  var
    sysDrive : char ;
    nHandle  : integer ;
    fStream  : THandleStream ;
  begin
    result := false ;
    if (FNWBase = nil) then
      exit ;
    if assigned(FBeforePost) then
      FBeforePost(self) ;  
    with lines do 
      try
        if FSystemLogin then              {write system login script}
          begin
            sysDrive := getNextNetDrive ;
            if map(sysDrive,FNWBase.serverName + '/sys:') then
              try
                saveToFile(sysDrive + ':\public\net$log.dat') ;
              finally
                mapDelete(sysDrive) ;
              end;  
            result := true ;
          end  
        else if (FNWBase.loginID <> '') then
          begin
            if FNWBase.ndsAvailable then   {write NDS Login Stream}
              begin
                if ndsOpenAttrStream('',FNWBase.loginID,dsaLoginScript,fStream) then
                  try
                    saveToStream(fStream) ;
                    result := true ;
                  finally 
                    nHandle := fStream.handle ;
                    fStream.free ;
                    fileClose(nHandle) ;
                  end;
              end
            else
              begin                       {write bindery login script}
                sysDrive := getNextNetDrive ;
                if map(sysDrive,FNWBase.serverName + '/sys:') then
                  try
                    saveToFile(sysDrive + ':\mail\' + FNWBase.objectID + '\login') ; 
                  finally
                    mapDelete(sysDrive) ;
                  end;  
                result := true ;  
              end;  
          end;
      except
        {nothing - just return false}
      end;    
    if assigned(FAfterPost) then
      FAfterPost(self) ;  
  end;

{ interpret login script }  
procedure TNWLoginScriptMemo.process(showProgress : boolean) ;
  var
    i         : integer ;
    cpCmdLine : array[0..255] of char ;
    verb,
    cmdLine   : string ;
  begin
    for i := 0 to (lines.count -1) do begin
      verb    := upperCase(strExtract(lines[i],' ',1)) ;
      cmdline := strExtract(lines[i],' ',2) ;
      if (copy(verb,1,1) = ';') or (verb = 'REM') then
        {comment - ignore}
      else if (copy(verb,1,1) = '#') then
        {execute DOS-style command}
        {$IFDef Win32}
        winExec(PChar(copy(lines[i],2,255)),sw_showNormal)
        {$ELSE}
        begin
          strPCopy(cpCmdLine,copy(lines[i],2,255)) ;
          winExec(cpCmdLine,sw_showNormal)
        end
        {$ENDIF}
      else if (verb = 'WRITE') then
        begin
          cmdLine := strTran(cmdLine,'"','') ;
          if showProgress and (length(cmdLine) > 0) then
            okBox(cmdLine) ;
        end
      else if (verb = 'MAP') then
        begin
          if (pos(' INS ',upperCase(lines[i])) < 1) then
            begin
              verb := strExtract(cmdLine,'=',1) ; {map f:=sys:\dir\dir}
              cmdLine := strExtract(cmdLine,'=',2) ;
              map(verb[1],cmdLine) ;
            end
          else  {map ins s1:=sys:\dir\dir }
            begin
            end;  
        end
      else if (verb = 'CAPTURE') then
        begin
        end
      else if (verb = 'IF') then
        begin
        end
    end;   
  end;  
  

end.
 