{ *************** NDS - Related Functions ****************
                                                                          
  Developed with Novell Inc.'s Client SDK for C SDK

  Copyright 1995-1999 by Devont Software Inc. and Jim Tyson.  All
  rights reserved.

  Thanks go to Nicholai Jensen for his work in supporting
  additional NDS object types.

}

unit nwNDS;

interface

uses
  SysUtils,
  Classes,
  winTypes,
  winProcs ;

  {$I nwlib.inc}

  type
    {$I nwTypes.inc }

  type
    ExNWNDS = class(Exception) ;

  { NDS Filter Syntax Types }
  type
    TNWDSSynTypes = (SYN_UNKNOWN,
                     SYN_DIST_NAME,
                     SYN_CE_STRING,
                     SYN_CI_STRING,
                     SYN_PR_STRING,
                     SYN_NU_STRING,
                     SYN_CI_LIST,
                     SYN_BOOLEAN,
                     SYN_INTEGER,
                     SYN_OCTET_STRING,
                     SYN_TEL_NUMBER,
                     SYN_FAX_NUMBER,
                     SYN_NET_ADDRESS,
                     SYN_OCTET_LIST, 	
                     SYN_EMAIL_ADDRESS,
                     SYN_PATH,
                     SYN_REPLICA_POINTER,
                     SYN_OBJECT_ACL,
                     SYN_PO_ADDRESS,
                     SYN_TIMESTAMP,
                     SYN_CLASS_NAME,
                     SYN_STREAM,
                     SYN_COUNTER,
                     SYN_BACK_LINK,
                     SYN_TIME,
                     SYN_TYPED_NAME,
                     SYN_HOLD,
                     SYN_INTERVAL,
                     SYNTAX_COUNT ) ;
  type
    TNWDSObjType =
       (dsoAFPServer,
        dsoAlias,
        dsoBinderyObject,
        dsoBinderyQueue,
        dsoComputer,
        dsoCountry,
        dsoDirectoryMap,
        dsoExternalEntity,
        dsoGroup,
        dsoList,
        dsoLocality,
        dsoMessageRoutingGroup,
        dsoMessagingServer,
        dsoNcpServer,
        dsoOrganization,
        dsoOrganizationalRole,
        dsoOrganizationalUnit,
        dsoPrinter,
        dsoPrintServer,
        dsoProfile,
        dsoQueue,
        dsoServer,     {3.01 add}
        dsoTop,
        dsoUnknown,
        dsoUser,
        dsoVolume,
        dsoTree,       {3.01 add}
        dsoFile,       {3.01 add}
        dsoDirectory,  {3.01 add}
        dsoQueueJob,   {3.01 add}
        dsoApplication, 
        dsoWSGroup,     
        dsoWorkstation) ; 

  type
    TNWDSAttrType =
       (dsaAccountBalance,dsaACL,dsaAliasedObjName,
        dsaAllowUnlimitedCredit,dsaAuthorityRevocation,
        dsaBackLink,dsaBinderyObjRestriction,
        dsaBinderyProperty,dsaBinderyType,
        dsaCountry,dsaCAPrivateKey,dsaCAPublicKey,
        dsaCartridge,dsaCertificateRevocation,
        dsaCertificateValidityInterval,
        dsaClassName,
        dsaCommonName,dsaConvergence,
        dsaCrossCertificatePair,dsaDefaultQueue,
        dsaDescription,dsaDetectIntruder,dsaDevice,
        dsaDSRevision,dsaEmailAddress,dsaForeignEMailAddress,dsaExternalName,
        dsaEquivalentToMe,dsaExternalSynchronizer,
        dsaFacsimileTelephoneNumber,dsaFullName,
        dsaGenerationalQualifier,dsaGroupID,
        dsaGivenName,dsaGroupMembership,
        dsaHighConvergenceSyncInterval,
        dsaHigherPrivileges,dsaHomeDirectory,
        dsaHostDevice,dsaHostResourceName,
        dsaHostServer,dsaInheritedACL,dsaInitials,
        dsaIntruderAttemptResetInterval,
        dsaIntruderLockoutResetInterval,dsaLocality,
        dsaLanguage,dsaLastLoginTime,
        dsaLastReferencedTime,dsaLockedByIntruder,
        dsaLockoutAfterDetection,
        dsaLoginAllowedTimeMap,dsaLoginDisabled,
        dsaLoginExpirationTime,dsaLoginGraceLimit,
        dsaLoginGraceRemaining,dsaLoginIntruderAddress,
        dsaLoginIntruderAttempts,dsaLoginIntruderLimit,
        dsaLoginIntruderResetTime,
        dsaLoginMaximumSimultaneous,
        dsaLoginScript,dsaLoginTime,
        dsaLowConvergenceResetTime,
        dsaLowConvergenceSyncInterval,dsaMailboxID,
        dsaMailboxLocation,dsaMember,dsaMemory,
        dsaMessageRoutingGroup,dsaMessageServer,
        dsaMessagingDatabaseLocation,dsaMessagingServer,
        dsaMessagingServerType,
        dsaMinimumAccountBalance,dsaNetworkAddress,
        dsaNetworkAddressRestriction,dsaNNSDomain,
        dsaNotify,dsaOrganization,dsaObituary,
        dsaObjectClass,dsaOperator,dsaOrganizationalUnit,
        dsaOwner,dsaPageDescriptionLanguage,
        dsaPartitionControl,dsaPartitionCreationTime,
        dsaPasswordAllowChange,
        dsaPasswordExpirationInterval,
        dsaPasswordExpirationTime,
        dsaPasswordMinimumLength,dsaPasswordRequired,
        dsaPasswordUniqueRequired,dsaPasswordsUsed,
        dsaPath,dsaPhysicalDeliveryOfficeName,
        dsaPostalAddress,dsaPostalCode,dsaPostalOfficeBox,
        daPostmaster,dsaPrintJobConfiguration,
        dsaPrintServer,dsaPrinter,
        dsaPrinterConfiguration,
        dsaPrinterControl,dsaPrivateKey,dsaProfile,
        dsaProfileMembership,dsaPublicKey,dsaQueue,
        dsaQueueDirectory,dsaReceivedUpTo,
        dsaReference,dsaReplica,dsaReplicaUpTo,
        dsaResource,dsaRevision,dsaRoleOccupant,
        dsaState,dsaStreetAddress,dsaSAPName,
        dsaSecurityEquals,dsaSecurityFlags,
        dsaSeeAlso,dsaSerialNumber,dsaServer,
        dsaServerHolds,dsaStatus,
        dsaSupportedConnections,dsaSupportedGateway,
        dsaSupportedServices,dsaSupportedTypefaces,
        dsaSurname,dsaSynchronizesUpTo,
        dsaTelephoneNumber,dsaTitle,dsaTypeCreatorMap,
        dsaUserID,dsaUnknown,dsaUnknownBaseClass,
        dsaUser,dsaVersion,dsaVolume,dsaAssociations,
        dsaAuthorityRevocationList,
        dsaBusinessCategory,
        dsaCarLicense,
        dsaDisplayName,
        dsaEmployeeID,
        dsaJPEGPhoto,
        dsaLDAPPhoto,
        dsaManager,
        dsaMobile,
        dsaPager,
        dsaPrinterModel,
        dsaPrinterManufacturer,
        dsaRoomNumber,
        dsaSecretary,
        dsaTimeZone,
        dsaTreeName
        ) ; 

  type
    TNWDSAttrAction = (dsaaAdd,dsaaEdit,dsaaRemoveValue,dsaaRemoveAttr) ;

  {base object information}
  type
    TNWDSObjectInfo = record
      objType          : TNWDSObjType ;
      contextName,
      aliasName,
      objName,
      hostServer,
      hostResourceName,
      directoryName,
      objectClassName,
      fullName,
      password,
      surname,
      givenName,
      cn,
      o,
      ou               : string ;
    end;

  type
    TNWDSAttrRights = record   {masks on spec p.39}
      compare    : boolean ;
      read       : boolean ;
      write      : boolean ;
      self       : boolean ;
      supervisor : boolean ;
    end;

  type
    TNWDSEntryRights = record
      browse     : boolean ;
      add        : boolean ;
      canDelete  : boolean ;
      rename     : boolean ;
      supervisor : boolean ;
    end;

  type
    TNWDSSMSRights = record
      scan       : boolean ;
      backup     : boolean ;
      restore    : boolean ;
      rename     : boolean ;
      canDelete  : boolean ;
      admin      : boolean ;
    end;

  type
    TNWDSPathInfo = record
      nameSpaceType : longint ;
      volumeName    : string ;
      path          : string ;
    end;

  type
    TNWDSEMailInfo = record
      emailType,
      filler        : longint ;
      emailAddress  : TRetBuff ;
    end;

  type
    EMail_Address_T = record
      emailType     : longint ;
      emailAddress  : pnstr8 ;
    end;
    

  type
    TNWDSPhoneInfo  = record
      parmData    : array[0..7] of char ;
      filler      : longint  ;
      phoneNumber : TRetBuff ;
    end;

  type
    TNWDSNetworkAddress = record
      addressType,
      addressLen    : longint ;
      address       : pnstr8  ;
    end;

  type
    TNWDSObjectACL = record 
      protectedAttrName  : pnstr8  ;
      subjectName        : pnstr8  ;
      privileges         : nuint32 ;
    end;

  type 
    TNWDSAttrFlags = record
      singleValue,
      sized,
      nonRemovable,
      readOnly,
      hidden,
      stringType,
      syncImmediate : boolean ;
    end;

  type 
    TNWDSClassFlags = record
      container,
      effective,
      nonRemovable,
      ambiguousNaming,
      ambiguousContainment : boolean ;
  end;    
      
  type
    TNWDSClassDef = record
      length     : longint ;
      classFlags : TNWDSClassFlags ;
  end;      
  
  type
    TNWDSAttrDef = record
      attrFlags  : TNWDSAttrFlags ;
      syntaxType : TNWDSSynTypes ;
      minValue,
      maxValue   : longint ; 
  end; 

  {******** Public Interface Function Declarations *********}
  function ndsInit : boolean ;
  function ndsClose : boolean ;
  function ndsGetServerDN(nServer : TNWConnHandle) : string ;
  function ndsGetBinderyContextName(nServer : TNWConnHandle) : string ;
  function ndsGetContextName : string ;
  function ndsSetContextName(var context : TNWDSContextHandle ;
                             ctext   : string ) : boolean ;
  function ndsAbbreviateName(cname : string) : string ;
  function ndsExpandName(cname : string) : string ;
  function ndsWhoAmI : string ;
  function ndsLogin(contextName, cname, cPassword : string) : boolean ;
  function ndsLogout : boolean ;
  function ndsPassCheck(contextName,cname, cPassword : string) : boolean ;
  function ndsGetRootName(cobject : string) : string ;
  function ndsFreeContext(context : TNWDSContextHandle) : boolean ;
  function ndsGetContextHandle : TNWDSContextHandle ;
  function ndsCopyContext(inContext : TNWDSContextHandle) : TNWDSContextHandle ;
  function ndsGetObjID(nServer : TNWConnHandle ; 
                       objectName : string) : string  ;
  function ndsGetObjName(nServer : TNWConnHandle ;
                         objID : TObjID) : string ;
  function ndsGetAttrRights(cSource,cTarget : string ;
                       var attrRights : TNWDSAttrRights) : boolean ;
  function ndsGetSMSRights(cSource, cTarget : string ;
                       var smsRights : TNWDSsmsRights) : boolean ;
  function ndsGetEntryRights(cSource, cTarget : string ;
                       var entryRights : TNWDSEntryRights) : boolean ;


  {1.5 additions}
  function ndsConnectToServer(serverName : string) : TNWConnHandle ;
  function ndsisDSServer(nServer : TNWConnHandle) : boolean ;
  function ndsGetServerTreeName(nServer : TNWConnHandle) : string ;
  function ndsSetPreferredTreeName(treeName : string) : boolean ;
  function ndsGetPreferredDSServer : TNWConnHandle ;
  function ndsAttach(serverName : string) : TNWConnHandle ;
  function ndsDetach(nServer : TNWConnHandle) : boolean ;
  function ndsAuthenticateServerConn(nServer : TNWConnHandle) : boolean ;

  {2.03 additions}
  function ndsGetTreeList : TStringList ;

  {2.1 changes}
  function ndsChangePassword(contextName,   {used to be serverHandle}
                             cUserID,
                             newPassword,
                             oldPassword : string) : boolean ;

  {2.1 additions}
  function ndsSetContext(ctext : string) : boolean ;
  function ndsGetObjType(contextName, objName : string) : TNWDSObjType ;
  function ndsList(contextName, baseObjName : string) : TStringList ;
  function ndsCreateObject(var ndsObjInfo : TNWDSObjectInfo) : boolean;
  function ndsAddObjAttr(contextName,
                         objName      : string ;
                         attrType     : TNWDSAttrType ;
                         pAttrValue   : pointer) : boolean ;
  function ndsModifyObjAttr(contextName,
                            objName     : string ;
                            attrType    : TNWDSAttrType ;
                            pAttrValue  : pointer) : boolean ;
  function ndsGetObjAttr(context      : TNWDSContextHandle ;
                         objName      : string ;
                         attrType     : TNWDSAttrType ;
                         value        : pointer) : boolean ;
                         
  function ndsRemoveObject(contextName,
                           objName     : string ) : boolean ;
  function ndsGetStringAttr(contextName, objName : string ;
                            attrType : TNWDSAttrType;
                            var value : string) : boolean ;
  function ndsGetBooleanAttr(contextName, objName : string ;
                             attrType : TNWDSAttrType;
                             var value : boolean) : boolean ;
  function ndsGetIntegerAttr(contextName, objName : string ;
                             attrType : TNWDSAttrType;
                             var value : longint) : boolean ;
  function ndsGetDateTimeAttr(contextName, objName : string ;
                              attrType : TNWDSAttrType;
                              var value : TDateTime) : boolean ;
  function ndsGetMultiAttr(contextName,
                           objName     : string ;
                           attrType    : TNWDSAttrType ;
                           var objList : TList) : boolean ;
  function ndsCreateStringAttr(contextName,
                               objName   : string ;
                               attrType  : TNWDSAttrType      ;
                               attrVal   : string) : boolean  ;
  function ndsCreateIntegerAttr(contextName,
                                objName   : string ;
                                attrType  : TNWDSAttrType      ;
                                attrVal   : longInt) : boolean  ;
  function ndsCreateBooleanAttr(contextName,
                                objName   : string ;
                                attrType  : TNWDSAttrType      ;
                                attrVal   : boolean) : boolean  ;
  function ndsCreateDateTimeAttr(contextName,
                                 objName   : string ;
                                 attrType  : TNWDSAttrType      ;
                                 attrVal   : TDatetime) : boolean  ;
  function ndsModifyStringAttr(contextName,
                               objName      : string ;
                               attrType     : TNWDSAttrType ;
                               attrVal      : string) : boolean ;
  function ndsModifyIntegerAttr(contextName,
                                objName      : string ;
                                attrType     : TNWDSAttrType ;
                                attrVal      : longint) : boolean ;
  function ndsModifyBooleanAttr(contextName,
                                objName      : string ;
                                attrType     : TNWDSAttrType ;
                                attrVal      : boolean) : boolean ;
  function ndsModifyDateTimeAttr(contextName,
                                 objName      : string ;
                                 attrType     : TNWDSAttrType ;
                                 attrVal      : TDateTime) : boolean ;
  {2.12 additions}
  function ndsOpenAttrStream(contextName,
                             objName      : string ;
                             attrType     : TNWDSAttrType;
                             var hStream  : THandleStream) : boolean ;

  {2.2 additions}
  function ndsGetPathAttr(contextName, objName : string ;
                          attrType : TNWDSAttrType;
                          var pathInfo : TNWDSPathInfo) : boolean ;
  function ndsAuthenticateObject(contextName, objName : string) : TNWConnHandle ;
  function ndsSetContextFlags(flags : longint) : boolean ;

  {2.23 additions}
  function ndsModifyPathAttr(contextName,
                             objName     : string ;
                             attrType    : TNWDSAttrType;
                             ndsPathInfo : TNWDSPathInfo) : boolean ;
  function ndsAddSecurityEquals(contextName, objName, equalToObj : string) : boolean ;

  {2.3 additions}
  function ndsSetUserContextFlags(var inContext : TNWDSContextHandle ;flags : longint) : boolean ;

  {3.0 additions}
  function ndsGetTypelessName(typedName : string) : string ;
  function ndsRemoveSecurityEquals(contextName, objName, equalToObj : string) : boolean ;
  function ndsCanAuthenticate(contextName : string) : boolean ;
  function ndsGetDSBuildLevel(nServer : TNWConnHandle) : string ;
  function ndsAddObjToGroup(objName, groupName : string) : boolean ;
  function ndsRemoveObjFromGroup(objName, groupName : string) : boolean ;
  function ndsAddToMultiAttr(contextName,
                             objName      : string ;
                             attrType     : TNWDSAttrType ;
                             pAttrValue   : pointer) : boolean ;
  function ndsRemoveFromMultiAttr(contextName,
                                  objName      : string ;
                                  attrType     : TNWDSAttrType ;
                                  pAttrValue   : pointer) : boolean ;

  {3.01 additions}                                
  function ndsGetContextFlags : longint ;
  function ndsGetGroupMembers(contextName, objName : string) : TStringList ;
  function ndsGetMyGroups(contextName, objName : string) : TStringList ;
  {- internal -} function _ndsGetSynType(attrType : TNWDSAttrType) : TNWDSSynTypes ;

  {3.2 addition}
  procedure resetNWLibContext ;

  {3.33 addition}
  procedure encodeACLRights(var objectACL : TNWDSObjectACL ; rightsList : string) ;
  function  decodeACLRights(objectACL : TNWDSObjectACL) : string ;

  {3.5 addition}
  function getInternalContextHandle : TNWDSContextHandle ;

  {4.0 additions}
  {not ready} function ndsDefineClass(contextName, className : string ;
                                      classDef : TNWDSClassDef) : boolean ;
  function ndsDefineAttr(contextName, attrName : string ; 
                         attrDef : TNWDSAttrDef) : boolean ;
  function ndsRemoveAttr(contextName, attrName : string) : boolean ;
  function ndsReadAttr(contextName,  {can read any type}
                       objName,
                       attrName     : string ;
                       syntaxType   : TNWDSSynTypes ;
                       pAttrValue   : pointer) : boolean ;
  function ndsWriteAttr(contextName, {can write to any type}
                        objName,
                        attrName     : string ;
                        syntaxType   : TNWDSSynTypes ;
                        pAttrValue   : pointer) : boolean ;
  function ndsAddObjAttrEx(contextName,  {can add to any attr type}
                           objName,
                           attrName     : string ;
                           syntaxType   : TNWDSSynTypes ;
                           pAttrValue   : pointer) : boolean ;
  function ndsMoveObject(contextName, objName, newContainerName : string) : boolean ;

  function ndsRemoveObjAttr(contextName,
                            objName      : string ;
                            attrType     : TNWDSAttrType) : boolean ;
  
  function ndsGetObjAttrList(contextName, objName : string) : TStringList ;

  {4.5 additions}
  function ndsReadOctetAttr(contextName, objName, attrName : string) : string ;
  function ndsWriteOctetAttr(contextName, objName, attrName, value : string) : boolean ;
  function ndsWriteObjectACL(contextName, objName, attrName : string ; rightsList : string) : boolean ;

  {4.5 changes}
  function ndsGetObjNumber(var nServer : TNWConnHandle ; {made nServer by reference since API gets server ID}
                           fullObjectDN : string) : TObjID  ;
  function ndsGetTreeListEx(filter : string) : TStringList ;
  function ndsGetTreeListOld : TStringList ;

  {4.6 additions}
  function ndsSearch(contextName, className, filterName : string) : TStringList ;
  function ndsSetReplicaServer(nServer : TNWConnHandle) : boolean ;
  function ndsAddToMultiAttrEx(contextName,  {can do any attr type}
                               objName,
                               attrName     : string ;
                               syntaxType   : TNWDSSynTypes ;
                               pAttrValue   : pointer) : boolean ;
  function ndsRemoveFromMultiAttrEx(contextName, {can do any attr type}
                                    objName,
                                    attrName     : string ;
                                    syntaxType   : TNWDSSynTypes ;
                                    pAttrValue   : pointer) : boolean ;
  function ndsAddEMailAddress(contextName, objName, emailAddress : string) : boolean ;
  function ndsGetEMailAddress(contextName, objName : string) : TStringList ;
  function ndsWriteTrusteeACL(contextName, objName,
                              trustee, attrName,
                              rightsList : string) : boolean ;

  {5.1 additions}  
  function ndsClearUserContextFlags(var inContext : TNWDSContextHandle ;
                                    flags : longint) : boolean ; {Contr. by to Robert Nilsson}
  function ndsClearContextFlags(flags : longint) : boolean ; {Contr. by to Robert Nilsson}
  function ndsOpenAttrStreamEx(contextName,  {can read any attribute name}
                             objName,
                             attrName     : string ;
                             var hStream  : THandleStream) : boolean ;
  function ndsGetMultiAttrEx(contextName,  {reads any attr type}
                           objName,     
                           attrName    : string ;
                           syntaxType  : TNWDSSynTypes ;
                           var objList : TList) : boolean ;
  function ndsRemoveEMailAddress(contextName, 
                                                                        objName, 
			        emailAddress : string) : boolean ;                             
  type
    TNWNDS = class(TObject)
    public
      constructor create ;
      destructor  destroy ; override ;
      function getLastError : string ;
      procedure resetLastError ;
  end;

var
  lasterror : TNWError ;

implementation

uses
  nwTools,
  nwLib,
  nwServer ;
  
{$I nwNDS.imp}  {Novell API Imports}

var
  nError    : TNWError ;
  hNWLocale,
  hNWNet    : THandle ;
  wrkContext,
  nwContext : TNWDSContextHandle ;


constructor TNWNDS.create ;
  begin
    inherited create ;
    lastError := 0 ;
    nwContext := 0 ;
    try
      {Load NDS DLLs}
      hNWNet := loadLibrary(nw_NDSCalls) ;
      if (hNWNet = 0) then
        begin
          lastError := NWERROR_DLL_LOAD_FAILURE ;
          exit ;
        end;
      hNWLocale := loadLibrary(nw_localeCalls) ;
      if (hNWLocale = 0) then
        begin
          lastError := NWERROR_DLL_LOAD_FAILURE ;
          exit ;
        end;
      {nwLocale functions}
      @NWLLocaleConv := getProcAddress(hNWLocale,'NWLlocaleconv') ;
      if (@NWLLocaleConv = nil) then
        exit ;
      @NWInitUnicodeTables := getProcAddress(hNWLocale,'NWInitUnicodeTables') ;
      if (@NWInitUnicodeTables = nil) then
        exit ;
      {nwNet Functions}
      @NWDSCreateContext := getProcAddress(hNWNet,'NWDSCreateContext') ;
      if (@NWDSCreateContext = nil) then
        exit ;
      @NWDSFreeContext := getProcAddress(hNWNet,'NWDSFreeContext') ;
      if (@NWDSFreeContext = nil) then
        exit ;
      @NWDSSetContext := getProcAddress(hNWNet,'NWDSSetContext') ;
      if (@NWDSSetContext = nil) then
        exit ;
      @NWDSAllocBuf := getProcAddress(hNWNet,'NWDSAllocBuf') ;
      if (@NWDSAllocBuf = nil) then
        exit ;
      @NWDSInitBuf := getProcAddress(hNWNet,'NWDSInitBuf') ;
      if (@NWDSInitBuf = nil) then
        exit ;
      @NWDSFreeBuf := getProcAddress(hNWNet,'NWDSFreeBuf') ;
      if (@NWDSFreeBuf = nil) then
        exit ;
      @NWDSDuplicateContext := getProcAddress(hNWNet,'NWDSDuplicateContext') ;
      if (@NWDSDuplicateContext = nil) then
        exit ;
      @NWDSPutAttrName := getProcAddress(hNWNet,'NWDSPutAttrName') ;
      if (@NWDSPutAttrName = nil) then
        exit ;
      @NWDSPutAttrVal := getProcAddress(hNWNet,'NWDSPutAttrVal') ;
      if (@NWDSPutAttrVal = nil) then
        exit ;
      @NWDSGetAttrName := getProcAddress(hNWNet,'NWDSGetAttrName') ;
      if (@NWDSGetAttrName = nil) then
        exit ;
      @NWDSGetAttrVal := getProcAddress(hNWNet,'NWDSGetAttrVal') ;
      if (@NWDSGetAttrVal = nil) then
        exit ;
      @NWDSGetAttrCount := getProcAddress(hNWNet,'NWDSGetAttrCount') ;
      if (@NWDSGetAttrCount = nil) then
        exit ;
      @NWDSPutChange := getProcAddress(hNWNet,'NWDSPutChange') ;
      if (@NWDSPutChange = nil) then
        exit ;
      @NWDSModifyObject := getProcAddress(hNWNet,'NWDSModifyObject') ;
      if (@NWDSModifyObject = nil) then
        exit ;
      @NWDSComputeAttrValSize := getProcAddress(hNWNet,'NWDSComputeAttrValSize') ;
      if (@NWDSComputeAttrValSize = nil) then
        exit ;
      @NWDSRead := getProcAddress(hNWNet,'NWDSRead') ;
      if (@NWDSRead = nil) then
        exit ;
      @NWDSRemoveObject := getProcAddress(hNWNet,'NWDSRemoveObject') ;
      if (@NWDSRemoveObject = nil) then
        exit ;
      @NWDSGenerateObjectKeyPair := getProcAddress(hNWNet,'NWDSGenerateObjectKeyPair') ;
      if (@NWDSGenerateObjectKeyPair = nil) then
        exit ;
      @NWDSGetObjectName := getProcAddress(hNWNet,'NWDSGetObjectName') ;
      if (@NWDSGetObjectName = nil) then
        exit ;
      @NWDSGetObjectCount := getProcAddress(hNWNet,'NWDSGetObjectCount') ;
      if (@NWDSGetObjectCount = nil) then
        exit ;
      @NWDSAddObject := getProcAddress(hNWNet,'NWDSAddObject') ;
      if (@NWDSAddObject = nil) then
        exit ;
      @NWDSList := getProcAddress(hNWNet,'NWDSList') ;
      if (@NWDSList = nil) then
        exit ;
      @NWFreeUnicodeTables := getProcAddress(hNWLocale,'NWFreeUnicodeTables') ;
      if (@NWFreeUnicodeTables = nil) then
        exit ;
      @NWDSGetContext := getProcAddress(hNWnet,'NWDSGetContext') ;
      if (@NWDSGetContext = nil) then
        exit ;
      @NWDSOpenStream := getProcAddress(hNWNet,'NWDSOpenStream') ;
      if (@NWDSOpenStream = nil) then
        exit ;
   
      {create unit-wide context variable}
      nwContext  := NWDSCreateContext ;
      wrkContext := NWDSCreateContext ;
      
      ndsSetContext('[Root]') ;
    except
      hNWNet    := 0 ;
      hNWLocale := 0 ;
    end;
  end;

destructor TNWNDS.Destroy;
  begin
    if (nwContext <> 0) then
      ndsFreeContext(nwContext) ;
    if (wrkContext <> 0) then
      ndsFreeContext(wrkContext) ;  
    inherited Destroy;
  end;

function TNWNDS.getLastError : string ;
  begin
    result := intToHex(lastError,sizeOf(TNWError)) ;
  end;

procedure TNWNDS.resetLastError ;
  begin
    lastError := 0 ;
  end;

  
{ *********************************************************** }
{ ******************** Internal Functions ******************* }
{ *********************************************************** }
function _ndsGetBufValue(context  : TNWDSContextHandle;
                         pBuf     : pBuf_T ;
                         attrName : string ;
                         pValue   : pointer) : boolean ;
  var
    i          : integer ;
    valCount,
    attrCount,
    synType    : longint ;
    cpAttrName : TNWDSAttrName ;
  begin
    result := false ;
    strPCopy(cpAttrName,attrName) ;

    {count the attrs in buffer}
    nError := NWDSGetAttrCount(context, pBuf, @attrCount);
    if (nError <> 0) then
      begin
        lastError := nError ;
        exit;
      end;
      
    {locate attribute value}
    for i := 1 to attrCount do begin
      nError := NWDSGetAttrName(context,
                                pBuf,
                                @cpAttrName,
                                @valCount,
                                @synType) ;
      if (nError <> 0) then
        begin
          lastError := nError ;
          exit ;
        end;
      if (strUpper(cpAttrName) = upperCase(attrName)) then  
        begin
          {place value in pointer location - must always retrieve all values from buffer}
          nError := NWDSGetAttrVal(context,
                                 pBuf,
                                 synType,
                                 pValue) ;
          if (nError <> 0) then
            begin
              lastError := nError ;
              exit ;
            end
          else
            result := true ;
        end;
    end;    
  end;
  


{ ********************************************************* }
{ ******************** Public Functions ******************* }
{ ********************************************************* }

function ndsInit : boolean ;
  { initialize shell's unicode tables - must be called first!}
  var
    lConv : TNWDSLConv ;
  begin
    result := false ;
    if (hNWNet = 0) or (hNWLocale = 0) then
      exit ;
    if (nwContext = 0) then
      nwContext := NWDSCreateContext ;
    NWLLocaleConv(@lConv) ;
    if (NWInitUnicodeTables(lConv.country_ID,
                            lConv.code_Page)=0) then
      result := (nwContext <> 0) ;
  end;

function ndsClose : boolean ;
  { must shut down nds communication to close context, unicode tables, etc.}
  begin
    result := false ;
    nError := NWFreeUnicodeTables ;
    if (nError <> 0) then
      lastError := nError
    else
      result := true ;
  end;

{Internal NDS functions required by NWNDS.PAS}

function _ndsGetSynType(attrType : TNWDSAttrType) : TNWDSSynTypes ;
  {attrType to syntax type map}
  begin
    result := SYN_INTEGER ;
    case attrType of
      {booleans}
      dsaDetectIntruder,
      dsaLockedByIntruder,
      dsaLockoutAfterDetection,
      dsaLoginDisabled,
      dsaPasswordAllowChange,
      dsaPasswordRequired,
      dsaPasswordUniqueRequired,
      dsaAllowUnlimitedCredit         : result := SYN_BOOLEAN ;
      {PChars}
      dsaTreeName,
      dsaRoomNumber,
      dsaPrinterModel,
      dsaPrinterManufacturer,
      dsaEmployeeID,
      dsaDisplayName,
      dsaCarLicense,
      dsaMailboxID,
      dsaNNSDomain,
      dsaOrganization,
      dsaOrganizationalUnit,
      dsaDescription,
      dsaFullName,
      dsaGenerationalQualifier,
      dsaCountry,
      dsaCartridge,
      dsaClassName,
      dsaCommonName,
      dsaGivenName,
      dsaHostResourceName,
      dsaLocality,
      dsaLanguage,
      dsaInitials,
      dsaQueueDirectory,
      dsaMessagingServerType,
      dsaPhysicalDeliveryOfficeName,
      dsaSupportedGateway,
      dsaSupportedServices,
      dsaSupportedTypefaces,
      dsaSurname,
      dsaUnknownBaseClass,
      dsaVersion,
      dsaPostalCode,
      dsaPostalOfficeBox,
      dsaTitle,
      dsaState,
      dsaStreetAddress,
      dsaSAPName,
      dsaBusinessCategory             : result := SYN_CI_STRING ;
      {DN PChars}
      dsaSecretary,
      dsaManager,
      dsaMailboxLocation,
      dsaMember,
      dsaMessageRoutingGroup,
      dsaMessageServer,
      dsaGroupMembership,
      dsaHigherPrivileges,
      dsaEquivalentToMe,
      dsaHostDevice,
      dsaHostServer,
      dsaMessagingServer,
      dsaDefaultQueue,
      dsaAliasedObjName,
      dsaDevice,
      dsaProfile,
      dsaProfileMembership,
      dsaReference,
      daPostmaster,
      dsaOperator,
      dsaOwner,
      dsaServer,
      dsaSeeAlso,
      dsaResource,
      dsaRoleOccupant,
      dsaSecurityEquals,
      dsaUser,
      dsaVolume                       : result := SYN_DIST_NAME ;
      {paths (path_t)}
      dsaHomeDirectory,
      dsaPath,
      dsaMessagingDatabaseLocation    : result := SYN_PATH ;
      {printable strings}
      dsaPageDescriptionLanguage,
      dsaSerialNumber                 : result := SYN_PR_STRING ;
      {integer types}
      dsaBinderyObjRestriction,
      dsaConvergence,
      dsaLoginIntruderLimit,
      dsaLoginMaximumSimultaneous,
      dsaMinimumAccountBalance,
      dsaPasswordMinimumLength,
      dsaMemory,
      dsaLoginGraceLimit,
      dsaGroupID,
      dsaDSRevision,
      dsaStatus,
      dsaSupportedConnections,
      dsaUserID,
      dsaSecurityFlags                : result := SYN_INTEGER ;
      {intervals (integers)}
      dsaCertificateValidityInterval,
      dsaLowConvergenceSyncInterval,
      dsaHighConvergenceSyncInterval,
      dsaIntruderAttemptResetInterval,
      dsaIntruderLockoutResetInterval,
      dsaPasswordExpirationInterval   : result := SYN_INTERVAL ;
      {counters (integers)}
      dsaLoginGraceRemaining,
      dsaLoginIntruderAttempts,
      dsaAccountBalance,
      dsaRevision                     : result := SYN_COUNTER ;
      {multi-octet strings}
      dsaTimeZone,
      dsaLDAPPhoto,
      dsaJPEGPhoto,
      dsaReplicaUpTo,
      dsaCrossCertificatePair,
      dsaLoginAllowedTimeMap,
      dsaObituary,
      dsaPasswordsUsed,
      dsaPrinterConfiguration,
      dsaPrivateKey,
      dsaPublicKey,
      dsaBinderyProperty,
      dsaCAPrivateKey,
      dsaCAPublicKey,
      dsaCertificateRevocation,
      dsaExternalSynchronizer,
      dsaExternalName,
      dsaAuthorityRevocation,
      dsaAuthorityRevocationList      : result := SYN_OCTET_STRING ;
      {time}
      dsaLastLoginTime,
      dsaLoginExpirationTime,
      dsaLoginIntruderResetTime,
      dsaLoginTime,
      dsaLowConvergenceResetTime,
      dsaPasswordExpirationTime       : result := SYN_TIME ;
      {timestamps}
      dsaLastReferencedTime,
      dsaPartitionCreationTime,
      dsaSynchronizesUpTo,
      dsaReceivedUpTo                 : result := SYN_TIMESTAMP ;
      {typed names}
      dsaQueue,
      dsaPartitionControl,
      dsaNotify,
      dsaPrintServer,
      dsaPrinter                      : result := SYN_TYPED_NAME ;
      {email addresses}
      dsaForeignEMailAddress,
      dsaEmailAddress                 : result := SYN_EMAIL_ADDRESS ;
      {fax numbers - multi}
      dsaFacsimileTelephoneNumber     : result := SYN_FAX_NUMBER ;
      {telephone numbers - multi}
      dsaPager,
      dsaMobile,
      dsaTelephoneNumber              : result := SYN_TEL_NUMBER ;
      {net addresses}
      dsaLoginIntruderAddress,
      dsaNetworkAddress,
      dsaNetworkAddressRestriction    : result := SYN_NET_ADDRESS ;
      {po address}
      dsaPostalAddress                : result := SYN_PO_ADDRESS ;
      {numeric strings}
      dsaBinderyType                  : result := SYN_NU_STRING ;
      {acls}
      dsaACL,
      dsaInheritedACL                 : result := SYN_OBJECT_ACL ;
      {replica pointers}
      dsaReplica                      : result := SYN_REPLICA_POINTER ;
      {holds}
      dsaServerHolds                  : result := SYN_HOLD ;
      {streams}
      dsaLoginScript,
      dsaPrinterControl,
      dsaPrintJobConfiguration,
      dsaTypeCreatorMap               : result := SYN_STREAM ;
      {object class - worm}
      dsaObjectClass                  : result := SYN_CLASS_NAME ;
      {backlinks}
      dsaBackLink                     : result := SYN_BACK_LINK ;
      {unknowns}
      dsaUnknown                      : result := SYN_UNKNOWN ;
      dsaAssociations                 : result := SYN_TYPED_NAME; 
    end;
  end;

function _ndsGetAttrName(attrType : TNWDSAttrType) : string ;
  begin
    result := '' ;
    case attrType of
      dsaAccountBalance               : result := 'Account Balance' ;
      dsaACL                          : result := 'ACL' ;
      dsaAliasedObjName               : result := 'Aliased Object Name' ;
      dsaAllowUnlimitedCredit         : result := 'Allow Unlimited Credit' ;
      dsaAuthorityRevocation          : result := 'Authority Revocation' ;
      dsaBackLink                     : result := 'Back Link' ;
      dsaBinderyObjRestriction        : result := 'Bindery Object Restriction' ;
      dsaBinderyProperty              : result := 'Bindery Property' ;
      dsaBinderyType                  : result := 'Bindery Type' ;
      dsaCountry                      : result := 'C' ;
      dsaCAPrivateKey                 : result := 'CA Private Key' ;
      dsaCAPublicKey                  : result := 'CA Public Key' ;
      dsaCartridge                    : result := 'Cartridge' ;
      dsaCertificateRevocation        : result := 'Certificate Revocation' ;
      dsaCertificateValidityInterval  : result := 'Certificate Validity Interval' ;
      dsaClassName                    : result := 'Object Class' ;
      dsaCommonName                   : result := 'CN' ;
      dsaConvergence                  : result := 'Convergence' ;
      dsaCrossCertificatePair         : result := 'Cross Certificate Pair' ;
      dsaDefaultQueue                 : result := 'Default Queue' ;
      dsaDescription                  : result := 'Description' ;
      dsaDetectIntruder               : result := 'Detect Intruder' ;
      dsaDevice                       : result := 'Device' ;
      dsaDSRevision                   : result := 'Revision' ;
      dsaForeignEmailAddress          : result := 'Foreign EMail Address' ;
      dsaEmailAddress                 : result := 'EMail Address' ;
      dsaExternalName                 : result := 'External Name' ;
      dsaEquivalentToMe               : result := 'Equivalent To Me' ;
      dsaExternalSynchronizer         : result := 'External Synchronizer' ;
      dsaFacsimileTelephoneNumber     : result := 'Facsimile Telephone Number' ;
      dsaFullName                     : result := 'Full Name' ;
      dsaGenerationalQualifier        : result := 'Generational Qualifier' ;
      dsaGroupID                      : result := 'GID' ;
      dsaGivenName                    : result := 'Given Name' ;
      dsaGroupMembership              : result := 'Group Membership' ;
      dsaHighConvergenceSyncInterval  : result := 'High Convergence Sync Interval' ;
      dsaHigherPrivileges             : result := 'Higher Privileges' ;
      dsaHomeDirectory                : result := 'Home Directory' ;
      dsaHostDevice                   : result := 'Host Device' ;
      dsaHostResourceName             : result := 'Host Resource Name' ;
      dsaHostServer                   : result := 'Host Server' ;
      dsaInheritedACL                 : result := 'Inherited ACL' ;
      dsaInitials                     : result := 'Initials' ;
      dsaIntruderAttemptResetInterval : result := 'Intruder Attempt Reset Interval' ;
      dsaIntruderLockoutResetInterval : result := 'Intruder Lockout Reset Interval' ;
      dsaLocality                     : result := 'L' ;
      dsaLanguage                     : result := 'Language' ;
      dsaLastLoginTime                : result := 'Last Login Time' ;
      dsaLastReferencedTime           : result := 'Last Referenced Time' ;
      dsaLockedByIntruder             : result := 'Locked By Intruder' ;
      dsaLockoutAfterDetection        : result := 'Lockout After Detection' ;
      dsaLoginAllowedTimeMap          : result := 'Login Allowed Time Map' ;
      dsaLoginDisabled                : result := 'Login Disabled' ;
      dsaLoginExpirationTime          : result := 'Login Expiration Time' ;
      dsaLoginGraceLimit              : result := 'Login Grace Limit' ;
      dsaLoginGraceRemaining          : result := 'Login Grace Remaining' ;
      dsaLoginIntruderAddress         : result := 'Login Intruder Address' ;
      dsaLoginIntruderAttempts        : result := 'Login Intruder Attempts' ;
      dsaLoginIntruderLimit           : result := 'Login Intruder Limit' ;
      dsaLoginIntruderResetTime       : result := 'Login Intruder Reset Time' ;
      dsaLoginMaximumSimultaneous     : result := 'Login Maximum Simultaneous' ;
      dsaLoginScript                  : result := 'Login Script' ;
      dsaLoginTime                    : result := 'Login Time' ;
      dsaLowConvergenceResetTime      : result := 'Low Convergence Reset Time' ;
      dsaLowConvergenceSyncInterval   : result := 'Low Convergence Sync Interval' ;
      dsaMailboxID                    : result := 'Mailbox ID' ;
      dsaMailboxLocation              : result := 'Mailbox Location' ;
      dsaMember                       : result := 'Member' ;
      dsaMemory                       : result := 'Memory' ;
      dsaMessageRoutingGroup          : result := 'Message Routing Group' ;
      dsaMessageServer                : result := 'Message Server' ;
      dsaMessagingDatabaseLocation    : result := 'Messaging Database Location' ;
      dsaMessagingServer              : result := 'Messaging Server' ;
      dsaMessagingServerType          : result := 'Messaging Server Type' ;
      dsaMinimumAccountBalance        : result := 'Minimum Account Balance' ;
      dsaNetworkAddress               : result := 'Network Address' ;
      dsaNetworkAddressRestriction    : result := 'Network Access Restriction' ;
      dsaNNSDomain                    : result := 'NNS Domain' ;
      dsaNotify                       : result := 'Notify' ;
      dsaOrganization                 : result := 'O' ;
      dsaObituary                     : result := 'Obituary' ;
      dsaObjectClass                  : result := 'Object Class' ;
      dsaOperator                     : result := 'Operator' ;
      dsaOrganizationalUnit           : result := 'OU' ;
      dsaOwner                        : result := 'Owner' ;
      dsaPageDescriptionLanguage      : result := 'Page Description Language' ;
      dsaPartitionControl             : result := 'Partition Control' ;
      dsaPartitionCreationTime        : result := 'Partition Creation Time' ;
      dsaPasswordAllowChange          : result := 'Password Allow Change' ;
      dsaPasswordExpirationInterval   : result := 'Password Expiration Interval' ;
      dsaPasswordExpirationTime       : result := 'Password Expiration Time' ;
      dsaPasswordMinimumLength        : result := 'Password Minimum Length' ;
      dsaPasswordRequired             : result := 'Password Required' ;
      dsaPasswordUniqueRequired       : result := 'Password Unique Required' ;
      dsaPasswordsUsed                : result := 'Passwords Used' ;
      dsaPath                         : result := 'Path' ;
      dsaPhysicalDeliveryOfficeName   : result := 'Physical Delivery Office Name' ;
      dsaPostalAddress                : result := 'Postal Address' ;
      dsaPostalCode                   : result := 'Postal Code' ;
      dsaPostalOfficeBox              : result := 'Postal Office Box' ;
      daPostmaster                    : result := 'Postmaster' ;
      dsaPrintJobConfiguration        : result := 'Print Job Configuration' ;
      dsaPrintServer                  : result := 'Print Server' ;
      dsaPrinter                      : result := 'Printer' ;
      dsaPrinterConfiguration         : result := 'Printer Configuration' ;
      dsaPrinterControl               : result := 'Printer Control' ;
      dsaPrivateKey                   : result := 'Private Key' ;
      dsaProfile                      : result := 'Profile' ;
      dsaProfileMembership            : result := 'Profile Membership' ;
      dsaPublicKey                    : result := 'Public Key' ;
      dsaQueue                        : result := 'Queue' ;
      dsaQueueDirectory               : result := 'Queue Directory' ;
      dsaReceivedUpTo                 : result := 'Received Up To' ;
      dsaReference                    : result := 'Reference' ;
      dsaReplica                      : result := 'Replica' ;
      dsaReplicaUpTo                  : result := 'Replica Up To' ;
      dsaResource                     : result := 'Resource' ;
      dsaRevision                     : result := 'Revision' ;
      dsaRoleOccupant                 : result := 'Role Occupant' ;
      dsaState                        : result := 'S' ;
      dsaStreetAddress                : result := 'SA' ;
      dsaSAPName                      : result := 'SAP Name' ;
      dsaSecurityEquals               : result := 'Security Equals' ;
      dsaSecurityFlags                : result := 'Security Flags' ;
      dsaSeeAlso                      : result := 'See Also' ;
      dsaSerialNumber                 : result := 'Serial Number' ;
      dsaServer                       : result := 'Server' ;
      dsaServerHolds                  : result := 'Server Holds' ;
      dsaStatus                       : result := 'Status' ;
      dsaSupportedConnections         : result := 'Supported Connections' ;
      dsaSupportedGateway             : result := 'Supported Gateway' ;
      dsaSupportedServices            : result := 'Supported Services' ;
      dsaSupportedTypefaces           : result := 'Supported Typefaces' ;
      dsaSurname                      : result := 'Surname' ;
      dsaSynchronizesUpTo             : result := 'Synchronizes Up To' ;
      dsaTelephoneNumber              : result := 'Telephone Number' ;
      dsaTitle                        : result := 'Title' ;
      dsaTypeCreatorMap               : result := 'Type Creator Map' ;
      dsaUserID                       : result := 'UID' ;
      dsaUnknown                      : result := 'Unknown' ;
      dsaUnknownBaseClass             : result := 'Unknown Base Class' ;
      dsaUser                         : result := 'User' ;
      dsaVersion                      : result := 'Version' ;
      dsaVolume                       : result := 'Volume' ;
      dsaAssociations                 : result := 'App:Associations'; 
      dsaAuthorityRevocationList      : result := 'authorityRevocationList' ;
      dsaBusinessCategory             : result := 'businessCategory' ;
      dsaCarLicense                   : result := 'carLicense' ;
      dsaDisplayName                  : result := 'displayName' ;
      dsaEmployeeID                   : result := 'Employee ID' ;
      dsaJPEGPhoto                    : result := 'jpegPhoto' ;
      dsaLDAPPhoto                    : result := 'ldapPhoto' ;
      dsaManager                      : result := 'manager' ;
      dsaMobile                       : result := 'mobile' ;
      dsaPager                        : result := 'pager' ;
      dsaPrinterModel                 : result := 'Printer Model' ;
      dsaPrinterManufacturer          : result := 'Printer Manufacturer' ;   
      dsaRoomNumber                   : result := 'roomNumber' ;
      dsaSecretary                    : result := 'secretary' ;
      dsaTimeZone                     : result := 'Timezone' ;
      dsaTreeName                     : result := 'T' ;
    end;
  end;


{ create an Object Class in Buffer }
function _ndsCreateClassType(context   : TNWDSContextHandle ;
                             pBuf      : pBuf_T ;
                             classText : string) : boolean ;
  var
    cpValue : array[0..63] of char ;
  begin
    result := false ;
    strPCopy(cpValue,'Object Class');
    nError := NWDSPutAttrName(context, pBuf, @cpValue) ;
    if (nError <> 0) then
      lastError := nError
    else
      begin
        strPCopy(cpValue,classText) ;
        nError := NWDSPutAttrVal(context,
                                 pBuf,
                                 ord(SYN_CLASS_NAME),
                                 @cpValue) ;
        if (nError <> 0) then
          lastError := nError
        else
          result := true ;
      end;
  end;

  
{ add or change an Attribute Value in buffer}
function _ndsChangeAttrValue(contextHandle : TNWDSContextHandle ;
                             pBuf          : pBuf_T             ;
                             attrSyntax    : TNWDSSynTypes      ;
                             cpAttrName    : TNWDSAttrName      ;
                             pAttrValue    : pointer            ;
                             action        : TNWDSAttrAction) : boolean ;
  begin
    result := false ;
    {store add/overwrite verb in request buffer}
    case action of
      dsaaAdd :
        nError := NWDSPutChange(contextHandle,
                                pBuf,
                                ord(DS_ADD_VALUE),
                                @cpAttrName) ;
      dsaaEdit :
        nError := NWDSPutChange(contextHandle,
                                pBuf,
                                ord(DS_OVERWRITE_VALUE),
                                @cpAttrName) ;
      dsaaRemoveValue :                          
        nError := NWDSPutChange(contextHandle,
                                pBuf,
                                ord(DS_REMOVE_VALUE),
                                @cpAttrName) ;
      dsaaRemoveAttr :                          
        nError := NWDSPutChange(contextHandle,
                                pBuf,
                                ord(DS_REMOVE_ATTRIBUTE),
                                @cpAttrName) ;
                                
    end;                            
    if (nError <> 0) then
      begin
        lastError := nError ;
        exit;
      end;
    {specify attribute value}
    nError := NWDSPutAttrVal(contextHandle,
                             pBuf,
                             ord(attrSyntax),
                             pAttrValue) ;
    if (nError <> 0) then
      lastError := nError
    else
      result := true ;
  end;


{the big one - add/modify object attributes}
function _ndsAlterObjAttr(contextHandle : TNWDSContextHandle ;
                          pBuf          : pBuf_T             ;
                          cpObjName     : TNDSName           ;
                          cpAttrName    : TNWDSAttrName      ;
                          syntaxType    : TNWDSSynTypes      ;
                          pAttrValue    : pointer            ;
                          action        : TNWDSAttrAction) : boolean ;
  begin
    result := false ;
    { write changed value into buffer using proper syntax }
    if (not _ndsChangeAttrValue(contextHandle,
                                pBuf,
                                syntaxType,
                                cpAttrName,
                                pAttrValue,
                                action)) then
      exit ;

    {*** ready to apply buffer to modify the object ***}
    nError  := (NWDSModifyObject(contextHandle,
                                 @cpObjName,
                                 nil,
                                 nbool8(0),
                                 pBuf)) ;
    if (nError <> 0) then
      lastError  := nError
    else
      result  := true ;
  end;

function ndsRemoveObjAttr(contextName,
                          objName      : string ;
                          attrType     : TNWDSAttrType) : boolean ;
  {add a new nds object attribute & value}
  var
    tempContext : TNWDSContextHandle ;
    cpAttrName  : TNWDSAttrName ;
    cpObjName   : TNDSName ;
    pBuf        : pBuf_T   ;
    ntemp       : integer  ;
  begin
    result := false ;
    ntemp  := 0 ;
    if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @pBuf) <> 0) then
      exit;
    try
      strPCopy(cpObjName,objName) ;
      strPCopy(cpAttrName,_ndsGetAttrName(attrType)) ;
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      if (NWDSInitBuf(tempContext, DSV_ADD_ENTRY, pBuf) <> 0) then
         exit ;
      result := _ndsAlterObjAttr(tempContext,
                                 pBuf,
                                 cpObjName,
                                 cpAttrName,
                                 _ndsGetSynType(attrType),
                                 @ntemp,
                                 dsaaRemoveAttr) ;
    finally
      ndsFreeContext(tempContext) ;
      NWDSFreeBuf(pBuf) ;
    end;
  end;
  

{ create a new string attribute and value in buffer }
function _ndsCreateStringAttr(context   : TNWDSContextHandle ;
                              pBuf      : pBuf_t             ;
                              attrType  : TNWDSAttrType      ;
                              attrVal   : string) : boolean  ;
  var
    cpValue : array[0..63] of char ;
    synType : TNWDSSynTypes ;
  begin
    result := false ;
    strPCopy(cpValue,_ndsGetAttrName(attrType)) ;
    synType := _ndsGetSynType(attrType) ;
    nError  := NWDSPutAttrName(context, pBuf, @cpValue) ;
    if (nError <> 0) then
      lastError := nError
    else
      begin
        strPCopy(cpValue,attrVal) ;
        nError := NWDSPutAttrVal(context,
                                 pBuf,
                                 ord(synType),
                                 @cpValue) ;
        if (nError <> 0) then
          lastError := nError
        else
          result := true ;
     end;
  end;

{ create a new integer attribute and value in buffer }
function _ndsCreateIntegerAttr(context   : TNWDSContextHandle  ;
                               pBuf      : pBuf_t              ;
                               attrType  : TNWDSAttrType       ;
                               attrVal   : longint) : boolean  ;
  var
    cpValue : array[0..63] of char ;
    synType : TNWDSSynTypes ;
  begin
    result := false ;
    strPCopy(cpValue,_ndsGetAttrName(attrType)) ;
    synType := _ndsGetSynType(attrType) ;
    nError  := NWDSPutAttrName(context, pBuf, @cpValue) ;
    if (nError <> 0) then
      lastError := nError
    else
      begin
        nError := NWDSPutAttrVal(context,
                                 pBuf,
                                 ord(synType),
                                 @attrVal) ;
        if (nError <> 0) then
          lastError := nError
        else
          result := true ;
     end;
  end;

{ create a new date/time attribute and value in buffer }
function _ndsCreateDateTimeAttr(context   : TNWDSContextHandle  ;
                                pBuf      : pBuf_t              ;
                                attrType  : TNWDSAttrType       ;
                                attrVal   : TDateTime) : boolean  ;
  var
    intValue : longint ;
    cpValue  : array[0..63] of char ;
    synType  : TNWDSSynTypes ;
  begin
    result := false ;
    strPCopy(cpValue,_ndsGetAttrName(attrType)) ;
    synType  := _ndsGetSynType(attrType) ;
    nError   := NWDSPutAttrName(context, pBuf, @cpValue) ;
    intValue := delphiDateToNWDate(attrVal) ;
    if (nError <> 0) then
      lastError := nError
    else
      begin
        nError := NWDSPutAttrVal(context,
                                 pBuf,
                                 ord(synType),
                                 @intValue) ;
        if (nError <> 0) then
          lastError := nError
        else
          result := true ;
     end;
  end;


{ create a new DN attribute and value in buffer }
function _ndsCreateDNAttr(context   : TNWDSContextHandle ;
                          pBuf      : pBuf_t             ;
                          attrType  : TNWDSAttrType      ;
                          attrVal   : string) : boolean  ;
  var
    cpValue  : array[0..63] of char ;
    objectDN : distinguished_name_t ;
    synType  : TNWDSSynTypes ;
  begin
    result := false ;
    strPCopy(cpValue,_ndsGetAttrName(attrType)) ;
    synType := _ndsGetSynType(attrType) ;
    nError  := NWDSPutAttrName(context, pBuf, @cpValue) ;
    if (nError <> 0) then
      lastError := nError
    else
      begin
        strPCopy(cpValue,attrVal) ;
        with objectDN do begin
          dataSize := length(attrVal) ;
          data     := @cpValue ;
        end;
        nError := NWDSPutAttrVal(context,
                                 pBuf,
                                 ord(synType),
                                 @objectDN) ;
        if (nError <> 0) then
          lastError := nError
        else
          result := true ;
     end;
  end;

function _ndsGetClassType(pObjInfo : pObject_Info_T) : TNWDSObjType ;
  var
    ctemp : string ;
  begin
    result := dsoUnknown ;
    ctemp := strPas(strUpper(pObjInfo^.baseClass)) ;
    if (ctemp = 'USER') then
      result := dsoUser
    else if (ctemp = 'VOLUME') then
      result := dsoVolume
    else if (ctemp = 'TOP') then
      result := dsoTop
    else if (ctemp = 'QUEUE') then
      result := dsoQueue
    else if (ctemp = 'PROFILE') then
      result := dsoProfile
    else if (ctemp = 'PRINT SERVER') then
      result := dsoPrintServer
    else if (ctemp = 'PRINTER') then
      result := dsoPrinter
    else if (ctemp = 'ORGANIZATIONAL UNIT') then
      result := dsoOrganizationalUnit
    else if (ctemp = 'ORGANIZATIONAL ROLE') then
      result := dsoOrganizationalRole
    else if (ctemp = 'ORGANIZATION') then
      result := dsoOrganization
    else if (ctemp = 'NCP SERVER') then
      result := dsoNcpServer
    else if (ctemp = 'MESSAGING SERVER') then
      result := dsoMessagingServer
    else if (ctemp = 'MESSAGE ROUTING GROUP') then
      result := dsoMessageRoutingGroup
    else if (ctemp = 'LOCALITY') then
      result := dsoLocality
    else if (ctemp = 'LIST') then
      result := dsoList
    else if (ctemp = 'GROUP') then
      result := dsoGroup
    else if (ctemp = 'EXTERNAL ENTITY') then
      result := dsoExternalEntity
    else if (ctemp = 'DIRECTORY MAP') then
      result := dsoDirectoryMap
    else if (ctemp = 'COUNTRY') then
      result := dsoCountry
    else if (ctemp = 'COMPUTER') then
      result := dsoComputer
    else if (ctemp = 'BINDERY QUEUE') then
      result := dsoBinderyQueue
    else if (ctemp = 'BINDERY OBJECT') then
      result := dsoBinderyObject
    else if (ctemp = 'ALIAS') then
      result := dsoAlias
    else if (ctemp = 'AFP SERVER') then
      result := dsoAfpServer
    else if (ctemp = 'APP:APPLICATION') then 
      result := dsoApplication               
    else if (ctemp = 'Workstation Group') then 
      result:= dsoWSGroup                      
    else if (ctemp = 'Workstation') then       
      result:= dsoWorkstation                  
    else if (ctemp = 'SERVER') then
      result := dsoServer ;
  end;

function ndsGetContextHandle : TNWDSContextHandle ;
  { create a new context handle - user must free w/NDSfreeContext}
  begin
    result := 0 ;
    if (@NWDSDuplicateContext = nil) or (@NWDSCreateContext = nil) then
      exit ;
    if (nwContext > 0) then
      result := NWDSDuplicateContext(nwContext)
    else
      result := NWDSCreateContext;
  end;

function ndsFreeContext(context : TNWDSContextHandle) : boolean ;
  { leggo context handle }
  begin
    result := (NWDSFreeContext(context)=0) ;
  end;

function ndsGetRootName(cobject : string) : string ;
  { [root] }
  var
    cpObject : TNDSName ;
    cpRoot   : array[0..255] of char ;
  begin
    result  := '' ;
    if (@NWDSGetPartitionRoot = nil) then
      @NWDSGetPartitionRoot := getProcAddress(hNWNet,'NWDSGetPartitionRoot') ;
    if (@NWDSGetPartitionRoot = nil) then
      exit ;
    strPCopy(cpObject,cObject) ;
    if (NWDSGetPartitionRoot(nwContext,
                             @cpObject,
                             @cpRoot)=0) then
      result := strPas(cpRoot) ;
  end;

function ndsExpandName(cname : string) : string ;
  {cn=admin.o=context}
  var
    key    : integer ;
    oldValue,
    nValue : longint ;
    buffer,
    cpName : array[0..255] of char ; 
  begin
    result := '' ;
    if (@NWDSCanonicalizeName = nil) then
      @NWDSCanonicalizeName := getProcAddress(hNWNet,'NWDSCanonicalizeName') ;
    if (@NWDSCanonicalizeName = nil) then
      exit ;
    strPCopy(cpName,cname) ;
    key := DCK_FLAGS    ;
    nValue :=  (DCV_DEREF_ALIASES or
                DCV_XLATE_STRINGS or
                DCV_CANONICALIZE_NAMES) ;
    nError := NWDSGetContext(nwContext,key,@oldValue) ;
    if (nError <> 0) then
      begin
        lastError := nError ;
        exit ;
      end;
    NWDSSetContext(nwContext,key,@nValue) ;
    nError := NWDSCanonicalizeName(nwContext,
                                   @cpName,
                                   @buffer) ;
    if (nError <> 0) then
      lastError := nError
    else
      result := strPas(buffer) ;
    NWDSSetContext(nwContext,key,@oldValue) ;
  end;

function ndsAbbreviateName(cname : string) : string ;
  { cn=admin (in relation to current context) }
  var
    buffer : array[0..255] of char ;
    cpName : TNDSName ;
  begin
    result := '' ;
    if (@NWDSAbbreviateName = nil) then
      @NWDSAbbreviateName := getProcAddress(hNWNet,'NWDSAbbreviateName') ;
    if (@NWDSAbbreviateName = nil) then
      exit ;
    strPCopy(cpname,cname) ;
    nError := NWDSAbbreviateName(nwContext,
                                 @cpname,
                                 @buffer) ;

    if (nError <> 0) then
      lastError := nError
    else
      result := strPas(buffer) ;
  end;

function ndsGetContextName : string ;
  { retrieve context string }
  var
    key     : integer ;
    buffer  : TRetbuff ;
  begin
    result  := '' ;
    key     := NDS_KEY_CONTEXTNAME;
    nError  := NWDSGetContext(nwContext,
                              key,
                              @buffer) ;
    if (nError <> 0) then
      lastError := nError
    else
      result := strPas(buffer) ;
  end;

function ndsSetContextName(var context : TNWDSContextHandle ;
                           ctext : string) : boolean ;
  { set internal context to equal input context }
  var
    cptext : TRetBuff ;
  begin
    result := false ;
    if (@NWDSSetContext = nil) then
      exit ;
    strPCopy(cptext,allTrim(ctext)) ;
    nError := NWDSSetContext(context,
                             DCK_NAME_CONTEXT,
                             @cptext) ;
    if (nError <> 0) then
      lastError := nError
    else                                    {src}   {dest}
      begin
        ndsFreeContext(nwContext) ;
        if (@NWDSDuplicateContextHandle = nil) then
          @NWDSDuplicateContextHandle := getProcAddress(hNWNet,'NWDSDuplicateContextHandle') ;
        if (@NWDSDuplicateContextHandle <> nil) then
          NWDSDuplicateContextHandle(context,nwContext)
        else
          nwContext := NWDSDuplicateContext(context) ;
        result := (nwContext <> 0) ;
      end;
  end;

function ndsSetContext(ctext : string) : boolean ;
  { sets the global context - no input context required }
  var
    cptext : TRetbuff ;
  begin
    result  := false ;
    if (@NWDSSetContext = nil) then
      exit ;
    strPCopy(cptext,allTrim(ctext)) ;
    nError := NWDSSetContext(nwContext,
                             DCK_NAME_CONTEXT,
                             @cptext) ;
    if (nError <> 0) then
      lastError := nError
    else
      result := true ;
  end;

function ndsSetContextFlags(flags : longint) : boolean ;
  var
    oldFlags : nuint32 ;
  begin
    result := false ;
    if (@NWDSGetContext = nil) or (@NWDSSetContext = nil) then
      exit ;
    NWDSGetContext(nwContext,DCK_FLAGS,@oldFlags) ;
    flags := (oldFlags or flags) ;
    nError := NWDSSetContext(nwContext,DCK_FLAGS,@flags) ;
    nError := NWDSSetContext(wrkContext,DCK_FLAGS,@flags) ;
    if (nError <> 0) then
      lastError := nError
    else
      result := true ;
  end;

function ndsGetContextFlags : longint ;
  var
    flags : longint ;
  begin
    result := 0 ;
    if (@NWDSGetContext = nil) then
      exit ;
    NWDSGetContext(nwContext,DCK_FLAGS,@flags) ;
    if (nError <> 0) then
      lastError := nError
    else
      result := flags ;
  end;
  

function ndsSetUserContextFlags(var inContext : TNWDSContextHandle ;flags : longint) : boolean ;
  var
    oldFlags : nuint32 ;
  begin
    result := false ;
    if (@NWDSGetContext = nil) or (@NWDSSetContext = nil) then
      exit ;
    NWDSGetContext(inContext,DCK_FLAGS,@oldFlags) ;
    flags := (oldFlags or flags) ;
    nError := NWDSSetContext(inContext,DCK_FLAGS,@flags) ;
    if (nError <> 0) then
      lastError := nError
    else
      result := true ;
  end;


function ndsGetBinderyContextName(nServer : TNWConnHandle) : string ;
  { o=context : starting point }
  var
    buffer : TRetBuff ;
  begin
    result := '' ;
    if (@NWDSGetBinderyContext = nil) then
      @NWDSGetBinderyContext := getProcAddress(hNWNet,'NWDSGetBinderyContext') ;
    if (@NWDSGetBinderyContext = nil) then
      exit ;
    if (nServer = 0) then
      nServer := getPrimaryServerID ;
    if (NWDSGetBinderyContext(nwContext,
                              nServer,
                              @buffer) = 0) then
      result := strPas(buffer) ;
  end;

function ndsGetServerDN(nServer : TNWConnHandle) : string ;
  {cn=server.ou=main.ou=....}
  var
    buffer  : TRetBuff ;
  begin
    result := '' ;
    if (@NWDSGetServerDN = nil) then
      @NWDSGetServerDN := getProcAddress(hNWNet,'NWDSGetServerDN') ;
    if (@NWDSGetServerDN = nil) then
      exit ;
    if (nServer = 0) then
      nServer := getPrimaryServerID ;
    if (NWDSGetServerDN(nwContext,
                        nServer,
                        @buffer)=0) then
      result := strPas(buffer) ;
  end;

function ndsWhoAmI : string ;
  {cn=admin}
  var
    cpname : TRetbuff ;
  begin
    result  := '' ;
    if (@NWDSWhoAmI = nil) then
      @NWDSWhoAmI := getProcAddress(hNWNet,'NWDSWhoAmI') ;
    if (@NWDSWhoAmI = nil) then
      exit ;
    if (NWDSWhoAmI(nwContext,
                   @cpName)=0) then
      result := strPas(cpname) ;
  end;

function ndsLogout : boolean ;
  begin
    result := false ;
    if (@NWDSLogout = nil) then
      @NWDSLogout := getProcAddress(hNWNet,'NWDSLogout') ;
    if (@NWDSLogout = nil) then
      exit ;
    nError := NWDSLogout(nwContext) ;
    if (nError <> 0) then
      lastError := nError
    else
      result := true ;
  end;

function ndsLogin(contextName, cname, cPassword : string) : boolean ;
  { login and authenticate }
  var
    cpName     : TNDSName ;
    cpPassword : TNWPassword ;
  begin
    result := false ;
    if (@NWDSLogin = nil) then
      @NWDSLogin := getProcAddress(hNWNet,'NWDSLogin') ;
    if (@NWDSLogin = nil) then
      exit ;
    strPCopy(cpname,allTrim(cname)) ;
    strPCopy(cpPassword,allTrim(cPassword)) ;
    if (length(contextName) > 0) then
      ndsSetContext(contextName) ;
    nError := NWDSLogin(nwContext,0,@cpName,@cpPassword,0) ;
    if (nError <> 0) then
      lastError := nError
    else
      result := true ;
  end;

function ndsPassCheck(contextName, cname, cPassword : string) : boolean ;
  { validate a user's password }
  var
    cpName     : TNDSName ;
    cpPassword : TNWPassword ;
    tempContext  : TNWDSContextHandle ;
  begin
    result := false ;
    if (@NWDSVerifyObjectPassword = nil) then
      @NWDSVerifyObjectPassword := getProcAddress(hNWNet,'NWDSVerifyObjectPassword') ;
    if (@NWDSVerifyObjectPassword = nil) then
      exit ;
    strPCopy(cpName,cname) ;
    strPCopy(cpPassword,upperCase(cPassword)) ;
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      
      nError := NWDSVerifyObjectPassword(tempContext,
                                         0,
                                         @cpName,
                                         @cpPassword);
      if (nError <> 0) then
        lastError := nError
      else
        result := true ;
    finally
      ndsFreeContext(tempContext) ;
    end;   
  end;

function ndsCopyContext(inContext : TNWDSContextHandle) : TNWDSContextHandle ;
  { copy context handle - user must free }
  begin
    result := 0 ;
    if (@NWDSDuplicateContext = nil) then
      @NWDSDuplicateContext := getProcAddress(hNWNet,'NWDSDuplicateContext') ;
    if (@NWDSDuplicateContext = nil) then
      exit ;
    result := NWDSDuplicateContext(inContext) ;
  end;

function NDSGetAttrRights(cSource,cTarget : string ;
                          var attrRights : TNWDSAttrRights) : boolean ;
  var
    cpUser,
    cpObject,
    cpAttrName : TNDSName ;
    rightsList : TNWDSPrivileges ;
  begin
    result := false ;
    if (@NWDSGetEffectiveRights = nil) then
      @NWDSGetEffectiveRights := getProcAddress(hNWNet,'NWDSGetEffectiveRights') ;
    if (@NWDSGetEffectiveRights = nil) then
      exit ;
    strPCopy(cpObject,upperCase(cTarget)) ;
    strPCopy(cpUser,upperCase(cSource)) ;
    strPCopy(cpAttrName,'[All Attributes Rights]') ;
    if (NWDSGetEffectiveRights(nwContext,
                               @cpUser,
                               @cpObject,
                               @cpAttrName,
                               @rightsList)=0) then
      begin
        result := true ;
        with attrRights do begin
          compare    := ((rightsList and nds_attr_compare)>0)  ;
          read       := ((rightsList and nds_attr_read)>0)     ;
          write      := ((rightsList and nds_attr_write)>0)    ;
          self       := ((rightsList and nds_attr_self)>0)     ;
          supervisor := ((rightsList and nds_attr_supervisor)>0)  ;
        end;
      end;
  end;

function ndsGetEntryRights(cSource,cTarget : string ;
                           var entryRights : TNWDSEntryRights) : boolean ;
  var
    cpUser,
    cpObject,
    cpAttrName : TNDSName ;
    rightsList : TNWDSPrivileges ;
  begin
    result  := false ;
    if (@NWDSGetEffectiveRights = nil) then
      @NWDSGetEffectiveRights := getProcAddress(hNWNet,'NWDSGetEffectiveRights') ;
    if (@NWDSGetEffectiveRights = nil) then
      exit ;
    strPCopy(cpObject,upperCase(cTarget)) ;
    strPCopy(cpUser,upperCase(cSource)) ;
    strPCopy(cpAttrName,'[Entry Rights]') ;
    if (NWDSGetEffectiveRights(nwContext,
                               @cpUser,
                               @cpObject,
                               @cpAttrName,
                               @rightsList)=0) then
      begin
        result := True ;
        with entryRights do begin
          browse     := ((rightsList and nds_entry_browse)>0) ;
          add        := ((rightsList and nds_entry_add)>0)    ;
          canDelete  := ((rightsList and nds_entry_delete)>0) ;
          rename     := ((rightsList and nds_entry_rename)>0) ;
          supervisor := ((rightsList and nds_entry_supervisor)>0) ;
        end;
      end;
  end;

function ndsGetSMSRights(cSource,cTarget : string ;
                         var smsRights : TNWDSsmsRights) : boolean ;
  var
    cpUser,
    cpObject,
    cpAttrName : TNDSName ;
    rightsList : TNWDSPrivileges ;
  begin
    result := false ;
    if (@NWDSGetEffectiveRights = nil) then
      @NWDSGetEffectiveRights := getProcAddress(hNWNet,'NWDSGetEffectiveRights') ;
    if (@NWDSGetEffectiveRights = nil) then
      exit ;
    strPCopy(cpObject,upperCase(cTarget)) ;
    strPCopy(cpUser,upperCase(cSource)) ;
    strPCopy(cpAttrName,'[SMS Rights]') ;
    if (NWDSGetEffectiveRights(nwContext,
                               @cpUser,
                               @cpObject,
                               @cpAttrName,
                               @rightsList)=0) then
      begin
        result := true ;
        with smsRights do begin
          scan      := ((rightsList and nds_sms_scan)>0)     ;
          backup    := ((rightsList and nds_sms_backup)>0)   ;
          restore   := ((rightsList and nds_sms_restore)>0)  ;
          rename    := ((rightsList and nds_sms_rename)>0)   ;
          canDelete := ((rightsList and nds_sms_delete)>0)   ;
          admin     := ((rightsList and nds_sms_admin)>0)    ;
        end;
      end;
  end;

function ndsGetObjID(nServer : TNWConnHandle ;
                     objectName : string) : string ;
  {returns the object's hex ID number}
  var
    nObjID : TObjID   ;
    cpName : TNDSName ;
  begin
    result  := '' ;
    if (@NWDSMapNameToID = nil) then
      @NWDSMapNameToID := getProcAddress(hNWNet,'NWDSMapNameToID') ;
    if (@NWDSMapNameToID = nil) then
      exit ;
    if (nServer = 0) then
      nServer := getPrimaryServerID ;
    if (not ndsSetContextName(wrkContext,'[root]')) then
      exit ;
    strPCopy(cpName,objectName) ;
    nError := NWDSMapNameToID(wrkContext, nServer, @cpName, @nObjID) ;
    if (nError <> 0) then
      lastError := nError
    else  
      begin
        result := intToHex(longswap(nObjID),8) ;
        while (leftString(result,1) = '0') do begin
          result := copy(result,2,length(result)-1) ;
          if length(result) = 1 then
            break;
        end;
      end;
  end;                  

function ndsGetObjNumber(var nServer : TNWConnHandle ;
                         fullObjectDN : string) : TObjID ;  
  {return the object's longint object number - must pass full DN}
  var
    nObjID : TObjID   ;
    cpName : TNDSName ;
  begin
    result  := 0 ;
    if (@NWDSMapNameToID = nil) then
      @NWDSMapNameToID := getProcAddress(hNWNet,'NWDSMapNameToID') ;
    if (@NWDSMapNameToID = nil) then
      exit ;
    if (nServer = 0) then
      nServer := getPrimaryServerID ;
    if (not ndsSetContextName(wrkContext,'[root]')) then
      exit ;
    strPCopy(cpName,fullObjectDN) ;
    nError := NWDSMapNameToID(wrkContext, nServer, @cpName, @nObjID) ;
    if (nError <> 0) then
      lastError := nError
    else  
      result := nObjID ;
  end;                  


function ndsConnectToServer(serverName : string) : TNWConnHandle ;
  var
    nServer      : TNWConnHandle ;
    cpServerName : TNDSName ;
  begin
    result := 0 ;
    if (@NWDSOpenConnToNDSServer = nil) then
      @NWDSOpenConnToNDSServer := getProcAddress(hNWNet,'NWDSOpenConnToNDSServer') ;
    if (@NWDSOpenConnToNDSServer = nil) then
      exit ;
    strpCopy(cpServerName,upperCase(serverName)) ;
    if (not ndsSetContextName(wrkContext,'[root]')) then
      exit ;
    nError := NWDSOpenConnToNDSServer(wrkContext,cpServerName,nServer) ;
    if (nError <> 0) then
      lastError := nError
    else
      result := nServer ;
  end;

function ndsDetach(nServer : TNWConnHandle) : boolean ;
  begin
    result := false ;
    if (@NWCCCloseConn = nil) then
      @NWCCCloseConn := getProcAddress(hNWNet,'NWCCCloseConn') ;
    if (@NWCCCloseConn <> nil) then
      nError := NWCCCloseConn(nServer)
    else
      begin
        if (@NWDSUnlockConnection = nil) then
          @NWDSUnlockConnection := getProcAddress(hNWNet,'NWDSUnlockConnection') ;
        if (@NWDSUnlockConnection <> nil) then
          nError := NWDSUnlockConnection(nServer) ;
      end;
    if (nError <> 0) then
      lastError := nError
    else
      result := true ;
  end;

function ndsAttach(serverName : string) : TNWConnHandle ;
  begin
    result := getServerHandle(serverName) ;
    if (result <> 0) then
      ndsAuthenticateServerConn(result) ;
  end;


function ndsisDSServer(nServer : TNWConnHandle) : boolean ;
  var
    cpTreeName : TNDSName ;
  begin
    result := false ;
    if (@NWIsDSServer = nil) then
      @NWIsDSServer := getProcAddress(hNWNet,'NWIsDSServer') ;
    if (@NWIsDSServer = nil) then
      exit ;
    if (nServer = 0) then
      nServer := getPrimaryServerID ;
    nError := (NWIsDSServer(nServer,
                            @cpTreeName)) ;
    if (nError = 0) then
      lastError := -1
    else
      result := (strLen(cpTreeName) > 0);
  end;

function ndsGetServerTreeName(nServer : TNWConnHandle) : string ;
  var
    cpTreeName : TNDSName ;
  begin
    result := '' ;
    if (@NWIsDSServer = nil) then
      @NWIsDSServer := getProcAddress(hNWNet,'NWIsDSServer') ;
    if (@NWIsDSServer = nil) then
      exit ;  
    if (nServer = 0) then
      nServer := getPrimaryServerID ;  
    nError := NWIsDSServer(nServer,@cpTreeName) ;
    if (nError = 0) then  {weird - returns 1 if successful!}
      lastError := nError
    else if (strLen(cpTreeName) > 0) then
      result := strPas(cpTreeName) ;
    while (rightString(result,1) = '_') do
      result := copy(result,1,length(result)-1) ;
  end;


function ndsGetPreferredDSServer : TNWConnHandle ;
  var
    nServer : TNWConnHandle ;
  begin
    result  := 0 ;
    @NWGetPreferredDSServer := getProcAddress(hNWNet,'NWGetPreferredDSServer') ;
    if (@NWGetPreferredDSServer = nil) then
      exit ;
    nServer := 0 ;
    nError := NWGetPreferredDSServer(nServer) ;
    if (nError <> 0) then
      lastError := nError
    else
      result := nServer ;
  end;

function ndsSetPreferredTreeName(treeName : string) : boolean ;
  var
    cpTreeName : TNDSName ;
  begin
    result := false ;
    if (@NWSetPreferredDSTree = nil) then
      @NWSetPreferredDSTree := getProcAddress(hNWNet,'NWSetPreferredDSTree') ;
    if (@NWSetPreferredDSTree = nil) then
      exit ;
    strPCopy(cpTreeName,treeName) ;
    nError := NWSetPreferredDSTree(length(treeName),@cpTreeName) ;
    if (nError <> 0) then
      lastError := nError
    else
      result := true ;
  end;

function ndsAuthenticateServerConn(nServer : TNWConnHandle) : boolean ;
  {convert server handle to authenticated}
  begin
    result := false ;
    if (@NWDSAuthenticateConn = nil) then
      @NWDSAuthenticateConn := getProcAddress(hNWNet,'NWDSAuthenticateConn') ;
    if (@NWDSAuthenticateConn = nil) then
      exit ;
    if (nServer = 0) then
      nServer := getPrimaryServerID ;
    nError := NWDSAuthenticateConn(nwContext,nServer) ;
    if (nError <> 0) then
      lastError := nError
    else
      result := true ;
  end;

function ndsGetObjName(nServer : TNWConnHandle ;
                       objID : TObjID) : string ;
  var
    retbuff : TRetBuff ;
  begin
    result := '' ;
    if (@NWDSMapIDToName = nil) then
      @NWDSMapIDToName := getProcAddress(hNWNet,'NWDSMapIDToName') ;
    if (@NWDSMapIDToName = nil) then
      exit ;
    if (nServer = 0) then
      nServer := getPrimaryServerID ;
    if (not ndsSetContextName(wrkContext,'[root]')) then
      exit ;
    nError := NWDSMapIDToName(wrkContext,nServer,objID,@retBuff) ;
    if (nError <> 0) then
      lastError := nError
    else
      result :=  strPas(retBuff) ;
  end;

function ndsChangePassword(contextName,
                           cUserID,
                           newPassword,
                           oldPassword : string) : boolean ;
  var
    tempContext : TNWDSContextHandle ;
    cpOldPass,
    cpNewPass   : TRetBuff ;
    cpUserID    : TNDSName ;
  begin
    result := false ;
    if (@NWDSChangeObjectPassword = nil) then
      @NWDSChangeObjectPassword := getProcAddress(hNWNet,'NWDSChangeObjectPassword') ;
    if (@NWDSChangeObjectPassword = nil) then
      exit ;
    strPCopy(cpUserID,cUserID) ;
    strPCopy(cpNewPass,upperCase(newPassword)) ;
    strPCopy(cpOldPass,upperCase(oldPassword)) ;
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      if (length(oldPassword) > 0) then  
        nError := NWDSChangeObjectPassword(tempContext,
                                           0,
                                           @cpUserID,
                                           @cpOldPass,
                                           @cpNewPass) 
      else                                     
        nError := NWDSGenerateObjectKeyPair(tempContext,
                                            @cpUserID,
                                            @cpNewPass,
                                            0) ;
                                             
      if (nError <> 0) then
        lastError := nError
      else
        result := true ;
    finally
      ndsFreeContext(tempContext) ;
    end;
  end;

function ndsList(contextName, baseObjName : string) : TStringList ;
  {list container object subordinates}
  var
    nloop       : integer ;
    attrCount,
    objCount    : TNWCount ;
    tempContext : TNWDSContextHandle ;
    iteration   : TNWSequence ;
    oInfo       : Object_Info_T ;
    pBuf        : pBuf_T ;
    cpObjName   : TNDSName ;
  begin
    result     := TStringList.create ;
    iteration  := NO_MORE_ITERATIONS ;
    if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN,@pBuf) <> 0) then
      exit ;
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      try
        strPCopy(cpObjName,baseObjName) ;
        while true do begin
          nError := NWDSList(tempContext,@cpObjName,@iteration,pBuf);
          if (nError <> 0) then
            begin
              lastError := nError ;
              break ;
            end;
          nError := NWDSGetObjectCount(tempContext,pBuf,@objCount);
          if (nError <> 0) then
            begin
              lastError := nError ;
              break ;
            end;
          for nloop := 1 to objCount do begin
            if (NWDSGetObjectName(tempContext,
                                  pBuf,
                                  @cpObjName,
                                  @attrCount,
                                  @oInfo) = 0) then
              result.addObject(
                 strPas(cpObjName),
                 TObject(_ndsGetClassType(@oInfo))) ;
          end ;
          if (iteration = NO_MORE_ITERATIONS) then
            break ;
        end;
      finally
        NWDSFreeContext(tempContext) ;
      end;
    finally
      NWDSFreeBuf(pBuf) ;
    end;
  end;

function ndsGetObjType(contextName, objName : string) : TNWDSObjType ;
  {Get Object Class Type}
  var
    objInfo  : Object_info_T ;
    strValue : string ;
  begin
    result := dsoUnknown ;
    if ndsGetStringAttr(contextName,objName,dsaClassName,strValue) then
      begin
        strPCopy(objInfo.baseClass,strValue) ;
        result := _ndsGetClassType(@objInfo) ;
      end;
  end;

function ndsGetTreeList : TStringList ;
  var
    nServer        : TNWConnHandle      ;
    objID          : TObjID ;
    cpObject       : array[0..63] of char ;
    buffer         : array[0..63] of char ;
    thisName       : string ;
  begin
    result := TStringList.create ;
    if (@NWScanObject = nil) then
      @NWScanObject := getProcAddress(hNWCalls,'NWScanObject') ;
    if (@NWScanObject = nil) then
      exit ;
    nServer   := getPrimaryServerID ;  
    objID     := -1 ;
    strPCopy(buffer,'*') ;
    while true do begin  
      nError   := NWScanObject(nServer,@buffer,$7802,@objID,@cpObject,nil,nil,nil,nil) ;
      {char(95) at end of result string - extract just the name}
      thisName := strExtract(
                      strTran(
                            copy(strPas(cpObject),1,NW_MAX_TREE_NAME_LEN)
                       ,char(95),'=')
                   ,'=',1) ;
      if (nError <> 0) then
        begin
          lastError := nError ;
          break ;
        end
      else if (nError <> 0) then
        break
      else if (result.indexOf(thisName) < 1) then
        begin
          result.addObject(
             thisName,
             TObject(objID)
             ) ;    
        end;          
    end;  
  end;  

  
function ndsGetTreeListEx(filter : string) : TStringList ;
  {has problem with new client shell}
  var
    i              : integer ;
    nTrees,
    nTotalTrees    : longint ;
    tempContext    : TNWDSContextHandle ;
    nServer        : TNWConnHandle      ;
    buffer         : array[0..24] of PChar ;
    cpFilter,
    cpLastTreeName : array[0..NW_MAX_TREE_NAME_LEN-1] of char ;
  begin
    result := TStringList.create ;
    if (@NWDSReturnBlockOfAvailableTrees = nil) then
      @NWDSReturnBlockOfAvailableTrees := getProcAddress(hNWNet,'NWDSReturnBlockOfAvailableTrees') ;
    if (@NWDSReturnBlockOfAvailableTrees = nil) then
      exit ;
    strPCopy(cpFilter,filter) ;
    fillChar(cpLastTreeName,sizeOf(cpLastTreeName),#0) ;
    nServer := getPrimaryServerID ;
    for i := 0 to high(buffer) do
      buffer[i] := strAlloc(NW_MAX_TREE_NAME_LEN) ;
    tempContext := ndsGetContextHandle ;
    try
      while true do begin
        nError := NWDSReturnBlockOfAvailableTrees(tempContext,
                                                  nServer,
                                                  @cpFilter,
                                                  @cpLastTreeName,
                                                  nil,
                                                  sizeOf(buffer),
                                                  buffer,
                                                  @ntrees,
                                                  @ntotalTrees) ;
        if (nError <> 0) and (result.count < 1) then
          begin
            lastError := nError ;
            break ;
          end
        else if (nError <> 0) and (result.count > 0) then
          break
        else
          for i := 0 to high(buffer) do
            result.add(strPas(PChar(buffer[i]^))) ;
      end;
    finally
      ndsFreeContext(tempContext) ;
    end;
    for i := 0 to high(buffer) do
      strDispose(buffer[i]) ;
  end;

function ndsGetTreeListOld : TStringList ;
  {get a listing of available trees - has problem with new client shell}
  var
    tempContext : TNWDSContextHandle ;
    nServer     : TNWConnHandle ;
    sequence    : TNWSequence   ;
    cpFilter,
    cpTreeName  : TNDSName     ;
  begin
    if (@NWDSScanForAvailableTrees = nil) then
      @NWDSScanForAvailableTrees := getProcAddress(hNWNet,'NWDSScanForAvailableTrees') ;
    if (@NWDSScanForAvailableTrees = nil) then
      begin
        result := ndsList('[Root]','') ;
        exit ;
      end;
    result   := TStringList.create ;
    sequence := -1  ;
    nServer  := getPrimaryServerID ;
    tempContext := ndsGetContextHandle ;
    strPCopy(cpFilter,'*') ;
    try                      
      ndsSetContextName(tempContext,'{Root]') ;
      while true do begin
        fillChar(cpTreeName,sizeOf(cpTreeName),#0) ;
        nError := NWDSScanForAvailableTrees(tempContext,
                                            nServer,
                                            @cpFilter,
                                            sequence,
                                            @cpTreeName) ;
        if (nError <> 0) and (result.count < 1) then
          begin
            lastError := nError ;
            break ;
          end
        else if (nError <> 0) then
          break
        else if (result.indexOf(strPas(cpTreeName)) < 0) then
          result.addObject(strPas(cpTreeName),TObject(dsoTree)) ;
      end;   
    finally
      ndsFreeContext(tempContext) ;
    end;      
  end;

function ndsAddObjAttr(contextName,
                       objName      : string ;
                       attrType     : TNWDSAttrType ;
                       pAttrValue   : pointer) : boolean ;
  {add a new nds object attribute & value}
  var
    tempContext : TNWDSContextHandle ;
    cpAttrName  : TNWDSAttrName ;
    cpObjName   : TNDSName ;
    pBuf        : pBuf_T ;
  begin
    result := false ;
    if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @pBuf) <> 0) then
      exit;
    try
      strPCopy(cpObjName,objName) ;
      strPCopy(cpAttrName,_ndsGetAttrName(attrType)) ;
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      if (NWDSInitBuf(tempContext, DSV_ADD_ENTRY, pBuf) <> 0) then
         exit ;
      result := _ndsAlterObjAttr(tempContext,
                                 pBuf,
                                 cpObjName,
                                 cpAttrName,
                                 _ndsGetSynType(attrType),
                                 pAttrValue,
                                 dsaaAdd) ;
    finally
      ndsFreeContext(tempContext) ;
      NWDSFreeBuf(pBuf) ;
    end;
  end;

function ndsModifyObjAttr(contextName,
                          objName      : string ;
                          attrType     : TNWDSAttrType ;
                          pAttrValue   : pointer) : boolean ;
  {change nds object attribute value}
  var
    tempContext : TNWDSContextHandle ;
    cpAttrName  : TNWDSAttrName ;
    cpObjName   : TNDSName ;
    pBuf        : pBuf_T ;
  begin
    result := false ;
    if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @pBuf) <> 0) then
      exit;
    try
      strPCopy(cpObjName,objName) ;
      strPCopy(cpAttrName,_ndsGetAttrName(attrType)) ;
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      if (NWDSInitBuf(tempContext, DSV_MODIFY_ENTRY, pBuf) <> 0) then
        exit ;
      result := _ndsAlterObjAttr(tempContext,
                                 pBuf,
                                 cpObjName,
                                 cpAttrName,
                                 _ndsGetSynType(attrType),
                                 pAttrValue,
                                 dsaaEdit) ;
    finally
      NDSFreeContext(tempContext) ;
      NWDSFreeBuf(pBuf) ;
    end;
  end;

function ndsAddToMultiAttr(contextName,
                           objName      : string ;
                           attrType     : TNWDSAttrType ;
                           pAttrValue   : pointer) : boolean ;
  {add to nds object's multi-value attribute}
  var
    tempContext : TNWDSContextHandle ;
    cpAttrName  : TNWDSAttrName ;
    cpObjName   : TNDSName ;
    pBuf        : pBuf_T ;
  begin
    result := false ;
    if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @pBuf) <> 0) then
      exit;
    try
      strPCopy(cpObjName,objName) ;
      strPCopy(cpAttrName,_ndsGetAttrName(attrType)) ;
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      if (NWDSInitBuf(tempContext, DSV_MODIFY_ENTRY, pBuf) <> 0) then
        exit ;
      result := _ndsAlterObjAttr(tempContext,
                                 pBuf,
                                 cpObjName,
                                 cpAttrName,
                                 _ndsGetSynType(attrType),
                                 pAttrValue,
                                 dsaaAdd) ;
    finally
      NDSFreeContext(tempContext) ;
      NWDSFreeBuf(pBuf) ;
    end;
  end;
  
function ndsRemoveFromMultiAttr(contextName,
                                objName      : string ;
                                attrType     : TNWDSAttrType ;
                                pAttrValue   : pointer) : boolean ;
  {add to nds object's multi-value attribute}
  var
    tempContext : TNWDSContextHandle ;
    cpAttrName  : TNWDSAttrName ;
    cpObjName   : TNDSName ;
    pBuf        : pBuf_T ;
  begin
    result := false ;
    if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @pBuf) <> 0) then
      exit;
    try
      strPCopy(cpObjName,objName) ;
      strPCopy(cpAttrName,_ndsGetAttrName(attrType)) ;
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      if (NWDSInitBuf(tempContext, DSV_MODIFY_ENTRY, pBuf) <> 0) then
        exit ;
      result := _ndsAlterObjAttr(tempContext,
                                 pBuf,
                                 cpObjName,
                                 cpAttrName,
                                 _ndsGetSynType(attrType),
                                 pAttrValue,
                                 dsaaRemoveValue) ;
    finally
      NDSFreeContext(tempContext) ;
      NWDSFreeBuf(pBuf) ;
    end;
  end;

function ndsAddToMultiAttrEx(contextName,
                           objName,
                           attrName     : string ;
                           syntaxType   : TNWDSSynTypes ;
                           pAttrValue   : pointer) : boolean ;
  {add to nds object's multi-value attribute}
  var
    tempContext : TNWDSContextHandle ;
    cpAttrName  : TNWDSAttrName ;
    cpObjName   : TNDSName ;
    pBuf        : pBuf_T ;
  begin
    result := false ;
    if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @pBuf) <> 0) then
      exit;
    try
      strPCopy(cpObjName,objName) ;
      strPCopy(cpAttrName,attrName) ;
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      if (NWDSInitBuf(tempContext, DSV_MODIFY_ENTRY, pBuf) <> 0) then
        exit ;
      result := _ndsAlterObjAttr(tempContext,
                                 pBuf,
                                 cpObjName,
                                 cpAttrName,
                                 syntaxType,
                                 pAttrValue,
                                 dsaaAdd) ;
    finally
      NDSFreeContext(tempContext) ;
      NWDSFreeBuf(pBuf) ;
    end;
  end;

function ndsRemoveFromMultiAttrEx(contextName,
                                objName,
                                attrName     : string ;
                                syntaxType   : TNWDSSynTypes ;
                                pAttrValue   : pointer) : boolean ;
  {add to nds object's multi-value attribute}
  var
    tempContext : TNWDSContextHandle ;
    cpAttrName  : TNWDSAttrName ;
    cpObjName   : TNDSName ;
    pBuf        : pBuf_T ;
  begin
    result := false ;
    if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @pBuf) <> 0) then
      exit;
    try
      strPCopy(cpObjName,objName) ;
      strPCopy(cpAttrName,attrName) ;
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      if (NWDSInitBuf(tempContext, DSV_MODIFY_ENTRY, pBuf) <> 0) then
        exit ;
      result := _ndsAlterObjAttr(tempContext,
                                 pBuf,
                                 cpObjName,
                                 cpAttrName,
                                 syntaxType,
                                 pAttrValue,
                                 dsaaRemoveValue) ;
    finally
      NDSFreeContext(tempContext) ;
      NWDSFreeBuf(pBuf) ;
    end;
  end;

function ndsCreateObject(var ndsObjInfo : TNWDSObjectInfo) : boolean;
  var
    tempContext : TNWDSContextHandle ;
    cptemp,
    cpValue,
    cpObjName   : TNDSName ;
    pBuf        : pBuf_T ;
  begin
    result := false ;
    if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @pBuf) <> 0) then
      exit;
    try
      if (length(ndsObjInfo.contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetcontextName(tempContext,ndsObjInfo.contextName)) then
            exit
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      if (NWDSInitBuf(tempContext, DSV_ADD_ENTRY, pBuf) <> 0) then
        exit ;

      { objName and cn are interchangeable
        should remove objName from record type }
      with ndsObjInfo do begin
        if (length(objName) < 1) then
          objName := cn ;
        if (length(cn) < 1) then
          cn := objName ;
      end;

      {create object class type and mandatory attrs}
      {note:  buffer can hold only 4 attributes at once}
      case ndsObjInfo.objType of
        dsoAFPServer :
          if (not _ndsCreateClassType(tempContext,
                                      pBuf,
                                      'AFP Server')) or
             (not _ndsCreateStringAttr(tempContext,
                                       pBuf,
                                       dsaCommonName,
                                       ndsObjInfo.cn)) then
            exit ;
        dsoAlias :
          if (not _ndsCreateClassType(tempContext,
                                      pBuf,
                                      'Alias')) or
             (not _ndsCreateStringAttr(tempContext,
                                       pBuf,
                                       dsaAliasedObjName,
                                       ndsObjInfo.aliasName)) then
            exit ;
        dsoBinderyObject :
            exit ;
        dsoBinderyQueue :
            exit ;
        dsoComputer :
            exit ;
        dsoCountry :
            exit ;
        dsoDirectoryMap :
            exit ;
        dsoExternalEntity :
            exit ;
        dsoGroup :
          if (not _ndsCreateClassType(tempContext,
                                      pBuf,
                                      'Group')) then
            exit
          else if (not _ndsCreateStringAttr(tempContext,
                                            pBuf,
                                            dsaCommonName,
                                            ndsObjInfo.cn)) then
            exit ;
        dsoList :
            exit ;
        dsoLocality :
            exit ;
        dsoMessageRoutingGroup :
            exit ;
        dsoMessagingServer :
            exit ;
        dsoNcpServer :
            exit ;
        dsoOrganization :
          if (not _ndsCreateClassType(tempContext,
                                      pBuf,
                                      'Organization')) then
            exit
          else if (not _ndsCreateStringAttr(tempContext,
                                            pBuf,
                                            dsaOrganization,
                                            ndsObjInfo.o)) then
            exit ;
        dsoOrganizationalRole :
          if (not _ndsCreateClassType(tempContext,
                                      pBuf,
                                      'Organizational Role')) then
            exit
          else if (not _ndsCreateStringAttr(tempContext,
                                            pBuf,
                                            dsaCommonName,
                                            ndsObjInfo.cn)) then
            exit ;
        dsoOrganizationalUnit :
          if (not _ndsCreateClassType(tempContext,
                                      pBuf,
                                      'Organizational Unit')) then
            exit
          else 
            if (not _ndsCreateStringAttr(tempContext,
                                                pBuf,
                                                dsaOrganizationalUnit,
                                                ndsObjInfo.ou)) then
               exit ;
        dsoPrinter :
          if (not _ndsCreateClassType(tempContext,
                                      pBuf,
                                      'Printer')) then
            exit
          else if (not _ndsCreateStringAttr(tempContext,
                                            pBuf,
                                            dsaCommonName,
                                            ndsObjInfo.cn)) then
            exit ;
        dsoPrintServer :
          if (not _ndsCreateClassType(tempContext,
                                      pBuf,
                                     'Print Server')) then
            exit
          else if (not _ndsCreateStringAttr(tempContext,
                                            pBuf,
                                            dsaCommonName,
                                            ndsObjInfo.cn)) then
            exit ;
            


        dsoProfile :
          begin
            strPCopy(cpValue,'Login Script') ;
            strPCopy(cptemp,'rem Login Script Begin') ;
            if (not _ndsCreateClassType(tempContext,
                                        pBuf,
                                        'Profile')) then
              exit
            else if (not _ndsCreateStringAttr(tempContext,
                                              pBuf,
                                              dsaCommonName,
                                              ndsObjInfo.cn)) then
              exit
            else if (NWDSPutAttrName(tempContext, pBuf, @cpValue) <> 0) then
              exit
            else if (NWDSPutAttrVal(tempContext, pBuf, ord(SYN_STREAM), @cptemp) <> 0) then
              exit ;
          end;
        dsoQueue :
          if (not _ndsCreateClassType(tempContext,
                                      pBuf,
                                      'Queue')) then
            exit
          else if (not _ndsCreateStringAttr(tempContext,
                                            pBuf,
                                            dsaCommonName,
                                            ndsObjInfo.cn)) then
            exit
          else if (not _ndsCreateStringAttr(tempContext,
                                            pBuf,
                                            dsaQueueDirectory,
                                            ndsObjInfo.directoryName)) then
            exit ;
        dsoTop :
            exit ;
        dsoUnknown :
            exit ;
        dsoVolume :
            exit ;
      else           { assume a user object}
        begin
          if (not _ndsCreateClassType(tempContext,
                                      pBuf,
                                      'User')) then
            exit   {
          else if (not _ndsCreateStringAttr(tempContext,
                                            pBuf,               // don't put in buffer, objName contains
                                            dsaCommonName,      // full DN, or context+objName = fullDN
                                            ndsObjInfo.cn)) then
            exit  }
          else if (not _ndsCreateStringAttr(tempContext,
                                            pBuf,
                                            dsaSurname,
                                            ndsObjInfo.surname)) then
            exit
          else if (not _ndsCreateStringAttr(tempContext,
                                            pBuf,
                                            dsaGivenName,
                                            ndsObjInfo.givenName)) then
            exit
          else if (not _ndsCreateStringAttr(tempContext,
                                            pBuf,
                                            dsaFullname,
                                            ndsObjInfo.fullname)) then  
            exit  
        end;      
      end;

      {create the object}
      strPCopy(cpObjName,ndsObjInfo.objName) ;
      nError := NWDSAddObject(tempContext,
                              @cpObjName,
                              nil, 
                              byteBool(0),
                              pBuf) ;
      if (nError <> 0) then
        lastError := nError
      else if (ndsObjInfo.objType = dsoUser) then
        begin  {generate pw keys for users to login}
          strPCopy(cpValue,upperCase(ndsObjInfo.password)) ;
          result := (NWDSGenerateObjectKeyPair(tempContext,
                                               @cpObjName,
                                               @cpValue,
                                               0) = 0)
        end
      else
        result := true ;
    finally
      NWDSFreeBuf(pBuf) ;
      NWDSFreeContext(tempContext) ;
    end;
  end;
  
function ndsRemoveObject(contextName,
                         objName     : string ) : boolean ;
  {delete an object from tree}
  var
    tempContext : TNWDSContextHandle ;
    cpObjName   : TNDSName ;
  begin
    result := false ;
    strpCopy(cpObjName,objName) ;
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetcontextName(tempContext,contextName)) then
            exit
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      nError := NWDSRemoveObject(tempContext,@cpObjName) ;
      if (nError <> 0) then
        lastError := nError
      else
        result := true ;
    finally
      NWDSFreeContext(tempContext) ;
    end;
  end;

function ndsGetObjAttr(context  : TNWDSContextHandle ;
                       objName  : string ;
                       attrType : TNWDSAttrType ;
                       value    : pointer) : boolean ;
  var                 
    iteration   : TNWSequence ;
    cpAttrName  : TNWDSAttrName ;
    cpObject    : TNDSName ;
    pInBuf,
    pBuf        : pBuf_T ;
  begin
    result    := false ;
    iteration := NO_MORE_ITERATIONS ;
    if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @pInBuf) <> 0) then
      exit ;
    try
      if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @pBuf) <> 0) then
        exit ;
      try
        strPCopy(cpObject,objName) ;
        if (NWDSInitBuf(context, DSV_READ, pInBuf) <> 0) then
          exit ;
        {add attribute name to input buffer}
        strPCopy(cpAttrName,_ndsGetAttrName(attrType)) ;
        nError := NWDSPutAttrName(context,pInBuf,@cpAttrName) ;
        if (nError <> 0) then
          begin
            lastError := nError ;
            exit ;
          end;
        {read object, fill up the output buffer}
        while true do begin
          nError := NWDSRead(context,
                             @cpObject,
                             ord(DS_ATTRIBUTE_VALUES),
                             byteBool(false),
                             pInBuf,
                             @iteration,
                             pBuf) ;
          if (nError <> 0) then
            begin
              lastError := nError ;
              break ;
            end;
          if _ndsGetBufValue(context,
                             pBuf,
                             _ndsGetAttrName(attrType),
                             value) then
          result := true ;
          if (iteration = NO_MORE_ITERATIONS) then
            break ;
        end;
      finally
        NWDSFreeBuf(pBuf) ;
      end;
    finally
      NWDSFreeBuf(pInBuf) ;
    end;
  end;

function ndsGetStringAttr(contextName, objName : string ;
                          attrType : TNWDSAttrType;
                          var value : string) : boolean ;
  var
    tempContext : TNWDSContextHandle ;
    cpValue     : TRetBuff ;
  begin
    result := false ;
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      if (not ndsGetObjAttr(tempContext,
                            objName,
                            attrType,
                            @cpValue)) then
        exit ;
      value := strPas(cpValue) ;
      result := true ;
    finally
      ndsFreeContext(tempContext) ;
    end;
  end;

function ndsGetPathAttr(contextName, objName : string ;
                        attrType : TNWDSAttrType;
                        var pathinfo : TNWDSPathInfo) : boolean ;
  var
    tempContext : TNWDSContextHandle ;
    dsPath      : Path_THack ;
    cpPath,
    cpVol       : string ;
  begin
    result := false ;
    dsPath.path := @cpPath ;
    dsPath.volumename := @cpVol ;
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      if ndsGetObjAttr(tempContext,
                       objName,
                       attrType,
                       @dsPath) then
        begin                
          pathInfo.nameSpaceType := dsPath.nameSpaceType ;
          pathInfo.volumeName    := strPas(pchar(dsPath.volumename)) ;
          pathInfo.path          := strPas(pchar(dsPath.path)) ;
          result := true ;
        end;  
    finally
      ndsFreeContext(tempContext) ;
    end;
  end;


function ndsGetBooleanAttr(contextName, objName : string ;
                           attrType : TNWDSAttrType;
                           var value : boolean) : boolean ;
  var
    byteValue   : byte ;
    tempContext : TNWDSContextHandle ;
  begin
    result := false ;
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      if (not ndsGetObjAttr(tempContext,
                            objName,
                            attrType,
                            @byteValue)) then
        exit ;
      value := (byteValue = 1) ;
      result := true ;
    finally
      ndsFreeContext(tempContext) ;
    end;
  end;

function ndsGetIntegerAttr(contextName, objName : string ;
                           attrType : TNWDSAttrType;
                           var value : longint) : boolean ;
  var
    tempContext : TNWDSContextHandle ;
  begin
    result := false ;
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      if (not ndsGetObjAttr(tempContext,
                            objName,
                            attrType,
                            @value)) then
        exit ;
      result := true ;
    finally
      ndsFreeContext(tempContext) ;
    end;
  end;

function ndsGetDateTimeAttr(contextName, objName : string ;
                            attrType : TNWDSAttrType;
                            var value : TDateTime) : boolean ;
  var
    intValue    : longint ;
    tempContext : TNWDSContextHandle ;
  begin
    result := false ;
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;

      if (not ndsGetObjAttr(tempContext,
                            objName,
                            attrType,
                            @intValue)) then
        exit ;
      value := nwDateToDelphiDate(intValue) ;
      result := true ;
    finally
      ndsFreeContext(tempContext) ;
    end;
  end;

{ create a new string attribute and value }
function ndsCreateStringAttr(contextName,
                             objName   : string ;
                             attrType  : TNWDSAttrType ;
                             attrVal   : string) : boolean  ;
  var
    cpValue : array[0..255] of char ;
  begin
    strPCopy(cpValue,attrVal) ;
    result := ndsAddObjAttr(contextName,objName,attrType,@cpValue) ;
  end;


{ create a new integer attribute and value }
function ndsCreateIntegerAttr(contextName,
                              objName   : string ;
                              attrType  : TNWDSAttrType ;
                              attrVal   : longint) : boolean  ;
  begin
    result := ndsAddObjAttr(contextName,objName,attrType,@attrVal) ;
  end;

{ create a new boolean attribute and value }
function ndsCreateBooleanAttr(contextName,
                              objName   : string ;
                              attrType  : TNWDSAttrType      ;
                              attrVal   : boolean) : boolean  ;
  var
    boolValue : byteBool ;
  begin
    boolValue := byteBool(attrVal) ;
    result    := ndsAddObjAttr(contextName,objName,attrType,@boolValue) ;
  end;

{ create a new date/time attribute and value }
function ndsCreateDateTimeAttr(contextName,
                               objName   : string ;
                               attrType  : TNWDSAttrType      ;
                               attrVal   : TDateTime) : boolean  ;
  var
    intValue : longint ;
  begin
    intValue := delphiDateToNWDate(attrVal) ;
    result := ndsAddObjAttr(contextName,objName,attrType,@intValue) ;
  end;

{change an object's string attribute}
function ndsModifyStringAttr(contextName,
                             objName      : string ;
                             attrType     : TNWDSAttrType ;
                             attrVal      : string) : boolean ;
  var
    cpValue : array[0..255] of char ;
  begin
    strPCopy(cpValue,attrVal) ;
    result := ndsModifyObjAttr(contextName,objName,attrType,@cpValue) ;
  end;

{change an object's integer attribute}
function ndsModifyIntegerAttr(contextName,
                              objName      : string ;
                              attrType     : TNWDSAttrType ;
                              attrVal      : longint) : boolean ;
  begin
    result := ndsModifyObjAttr(contextName,objName,attrType,@attrVal) ;
  end;

{change an object's string attribute}
function ndsModifyBooleanAttr(contextName,
                              objName      : string ;
                              attrType     : TNWDSAttrType ;
                              attrVal      : boolean) : boolean ;
  var
    boolValue : bytebool ;
  begin
    boolValue := byteBool(attrVal) ;
    result    := ndsModifyObjAttr(contextName,objName,attrType,@boolValue) ;
  end;

{change an object's date/time attribute}
function ndsModifyDateTimeAttr(contextName,
                             objName      : string ;
                             attrType     : TNWDSAttrType ;
                             attrVal      : TDateTime) : boolean ;
  var
    intValue : longint ;
  begin
    intValue := delphiDateToNWDate(attrVal) ;
    result   := ndsModifyObjAttr(contextName,objName,attrType,@intValue) ;
  end;


{get multi-value attribute}
function ndsGetMultiAttr(contextName,
                         objName      : string ;
                         attrType     : TNWDSAttrType ;
                         var objList  : TList) : boolean ;
  { thanks to Allen Drennan for great debug work! }                       
  var
    nloop       : integer ;
    valSize,
    valCount,
    attrCount,
    synType     : longint ;
    iteration   : TNWSequence ;
    tempContext : TNWDSContextHandle ;
    pInBuf,
    pBuf        : pBuf_T ;
    pValue      : pointer ;
    cpAttrName  : TNWDSAttrName ;
    cpObject    : TNDSName ;
  begin
    result := false ;
    strPCopy(cpObject,objName) ;
    strPCopy(cpAttrName,_ndsGetAttrName(attrType)) ;
    iteration := NO_MORE_ITERATIONS ;

    {context creation}
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;

      {buffer allocation}
      if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @pInBuf) <> 0) then
        exit ;
      try
        if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @pBuf) <> 0) then
          exit ;
        try
          if (NWDSInitBuf(tempContext, DSV_READ, pInBuf) <> 0) then
            exit ;
          {add attribute name to input buffer}
          nError := NWDSPutAttrName(tempContext,pInBuf,@cpAttrName) ;
          if (nError <> 0) then
            begin
              lastError := nError ;
              exit ;
            end;
          {read object, fill up the output buffer}
          while true do begin
            nError := NWDSRead(tempContext,
                               @cpObject,
                               ord(DS_ATTRIBUTE_VALUES),
                               byteBool(false),
                               pInBuf,
                               @iteration,
                               pBuf) ;
            if (nError <> 0) then
              begin
                lastError := nError ;
                break ;
              end;

            {count the attrs in buffer}
            nError := NWDSGetAttrCount(tempContext, pBuf, @attrCount);
            if (nError <> 0) then
              begin
                lastError := nError ;
                exit;
              end;

            {locate attribute value}
            nError := NWDSGetAttrName(tempContext,
                                      pBuf,
                                      @cpAttrName,
                                      @valCount,
                                      @synType) ;
            if (nError <> 0) then
              begin
                lastError := nError ;
                exit ;
              end;
            {compute attribute size}
            if (NWDSComputeAttrValSize(tempContext,pBuf,synType,@valSize) = 0) then
              {extract each attribute value}
              for nloop := 1 to valCount do begin
                getMem(pValue,valSize*2) ;
                nError := NWDSGetAttrVal(tempContext,
                                         pBuf,
                                         synType,
                                         pValue) ;
                if (nError <> 0) then
                  begin
                    if (nloop = 1) then
                      lastError := nError ;
                    exit ;
                  end
                else
                  objList.add(pValue) ;
              end;
            if (iteration = NO_MORE_ITERATIONS) then
              break ;
          end;
        finally
          NWDSFreeBuf(pBuf) ;
        end;
      finally
        NWDSFreeBuf(pInBuf) ;
      end;
    finally
      ndsFreeContext(tempContext) ;
    end;
    result := (objList.count > 0) ;
  end;

{get any multi-value attribute}  
function ndsGetMultiAttrEx(contextName,
                           objName,     
                           attrName    : string ;
                           syntaxType  : TNWDSSynTypes ;
                           var objList : TList) : boolean ;
  var
    nloop       : integer ;
    valSize,
    valCount,
    attrCount,
    synType     : longint ;
    iteration   : TNWSequence ;
    tempContext : TNWDSContextHandle ;
    pInBuf,
    pBuf        : pBuf_T ;
    pValue      : pointer ;
    cpAttrName  : TNWDSAttrName ;
    cpObject    : TNDSName ;
  begin
    result := false ;
    strPCopy(cpObject,objName) ;
    strPCopy(cpAttrName,attrName) ;
    iteration := NO_MORE_ITERATIONS ;
    {context creation}
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;

      {buffer allocation}
      if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @pInBuf) <> 0) then
        exit ;
      try
        if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @pBuf) <> 0) then
          exit ;
        try
          if (NWDSInitBuf(tempContext, DSV_READ, pInBuf) <> 0) then
            exit ;
          {add attribute name to input buffer}
          nError := NWDSPutAttrName(tempContext,pInBuf,@cpAttrName) ;
          if (nError <> 0) then
            begin
              lastError := nError ;
              exit ;
            end;
          {read object, fill up the output buffer}
          while true do begin
            nError := NWDSRead(tempContext,
                               @cpObject,
                               ord(DS_ATTRIBUTE_VALUES),
                               byteBool(false),
                               pInBuf,
                               @iteration,
                               pBuf) ;
            if (nError <> 0) then
              begin
                lastError := nError ;
                break ;
              end;

            {count the attrs in buffer}
            nError := NWDSGetAttrCount(tempContext, pBuf, @attrCount);
            if (nError <> 0) then
              begin
                lastError := nError ;
                exit;
              end;

            {locate attribute value}
            nError := NWDSGetAttrName(tempContext,
                                      pBuf,
                                      @cpAttrName,
                                      @valCount,
                                      @synType) ;
            if (nError <> 0) then
              begin
                lastError := nError ;
                exit ;
              end;
            {compute attribute size}
            if (NWDSComputeAttrValSize(tempContext,pBuf,synType,@valSize) = 0) then
              {extract each attribute value}
              for nloop := 1 to valCount do begin
                getMem(pValue,valSize*2) ;
                nError := NWDSGetAttrVal(tempContext,
                                         pBuf,
                                         synType,
                                         pValue) ;
                if (nError <> 0) then
                  begin
                    if (nloop = 1) then
                      lastError := nError ;
                    exit ;
                  end
                else
                  objList.add(pValue) ;
              end;
            if (iteration = NO_MORE_ITERATIONS) then
              break ;
          end;
        finally
          NWDSFreeBuf(pBuf) ;
        end;
      finally
        NWDSFreeBuf(pInBuf) ;
      end;
    finally
      ndsFreeContext(tempContext) ;
    end;
    result := (objList.count > 0) ;
  end;
                           
  

function ndsOpenAttrStream(contextName,
                           objName      : string ;
                           attrType     : TNWDSAttrType;
                           var hStream  : THandleStream) : boolean ;
  var
    tempContext : TNWDSContextHandle ;
    hFile       : NWFile_Handle ;
    cpObject,
    cpAttrName  : TObjName ;
  begin
    {context creation}
    result := false ;
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not ndsSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;

      strPCopy(cpObject,objName) ;
      strPCopy(cpAttrName,_ndsGetAttrName(attrType)) ;                      {1=read 2=write}
      nError := NWDSOpenStream(tempContext,@cpObject,@cpAttrName,3,hFile) ; {3=read/write}
      if (nError <> 0) then
        begin
          lastError := nError ;
          exit ;
        end ;
      hStream := THandleStream.create(hFile) ;
      result := true ;
    finally
      ndsFreeContext(tempContext) ;
    end;
  end;

  
function ndsOpenAttrStreamEx(contextName,  {can read any attr. type}
                             objName,
                             attrName     : string ;
                             var hStream  : THandleStream) : boolean ;
  var
    tempContext : TNWDSContextHandle ;
    hFile       : NWFile_Handle ;
    cpObject,
    cpAttrName  : TObjName ;
  begin
    {context creation}
    result := false ;
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not ndsSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;

      strPCopy(cpObject,objName) ;
      strPCopy(cpAttrName,attrName) ;                                       {1=read 2=write}
      nError := NWDSOpenStream(tempContext,@cpObject,@cpAttrName,3,hFile) ; {3=read/write}
      if (nError <> 0) then
        begin
          lastError := nError ;
          exit ;
        end ;
      hStream := THandleStream.create(hFile) ;
      result := true ;
    finally
      ndsFreeContext(tempContext) ;
    end;
  end;
  

function ndsAuthenticateObject(contextName, objName : string) : TNWConnHandle ;
  var
    tempContext : TNWDSContextHandle ;
    nServer     : TNWConnHandle ;
    objID       : TObjID        ;
    cpObject    : TNDSName ;
  begin
    result := 0 ;
    if (@NWDSResolveName = nil) then
      @NWDSResolveName := getProcAddress(hNWNet,'NWDSResolveName') ;
    if (@NWDSResolveName = nil) then
      exit ;
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not ndsSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;

      strPCopy(cpObject,objName) ;
      nError := NWDSResolveName(tempContext,@cpObject,nServer,@objID) ;
      if (nError <> 0) then
        lastError := nError
      else
        begin
          @NWDSAuthenticateConn := getProcAddress(hNWNet,'NWDSAuthenticateConn') ;
          if (@NWDSAuthenticateConn <> nil) then
            nError := NWDSAuthenticateConn(tempContext,nServer)
          else
            begin  {pre 1/97}
              @NWDSAuthenticate := getProcAddress(hNWNet,'NWDSAuthenticate') ;
              if (@NWDSAuthenticate = nil) then
                exit ;
              nError := NWDSAuthenticate(nServer,0,nil) ;
            end;
          if (nError <> 0) then
            lastError := nError
          else
            result := nServer ;
        end;
    finally
      ndsFreecontext(tempContext) ;
    end;
  end;


function ndsAddSecurityEquals(contextName, objName, equalToObj : string) : boolean ;
  var
    tempContext : TNWDSContextHandle ;
    cpEqualObj,
    cpObjName   : TNDSName ;
  begin
    result := false ;
    if (@NWDSAddSecurityEquiv = nil) then
      @NWDSAddSecurityEquiv := getProcAddress(hNWNet,'NWDSAddSecurityEquiv') ;
    if (@NWDSAddSecurityEquiv = nil) then
      exit ;
    strPCopy(cpObjName,objName) ;
    strPCopy(cpEqualObj,equalToObj) ;
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not ndsSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      nError := NWDSAddSecurityEquiv(tempContext,@cpObjName,@cpEqualObj) ;
      if (nError <> 0) then
        lastError := nError
      else
        result := true ;
    finally
      ndsFreeContext(tempContext) ;
    end;
  end;

function ndsModifyPathAttr(contextName,
                           objName     : string ;
                           attrType    : TNWDSAttrType;
                           ndsPathInfo : TNWDSPathInfo) : boolean ;
  var
    dsPath      : path_T ;
    cpPath,
    cpVolName   : TRetBuff ;
  begin
    with ndsPathInfo do begin
      strPCopy(cpVolName,volumeName) ;
      strPCopy(cpPath,path) ;
    end;
    with dsPath do begin
      nameSpaceType := ndsPathInfo.nameSpaceType ;
      volumeName    := @cpVolName ;
      path          := @cpPath ;
    end ;
    result := ndsModifyObjAttr(contextName,
                               objName,
                               attrType,
                               @dsPath) ;
  end;

function ndsGetDSBuildLevel(nServer : TNWConnHandle) : string ;
  var
    ndsVersion : longint ;
  begin
    result := '' ;
    if (@NWDSGetDSVerInfo = nil) then
      @NWDSGetDSVerInfo := getProcAddress(hNWNet,'NWDSGetDSVerInfo') ;
    if (@NWDSGetDSVerInfo = nil) then
      exit ;
    if (nServer = 0) then
      nServer := getPrimaryServerID ;
    nError := NWDSGetDSVerInfo(nServer,@ndsVersion,nil,nil,nil,nil) ;
    if (nError <> 0) then
      lastError := nError
    else
      result := intToStr(ndsVersion) ;      
  end;
  
function ndsCanAuthenticate(contextName : string) : boolean ;
  var
    tempContext : TNWDSContextHandle ;
  begin
    result := false ;
    if (@NWDSCanDSAuthenticate = nil) then
      @NWDSCanDSAuthenticate := getProcAddresS(hNWNet,'NWDSCanDSAuthenticate') ;
    if (@NWDSCanDSAuthenticate = nil) then
      exit ;
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not ndsSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      nError := NWDSCanDSAuthenticate(tempContext) ;
      if (nError <> 1) then {1=credentials exist}
        lastError := nError
      else
        result := true ;
     finally
       ndsFreeContext(tempContext) ;
     end;
  end;

function ndsRemoveSecurityEquals(contextName, objName,  equalToObj : string) : boolean ;
  var
    tempContext : TNWDSContextHandle ;
    cpObjName,
    cpEqualObj  : TNDSName ;
  begin
    result := false ;
    if (@NWDSRemSecurityEquiv = nil) then
      @NWDSRemSecurityEquiv := getProcAddress(hNWNet,'NWDSRemSecurityEquiv') ;
    if (@NWDSRemSecurityEquiv = nil) then
      exit ;
    strPCopy(cpObjName,objName) ;
    strPCopy(cpEqualObj,equalToObj) ;  
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not ndsSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      nError := NWDSRemSecurityEquiv(tempContext,@cpObjName,@cpEqualObj) ;
      if (nError <> 0) then
        lastError := nError
      else
        result := true ;    
    finally
      ndsFreeContext(tempContext) ;
    end;
  end;

function ndsGetTypelessName(typedName : string) : string ;
  var
    cpTypeName,
    cpTypelessName : TNDSName ;
  begin
    result := '' ;
    strPCopy(cpTypeName,typedName) ;
    if (@NWDSRemoveAllTypes = nil) then
      @NWDSRemoveAllTypes := getProcAddress(hNWNet,'NWDSRemoveAllTypes') ;
    if (@NWDSRemoveAllTypes = nil) then
    exit ;
    nError := NWDSRemoveAllTypes(nwContext,@cpTypeName,@cpTypelessName) ;
    if (nError <> 0) then
      lastError := nError 
    else
      result := strPas(cpTypelessName) ;  
  end;  

  
function ndsAddObjToGroup(objName, groupName : string) : boolean ;
  var
    cpObject,
    cpGroup   : TNDSName ;
  begin
    result := false ;
    strPCopy(cpObject,objName) ;
    strPCopy(cpGroup,groupName) ;
    if ndsAddToMultiAttr('',objName,dsaGroupMembership,@cpGroup) then
      result := ndsAddToMultiAttr('',groupName,dsaMember,@cpObject) ;
  end;
  
function ndsRemoveObjFromGroup(objName, groupName : string) : boolean ;
  var
    cpObject,
    cpGroup   : TNDSName ;
  begin
    result := false ;
    strPCopy(cpObject,objName) ;
    strPCopy(cpGroup,groupName) ;
    if ndsRemoveFromMultiAttr('',objName,dsaGroupMembership,@cpGroup) then
      result := ndsRemoveFromMultiAttr('',groupName,dsaMember,@cpObject) ;
  end;

function ndsGetMyGroups(contextName, objName : string) : TStringList ;
  var
    nloop    : integer ;
    tempList : TList ;
  begin
    result := TStringList.create ;
    tempList := TList.create ;
    try
      if ndsGetMultiAttr(contextName,objName,dsaGroupMembership,tempList) then
        for nloop := 0 to (tempList.count -1) do 
          result.addObject(strPas(tempList[nloop]),TObject(dsoGroup)) ;
      result.sort ;    
    finally 
      tempList.free ;
    end;
  end;  

procedure resetNWLibContext ;  {reset back to default}
  begin
    ndsFreeContext(nwContext) ;
    nwContext := NWDSCreateContext ;
    ndsSetContext('[Root]') ;
  end;               

function ndsGetGroupMembers(contextName, objName : string) : TStringList ;
  var
    nloop    : integer ;
    tempList : TList ;
  begin
    result := TStringList.create ;
    tempList := TList.create ;
    try
      if ndsGetMultiAttr(contextName,objName,dsaMember,tempList) then
        for nloop := 0 to (tempList.count -1) do 
          result.addObject(strPas(tempList[nloop]),TObject(dsoUser)) ;
      result.sort ;    
    finally 
      tempList.free ;
    end;
  end;  
  
function ndsSearch(contextName, className, filterName : string) : TStringList ;
  {many thanks to Darwin Collins for help with this function}
  var
    i,ntemp,
    iteration   : integer ;
    ncount      : nuint32 ;
    cpClassName,
    cpOutput,
    cpFilter,
    cpStartLoc  : TNDSName ;
    pFilterBuf,
    pResultBuf  : pBuf_T ;
    oInfo       : Object_Info_T ;
    pCursor     : pFilter_Cursor_T ;
  begin
    result     := TStringList.create ;
    iteration  := NO_MORE_ITERATIONS ;
    
    if (@NWDSSearch = nil) then
      @NWDSSearch := getProcAddress(hNWNet,'NWDSSearch') ;
    if (@NWDSSearch = nil) then
      exit ; 
    if (@NWDSAllocFilter = nil) then
      @NWDSAllocFilter := getProcAddress(hNWNet,'NWDSAllocFilter') ;
    if (@NWDSAllocFilter = nil) then
      exit ;
    if (@NWDSAddFilterToken = nil) then
      @NWDSAddFilterToken := getProcAddress(hNWNet,'NWDSAddFilterToken') ;
    if (@NWDSAddFilterToken = nil) then
      exit ;
    if (@NWDSPutFilter = nil) then
      @NWDSPutFilter := getProcAddress(hNWNet,'NWDSPutFilter') ;
    if (@NWDSPutFilter = nil) then
      exit ;
    if (@NWDSFreeFilter = nil) then
      @NWDSFreeFilter := getProcAddress(hNWNet,'NWDSFreeFilter') ;
    if (@NWDSFreeFilter = nil) then
      exit ;

    if (length(contextName) < 1) then
      contextName := '[Root]' ;
      
    if (not ndsSetContextName(wrkContext,'[Root]')) then
      exit ;

    strPCopy(cpStartLoc,contextName) ; 
    
    if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN,@pFilterBuf) = 0) then
      try
        if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN,@pResultBuf) = 0) then
          try
            {initialize filter buffer - filter tokens added next}
            nError := NWDSInitBuf(wrkContext,DSV_SEARCH_FILTER,pFilterBuf);
            if (nError <> 0) then
              begin
                lastError := nError;
                exit ;
              end;
              
            {allocate filter, and prepare tokens in expression tree}
            if (NWDSAllocFilter(@pCursor) = 0) then 
              begin
                {RDN = Name}
                if (NWDSAddFilterToken(pCursor,FTOK_RDN, nil, 0) <> 0) then
                  exit ;
                strPCopy(cpFilter,filterName) ;  
                if (NWDSAddFilterToken(pCursor,FTOK_ANAME,@cpFilter,ord(SYN_CI_STRING)) <> 0) then
                  exit ;  
                {Class Name Filter}
                if (length(className) > 0) then
                  begin
                    strPCopy(cpClassName,className) ;
                    if (NWDSAddFilterToken( pCursor, FTOK_AND, nil, 0) <> 0) then
                      exit ;
                    if (NWDSAddFilterToken( pCursor, FTOK_BASECLS, nil, 0) <> 0) then
                      exit ;
                    if (NWDSAddFilterToken( pCursor, FTOK_ANAME, @cpClassName, ord(SYN_CI_STRING)) <> 0) then
                      exit ;
                  end;  

                {end of buffer}
                if (NWDSAddFilterToken(pCursor,
                                       FTOK_END,
                                       nil,
                                       0) <> 0) then
                  exit ;                            
                           
                {apply cursor filter tokens to filter buffer - frees cursor}  
                nError := NWDSPutFilter(wrkContext,pFilterBuf,pCursor,nil) ;
                if (nError <> 0) then
                  begin
                    // freed if filter PUT properly
                    NWDSFreeFilter(pCursor, nil) ;
                    lastError := nError ;
                  end  
                else  
                  repeat  {begin search!}  
                    nError := NWDSSearch(wrkContext,
                                         @cpStartLoc,
                                         DS_SEARCH_SUBTREE,
                                         false,           {deref aliases}
                                         pFilterBuf,
                                         1,               {0=attrNames 1=names + values}
                                         false,           {all attributes?}
                                         nil, 
                                         @iteration,     
                                         0,               {reserved for future use}
                                         @ncount,
                                         pResultBuf) ;    {the located cn is stored here}
                    if (nError <> 0) then
                      begin
                        lastError := nError ;
                        break ;
                      end
                    else
                      begin
                        // extract names from buffer
                        if (NWDSGetObjectCount(wrkContext, pResultBuf, @nCount) = 0) then
                          for i := 1 to ncount do begin
                            if (NWDSGetObjectName(wrkContext, pResultBuf, @cpOutput, @ntemp, @oInfo) = 0) then
                              result.addObject(strPas(cpOutput),
                                               TObject(_ndsGetClassType(@oInfo))) ;
                          end;
                      end;
                  until (iteration = NO_MORE_ITERATIONS) ;
              end;
          finally
            NWDSFreeBuf(pResultBuf) ;
          end;  
      finally 
        NWDSFreeBuf(pFilterBuf) ;
      end;
  end;

function getInternalContextHandle : TNWDSContextHandle ;
  begin
    result := nwContext ;
  end;  

function ndsRemoveAttr(contextName, attrName : string) : boolean ;
  var
    cpAttrName  : array[0..(max_asn1_name-1)] of char ;
    tempContext : TNWDSContextHandle ;
  begin         
    result := false ;
    if (@NWDSRemoveAttrDef = nil) then
      @NWDSRemoveAttrDef := getProcAddress(hNWNet,'NWDSRemoveAttrDef') ;
    if (@NWDSRemoveAttrDef = nil) then
      exit ;
    strPCopy(cpAttrName,attrName) ;  
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      nError := NWDSRemoveAttrDef(tempContext,@cpAttrName) ;
      if (nError <> 0) then
        lastError := nError
      else
        result := true ;    
    finally
      ndsFreeContext(tempContext) ;
    end;
  end;

function ndsDefineClass(contextName, className : string ; 
                        classDef : TNWDSClassDef) : boolean ;
  var
    tempContext : TNWDSContextHandle ;
    cpClassName : TRetBuff ;
    classInfo   : Class_Info_T ;
    buf         : Buf_T ;
  begin
    result := false ;
    if (@NWDSDefineClass = nil) then
      @NWDSDefineClass := getProcAddress(hNWNet,'NWDSDefineClass') ;
    if (@NWDSDefineClass = nil) then
      exit ;
    strPCopy(cpClassName,className) ;
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      with classInfo do begin
        classFlags := 0 ;
        if classDef.classFlags.container then
          classFlags := (classFlags or DS_CONTAINER_CLASS) ;
        if classDef.classFlags.effective then
          classFlags := (classFlags or DS_EFFECTIVE_CLASS) ;
        if classDef.classFlags.nonRemovable then
          classFlags := (classFlags or DS_NONREMOVABLE_CLASS) ;
        if classDef.classFlags.ambiguousNaming then
          classFlags := (classFlags or DS_AMBIGUOUS_NAMING) ;
        if classDef.classFlags.ambiguousContainment then
          classFlags := (classFlags or DS_AMBIGUOUS_CONTAINMENT) ;        
      end;
      nError := NWDSDefineClass(tempContext,@cpClassName,@classInfo,@buf) ;
      if (nError <> 0) then
        lastError := nError
      else
        result := true ;  
    finally
      ndsFreeContext(tempContext) ;
    end;
  end;

function ndsMoveObject(contextName, objName, newContainerName : string) : boolean ;
  var
    tempContext : TNWDSContextHandle ;
    cpObjName,
    cpDestName  : TRetBuff ;
  begin
    result := false ;
    if (@NWDSMoveObject = nil) then
      @NWDSMoveObject := getProcAddress(hNWNet,'NWDSMoveObject') ;
    if (@NWDSMoveObject = nil) then
      exit ;
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      strPCopy(cpObjName,objName) ;
      strPCopy(cpDestName,newContainerName) ;
      nError := NWDSMoveObject(tempContext,@cpObjName,@cpDestName,@cpObjName) ;
      if (nError <> 0) then
        lastError := nError
      else
        result := true ;  
    finally
      ndsFreeContext(tempContext) ;
    end;   
  end;      
    
function ndsDefineAttr(contextName, attrName : string ; attrDef : TNWDSAttrDef) : boolean ;
  var
    cpAttrName  : array[0..(max_asn1_name-1)] of char ;
    tempContext : TNWDSContextHandle ;
    attrInfo    : Attr_Info_T ;
  begin
    result := false ;
    if (@NWDSDefineAttr = nil) then
      @NWDSDefineAttr := getProcAddress(hNWNet,'NWDSDefineAttr') ;
    if (@NWDSDefineAttr = nil) then
      exit ;
    strPCopy(cpAttrName,attrName) ;  
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
    
      with attrInfo do begin
        attrSyntaxID  := ord(attrDef.syntaxType) ;
        attrFlags     := 0 ;
        if attrDef.attrFlags.singleValue then
          attrFlags := (attrFlags or DS_SINGLE_VALUED_ATTR) ;
        if attrDef.attrFlags.sized then
          attrFlags := (attrFlags or DS_SIZED_ATTR) ;
        if attrDef.attrFlags.nonRemovable then
          attrFlags := (attrFlags or DS_NONREMOVABLE_ATTR) ;
        if attrDef.attrFlags.readOnly then
          attrFlags := (attrFlags or DS_READ_ONLY_ATTR) ;
        if attrDef.attrFlags.hidden then
          attrFlags := (attrFlags or DS_HIDDEN_ATTR) ;
        if attrDef.attrFlags.stringType then
          attrFlags := (attrFlags or DS_STRING_ATTR) ;
        if attrDef.attrFlags.syncImmediate then
          attrFlags := (attrFlags or DS_SYNC_IMMEDIATE) ;    
      end ;  
      nError := NWDSDefineAttr(tempContext,@cpAttrName,@attrInfo) ;
      if (nError <> 0) then
        lastError := nError
      else
        result := true ;  
    finally
      ndsFreeContext(tempContext) ;
    end;    
  end;

  
function ndsReadAttr(contextName,
                     objName,
                     attrName     : string ;
                     syntaxType   : TNWDSSynTypes ;
                     pAttrValue   : pointer) : boolean ;
  {read any NDS object attribute}                   
  var
    iteration   : TNWSequence ;
    tempContext : TNWDSContextHandle ;
    cpAttrName  : TNWDSAttrName ;
    cpObject    : TNDSName ;
    pInBuf,
    pBuf        : pBuf_T ;
  begin
    result    := false ;
    iteration := NO_MORE_ITERATIONS ;
    if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @pInBuf) <> 0) then
      exit ;
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      try
        if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @pBuf) <> 0) then
          exit ;
        try
          strPCopy(cpObject,objName) ;
          if (NWDSInitBuf(tempContext, DSV_READ, pInBuf) <> 0) then
            exit ;
          {add attribute name to input buffer}
          strPCopy(cpAttrName,attrName) ;
          nError := NWDSPutAttrName(tempContext,pInBuf,@cpAttrName) ;
          if (nError <> 0) then
            begin
              lastError := nError ;
              exit ;
            end;
          {read object, fill up the output buffer}
          while true do begin
            nError := NWDSRead(tempcontext,
                               @cpObject,
                               ord(DS_ATTRIBUTE_VALUES),
                               byteBool(false),
                               pInBuf,
                               @iteration,
                               pBuf) ;
            if (nError <> 0) then
              begin
                lastError := nError ;
                break ;
              end;
            if _ndsGetBufValue(tempContext,
                               pBuf,
                               attrName,
                               pAttrValue) then
            result := true ;
            if (iteration = NO_MORE_ITERATIONS) then
              break ;
          end;
        finally
          NWDSFreeBuf(pBuf) ;
        end;
      finally
        NWDSFreeBuf(pInBuf) ;
      end;
    finally
      ndsFreeContext(tempContext) ;
    end;  
  end;

function ndsWriteAttr(contextName,
                      objName,
                      attrName     : string ;
                      syntaxType   : TNWDSSynTypes ;
                      pAttrValue   : pointer) : boolean ;
  {change any nds object attribute value}
  var
    tempContext : TNWDSContextHandle ;
    cpAttrName  : TNWDSAttrName ;
    cpObjName   : TNDSName ;
    pBuf        : pBuf_T ;
  begin
    result := false ;
    if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @pBuf) <> 0) then
      exit;
    try
      strPCopy(cpObjName,objName) ;
      strPCopy(cpAttrName,attrName) ;
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      if (NWDSInitBuf(tempContext, DSV_MODIFY_ENTRY, pBuf) <> 0) then
        exit ;
      result := _ndsAlterObjAttr(tempContext,
                                 pBuf,
                                 cpObjName,
                                 cpAttrName,
                                 syntaxType,
                                 pAttrValue,
                                 dsaaEdit) ;
    finally
      NDSFreeContext(tempContext) ;
      NWDSFreeBuf(pBuf) ;
    end;
  end;

function ndsAddObjAttrEx(contextName,
                         objName,
                         attrName     : string ;
                         syntaxType   : TNWDSSynTypes ;
                         pAttrValue   : pointer) : boolean ;
  {add a new nds object (any type) attribute & value}
  var
    tempContext : TNWDSContextHandle ;
    cpAttrName  : TNWDSAttrName ;
    cpObjName   : TNDSName ;
    pBuf        : pBuf_T ;
  begin
    result := false ;
    if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @pBuf) <> 0) then
      exit;
    try
      strPCopy(cpObjName,objName) ;
      strPCopy(cpAttrName,attrName) ;
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      if (NWDSInitBuf(tempContext, DSV_ADD_ENTRY, pBuf) <> 0) then
         exit ;
      result := _ndsAlterObjAttr(tempContext,
                                 pBuf,
                                 cpObjName,
                                 cpAttrName,
                                 syntaxType,
                                 pAttrValue,
                                 dsaaAdd) ;
    finally
      ndsFreeContext(tempContext) ;
      NWDSFreeBuf(pBuf) ;
    end;
  end;
  
function ndsGetObjAttrList(contextName, objName : string) : TStringList ;
  var
    i,
    nCount      : integer ;
    iteration   : TNWSequence ;
    tempContext : TNWDSContextHandle ;
    cpAttrName  : TNWDSAttrName ;
    cpObject    : TNDSName ;
    attrInfo    : Attr_Info_T ;
    pBuf        : pBuf_T ;
  begin
    result := TStringList.create ;
    
    if (@NWDSGetAttrDef = nil) then
      @NWDSGetAttrDef := getProcAddress(hNWNet,'NWDSGetAttrDef') ;
    if (@NWDSGetAttrDef = nil) then
      exit ;
                                                
    if (@NWDSReadAttrDef = nil) then
      @NWDSReadAttrDef := getProcAddress(hNWNet,'NWDSReadAttrDef') ;
    if (@NWDSReadAttrDef = nil) then
      exit ;

    strPCopy(cpObject,objName) ;
    iteration := NO_MORE_ITERATIONS ;
    if (NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @pBuf) <> 0) then
      exit ;
    try
      if (length(contextName) > 0) then
        begin
          tempContext := ndsGetContextHandle ;
          if (not NDSSetContextName(tempContext,contextName)) then
            exit ;
        end
      else
        tempContext := NWDSDuplicateContext(nwContext) ;
      try  
        while true do begin
          nError := NWDSReadAttrDef(tempContext,
                                    DS_ATTR_DEF_NAMES,
                                    nBool8(true),
                                    nil,
                                    @iteration,
                                    pBuf);
          if (nError <> 0) then
            begin
              if (result.count = 0) then
                lastError := nError ;
              break ;
            end
          else  
            begin
              if (NWDSGetAttrCount(tempContext,pBuf,@nCount) = 0) then
                for i := 0 to nCount do 
                  if (NWDSGetAttrDef(tempContext,pBuf,@cpAttrName,@attrInfo) = 0) then
                    result.addObject(strPas(cpAttrName),
                                     TObject(attrInfo.attrSyntaxID)) ;
            end;
          if (iteration = NO_MORE_ITERATIONS) then
            break ;
        end;
      finally
        ndsFreeContext(tempContext) ;
      end;
    finally
      NWDSFreeBuf(pBuf) ;
    end;  
  end;


function ndsReadOctetAttr(contextName, objName, attrName : string) :
string ;
  var
   tstr : string;
    octdata : octet_string_t ;
    buf     : array[0..255] of byte;
    looper : integer;
  begin
   fillchar(buf, sizeof(buf), #0);
   if ndsreadattr(contextname,objname,attrname,SYN_OCTET_STRING,@buf) then
     begin
      move(buf,octdata,sizeof(octdata));
      move(octdata.data^, buf, octdata.size);
      tstr := '';
      for looper := 0 to octdata.size - 1 do
       tstr := tstr + inttohex(integer(buf[looper]), 2);
      result := tstr;
     end;
  end;


function ndsWriteOctetAttr(contextName, objName, attrName, value : string) : boolean ;
  var
    octdata : octet_string_t ;
    cptemp  : PChar ;
  begin
    cptemp := strAlloc(length(value)) ;
    strPCopy(cptemp,value) ;
    with octdata do begin
      size := length(value) ;
      data := @cptemp ;
    end;
    result := ndsWriteAttr(contextName,objName,attrName,SYN_OCTET_STRING,@octData) ;
  end;
 
function decodeACLRights(objectACL : TNWDSObjectACL) : string ;
  var
    privileges : nuint32 ;
    attrName   : string ;  
  begin
    result     := '------' ;
    attrName   := strPas(PChar(objectACL.protectedAttrName^)) ;
    privileges := (objectACL.privileges) ;
    if (attrName = '[Entry Rights]') then
      begin
        if ((privileges and NDS_ENTRY_BROWSE) > 0) then
          result[1] := 'B' ;
        if ((privileges and NDS_ENTRY_ADD) > 0) then
          result[2] := 'A' ;
        if ((privileges and NDS_ENTRY_DELETE) > 0) then
          result[3] := 'D' ;
        if ((privileges and NDS_ENTRY_RENAME) > 0) then
          result[4] := 'R' ;
        if ((privileges and NDS_ENTRY_SUPERVISOR) > 0) then
          result[5] := 'S' ;
        result[6] := ' ' ;  
      end                           
    else if (attrName = '[SMS Rights]') then
      begin
        if ((privileges and NDS_SMS_SCAN) > 0) then
          result[1] := 'S' ;           
        if ((privileges and NDS_SMS_BACKUP) > 0) then
          result[2] := 'B' ;           
        if ((privileges and NDS_SMS_RESTORE) > 0) then
          result[3] := 'R' ;           
        if ((privileges and NDS_SMS_RENAME) > 0) then   
          result[4] := 'C' ;
        if ((privileges and NDS_SMS_DELETE) > 0) then
          result[5] := 'D' ;
        if ((privileges and NDS_SMS_ADMIN) > 0) then
          result[6] := 'A' ;           
      end                     
    else 
      begin
        if ((privileges and NDS_ATTR_COMPARE) > 0) then  
          result[1] := 'C' ;
        if ((privileges and NDS_ATTR_READ) > 0) then  
          result[2] := 'R' ;
        if ((privileges and NDS_ATTR_WRITE) > 0) then  
          result[3] := 'W' ;
        if ((privileges and NDS_ATTR_SELF) > 0) then  
          result[4] := 'A' ;
        if ((privileges and NDS_ATTR_SUPERVISOR) > 0) then  
          result[5] := 'S' ;
        result[6] := ' ' ;  
      end;
  end;  

procedure encodeACLRights(var objectACL : TNWDSObjectACL ; rightsList : string)  ;
  var           
    privs    : longint ;
    attrName : string ;
  begin
    privs      := 0 ;
    attrName   := upperCase(strPas(PChar(objectACL.protectedAttrName))) ;
    rightsList := upperCase(rightsList) ;
    if (attrName = '[ENTRY RIGHTS]') then
      begin
        if (pos('B',rightsList) > 0) then
          privs := (privs or NDS_ENTRY_BROWSE) ;
        if (pos('A',rightsList) > 0) then
          privs := (privs or NDS_ENTRY_ADD) ;
        if (pos('D',rightsList) > 0) then
          privs := (privs or NDS_ENTRY_DELETE) ;
        if (pos('R',rightsList) > 0) then
          privs := (privs or NDS_ENTRY_RENAME) ;
        if (pos('S',rightsList) > 0) then
          privs := (privs or NDS_ENTRY_SUPERVISOR) ;
      end
    else if (attrName = '[SMS RIGHTS]') then
      begin
        if (pos('S',rightsList) > 0) then
          privs := (privs or NDS_SMS_SCAN) ;
        if (pos('B',rightsList) > 0) then
          privs := (privs or NDS_SMS_BACKUP) ;
        if (pos('R',rightsList) > 0) then
          privs := (privs or NDS_SMS_RESTORE) ;
        if (pos('C',rightsList) > 0) then
          privs := (privs or NDS_SMS_RENAME) ;
        if (pos('D',rightsList) > 0) then
          privs := (privs or NDS_SMS_DELETE) ;
        if (pos('A',rightsList) > 0) then
          privs := (privs or NDS_SMS_ADMIN) ;
      end
    else
      begin
        if (pos('C',rightsList) > 0) then
          privs := (privs or NDS_ATTR_COMPARE) ;
        if (pos('R',rightsList) > 0) then
          privs := (privs or NDS_ATTR_READ) ;
        if (pos('W',rightsList) > 0) then
          privs := (privs or NDS_ATTR_WRITE) ;
        if (pos('A',rightsList) > 0) then
          privs := (privs or NDS_ATTR_SELF) ;
        if (pos('S',rightsList) > 0) then
          privs := (privs or NDS_ATTR_SUPERVISOR) ;
      end;
    {write privs back to record struct}  
    objectACL.privileges := privs ;          
  end;                 

function ndsWriteObjectACL(contextName, objName, attrName : string ; rightsList : string) : boolean ;
  var
    cpObjName   : TNDSName ;
    cpAttrName  : TNWDSAttrName ;
    objectACL   : TNWDSObjectACL ;
  begin
    strPCopy(cpObjName,objName) ;
    strPCopy(cpAttrName,attrName) ;
    objectACL.protectedAttrName := @cpAttrName ;
    objectACL.subjectName       := @cpObjName ;
    encodeACLRights(objectACL,rightsList) ;
    result := ndsWriteAttr(contextName, objName, 'ACL', SYN_OBJECT_ACL, @objectACL) ;
  end;

  
function ndsWriteTrusteeACL(contextName, objName, trustee, attrName, rightsList : string) : boolean ;
  {thanks to paul steele!}
  var
    cpTrustee   : TNDSName;
    cpAttrName  : TNWDSAttrName ;
    objectACL   : TNWDSObjectACL ;
  begin
    strPCopy(cpTrustee,trustee);
    strPCopy(cpAttrName,attrName) ;
    objectACL.subjectName       := @cpTrustee ;
    objectACL.protectedAttrName := @cpAttrName ;
    encodeACLRights(objectACL,rightsList) ;
    result := ndsWriteAttr(contextName, objName, 'ACL', SYN_OBJECT_ACL, @objectACL) ;
  end;


function ndsSetReplicaServer(nServer : TNWConnHandle) : boolean ;
  { force replica server, for sync issues }
  begin
    result := false ;
    if (@NWDSSetContext = nil) then
      exit ;
    if (nServer = 0) then
      nServer := getPrimaryServerID ;  
    
    nError := NWDSSetContext(nwContext,
                             DCK_LAST_CONNECTION,
                             @nServer) ;
    if (nError <> 0) then
      lastError := nError
    else 
      result := true ;
  end;

function ndsRemoveEMailAddress(contextName, objName, emailAddress : string) : boolean ;
var
  addRec  : EMail_Address_T ;
  addName : TRetBuff ;
begin
  addRec.emailType := -1 ;
  strPCopy(addName,emailAddress) ;
  addRec.emailAddress := @addName ;
  result := ndsRemoveFromMultiAttr(contextName, objName, dsaEMailAddress,
@addRec) ;
end;

function ndsAddEMailAddress(contextName, objName, emailAddress : string) : boolean ;
var
  addRec  : EMail_Address_T ;
  addName : TRetBuff ;
begin
  addRec.emailType := -1 ; // 12/2000:  was 0
  strPCopy(addName,emailAddress) ;
  addRec.emailAddress := @addName ;
  result := ndsWriteAttr(contextName,objName,'EMail Address',SYN_EMAIL_ADDRESS,@addRec) ;
end;

function ndsGetEMailAddress(contextName, objName : string) : TStringList ;
var
  nloop    : integer ;
  tempList : TList ;
begin
  result   := TStringList.create ;
  tempList := TList.create ;
  try
    if ndsGetMultiAttr(contextName,objName,dsaEMailAddress,tempList) then
      for nloop := 0 to (tempList.count -1) do 
        result.add(TNWDSEMailInfo(tempList[nloop]^).eMailAddress) ;
  finally
    tempList.free ;
  end;      
end;


function ndsClearContextFlags(flags : longint) : boolean ; 
var 
  oldFlags : nuint32 ; 
begin 
  result := false ; 
  if (@NWDSGetContext = nil) or (@NWDSSetContext = nil) then 
    exit ; 
  NWDSGetContext(nwContext,DCK_FLAGS,@oldFlags) ; 
  flags := (oldFlags and not flags) ; 
  nError := NWDSSetContext(nwContext,DCK_FLAGS,@flags) ; 
  nError := NWDSSetContext(wrkContext,DCK_FLAGS,@flags) ; 
  if (nError <> 0) then 
    lastError := nError 
  else 
    result := true ; 
end; 
  

function ndsClearUserContextFlags(var inContext : TNWDSContextHandle ;flags : longint) : boolean ; 
var 
  oldFlags : nuint32 ; 
begin 
  result := false ; 
  if (@NWDSGetContext = nil) or (@NWDSSetContext = nil) then 
    exit ; 
  NWDSGetContext(inContext,DCK_FLAGS,@oldFlags) ; 
  flags := (oldFlags and not flags) ; 
  nError := NWDSSetContext(inContext,DCK_FLAGS,@flags) ; 
  if (nError <> 0) then 
    lastError := nError 
  else 
    result := true ; 
end; 
  
  
end.
