unit nwqlist;

interface

uses
  SysUtils, 
  WinTypes, 
  WinProcs, 
  Messages, 
  Classes, 
  Graphics, 
  Controls,
  Forms, 
  Dialogs, 
  StdCtrls,
  nwBase,
  nwlib,
  nwprint ;

{$IFDEF Ver110}  
  {$ObjExportAll On}
{$ENDIF}

type
  TNWQueueJobDetails = class(TPersistent)
  private
    FJobPosition    : word    ;   
    FWorkstationID  : longint ;   
    FEntryDateTime,
    FExecDateTime   : TDateTime ; 
    FOwnerName,
    FServerName,
    FJobFileName,
    FJobDescription : string  ;   
  published
    property OwnerName       : string     read FOwnerName      write FOwnerName      stored false ;
    property QueueServerName : string     read FServerName     write FServerName     stored false ;
    property JobFileName     : string     read FJobFileName    write FJobFileName    stored false ;
    property JobDescription  : string     read FJobDescription write FJobDescription stored false ;
    property WorkstationID   : longint    read FWorkstationID  write FWorkstationID  stored false ;
    property EntryDateTime   : TDateTime  read FEntryDateTime  write FEntryDateTime  stored false ;
    property ExecDateTime    : TDateTime  read FExecDateTime   write FExecDateTime   stored false ;
    property JobPosition     : word       read FJobPosition    write FJobPosition    stored false ;
  end;
  
  TNWQueueJobListBox = class(TListBox)
  private
    FQueueName    : string  ;
    FQueueJobInfo : TNWQueueJobDetails ;
    FNWBase       : TNWBase ;
    procedure _setNWBase(value : TNWBase) ;
    procedure _setQueueName(value : string) ;
    function  _getJobID : longint ;
    procedure _populate ;
  protected 
    procedure Notification(AComponent: TComponent;
                           Operation: TOperation); override;
    procedure NWMBaseServerChange(var Message : TMessage) ; message NWM_BASESERVERCHANGE ;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure loaded ; override ;                       
  public
    constructor create(AOwner : TComponent) ; override ;
    destructor destroy ; override ;  
    property JobInfo : TNWQueueJobDetails read FQueueJobInfo write FQueueJobInfo stored false ;
  published   
    property NWBase        : TNWBase     read FNWBase     write _setNWBase ;
    property QueueName     : string      read FQueueName  write _setQueueName ;
    property JobID         : longint     read _getJobID   stored false ;
  end;


implementation

{************************* Component Implementation ****************************}  
constructor TNWQueueJobListBox.create(AOwner : TComponent) ; 
  begin
    inherited create(AOwner) ;
    jobInfo := TNWQueueJobDetails.create ;
  end;
  
destructor TNWQueueJobListBox.destroy ; 
  begin
    jobInfo.free ;
    inherited destroy ;
  end;
  
procedure TNWQueueJobListBox.Notification(AComponent: TComponent;
                                      Operation: TOperation);
  begin
    inherited Notification(AComponent, Operation);
    if (Operation = opRemove) then
      begin
        if (NWBase <> nil) and (AComponent = NWBase) then
          NWBase := nil ;
      end;
  end;

procedure TNWQueueJobListBox.loaded ;
  begin
    inherited loaded ;
    _populate ;  
  end;

procedure TNWQueueJobListBox.WMLButtonDown(var Message: TWMLButtonDown);
  var
    queueJobInfo : TNWQueueJobInfo ;
  begin
    inherited ;                      
    {fill request record}
    if (items.count < 1) or (FNWBase = nil) then
      exit ;
    with queueJobInfo do begin
      nServer := FNWBase.serverHandle ;
      cQueue  := self.queueName ;
      jobID   := self.jobID ;
    end;
    if getQueueJobInfo(queueJobInfo) then
      with jobInfo do begin
        ownerName       := queueJobInfo.ownerName ;
        queueServerName := queueJobInfo.queueServerName ;
        jobFileName     := queueJobInfo.jobFileName ;
        jobDescription  := queueJobInfo.jobDescription ;
        workstationID   := queueJobInfo.workstationID  ;
        entryDateTime   := queueJobInfo.entryDateTime  ;
        execDateTime    := queueJobInfo.execDateTime   ;
        jobPosition     := queueJobInfo.jobPosition    ;
      end;
  end;  
    

procedure TNWQueueJobListBox._populate ;
  {populate items list}
  begin
    if ((FNWBase = nil) or (FQueueName = '')) or
       (csLoading in componentState) then
     exit ;  
    with items do 
      try
        beginUpdate ;
        clear ;
        addStrings(FNWBase.getQJobList(FQueueName)) ;
      finally   
        endUpdate ;  
      end;    
  end;  

{*********************** Messaging Implementation **************************}  
procedure TNWQueueJobListBox.NWMBaseServerChange(var Message : TMessage) ; 
  begin
    _populate ;
  end;

{*********************** Property Write Implementation *************************}  

procedure TNWQueueJobListBox._setNWBase(value : TNWBase) ;
  begin
    if (value <> FNWBase) then
      FNWBase := value ;
    _populate ;
  end;

procedure TNWQueueJobListBox._setQueueName(value : string) ;
  begin
    FQueueName := value ;
    _populate ;
  end;

function TNWQueueJobListBox._getJobID : longint ;
  begin
    result := 0 ;
    if (items.count > 0) and (itemIndex > -1) then
      result := longint(items.objects[itemIndex]) ;
  end ;
  
end.
 