unit nwtreevw;

interface

uses
  SysUtils, 
  WinTypes, 
  WinProcs, 
  Messages, 
  Classes, 
  Graphics, 
  Controls,
  ExtCtrls,
  Forms, 
  Dialogs, 
  StdCtrls,
  comCtrls,
  nwBase,
  nwTools,
  nwLib,
  nwServer,
  nwNDS,
  nwPrint ;

{$IFDEF Ver110}  
  {$ObjExportAll On}
{$ENDIF}

type
  TNWDSObjSet = set of TNWDSObjType ;

type
  TNWTreeView = class(TCustomTreeView)
  private
    FNWBase        : TNWBase ;
    FShowObjFilter : TNWDSObjSet ;
    FObjType       : TNWObjListType ;
    FTreeExpand,
    FOthersExpand,
    FMembersExpand,
    FDirectoryExpand,
    FFileExpand,
    FUserExpand,
    FGroupExpand,
    FPrintServerExpand,
    FPrinterExpand,
    FPrintQueueExpand,
    FPrintQueueJobExpand,
    FServerExpand,
    FVolumeExpand,
    FOrgExpand,
    FOrgUnitExpand : TNotifyEvent ;
    procedure _populate ;
    procedure _setNWBase(value : TNWBase) ;
    procedure _setObjType(value : TNWObjListType) ;
    procedure _setObjFilter(value : TNWDSObjSet) ;
    function  _getText : string ;
  protected        
    procedure Notification(AComponent: TComponent;
                           Operation: TOperation); override;
    procedure loaded ; override ;                       
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN ;
  public    
    function  getFullDN(treeItem : TTreeNode) : string ;
    constructor create(AOwner : TComponent) ; override ;
    property ShowObjFilter : TNWDSObjSet    read FShowObjFilter write _setObjFilter ; {moved out of published -- too big}
  published
    property ShowButtons;
    property BorderStyle;
    property DragCursor;
    property ShowLines;
    property ShowRoot;
    property ReadOnly;
    {$IFDEF VER100}
    property RightClickSelect;
    {$ENDIF}
    property DragMode;
    property HideSelection;
    property Indent;
    property Items;
    property OnEditing;
    property OnEdited;
    property OnExpanding;
    property OnExpanded;
    property OnCollapsing;
    property OnCompare;
    property OnCollapsed;
    property OnChanging;
    property OnChange;
    property OnDeletion;
    property OnGetImageIndex;
    property OnGetSelectedIndex;
    property Align;
    property Enabled;
    property Font;
    property Color;
    property ParentColor default False;
    property ParentCtl3D;
    property Ctl3D;
    property SortType;
    property TabOrder;
    property TabStop default True;
    property Visible;
    property OnClick;
    property OnEnter;
    property OnExit;
    property OnDragDrop;
    property OnDragOver;
    property OnStartDrag;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnDblClick;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property PopupMenu;
    property ParentFont;
    property ParentShowHint;
    property ShowHint;
    property Images;
    property StateImages;
    property OnExpandPrinter       : TNotifyEvent read FPrinterExpand       write FPrinterExpand  ;
    property OnExpandPrintQueue    : TNotifyEvent read FPrintQueueExpand    write FPrintQueueExpand  ;
    property OnExpandPrintQueueJob : TNotifyEvent read FPrintQueueJobExpand write FPrintQueueJobExpand ;
    property OnExpandPrintServer   : TNotifyEvent read FPrintServerExpand   write FPrintServerExpand ;
    property OnExpandDirectory     : TNotifyEvent read FDirectoryExpand     write FDirectoryExpand  ;
    property OnExpandFile          : TNotifyEvent read FFileExpand          write FFileExpand ;
    property OnExpandUser          : TNotifyEvent read FUserExpand          write FUserExpand ;
    property OnExpandGroup         : TNotifyEvent read FGroupExpand         write FGroupExpand ;
    property OnExpandOrg           : TNotifyEvent read FOrgExpand           write FOrgExpand   ;
    property OnExpandOrgUnit       : TNotifyEvent read FOrgUnitExpand       write FOrgUnitExpand ;
    property OnExpandMembers       : TNotifyEvent read FMembersExpand       write FMembersExpand ;
    property OnExpandOthers        : TNotifyEvent read FOthersExpand        write FOthersExpand ;
    property OnExpandTree          : TNotifyEvent read FTreeExpand          write FTreeExpand   ;
    property OnExpandVolume        : TNotifyEvent read FVolumeExpand        write FVolumeExpand ;
    property NWBase        : TNWBase        read FNWBase        write _setNWBase ;
    property ShowObjType   : TNWObjListType read FObjType       write _setObjType default nwlNone ;
    property Text          : string         read _getText ;
  end;

implementation
                            
{************************* Component Implementation ****************************}  

constructor TNWTreeView.create(AOwner : TComponent) ; 
  var
    i : integer ;
  begin
    inherited create(AOwner) ;
    for i := ord(low(TNWDSObjType)) to ord(high(TNWDSObjType)) do
      include(FShowObjFilter,TNWDSObjType(i)) ;
  end;

procedure TNWTreeView.Notification(AComponent: TComponent;
                                      Operation: TOperation);
  begin
    inherited Notification(AComponent, Operation);
    if (Operation = opRemove) then
      begin
        if (NWBase <> nil) and (AComponent = NWBase) then
          NWBase := nil ;
      end;
  end;

procedure TNWTreeView.loaded ;
  begin
    inherited loaded ;
    {fill 'er up}  
    _populate ;  
  end;  

procedure TNWTreeView.WMLButtonDown(var Message: TWMLButtonDown);
  var
    i           : integer ;
    ttList      : TList ;
    fileList,  
    tempList    : TStringList ;
    serverInfo  : TNWServerInfo ;
    expandEvent : TNotifyEvent ;
    cObjName,
    ctemp,
    cDN         : string ;
  begin
    expandEvent := nil ;
    inherited ;
    if (not selected.expanded) and (showObjType in [nwlNDSTree,nwlNDSObjList]) then
      try
        items.beginUpdate ;
        if selected.hasChildren then
          selected.deleteChildren ;
        cDN := getfullDN(selected) ;
        case TNWDSObjType(selected.data) of
          dsoTree :
            begin
              tempList := ndsList(selected.text,'') ;
              expandEvent := FTreeExpand ;
            end;  
          dsoOrganization :
            begin
              tempList := ndsList('',cDN) ;
              expandEvent := FOrgExpand ;
            end;  
          dsoOrganizationalUnit :
            begin
              tempList := ndsList('',cDN) ;
              expandEvent := FOrgUnitExpand ;
            end;
          dsoGroup :     
            begin             
              tempList := ndsGetGroupMembers('',cDN) ;
              expandEvent := FGroupExpand ;
            end; 
          dsoQueueJob :               {expand queue job}  
            begin
              tempList := TStringList.create ;
              expandEvent := FPrintQueueJobExpand ;
            end;
          dsoQueue,dsoBinderyQueue :  {show queue jobs}
             begin
               tempList := TStringList.create ;
               getQueueJobList(0,cDN,tempList) ;
               for i := 0 to (tempList.count -1) do
                 tempList.objects[i] := TObject(dsoQueueJob) ;
               expandEvent := FPrintQueueExpand ;
             end; 
          dsoPrinter :                {show queues}
            begin
              tempList := TStringList.create ;
              ttList := TList.create ;
              try
                if ndsGetMultiAttr('',cDN, dsaQueue, ttList) then
                  for i := 0 to (ttList.count-1) do
                    tempList.addObject(strPas(PChar(ttList[i]^)),TObject(dsoQueue)) ;
              finally
                ttList.free ;
              end;
              expandEvent := FPrinterExpand ;
            end;  
          dsoPrintServer :            {show print server host device}    
            begin
              tempList := TStringList.create ;
              if ndsGetStringAttr('',cDN,dsaHostDevice,ctemp) then
                tempList.addObject(ctemp,TObject(ndsGetObjType('',ctemp))) ;
              expandEvent := FPrintServerExpand ;  
            end;
          dsoServer,dsoNCPServer :    {show server info}
            begin
              tempList := TStringList.create ;
              {if getServerStats(openConnByName(cDN,true,true),serverInfo) then <-safer/slower}
              if getServerStats(getServerHandle(ndsGetTypelessName(selected.text)),serverInfo) then
                 tempList.addObject('Netware Version: ' + serverInfo.version,TObject(0)) ;
              expandEvent := FServerExpand ;   
            end;  
          dsoVolume :                 {show volume's dirs/files}  
            begin
              if ndsGetStringAttr('',cDN,dsaHostResourceName,cObjname) then
                begin
                  ctemp := getServerName(ndsAuthenticateObject('',cDN)) ;
                  if (ctemp <> '') then
                    begin
                      tempList := getVolDirList(ctemp + '/' + cObjName + ':\*') ;
                      for i := 0 to (tempList.count-1) do
                        tempList.objects[i] := TObject(dsoDirectory) ;
                      
                      fileList := getVolFileList(ctemp + '/' + cObjName + ':\*.*') ;
                      for i := 0 to (fileList.count-1) do 
                        tempList.addObject(fileList[i],TObject(dsoFile)) ;
                      fileList.free ;  
                    end
                  else
                    tempList := TStringList.create ;
                end
              else
                tempList := TStringList.create ;
              expandEvent := FVolumeExpand ;  
            end;
          dsoDirectory :              {show directory files}  
            begin
              tempList := TStringList.create ;
              expandEvent := FDirectoryExpand ;
            end;
          dsoFile      :              {show file details}
            begin
              tempList := TStringList.create ;
              expandEvent := FFileExpand ;    
            end;  
          dsoUser :                   {show user information}
            begin
              tempList := TStringList.create ;
              if ndsGetStringAttr('', cDN, dsaFullName,ctemp) then
                tempList.add('Full Name: ' + ctemp) ;
              ttList := TList.create ;  
              try  {get email addresses}
                if ndsGetMultiAttr('', cDN, dsaEmailAddress, ttList) then
                 for i := 0 to (ttList.count-1) do
                   tempList.add('E-Mail: ' + strPas(TNWDSEMailInfo(ttList[i]^).emailAddress)) ;
              finally
                ttList.free ;
              end;
              ttList := TList.create ;
              try  {get telephone numbers}
                if ndsGetMultiAttr('',cDN, dsaTelephoneNumber, ttList) then
                  for i := 0 to (ttList.count-1) do
                    tempList.add('Telephone: ' + strPas(ttList[i])) ;
              finally
                ttList.free ;
              end;
              expandEvent := FUserExpand ;
            end;  
          else   
            tempList := TStringList.create ;   
        end;
        
        {add new items as children of selected node}
        try
          for i := 0 to (tempList.count -1) do  begin
          
            if (TNWDSObjType(tempList.objects[i]) in FShowObjFilter) then
              with items.addChildObject(selected,
                  strTran(tempList[i],char(VK_TAB),space(3)),
                  tempList.objects[i]) do begin
                imageIndex    := longint(tempList.objects[i]);
                selectedIndex := imageIndex ;
              end;      
          end;
        finally
          tempList.free ;
        end;
      finally
        items.endupdate ;    
      end;
      
      {--- run 'after expand' event --- }  
      if {selected.hasChildren and} (@expandEvent <> nil) then
        expandEvent(self) ;
  end;

  
{************************ Property Read Implementation *************************}  
function TNWTreeView._getText : string ;
  begin
    result := getFullDN(selected) ;
  end;
  
{*********************** Property Write Implementation *************************}  
procedure TNWTreeView._setNWBase(value : TNWBase) ;
  begin
    if (value <> FNWBase) then
      FNWBase := value ;
    _populate ;
  end;

procedure TNWTreeView._setObjType(value : TNWObjListType) ;
  begin
    if (value <> FObjType) then
      begin
        FObjType := value ;  
        _populate ;
      end;  
  end;

procedure TNWTreeView._setObjFilter(value : TNWDSObjSet) ;
  begin
    FShowObjFilter := value ;
    _populate ;
  end;
  
 
{*************************** Internal Functions ********************************}  

function TNWTreeView.getFullDN(treeItem : TTreeNode) : string ;
  begin
    if (treeItem = nil) then
      exit ;
    result := treeItem.text ;
    if (treeItem.parent <> nil) then
      while true do begin
        if (treeItem.parent <> nil) then
          begin
            treeItem := treeItem.parent ;
            result := result + '.' + treeItem.text ;
          end  
        else
          exit ;  
      end;
  end;
  
procedure TNWTreeView._populate ;
  var
    i        : integer ;
    newNode  : TTreeNode ;
    tempList : TStringList ;
  begin
    if (csLoading in componentState) then
      {nothing}
    else if (showObjType = nwlNone) then
      items.clear 
    else if (FNWBase <> nil) then
      begin
        tempList := FNWBase.getObjectList(showObjType) ;
        with items do try
          beginUpdate ;
          clear ;
          for i := 0 to (tempList.count -1) do begin
            if (TNWDSObjType(tempList.objects[i]) in FShowObjFilter) then
              begin
                newNode := TTreeNode.create(self.items) ;
                with addObject(newNode,tempList[i],tempList.objects[i]) do begin
                  imageIndex    := longint(tempList.objects[i]) ; 
                  selectedIndex := imageIndex ;
                end;  
              end;
          end;
        finally
          endUpdate ;
          tempList.free ;
        end;  
      end;
  end;
 
end.
 