VERSION 2.00
Begin Form BindForm 
   Caption         =   "Bindery Services Test"
   Height          =   4560
   Left            =   930
   LinkMode        =   1  'Source
   LinkTopic       =   "Form1"
   ScaleHeight     =   4155
   ScaleWidth      =   8895
   Top             =   975
   Width           =   9015
   Begin CommandButton CloseButton 
      Caption         =   "&OK"
      Height          =   372
      Left            =   6720
      TabIndex        =   11
      Top             =   3600
      Width           =   1332
   End
   Begin ComboBox ServerNameBox 
      Height          =   288
      Left            =   2400
      Sorted          =   -1  'True
      TabIndex        =   0
      Text            =   "ServerNameBox"
      Top             =   3600
      Width           =   2412
   End
   Begin ListBox BinderyObjList 
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Courier"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   2370
      Left            =   240
      Sorted          =   -1  'True
      TabIndex        =   9
      Top             =   840
      Width           =   8460
   End
   Begin Label Label10 
      Caption         =   "File Server:"
      Height          =   252
      Left            =   1200
      TabIndex        =   10
      Top             =   3600
      Width           =   1092
   End
   Begin Label Label1 
      Caption         =   "Add Props"
      Height          =   252
      Left            =   7560
      TabIndex        =   8
      Top             =   480
      Width           =   972
   End
   Begin Label Label7 
      Caption         =   "Scan"
      Height          =   252
      Left            =   7080
      TabIndex        =   7
      Top             =   480
      Width           =   492
   End
   Begin Label Label9 
      BorderStyle     =   1  'Fixed Single
      Height          =   12
      Left            =   7080
      TabIndex        =   12
      Top             =   360
      Width           =   1452
   End
   Begin Label Label4 
      Caption         =   "Object ID"
      Height          =   252
      Left            =   4920
      TabIndex        =   6
      Top             =   360
      Width           =   852
   End
   Begin Label Label3 
      Caption         =   "Object Type"
      Height          =   252
      Left            =   3120
      TabIndex        =   5
      Top             =   360
      Width           =   1092
   End
   Begin Label Label2 
      Caption         =   "Object Name"
      Height          =   252
      Left            =   312
      TabIndex        =   4
      Top             =   372
      Width           =   1212
   End
   Begin Label Label6 
      Alignment       =   2  'Center
      Caption         =   "Dyn/ Stat"
      Height          =   372
      Left            =   6384
      TabIndex        =   3
      Top             =   252
      Width           =   612
   End
   Begin Label Label5 
      Alignment       =   2  'Center
      Caption         =   "Has Props"
      Height          =   372
      Left            =   5880
      TabIndex        =   2
      Top             =   240
      Width           =   612
   End
   Begin Label Label8 
      Caption         =   "Access Control"
      Height          =   252
      Left            =   7140
      TabIndex        =   1
      Top             =   84
      Width           =   1332
   End
End

Sub CloseButton_Click ()
    Unload BindForm
End Sub

Sub Form_Load ()
    For connID% = 1 To 8
        fileServerName$ = String$(48, 0)
        If (IsConnectionIDInUse(connID%) = 1) Then
            GetFileServerName connID%, fileServerName$
            ServerNameBox.AddItem fileServerName$
        End If
    Next connID%

    'get name of default file server for combo box
    fileServerName$ = GetDefaultFileServerName()
    ServerNameBox.Text = fileServerName$

    Main.MousePointer = 0
End Sub

Sub Form_Unload (Cancel As Integer)
    SetPreferredConnectionID (originalPrefConnID%)
End Sub

Sub ScanBindery ()
    Dim objectType As String * 6

    BinderyObjList.Clear

    oID& = -1   'initialize object ID to -1 for first call to ScanBinderyObject
    Do
        oName$ = String$(48, 0)
        ccode% = ScanBinderyObject("*", OT_WILD, oID&, oName$, oType%, oHasProps%, oFlag%, oSecurity%)
        If (ccode% = SUCCESSFUL) Then
            
            'take all characters of object name up to terminating null
            out$ = Left$(oName$, InStr(oName$, Chr$(0)) - 1)

            'then take first 20 chars
            out$ = Left$(out$, 20)

            'pad with spaces
            out$ = out$ + Space$(22 - Len(out$))
            
            Select Case oType%
                Case OT_USER
                    out$ = out$ + "User            "
                Case OT_USER_GROUP
                    out$ = out$ + "User Group      "
                Case OT_PRINT_QUEUE
                    out$ = out$ + "Print Queue     "
                Case OT_FILE_SERVER
                    out$ = out$ + "File Server     "
                Case OT_JOB_SERVER
                    out$ = out$ + "Job Server      "
                Case OT_GATEWAY
                    out$ = out$ + "Gateway         "
                Case OT_PRINT_SERVER
                    out$ = out$ + "Print Server    "
                Case OT_ARCHIVE_QUEUE
                    out$ = out$ + "Archive Queue   "
                Case OT_ARCHIVE_SERVER
                    out$ = out$ + "Archive Server  "
                Case OT_JOB_QUEUE
                    out$ = out$ + "Job Queue       "
                Case OT_ADMINISTRATION
                    out$ = out$ + "Administration  "
                Case OT_NAS_SNA_GATEWAY
                    out$ = out$ + "NAS SNA Gateway "
                Case OT_NACS
                    out$ = out$ + "NACS            "
                Case OT_REMOTE_BRIDGE_SERVER
                    out$ = out$ + "Rem Bridge Serv "
                Case OT_BRIDGE_SERVER
                    out$ = out$ + "Bridge Server   "
                Case OT_TCPIP_GATEWAY
                    out$ = out$ + "TCP/IP Gateway  "
                Case OT_GATE
                    out$ = out$ + "Gateway         "
                Case OT_TIME_SYNCHRONIZATION_SERVER
                    out$ = out$ + "Time Synch Serv "
                Case OT_ARCHIVE_SRV
                    out$ = out$ + "Archive Server  "
                Case OT_ADVERTISING_PRINT_SERVER
                    out$ = out$ + "Adver Print Srv "
                Case OT_BTRIEVE_VAP_NLM_5XX
                    out$ = out$ + "Btrieve v5.xx   "
                Case OT_SQL_VAP_NLM
                    out$ = out$ + "SQL VAP/NLM     "
                Case OT_XTREE_NETWORK
                    out$ = out$ + "Xtree Net Ver   "
                Case OT_BTRIEVE_VAP_NLM_4XX
                    out$ = out$ + "Btrieve v4.xx   "
                Case OT_APPLETALK_GATEWAY
                    out$ = out$ + "AppleTalk Gatew "
                Case OT_X25_GATEWAY
                    out$ = out$ + "X.25 Gateway    "
                Case OT_WAN_COPY
                    out$ = out$ + "WAN Copy        "
                Case OT_TES_NETWARE_VMS
                    out$ = out$ + "TES-NetWare VMS "
                Case OT_NETWARE_ACCESS_SERVER
                    out$ = out$ + "NW Access Serv  "
                Case OT_PORTABLE_NETWARE
                    out$ = out$ + "Portable NetW   "
                Case OT_COMPAQ_IDA_STATUS_MONITOR
                    out$ = out$ + "Compaq IDA Stat "
                Case OT_NETWARE_386_SERVER
                    out$ = out$ + "NetWare 386 Srv "
                Case OT_CSA_MUX
                    out$ = out$ + "CSA MUX         "
                Case OT_CSA_LCA
                    out$ = out$ + "CSA LCA         "
                Case OT_CSA_CM
                    out$ = out$ + "CSA CM          "
                Case OT_CSA_SMA
                    out$ = out$ + "CSA SMA         "
                Case OT_CSA_DBA
                    out$ = out$ + "CSA DBA         "
                Case OT_CSA_NMA
                    out$ = out$ + "CSA NMA         "
                Case OT_CSA_SSA
                    out$ = out$ + "CSA SSA         "
                Case OT_CSA_STATUS
                    out$ = out$ + "CSA STATUS      "
                Case OT_CSA_APPC
                    out$ = out$ + "CSA APPC        "
                Case OT_SNA_TEST
                    out$ = out$ + "SNA TEST        "
                Case OT_CSA_TRACE
                    out$ = out$ + "CSA TRACE       "
                Case OT_COMMUNICATIONS_EXECUTIVE
                    out$ = out$ + "Comm Executive  "
                Case OT_NNS_DOMAIN
                    out$ = out$ + "NNS Domain      "
                Case OT_NNS_PROFILE
                    out$ = out$ + "NNS Profile     "
                Case OT_NNS_QUEUE
                    out$ = out$ + "NNS Queue       "
                Case OT_WORDPERFECT_NETWORK
                    out$ = out$ + "WordPerfect Net "
                Case Else
                    objectType = Str$(oType%)
                    out$ = out$ + "[" + objectType + "]" + "        "
            End Select

            'format the bindery object ID as 8 hex digits, with leading zeros
            out$ = out$ + String$((8 - Len(Hex$(oID&))), "0") + Hex$(oID&) + "  "

            'does the bindery object have properties?
            If oHasProps% = 0 Then
                out$ = out$ + "N   "
            Else
                out$ = out$ + "Y   "
            End If

            'is the bindery object static or dynamic?
            If oFlag% = 0 Then
                out$ = out$ + "Stat  "
            Else
                out$ = out$ + "Dyn   "
            End If

            'who can scan for the bindery object,
            'and who can add properties?
            Select Case (oSecurity% And &HF)
                Case &H0
                    out$ = out$ + "Any  "   'anyone can scan for the object
                Case &H1
                    out$ = out$ + "Log  "   'any logged user can scan
                Case &H2
                    out$ = out$ + "Obj  "   'only the object can scan for itself
                Case &H3
                    out$ = out$ + "Sup  "   'only the supervisor can scan
                Case &H4
                    out$ = out$ + "OS   "   'only the operating system can scan
            End Select
            
            Select Case (oSecurity% And &HF0)
                Case &H0
                    out$ = out$ + "Any  "   'anyone can add properties to the object
                Case &H10
                    out$ = out$ + "Log  "   'any logged user can add properties
                Case &H20
                    out$ = out$ + "Obj  "   'only the object can add props to itself
                Case &H30
                    out$ = out$ + "Sup  "   'only the supervisor can add props
                Case &H40
                    out$ = out$ + "OS   "   'only the OS can add properties
            End Select
            
            'finally, add one more entry to the list
            'of bindery objects
            BinderyObjList.AddItem out$
        End If
    Loop Until ccode%
End Sub

Sub ServerNameBox_Change ()
    prefServer$ = ServerNameBox.Text
    
    ccode% = GetConnectionID(prefServer$, connID%)
    If (ccode% = SUCCESSFUL) Then
        SetPreferredConnectionID (connID%)  'tell which file server to send
                                            'requests to
        Screen.MousePointer = 11
        ScanBindery                         'then go scan its bindery
        Screen.MousePointer = 0
    Else
        MsgBox "Unable to get connection ID of server " + prefServer$, MB_OK, "Error"
    End If
End Sub

Sub ServerNameBox_Click ()
    ServerNameBox_Change
End Sub

