VERSION 2.00
Begin Form FSE2xForm 
   Caption         =   "File Server Environment v2.x Services Test"
   Height          =   4050
   Left            =   1725
   LinkTopic       =   "Form1"
   ScaleHeight     =   3645
   ScaleWidth      =   5385
   Top             =   1485
   Width           =   5505
   Begin Frame Frame1 
      Caption         =   "Disk Cache Statistics"
      Height          =   1935
      Left            =   120
      TabIndex        =   5
      Top             =   960
      Width           =   5175
      Begin Label CacheHitsLabel 
         Height          =   255
         Left            =   2640
         TabIndex        =   17
         Top             =   1560
         Width           =   1695
      End
      Begin Label CacheWritesLabel 
         Height          =   255
         Left            =   2640
         TabIndex        =   16
         Top             =   1320
         Width           =   1695
      End
      Begin Label CacheReadsLabel 
         Height          =   255
         Left            =   2640
         TabIndex        =   15
         Top             =   1080
         Width           =   1695
      End
      Begin Label DirtyCacheLabel 
         Height          =   255
         Left            =   2640
         TabIndex        =   14
         Top             =   840
         Width           =   1695
      End
      Begin Label CacheSizeLabel 
         Height          =   255
         Left            =   2640
         TabIndex        =   13
         Top             =   600
         Width           =   1695
      End
      Begin Label CacheBuffLabel 
         Height          =   255
         Left            =   2640
         TabIndex        =   12
         Top             =   360
         Width           =   1695
      End
      Begin Label Label8 
         Alignment       =   1  'Right Justify
         Caption         =   "Cache hits:"
         Height          =   255
         Left            =   480
         TabIndex        =   11
         Top             =   1560
         Width           =   1695
      End
      Begin Label Label7 
         Alignment       =   1  'Right Justify
         Caption         =   "Cache writes:"
         Height          =   255
         Left            =   480
         TabIndex        =   10
         Top             =   1320
         Width           =   1695
      End
      Begin Label Label6 
         Alignment       =   1  'Right Justify
         Caption         =   "Cache reads:"
         Height          =   255
         Left            =   480
         TabIndex        =   9
         Top             =   1080
         Width           =   1695
      End
      Begin Label Label5 
         Alignment       =   1  'Right Justify
         Caption         =   "Dirty cache buffers:"
         Height          =   255
         Left            =   480
         TabIndex        =   8
         Top             =   840
         Width           =   1695
      End
      Begin Label Label4 
         Alignment       =   1  'Right Justify
         Caption         =   "Cache buffer size:"
         Height          =   255
         Left            =   480
         TabIndex        =   7
         Top             =   600
         Width           =   1695
      End
      Begin Label Label3 
         Alignment       =   1  'Right Justify
         Caption         =   "Cache buffers:"
         Height          =   255
         Left            =   480
         TabIndex        =   6
         Top             =   360
         Width           =   1695
      End
   End
   Begin CommandButton CancelButton 
      Caption         =   "&Cancel"
      Height          =   375
      Left            =   2880
      TabIndex        =   4
      Top             =   3120
      Width           =   975
   End
   Begin ComboBox ServerNameBox 
      Height          =   300
      Left            =   1680
      TabIndex        =   1
      Top             =   480
      Width           =   2655
   End
   Begin CommandButton OKButton 
      Caption         =   "&OK"
      Height          =   375
      Left            =   1560
      TabIndex        =   0
      Top             =   3120
      Width           =   975
   End
   Begin Label Label2 
      Caption         =   "Select a NetWare 2.x file server:"
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   120
      Width           =   4695
   End
   Begin Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "File Server:"
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   480
      Width           =   1455
   End
End

Sub CancelButton_Click ()
    Unload FSE2xForm
End Sub

Sub Form_Load ()
    Dim fileServerName As String * 48

    fileServerName = GetDefaultFileServerName()
    ServerNameBox.Text = fileServerName
    
    For connID% = 1 To 8
        If (IsConnectionIDInUse(connID%) = 1) Then
            GetFileServerName connID%, fileServerName
            ServerNameBox.AddItem fileServerName
        End If
    Next connID%
End Sub

Sub Form_Unload (Cancel As Integer)
    SetPreferredConnectionID (originalPrefConnID%)
End Sub

Sub OKButton_Click ()
    Dim cacheStats As DISK_CACHE_STATS

    connID% = GetPreferredConnectionID()
    ccode% = CheckConsolePrivileges()
    If (ccode% = SUCCESSFUL) Then
        ccode% = GetDiskCacheStats(connID%, Len(cacheStats), cacheStats)
        If (ccode% <> SUCCESSFUL) Then
            MsgBox "Unable to get disk cache statistics.", MB_OK, "Error"
        Else
            CacheBuffLabel.Caption = Str$(cacheStats.cacheBufferCount)
            CacheSizeLabel.Caption = Str$(cacheStats.cacheBufferSize)
            DirtyCacheLabel.Caption = Str$(cacheStats.dirtyCacheBuffers)
            CacheReadsLabel.Caption = Str$(cacheStats.cacheReadRequests)
            CacheWritesLabel.Caption = Str$(cacheStats.cacheWriteRequests)
            CacheHitsLabel.Caption = Str$(cacheStats.cacheHits)
        End If
    End If
End Sub

Sub ServerNameBox_Change ()
    ccode% = GetConnectionID(ServerNameBox.Text, connID%)
    If (ccode% <> SUCCESSFUL) Then
        MsgBox "Unable to get connection ID", MB_OK, "Error"
    Else
        SetPreferredConnectionID (connID%)
    End If
End Sub

Sub ServerNameBox_Click ()
    ServerNameBox_Change
End Sub

