{$X+,V-,B-}
Program testconn;

{ Testprogram for the nwConn unit / NwTP 0.6 API. (c) 1993, 1995, R.Spronk }

{ Purpose: testing of nwConn calls }

{ Tests the following nwConn functions:

  GetConnectionId
  GetConnectionInformation
  GetConnectionNumber
  GetDefaultConnectionId
  GetFileserverName
  GetInternetAddress
  GetObjectConnectionNumbers
  GetPreferredConnectionId
  GetPrimaryConnectionId
  GetWorkstationNodeAddress
  GetUserAtConnection
}

Uses nwMisc,nwConn;

Procedure Warning(s:string);
begin
writeln(s);
writeln(' ERROR #: $',HexStr(nwConn.Result,2),' (',nwConn.result,')');
writeln;
writeln('...Press <Enter> to Continue..');
readln;
end;

Var myConnNumber:byte;
    myConnId    :byte; { connID of server I'm attached to }
    myPhysNode2:TnodeAddress;
    myObjName   :string;
    myObjType   :word;
    myObjId     :longInt;
    myLoginTime :TnovTime;

    myAddress:TinternetworkAddress;

    nbrOfConn:byte;
    connList :TconnectionList;

    objName  :string;
    objType  :word;
    objId    :LongInt;
    LoginTime:TnovTime;

    connId    :byte;
    serverName:string;
    routeInfo :string;

    t      :byte;
    tempStr:string;

begin

IF GetConnectionNumber(myConnNumber)
 then writeln('Your connection number is:',myConnNumber)
 else warning('!!! The GetConnectionNumber call failed');

IF GetInterNetAddress(myConnNumber,myAddress)
 then begin
      write('Your Netw.:Node:Socket Nbr is: [$');
       for t:=1 to 4 do write(hexStr(myAddress.Net[t],2));
       write(':');
       for t:=1 to 6 do write(HexStr(myAddress.Node[t],2));
      writeln(':',hexstr(myAddress.socket,4),']');
      end
 else warning('!!! GetInterNetAdress failed.');


IF GetWorkstationNodeAddress(myPhysNode2)
  and (myAddress.Node[6]=myPhysNode2[6])
  and (myAddress.Node[5]=myPhysNode2[5])
  and (myAddress.Node[4]=myPhysNode2[4])
 then { ok }
 else begin
      warning('!!! GetStationadress failed');
      write('returned: $');
        for t:=1 to 6 do write(HexStr(myPhysNode2[t],2));
      end;

IF GetConnectionInformation(myConnNumber,
                            myObjName,myObjType,myObjId,myLoginTime)
 then begin
      writeln('You are :',myObjName);
      if myObjType=$1 { OT_USER}
       then writeln(' of object type : USER')
       else writeln(' of object type : $',HexStr(myObjType,4));
      writeln(' with object ID: $',HexStr(myObjId,8));
      NovTime2String(myLoginTime,tempStr);
      writeln(' logged in at ',tempStr);
      end
 else warning('!!! GetConnectionInformation failed.');

if NOT (GetUserAtConnection(myConnNumber,tempStr) and (tempStr=myObjName))
 then warning('!!! GetUserAtConnection (2) failed.');

IF GetObjectConnectionNumbers(myObjName,1 {OT_USER},
                              nbrOfConn,connList)
 then begin
      writeln('User ',myObjName,' has ',nbrOfConn,' active connection(s).');
      t:=nbrOfConn;
      if t>0
       then begin
            t:=1;
            while t<=nbrOfConn
             do begin
                writeln('  at connectionNumber:',connList[t]);
                inc(t);
                end;
            end;
      end
 else warning('!!! GetObjectConnectionNumbers failed.');


writeln;
t:=1;
writeln('ConnNbr Name             LoginTime');
WHILE t<250 { nw 3.x / 2.x  100 }
do begin
   IF GetConnectionInformation(t, objName,objType,objId,LoginTime)
    then begin
         PstrCopy(TempStr,objName,15);
         objName:=TempStr;
         NovTime2String(LoginTime,TempStr);
         writeln(t:4,'    ',objName,'  ',TempStr);
         end
    else if nwConn.result<>$FD { bad_station_number / nbr not in use }
         then warning('!!! GetConnectionInformation failed.');
   inc(t);
   end;

{*********** connection ID's ( server numbers in server table )************ }

{ to which server have we been sending all the above requests? }

routeInfo:='preferred';
GetPreferredConnectionID(ConnId);
 { if set previously, this server has the highest priority. }

if connId=0 { preferred server was not set }
 then begin
      RouteInfo:='default';
      GetDefaultConnectionID(ConnId);
      end;
 { your current default drive is attached to this server }

if connId=0
 then begin
      RouteInfo:='primary';
      GetPrimaryConnectionID(ConnId);
      end;
 { the server your shell initially attached to, used if the default drive
   is a local drive. Lowest priority. }

{ These three calls are also incorporated in the secondary function:
  GetEffectiveConnectionID. }
writeln;
writeln('All requests are routed to the ',RouteInfo,'-server with conn.ID=',connId);

GetFileServerName(connId,{out:} serverName);
GetConnectionID(serverName,{out} t);
if t<>connId
 then warning('!!! GetFileServerName and GetConnectionId report different values.')
 else writeln('Name of the server: ',serverName);

end.
