#
# Adduser.pl
#
# This script demonstrates how to create a user using
# the perl extension PerlWare.
#
# Copyright (c) 1997 Steinar Kleven
#



BEGIN { $| = 1; }
use PerlWare::NDSContext;
use PerlWare::Buf_T;

print "THIS SCRIPT WILL CREATE A USER IN YOUR DEFAULT CONTEXT\n";
print "Please type \"ok\" to continue.\n";

$Val = <STDIN>;
die("You typed: $Val, Aborting..\n") if ($Val !~ /^ok$/i);


$C = new PerlWare::NDSContext;
$Buf = new PerlWare::Buf_T;
die("Could not create objects") if (!$C || !$Buf);

# Handle needed in alot of methods
$NWHandle = $C->GetHandle();


$Result = $C->IsDSAuthenticated();
die("You're not logged on, bailing out!!") if (!$Result);

# Get YOUR username, and add "tmp" to the username
$User = $C->WhoAmI();
die("Error gettig your username, code ". $C->LastErr()) if (!defined($User));

# Add tmp.
$User =~ s/\.{1}/tmp./;
$Surename = "PerlWare-applied";
$Newtlf = "+47-180"; # White pages in Norway
$ObjType = "User";

$Result = $Buf->AllocBuf();
die("Error allocating buffer, code $Result") if ($Result);

$Result = $Buf->InitBuf($NWHandle, "DSV_ADD_ENTRY");
die("Error initiating buffer, code $Result") if ($Result);

# Call PutAttrName and PutAttrVal repeatedly for each type
#  of information about to be entered.  Start with User (Object Class).
#
$Result = $Buf->PutAttrName($NWHandle, "Object Class");
die("PutAttrName error, code $Result") if ($Result);

$Result = $Buf->PutAttrVal($NWHandle, "SYN_CLASS_NAME", $ObjType);
die("PutAttrVal error, code $Result") if ($Result);


# Add information for Surname
$Result = $Buf->PutAttrName($NWHandle, "Surname");
die("PutAttrName error, code $Result") if ($Result);

$Result = $Buf->PutAttrVal($NWHandle, "SYN_CI_STRING", $Surename);
die("PutAttrVal error, code $Result") if ($Result);


# Add information for Telephone Number
$Result = $Buf->PutAttrName($NWHandle, "Telephone Number");
die("PutAttrName error, code $Result") if ($Result);
$Result = $Buf->PutAttrVal($NWHandle, "SYN_TEL_NUMBER", $Newtlf);
die("PutAttrVal error, code $Result") if ($Result);

# Add the user we created in $Buf, the last two params are ignored.
$Iter = $Buf->AddObject($NWHandle, $User, 0, 0);
if (defined($Iter))
{
  print "User created.\n";
  $Status = $C->GenerateObjectKeyPair($UserName, "", 0);
  if ($Status) {print "Could not set password\n";}
  else {print "Password assigned\n";}
# Delete the newly created object
  $C->RemoveObject($User);
}
else
{
  $Err = $Buf->LastErr();
  print "Error $Err adding user\n";
}

__END__

