#
# Adduser.pl
#
# This script demonstrates how to create a user using
# the perl extension PerlWare.
#
# Copyright (c) 1997 Steinar Kleven
#


use PerlWare::NDSContext;
use PerlWare::Buf_T;
use PerlWare::NWServer;

BEGIN { }

print "THIS SCRIPT WILL CREATE A NEW USER IN NDS\n";
print "Please type \"ok\" to continue.\n";

$Val = <STDIN>;
die("You typed: $Val, Aborting..\n") if ($Val !~ /^ok$/i);


# Data for new user. The user resides in the context .RES.AHS.HIST
$HomeServer = "NWBETA1";
$HomeDir = "0\nNWBETA1_SYS.RES.AHS.HIST\nNEWHOME\n";
$HomeVol = "SYS";
$HomePath = "\NEWHOME";
$UserName = "tmpuser.RES.AHS.HIST";
$Surename = "PerlWare-applied";
$Newtlf = "+47-180"; # White pages in Norway
$Group = "TESTGROUP.RES.AHS.HIST"; # Group to add the user to.

$C = new PerlWare::NDSContext;
$Buf = new PerlWare::Buf_T;

# Connect to server where home-directory is going to be.
# NB! All PerlWare::NWServer objects is created without licensing the connection, except
# if we already are licensed.
$Server = new PerlWare::NWServer($HomeServer);
die("No server connection could be made\n") if (!$Server->IsInit());
$Server->Debug(1) if (defined($Server));

# Handle needed in most methods
$NWHandle = $C->GetHandle();

$Result = $C->IsDSAuthenticated();
if (!$Result){die("You're not logged on, bailing out!!")};

$Result = $Server->AuthenticateConn($NWHandle);
if ($Result){die("You can't authenticate to server, bailing out!!")};

# We need to license the connection because we are (behind the scenes) going
# to read some info about the volume to set space restrictions.
$Result = $Server->LicenseConn();
if ($Result)
{
  printf ("Error: %X\n", $Result);
  die("You can't license you connection, bailing out!!");
}

# We'll have to create the home directory before creating the
# user. That's what Novell engineers told me anyway..
$Server->CreateDirectory(0, $HomeVol.":".$HomePath, "ALL");

# Now we shall create the user.
# Note that we have to force PerlWare to talk to the server
# we want to create the home directory on.
# If not we could get involved in syncro problems when setting rights.

$C->SetContext("DCK_LAST_CONNECTION", $Server->GetHandle());
$Flags = $C->GetContext("DCK_FLAGS");
$Flags |= $C->GetConst("DCV_DISALLOW_REFERRALS");
$C->SetContext("DCK_FLAGS", $Flags);

# Now we should be forced to talk to server $Server.

$Result = $Buf->AllocBuf();

$Result = $Buf->InitBuf($NWHandle, "DSV_ADD_ENTRY");


# Call PutAttrName and PutAttrVal repeatedly for each type
#  of information about to be entered.  Start with User (Object Class).
#
$Result = $Buf->PutAttrName($NWHandle, "Object Class");
$Result = $Buf->PutAttrVal($NWHandle, "SYN_CLASS_NAME", "User");

# Add information for Surname
$Result = $Buf->PutAttrName($NWHandle, "Surname");
$Result = $Buf->PutAttrVal($NWHandle, "SYN_CI_STRING", $Surename);

# Maybe we want to add the new user to an existing group.
# Almost at the bottom of the script we add more values
# regarding the group.
$Result = $Buf->PutAttrName($NWHandle, "Group Membership");
$Result = $Buf->PutAttrVal($NWHandle, "SYN_DIST_NAME", $Group);

# Add information for Telephone Number
$Result = $Buf->PutAttrName($NWHandle, "Telephone Number");
$Result = $Buf->PutAttrVal($NWHandle, "SYN_TEL_NUMBER", $Newtlf);

# Add the home directory attribute
$Result = $Buf->PutAttrName($NWHandle, "Home Directory");
$Result = $Buf->PutAttrVal($NWHandle, "SYN_PATH", $HomeDir);

# Add the user we created in $Buf, the last two params are ignored.
$Iter = $Buf->AddObject($NWHandle, $UserName, 0, 0);
print "User added ok\n" if (defined($Iter));
if (defined($Iter))
{
# Now we also have to set the password for the user, we use blank
# password for this demo
   $Status = $C->GenerateObjectKeyPair($UserName, "", 0);
   if ($Status) {print "Could not set password\n";}
   else {print "Password assigned\n";}

# After we have created the user we can set user as trustee of the home directory.
# The userid used is a ID local to the server.
	$UserID = $Server->MapNameToID($NWHandle, $UserName);
   $Status = $Server->AddTrustee(0, $HomeVol.":".$HomePath, $UserID, "RWECMFA");
   if ($Status) {print "Could not add user as trustee\n";}
   else {print "Trustee added to directory\n";}

	# Set volume space restictions because we want to limit space used by thid user
   # on $HomeVol.
   $Status = $Server->SetObjectVolSpaceLimit($Server->GetVolumeNumber($HomeVol), $UserID, 20);
   if ($Status) {print "Could not set volume space restriction\n";}
   else {print "Volume restriction is activated for $UserName on $HomeVol\n";}


# Now the user is created with homedirectory and the info we added to $Buf.
# But maybe we want to make the user rights equal the rights for the group we
# added him/her to
	$C->AddSecurityEquiv($UserName, $Group);

# And add user to the list of Members in the group object.
   $Buf->InitBuf($NWHandle, "DSV_MODIFY_ENTRY");
   $Buf->PutChange($NWHandle, "DS_ADD_VALUE", "Member");
   $Buf->PutAttrVal($NWHandle, "SYN_DIST_NAME", $UserName);
   $Iter = $Buf->ModifyObject($NWHandle, $Group, 0, 0);
   if (!defined($Iter))
   {
	  print "Error :".$Buf->LastErr()." while adding user $UserName to group\n";
   }else {print "User added to group: $Group\n" ;}
}
else
{
  print STDERR "Reason : $UserName may exist, code: ".$Buf->LastErr()."\n";
}

__END__

