#
# Context.pl
#
# This script demonstrates how to get the current context settings
# with the perl extension PerlWare.
# See also misc.pl to learn what each parameter do.
#
# Copyright (c) 1997 Steinar Kleven
#



BEGIN { $| = 1; }
use PerlWare::NDSContext;

$C = new PerlWare::NDSContext;

# Check to see if we can / have authenicated
$Code = $C->CanDSAuthenticate();
die("CanDSAuthenticate() returned error code ". $C->LastErr() ."\n") if !$Code;


# Get the bit definitions for this context
print "\n\n\nRetrieving context flags.\n";
$Flags = $C->GetContext("DCK_FLAGS");
print "DCV_DEREF_ALIASES is ". (($Flags & $C->GetConst("DCV_DEREF_ALIASES",0)) ? "" : "NOT ") . "set.\n";
print "DCV_XLATE_STRINGS is ". (($Flags & $C->GetConst("DCV_XLATE_STRINGS",0)) ? "" : "NOT ") . "set.\n";
print "DCV_TYPELESS_NAMES is ". (($Flags & $C->GetConst("DCV_TYPELESS_NAMES",0)) ? "" : "NOT ") . "set.\n";
print "DCV_ASYNC_MODE is ". (($Flags & $C->GetConst("DCV_ASYNC_MODE",0)) ? "" : "NOT ") . "set.\n";
print "DCV_CANONICALIZE_NAMES is ". (($Flags & $C->GetConst("DCV_CANONICALIZE_NAMES",0)) ? "" : "NOT ") . "set.\n";
print "DCV_DEREF_BASE_CLASS is ". (($Flags & $C->GetConst("DCV_DEREF_BASE_CLASS",0)) ? "" : "NOT ") . "set.\n";
print "DCV_DISALLOW_REFERRALS is ". (($Flags & $C->GetConst("DCV_DISALLOW_REFERRALS",0)) ? "" : "NOT ") . "set.\n";

# Doing a XOR to tell if we got expected result.
$Std = $C->GetConst("DCV_DEREF_ALIASES",0)|
			$C->GetConst("DCV_XLATE_STRINGS",0)|
           $C->GetConst("DCV_TYPELESS_NAMES",0);
if ($Flags ^ ($Std)){ print "Expected other flags set as default.\n";}
else { print "Expected flags are set.\n";}


print "\n\n\nRetrieving confidence level.\n";
$Conf = $C->GetContext("DCK_CONFIDENCE");
print "Confidence is set as DCV_LOW_CONF\n" if ($Conf == $C->GetConst("DCV_LOW_CONF",0));
print "Confidence is set as DCV_MED_CONF\n" if ($Conf == $C->GetConst("DCV_MED_CONF",0));
print "Confidence is set as DCV_HIGH_CONF\n" if ($Conf == $C->GetConst("DCV_HIGH_CONF",0));

if ($Conf != $C->GetConst("DCV_LOW_CONF",0)){
  print "Expected different confidence set as default.\n";}
else {
  print "Expected confidence is set.\n";
}

print "\nActive context is ". $C->GetContext("DCK_NAME_CONTEXT") ."\n";
print "Active tree is ". $C->GetContext("DCK_TREE_NAME") ."\n";

__END__
