#
# Down.pl
# 
# This script demonstrates how to down a fileserver with
# the perl extension PerlWare. You have to be logged in to the
# server to use this script. You must also have console operator
# rights. Enable/disable login is also included.
#
# Copyright (c) 1997 Steinar Kleven
#



BEGIN { $| = 1; print "1..5\n"; }

use PerlWare::NWServer;
print "ok 1\n";

$ServerName = "SERVER_1";
if (!defined($ServerName)){die("You have to tell me what server to down\n");}

print "THIS SCRIPT WILL DOWN THE FILSERVER $ServerName\n";
print "Please type \"ok\" to continue.\n";

$Val = <STDIN>;
die("You typed: $Val, Aborting..\n") if ($Val !~ /^ok$/i);


$Server = new PerlWare::NWServer($ServerName);
if ($Server) { print "ok 2\n"; }
else { die("NWServer creation failed"); }


# I also demonstrates how to Enable/Disable login.

$Value = $Server->CheckConsolePrivileges();
if ($Value) {
  print STDERR "No consolle rights found\n";
  exit(0);
}  


# Disable login
$Value = $Server->DisableFileServerLogin();
print "ok 3\n" if !$Value;

# Enable login
$Value = $Server->EnableFileServerLogin();
print "ok 4\n" if !$Value;

# Disable login and.....
$Value = $Server->DisableFileServerLogin();

# Down fileserver even if files are open.
# You can feed the method != 0 and the file server will
# only go down if no files are open.
if (!$Server->DownFileServer(0)){
  print "ok 5\n" if !$Value;
  print STDERR "Server $ServerName is going down NOW!\n";
}


