#
# IsMembr.pl
#
# This script demonstrates how to figure out if a given user is
# member of a given group with the perl extension PerlWare.
#
# Copyright (c) 1997 Steinar Kleven
#



BEGIN { $| = 1; print "1..11\n"; }
use PerlWare::NDSContext;
use PerlWare::Buf_T;
print "ok 1\n";


$C = new PerlWare::NDSContext;
# Buffer for query
$InBuf = new PerlWare::Buf_T;
print "ok 2\n" if ($C && $InBuf);

$Handle = $C->GetHandle();


# Unicode init is not needed anymore
# ($code_page, $country_id) = $C->LocaleConv();
# $Retval = $C->InitUnicodeTables($code_page, $country_id);


# We can't do anything if we're not logged on
$Result = $C->IsDSAuthenticated();
if ($Result){print "ok 3\n"}else{die("You're not logged on, bailing out!!")};

# Get YOUR username, and check if you are member of "everyone".
$User = $C->WhoAmI();
print "ok 4\n" if $User;


# Alloc and initiate buffer for NDS compare operation.
$Result = $InBuf->AllocBuf();
print "ok 5\n" if !$Result;
$Result = $InBuf->InitBuf($Handle, "DSV_COMPARE");
print "ok 6\n" if !$Result;


# Put attributename in query-buffer.
$Result = $InBuf->PutAttrName($Handle, "Member");
print "ok 7\n" if !$Result;

# Put the name of the user/ Look up SyntaxID in included datatypes.txt file.
$Result = $InBuf->PutAttrVal($Handle, "SYN_DIST_NAME", $User);
print "ok 8\n" if !$Result;

# Do the compare
$match = $InBuf->Compare($Handle, "everyone");
print "First check returned MATCH!\n" if $match;




# This second test is done with "Group Membership" attribute of user.
# It's just to make sure....
# We should maybe check the "sequrity equal to" attribute also, because
# you can be a member of a group without having the same rights as the group.
# NWAdmin add "Sequrity equal to" attribute as default though.

$Result = $InBuf->InitBuf($Handle, "DSV_COMPARE");
print "ok 9\n" if !$Result;

# Put attributename in query-buffer.
$Result = $InBuf->PutAttrName($Handle, "Group Membership");
print "ok 10\n" if !$Result;

# Put the name of the user/ Look up SyntaxID in included datatypes.txt file.
$Result = $InBuf->PutAttrVal($Handle, "SYN_DIST_NAME", "everyone");
print "ok 11\n" if !$Result;

# Do the compare
$match = $InBuf->Compare($Handle, $User);
print "Second check returned MATCH!\n" if $match;


__END__

