#
# replica.pl
#
# This script demonstrates how to manage replicas and partitions with
# the perl extension PerlWare. You have to be logged in as admin rights to
# run this script successfully.
#
# Copyright (c) 1998 Steinar Kleven
#


use PerlWare;
use PerlWare::NWServer;
use PerlWare::Buf_T;



sub Mydie {
	$ErrMsg = shift;
	open LOG, ">>misc.err";
	print LOG $ErrMsg;
   print $ErrMsg;
   exit(-1);
}


sub GetErrAndDie {
	$Text = shift;
 	$Class = shift;
   Mydie($Text . ",error : ". $Class->LastErr());
}


#ListPart ($ContextHandle, $ServerName)
sub ListPart {
   my $Context = shift;
   my $Server = shift;

   my $Buf  = new PerlWare::Buf_T;
	$Buf->Debug(1);
	$Buf->AllocBuf();

	$iter = $Buf->ListPartitions($Context, $iter, $Server);
	GetErrAndDie("Could not get partition list", $Buf) if (!defined($iter));


	($CurrServer, $NumPart) = $Buf->GetServerName($Context, $ServerName);
	GetErrAndDie("Could not get partition number of partitions", $Buf)
	   if (!defined($CurrServer));

	print "Found $NumPart partitions on server $Server:\n";

	for ($i = 0; $i<$NumPart;$i++) {
		($PartName, $PartType) = $Buf->GetPartitionInfo($Context);
		print "$PartName on $Server is of type $PartType\n";
	}
}


print "Type the name of the server to work with : ";
$ServerName = <STDIN>;
chomp($ServerName);
if (!defined($ServerName)){die("You have to tell me what server work with\n");}

$Server = new PerlWare::NWServer($ServerName);

# We only need the handle so we don't need the full NDSContext package.
# This will save some startup time and memory...
$C = new PerlWare;
$CHandle = $C->GetHandle();

ListPart($CHandle, $ServerName);


# Get number of attributes
$AttrCount = $Buf->GetAttrCount($CHandle);
GetErrAndDie("Could not get attribute count", $Buf) if (!defined($AttrCount));
print "AttrCount: $AttrCount\n";
$outer=0;
while ($outer < $AttrCount) {
  ($AttrName, $ValCount, $SyntaxId) = $Buf->GetAttrName($CHandle);
  GetErrAndDie("GetAttrName error", $Buf) if (!defined($AttrName));
  print "$AttrName, $ValCount, $SyntaxId\n";
  if (!defined($AttrName)){$ok = 0;}
  $inner = 0;
  while ($inner < $ValCount)
  {
  	 $AttrVal = $Buf->GetAttrVal($CHandle, $SyntaxId);
    GetErrAndDie("GetAttrVal", $Buf) if (!defined($AttrVal));
    print "$AttrName: $AttrVal\n";
    $inner++;
  }
  $outer++;
}

# Try these ones yourself
# SplitPartition;
# AddReplica;

print "All methods passed\n";

__END__

