#
# UsrAttr.pl
#
# This script demonstrates how to get ALL attribute-values from an NDS object
# with the perl extension PerlWare.
# With this script you can view how the different attributes are
# represented in Perl.
# This probably gives you attributes that you've never seen in any other tool.
#
#
# Copyright (c) 1997 Steinar Kleven
#



BEGIN { $| = 1; print "1..6\n"; }
use PerlWare::NDSContext;
use PerlWare::Buf_T;
print "ok 1\n";


$C = new PerlWare::NDSContext;

# buffer for reply
$OutBuf = new PerlWare::Buf_T;
print "ok 2\n" if ($C && $OutBuf);

$CHandle = $C->GetHandle();

# Standard Unicode init.
# NOT required any more
($code_page, $country_id) = $C->LocaleConv();
if (defined($code_page) && defined($country_id)){
  $C->InitUnicodeTables($code_page, $country_id);
}

# We can't do anything if we're not logged on
if(!$C->IsDSAuthenticated())
{
   print "Type username: ";
   chomp($UserName = <STDIN>);
   print "Password: ";
   chomp($Passwd = <STDIN>);
   $C->Login(0, $UserName, Passwd, 0);
}


# Get YOUR username, and try to get some values..
print "What object do you want to dump values from: ";
chomp($Object = <STDIN>);
# print "ok 4\n" if defined($Object);

# Alloc and initiate buffer for NDS read operation.
$Result = $OutBuf->AllocBuf();
print "ok 5\n" if !$Result;

# Read NDS
# If you set $Iter to anything, it should be -1 or 0.
# This look a bit strange, passing our self as last
# argument. It's done this way because we are going to read ALL
# attributes and don't need a buffer for telling what we want,
# therefore we use the buffer as a reply-buffer.
# If we were to read only a few attributes we should specify those
# in one buffer (A) and call A->Read(....., B), in which case the buffer B get
# the result of query. See GetAttr.t
# The 4. arg to Read tells NDS that we want ALL attributes.

$ok = 1; # To test for later
$FileSyntax = $OutBuf->GetConst("SYN_STREAM"); # eq 12
do {
	$Iter = $OutBuf->Read($CHandle, $Object, "DS_ATTRIBUTE_VALUES", 1, $Iter, $OutBuf);
	$ok = 0 if (!defined($Iter));

	# Get number of attributes
	$AttrCount = $OutBuf->GetAttrCount($CHandle);
	print "AttrCount: $AttrCount\n";
	$outer=0;
	while ($outer < $AttrCount) {
		($AttrName, $ValCount, $SyntaxId) = $OutBuf->GetAttrName($CHandle);
		print "$AttrName, $ValCount, $SyntaxId\n";
		if (!defined($AttrName)){$ok = 0;}
   	$inner = 0;
 		while ($inner < $ValCount)
		{
        $AttrVal = $OutBuf->GetAttrVal($CHandle, $SyntaxId);
        if ($SyntaxId == $FileSyntax) {
          $nwFile = $OutBuf->OpenStream($CHandle, $Object, $AttrName, "r");
          if(defined($nwFile)) {
            print "$AttrName :\n";
            while(<$nwFile>) { print; }
          }else {$ok = 0;}
	     }else{
     		 if (defined($AttrVal)){
				if ($SyntaxId == 24) {$AttrVal = localtime($AttrVal); }
            print "$AttrName: $AttrVal\n";
          }else {$ok = 0;}
        }
       $inner++;
		}
		$outer++;
	}
}while($Iter != -1);

print "ok 6\n" if $ok;

__END__

