#
# Stattree.pl
#
# This script demonstrates how to browse through your entire tree with PerlWare
#
# Copyright (c) 1997 Steinar Kleven, all rights reserved
#
#	Please adjust the 'require ../cgi-lib.pl' to 
#  match this scripts relative location to cgi-lib.pl on your system.
#


BEGIN {$| = 1; require "../cgi-lib.pl"; print &PrintHeader; }

use strict;
use vars qw($C $Start $Flags %in %Images $ibase);

$ibase = '/PerlWare-demo/images';

%Images = ('Printer' => "$ibase/Printer.gif",
            'Computer' => "$ibase/Computer.gif",
            'Country' => "$ibase/Country.gif",
				'Group' => "$ibase/Group.gif",
				'NCP Server' => "$ibase/NCP_Server.gif",
				'Organizational Unit' => "$ibase/Organizational_Unit.gif",
				'Print Server' => "$ibase/Print_Server.gif",
				'Profile' => "$ibase/Profile.gif",
				'Queue' => "$ibase/Queue.gif",
				'Template' => "$ibase/Template.gif",
				'Unknown' => "$ibase/Unknown.gif",
				'User' => "$ibase/User.gif",
				'Volume' => "$ibase/Volume.gif",
				'Organization' => "$ibase/Organization.gif",
				'App:Application' => "$ibase/App_Application.gif",
				'Application (Windows 3.x)' => "$ibase/Application_win3.gif");



use PerlWare::NDSContext;
use PerlWare::Buf_T;



sub MyDie {
   my ($Object, $Msg) = @_;
   my $Err = $Object->LastErr();
   die("$Msg, error $Err");
}



sub PrintContainer {
	my ($Container, $refObjects) = @_;
	my ($ObjType, $i, $sum, $Image);	
	print "<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=0>\n";
	print "<CAPTION><B><I><FONT COLOR=\"#990000\" SIZE=+2> " .
			"$Container</FONT></I></B></CAPTION>";
	print "<TR><TD>&nbsp;<B><I><FONT SIZE=+1>Object type</FONT></I></B></TD>";

	print "<TD><B><I><FONT SIZE=+1>Number of objects</FONT></I></B></TD></TR>";
	$i=0;
	$sum = 0;
   foreach $ObjType (keys %$refObjects)
   {
		if (++$i % 2)
		{print "<TR BGCOLOR=\"#CCCCCC\">";}else{print "<TR BGCOLOR=\"#999999\">";}
      if (!($Image = $Images{$ObjType})){$Image = $Images{'Unknown'};}
      print "<TD><IMG SRC=\"$Image\">$ObjType </TD><TD ALIGN=CENTER> $refObjects->{$ObjType}</TD></TR>\n";
		$sum += $refObjects->{$ObjType};
   }
	print "<TR BGCOLOR=\"#52AD56\"><I><B>";
	print "<TD><B><I>Sum</I></B></TD><TD ALIGN=CENTER><B><I>$sum</I></B></TD><I><B></TR>\n";
	print "</table><P>\n\n\n";
}



# This is a recursive method listing number of different objects in each container.
sub StatTree {
   my $StartContainer = shift;
   my $Context = shift;
   my %Objects = ();
   my ($i, $iter, $ObjectName, $ObjectCount, $AttrCount, @ObjInfo, $ObjType);
   my $Buf = new PerlWare::Buf_T;
   my $CHandle = $Context->GetHandle();
	$Context->SetContext("DCK_NAME_CONTEXT", "$StartContainer");

   $Buf->AllocBuf(32768);
   $iter = $Buf->GetConst("NO_MORE_ITERATIONS");
   do
   {
      $iter = $Buf->List($CHandle, "", $iter);
      MyDie($Buf, "List()") if (!defined($iter));
      $ObjectCount = $Buf->GetObjectCount($CHandle);
      MyDie($Buf, "GetObjectCount()") if  (!defined($ObjectCount));

      #Now we can list all objects in this context
      for($i=0; $i < $ObjectCount; $i++) {
         ($ObjectName, $AttrCount, @ObjInfo) = $Buf->GetObjectName($CHandle);
         MyDie($Buf, "GetObjectName()") if (!defined($ObjectName));
         $ObjectName = $C->CanonicalizeName($ObjectName);
         if ($ObjInfo[0] & $Buf->GetConst("DS_CONTAINER_ENTRY"))
         {
            StatTree("$ObjectName", $Context);
				$Context->SetContext("DCK_NAME_CONTEXT", "$StartContainer");
         }
         $Objects{$ObjInfo[3]}++;
      }
   }while ($iter != -1);
	PrintContainer($StartContainer, \%Objects);
}

sub Myend { 
	print &HtmlBot;
	exit();
}


#######
# Execution start here
#######

$C = new PerlWare::NDSContext;

print &HtmlTop("PerlWare statistics example");


# We can't do anything if we're not logged on
if (!$C->IsDSAuthenticated())
{
  print("You're not logged on, bailing out!!") ;
  &Myend();
}


&ReadParse(\*in);
$Start = $in{'context'};

# Make sure we always get full name and context
# when we call CanonicalizeName() in StatTree 
# We also want those nice O=, OU= ....

$Flags = $C->GetContext("DCK_FLAGS");
$Flags |= $C->GetConst("DCV_CANONICALIZE_NAMES", 0);
$Flags &= ~ $C->GetConst("DCV_TYPELESS_NAMES", 0);
$C->SetContext("DCK_FLAGS", $Flags);

&StatTree($Start, $C);
print "<HR><p>Powered by <A HREF=\"http://www.ahs.hist.no/distr/PerlWare\"><B>PerlWare</B></A>\n";
&Myend();



__END__
