#
# NDSCreate.pl
#
# This script demonstrates how to set up an service to add users
# or other objects to NDS with PerlWare.
#
# Copyright (c) 1997 Steinar Kleven, all rights reserved
#
#	Please adjust the 'require ../cgi-lib.pl' to 
#  match this scripts relative location to cgi-lib.pl on your system.
#


BEGIN {$| = 1; require "../cgi-lib.pl"; print &PrintHeader; }

use strict;
use vars qw($C $Start $Flags %in %Images $this_script $ibase);

$this_script = $ENV{'SCRIPT_NAME'};
$ibase = '/PerlWare-demo/images';

%Images = ('Printer' => "$ibase/Printer.gif",
            'Computer' => "$ibase/Computer.gif",
            'Country' => "$ibase/Country.gif",
				'Group' => "$ibase/Group.gif",
				'NCP Server' => "$ibase/NCP_Server.gif",
				'Organizational Unit' => "$ibase/Organizational_Unit.gif",
				'Print Server' => "$ibase/Print_Server.gif",
				'Profile' => "$ibase/Profile.gif",
				'Queue' => "$ibase/Queue.gif",
				'Template' => "$ibase/Template.gif",
				'Unknown' => "$ibase/Unknown.gif",
				'User' => "$ibase/User.gif",
				'Volume' => "$ibase/Volume.gif",
				'Organization' => "$ibase/Organization.gif",
				'App:Application' => "$ibase/App_Application.gif",
				'Application (Windows 3.x)' => "$ibase/Application_win3.gif");



use PerlWare::NDSContext;
use PerlWare::Buf_T;



sub MyDie {
   my ($Object, $Msg) = @_;
   my $Err = $Object->LastErr();
   die("$Msg, error $Err");
}

sub MyEnd { 
	print "<HR><p>Powered by <A HREF=\"http://www.ahs.hist.no/distr/PerlWare\"><B>PerlWare</B></A>\n";
	print &HtmlBot;
	exit();
}


sub PrintMainMenu() {
   print "<FORM ACTION=\"$this_script\" METHOD=\"POST\">\n";
   print  << 'FORM_END';
  <FONT COLOR="FF0000">* => mandatory</FONT><P><P>
  * Task:    <BR><INPUT TYPE="radio" NAME="task" VALUE="create" CHECKED> Create object<BR>
                 <INPUT TYPE="radio" NAME="task" VALUE="modify"> Modify Object (Not implemented)<P>
  * Object type: <SELECT NAME="objtype">
                 <OPTION VALUE="User"> User
				 <OPTION VALUE="Group"> Group (Not implemented)
				 </SELECT><P>
				 Public.Demo.PerlWare is the only valid context<BR> 
  * Context:     <INPUT NAME="context" VALUE="Public.Demo.PerlWare" SIZE=31 MAXLENGTH=30> <P>
  <INPUT TYPE="Submit" Value="Create">
  <INPUT TYPE="Reset" Value="Clear">
  </form>
FORM_END
}


sub UserForm {
   print "<FORM ACTION=\"$this_script\" METHOD=\"POST\">\n";
   print "<INPUT TYPE=HIDDEN NAME=task VALUE=\"$in{'task'}\">\n";
   print "<INPUT TYPE=HIDDEN NAME=objtype VALUE=\"$in{'objtype'}\">\n";
   print "<INPUT TYPE=HIDDEN NAME=context VALUE=\"$in{'context'}\">\n";
   print  << 'FORM_END';
  <FONT COLOR="FF0000">* => mandatory</FONT><BR>
  <pre>
  User Name:    <INPUT NAME="objname" VALUE="" SIZE=16 MAXLENGTH=15>*
  Surname:      <INPUT NAME="surname" VALUE="" SIZE=31 MAXLENGTH=30>*
  Given name:   <INPUT NAME="given name" VALUE="" SIZE=31 MAXLENGTH=30>
  Password:     <INPUT TYPE=PASSWORD NAME="password" VALUE="" SIZE=31 MAXLENGTH=30>
  Description:  <INPUT NAME="description" VALUE="" SIZE=61 MAXLENGTH=60>
  </pre>
  <INPUT TYPE="Submit" Value="Create">
  <INPUT TYPE="Reset" Value="Clear">
  </form>
FORM_END
}



sub GroupForm {
	print "<B> Not implemented!</B>\n";
}



sub PrintDataForm {
	my $objtype = $in{'objtype'};
	UserForm() if ($objtype eq 'User');
	GroupForm() if ($objtype eq 'Group');
}




sub CreateObject() {
	my ($Buffer, $CHandle, $iter);

	$CHandle = $C->GetHandle;
	$Buffer = new PerlWare::Buf_T;
    $Buffer->AllocBuf();
	if ($in{'task'} eq "create")
	{
	$Buffer->InitBuf($CHandle, "DSV_ADD_ENTRY");
	}else{
	 $Buffer->InitBuf($CHandle, "DSV_MODIFY_ENTRY");
	}
	$Buffer->PutAttrName($CHandle, "Object Class");
	$Buffer->PutAttrVal($CHandle, "SYN_CLASS_NAME", $in{'objtype'});

	if (($in{'objtype'} eq 'User') && !defined($in{'surname'}))
	{
	  print "<P><BLINKING> Surname is mandatory </BLINKING>";
	  &MyEnd();
	} 
	if ($in{'surname'})
	{
	  $Buffer->PutAttrName($CHandle, "Surname");
	  $Buffer->PutAttrVal($CHandle, "SYN_CI_STRING", $in{'surname'});
	} 
	if ($in{'given name'})
	{
	  $Buffer->PutAttrName($CHandle, "Given name");
	  $Buffer->PutAttrVal($CHandle, "SYN_CI_STRING", $in{'given name'});
	}
	if ($in{'description'})
	{
	  $Buffer->PutAttrName($CHandle, "Description");
	  $Buffer->PutAttrVal($CHandle, "SYN_CI_STRING", $in{'description'});
	} 
    if ($in{'task'} eq 'create')
	{
	  $iter = -1;
	  $iter = $Buffer->AddObject($CHandle, $in{'objname'}, $iter, 0);
	  if (!defined($iter)) 
	  {
		MyDie($Buffer, "Failed to $in{'task'} $in{'objname'}");
	  }
	  else
	  { 
	    print "<P>$in{'objname'}.$in{'context'} <BLINK>created !!</BLINK>\n";
	  }
    }
}



sub ModifyObject {
	print "\n<B> Not Implemented!</B>\n";
}







#######
# Execution start here
#######



# Get parameters
&ReadParse(\*in);

print &HtmlTop("PerlWare edit/create demo");


if ($in{'task'} eq 'modify' || $in{'objtype'} eq 'Group')
{
   print "\n<B> Not Implemented!</B>\n";
   &MyEnd();
}




if ($in{'objtype'} && !$in{'objname'})
{
 	&PrintDataForm ();
	&MyEnd();
}
elsif (!$in{'objtype'})
{
 	&PrintMainMenu();
	&MyEnd();
}


$C = new PerlWare::NDSContext;


# We can't do anything if we're not logged on
#
# **** Add you authentication function here
# **** $C->Login(...)

if (!$C->IsDSAuthenticated())
{
  print("You're not logged on, bailing out!!") ;
  &MyEnd();
}


$Flags = $C->GetContext("DCK_FLAGS");
$Flags |= $C->GetConst("DCV_CANONICALIZE_NAMES", 0);
$Flags &= ~ $C->GetConst("DCV_TYPELESS_NAMES", 0);
$C->SetContext("DCK_FLAGS", $Flags);

$C->SetContext("DCK_NAME_CONTEXT", $in{'context'});

print "Context: ". $C->GetContext("DCK_NAME_CONTEXT") ."\n";

if ($in{'objname'} && $in{'context'} && $in{'objtype'} && ($in{'task'} eq 'create')){
   &CreateObject(); 
   &MyEnd();
}

if ($in{'objname'} && $in{'context'} && $in{'objtype'} && ($in{'task'} eq 'modify')){
   &ModifyObject(); 
   &MyEnd();
}




&MyEnd();

__END__
