#
# Adduser.pl
#
# This script demonstrates how to create a user using
# the perl extension PerlWare.
#
# Copyright (c) 1997 Steinar Kleven
#

BEGIN { $| = 1; }

use PerlWare::NDSContext;
use PerlWare::Buf_T;
use PerlWare::NWServer;

BEGIN { }


sub Mydie {
	$ErrMsg = shift;
	open LOG, ">>adduser.err";
	print LOG $ErrMsg;
   print $ErrMsg;
   exit(-1);
}

# Data for new user. The user resides in the context .HIST
print "Type server name homedir (ex. NWSRV2): ";
$HomeServer = <STDIN>;
chomp $HomeServer;
print "Type volume name for homedir (ex. NWSRV2_SYS.HiST): ";
$HomeDir = "0\n". <STDIN>;
print "Type homedir path on volume (ex. NEWHOME): ";
$HomePath = <STDIN>;
$HomeDir = $HomeDir.$HomePath;
chomp($HomePath);
print "Type volume name in short (ex. SYS) :";
$HomeVol = <STDIN>;
chomp($HomeVol);
print "Type in username (ex. tmpuser.HiST) :";
$UserName = <STDIN>;
chomp($UserName);
print "Type password for new user : ";
$Password = <STDIN>;
chomp($Password);
print "Type in surename (ex. Johnsen) :";
$Surename = <STDIN>;
chomp($Surename);
print "Type in phonenumber (ex. 23-24352-23) :";
$Newtlf = <STDIN>;
chomp($Newtlf);
print "Type in group user should be member of (ex. TESTGRP) :";
$Group = <STDIN>;
chomp($Group);

$C = new PerlWare::NDSContext;
Mydie("No context handle created\n") if (!$C->IsInit());
$Buf = new PerlWare::Buf_T;
Mydie("No buffer created\n") if (!defined($Buf));

# Connect to server where home-directory is going to be.
# NB! All PerlWare::NWServer objects is created without licensing the connection, except
# if we already are licensed.
$Server = new PerlWare::NWServer($HomeServer);
Mydie("No server connection could be made\n") if (!$Server->IsInit());

# Turn on debug
$C->Debug(1);
$Buf->Debug(1);
$Server->Debug(1);

# Handle needed in most methods
$NWHandle = $C->GetHandle();

$Result = $C->CanDSAuthenticate();
if (!$Result){Mydie("You can't authenticate!!\n")};


$Result = $C->IsDSAuthenticated();
if (!$Result){Mydie("You're not logged on, bailing out!!")};

$Result = $Server->AuthenticateConn($NWHandle);
if ($Result){Mydie("You can't authenticate to server, bailing out!!")};


# We need to license the connection because we are (behind the scenes) going
# to read some info about the volume to set space restrictions.
$Result = $Server->LicenseConn();
if ($Result)
{
  printf ("Error: %X\n", $Result);
  Mydie("You can't license you connection, bailing out!!");
}

# We'll have to create the home directory before creating the
# user. That's what Novell engineers told me anyway..
$Result = $Server->CreateDirectory(0, $HomeVol.":".$HomePath, "ALL");
Mydie("CreateDirectory Failed, code: $Result\n") if $Result;


# Now we shall create the user.
# Note that we have to force PerlWare to talk to the server
# we want to create the home directory on.
# If not we could get involved in syncro problems when setting rights.


$C->SetContext("DCK_LAST_CONNECTION", $Server->GetHandle());
$Flags = $C->GetContext("DCK_FLAGS");
$Flags |= $C->GetConst("DCV_DISALLOW_REFERRALS");
$C->SetContext("DCK_FLAGS", $Flags);

$ReadFlags = $Flags = $C->GetContext("DCK_FLAGS");
Mydie("SetContext failed\n") if ($Flags != $ReadFlags);


# Now we should be forced to talk to server $Server.

$Result = $Buf->AllocBuf();

$Result = $Buf->InitBuf($NWHandle, "DSV_ADD_ENTRY");


# Call PutAttrName and PutAttrVal repeatedly for each type
#  of information about to be entered.  Start with User (Object Class).
#
$Result = $Buf->PutAttrName($NWHandle, "Object Class");
$Result = $Buf->PutAttrVal($NWHandle, "SYN_CLASS_NAME", "User");

# Add information for Surname
$Result = $Buf->PutAttrName($NWHandle, "Surname");
$Result = $Buf->PutAttrVal($NWHandle, "SYN_CI_STRING", $Surename);

# Maybe we want to add the new user to an existing group.
# Almost at the bottom of the script we add more values
# regarding the group.
$Result = $Buf->PutAttrName($NWHandle, "Group Membership");
$Result = $Buf->PutAttrVal($NWHandle, "SYN_DIST_NAME", $Group);

# Add information for Telephone Number
$Result = $Buf->PutAttrName($NWHandle, "Telephone Number");
$Result = $Buf->PutAttrVal($NWHandle, "SYN_TEL_NUMBER", $Newtlf);

# Add the home directory attribute
$Result = $Buf->PutAttrName($NWHandle, "Home Directory");
$Result = $Buf->PutAttrVal($NWHandle, "SYN_PATH", $HomeDir ."\n");

# Add the user we created in $Buf, the last two params are ignored.
$Iter = $Buf->AddObject($NWHandle, $UserName, 0, 0);
print "User added ok\n" if (defined($Iter));
if (defined($Iter))
{
# Now we also have to set the password for the user, we use blank
# password for this demo
   $Status = $C->GenerateObjectKeyPair($UserName, "", 0);
   if ($Status) {Mydie("Could not set initialize new user\n");}
   else {print "User initialized\n";}

   $Status = $C->ChangeObjectPassword(0, $UserName, "", $Password);
   if ($Status) {Mydie("Could not set password\n");}
   else {print "Password set\n";}
   # Verify password
   $Status = $C->VerifyObjectPassword(0, $UserName, $Password);
   if ($Status) {Mydie("Password verification failed\n");}
   else {print "Password verified.\n";}

# After we have created the user we can set user as trustee of the home directory.
# The userid used is a ID local to the server.
	$UserID = $Server->MapNameToID($NWHandle, $UserName);
   $Status = $Server->AddTrustee(0, $HomeVol.":".$HomePath, $UserID, "RWECMFA");
   if ($Status) {Mydie("Could not add user as trustee\n");}
   else {print "Trustee added to directory\n";}

	# Set volume space restictions because we want to limit space used by thid user
   # on $HomeVol.
   $Status = $Server->SetObjectVolSpaceLimit($Server->GetVolumeNumber($HomeVol), $UserID, 20);
   if ($Status) {print "Could not set volume space restriction\n";}
   else {print "Volume restriction is activated for $UserName on $HomeVol\n";}
	# Verify.
   ($Restriction, $InUse) = $Server->GetObjDiskRestrictions($Server->GetVolumeNumber($HomeVol), $UserID);
   if ($Restriction != 20){Mydie("Diskrestrictions don't match ($Restriction, $InUse) \n");}
   else {print "Volume restriction is verified for $UserName on $HomeVol\n";}

# Now the user is created with homedirectory and the info we added to $Buf.
# But maybe we want to make the user rights equal the rights for the group we
# added him/her to
	$Result = $C->AddSecurityEquiv($UserName, $Group);
   Mydie("Error $Result while adding scurity equivalense\n") if $Result;

# And add user to the list of Members in the group object.
   $Buf->InitBuf($NWHandle, "DSV_MODIFY_ENTRY");
   $Buf->PutChange($NWHandle, "DS_ADD_VALUE", "Member");
   $Buf->PutAttrVal($NWHandle, "SYN_DIST_NAME", $UserName);
   $Iter = $Buf->ModifyObject($NWHandle, $Group, 0, 0);
   if (!defined($Iter))
   {
	  Mydie("Error :".$Buf->LastErr()." while adding user $UserName to group\n");
   }else {print "User added to group: $Group\n" ;}
}
else
{
  print STDERR "Reason : $UserName may exist, code: ".$Buf->LastErr()."\n";
}

print "Press 1 to delete user and homedirectory.\n";
print "Press 0 to end test\n";
if (<STDIN> eq "1\n")
{
	print "Deleteing trustee settings, user and homedirectory....\n";
	$Result = $C->RemSecurityEquiv($UserName, $Group);
   Mydie("Error $Result while removing scurity equivalense\n") if $Result;
   $Status = $Server->DeleteTrustee(0, $HomeVol.":".$HomePath, $UserID);
   Mydie("Could not delete trustee from directory, error: $Result\n") if $Result;
   $Result = $Server->DeleteDirectory(0, $HomeVol.":".$HomePath);
   Mydie("Could not delete directory, error: $Result\n") if $Result;
	$Result = $C->RemoveObject($UserName);
   Mydie("Could not delete userobject, error: $Result\n") if $Result;
}

print "\nAll methods passed.\n"

__END__

