#
# Misc.pl
# 
# This script demonstrates how to use contextflags to get the output you want
# with the perl extension PerlWare.
# There are also other misc metods demonstrated here.
#
# Copyright (c) 1997 Steinar Kleven
#


use PerlWare::NDSContext;

sub Mydie {
	$ErrMsg = shift;
	open LOG, ">>misc.err";
	print LOG $ErrMsg;
   print $ErrMsg;
   exit(-1);
}


sub GetErrAndDie {
	$Text = shift;
 	$Class = shift;
   Mydie($Text . ",error : ". $Class->LastErr());
}



$C = new PerlWare::NDSContext;
Mydie("Could not create class NDSContext.\n") if (!defined($C));

$Code = $C->CanDSAuthenticate();
Mydie("You can't authenticate.\n") if !$Code;

sub DoPrint {
	$MyName = $C->WhoAmI();
   GetErrAndDie("WhoAmI", $C) if (!defined($MyName));
	$CName = $C->CanonicalizeName($MyName);
   GetErrAndDie("CanonicalizeName", $C) if (!defined($CName));
	$AName = $C->AbbreviateName($MyName);
   GetErrAndDie("AbbreviateName", $C) if (!defined($AName));
	$Tree = $C->GetContext("DCK_TREE_NAME");
   GetErrAndDie("GetContext", $C) if (!defined($Tree));
	$DefCtx = $C->GetDefNameContext();
   GetErrAndDie("GetDefNameContext", $C) if (!defined($DefCtx));
	$TypeLess = $C->RemoveAllTypes($MyName);
   GetErrAndDie("RemoveAllTypes", $C) if (!defined($TypeLess));

	print "WhoAmI           : $MyName\n";
	print "CanonicalizeName : $CName\n";
	print "AbbreviateName   : $AName\n";
	print "Typeless         : $TypeLess\n";
	print "Tree             : $Tree\n";
	print "Default name ctx : $DefCtx\n";
	print "\n\n\n";
}





# As default the context flags are set as follows
#  typeless naming on.
#  canonicalize names off.  This means we will get full names (from [root])
#
$Flags = $C->GetContext("DCK_FLAGS");
# Typeless naming on: NO CN=....OU=... O=...
$Flags |= $C->GetConst("DCV_TYPELESS_NAMES", 0);
# Canonicalize names on: Give us names relative to context.
$Flags |= $C->GetConst("DCV_CANONICALIZE_NAMES", 0);
# Activate the new settings
$Status = $C->SetContext("DCK_FLAGS", $Flags);
DoPrint();

# Typeless naming off: Should give us  CN=....OU=... O=...
$Flags &= ~ $C->GetConst("DCV_TYPELESS_NAMES", 0);
# Canonicalize names on: Give us names relative to context.
$Flags |= $C->GetConst("DCV_CANONICALIZE_NAMES", 0);
# Activate the new settings
$Status = $C->SetContext("DCK_FLAGS", $Flags);
DoPrint();

$Temp = $C->RemoveAllTypes($CName);
GetErrAndDie("RemoveAllTypes", $C) if (!defined($TypeLess));
print "Removed types, got : $Temp\n";

$CN = $C->ReplaceAttrNameAbbrev("CN");
GetErrAndDie("ReplaceAttrNameAbbrev", $C) if (!defined($TypeLess));
print "Did you know that 'CN' stand for '$CN' ?\n";
$OU = $C->ReplaceAttrNameAbbrev("OU");
GetErrAndDie("ReplaceAttrNameAbbrev", $C) if (!defined($TypeLess));
print "Did you know that 'OU' stand for '$OU' ?\n";

print "All methods passed\n";

__END__
