#
# Rattrib.pl
#
# This script demonstrates how to get ALL attribute-values from an NDS object
# with the perl extension PerlWare.
# With this script you can view how the different attributes are
# represented in Perl.
# This probably gives you attributes that you've never seen in any other tool.
#
#
# Copyright (c) 1997 Steinar Kleven
#



use PerlWare::NDSContext;
use PerlWare::Buf_T;

sub Mydie {
	$ErrMsg = shift;
	open LOG, ">>rattrib.err";
	print LOG $ErrMsg;
   print $ErrMsg;
   exit(-1);
}


sub GetErrAndDie {
	$Text = shift;
 	$Class = shift;

   Mydie($Text . ",error : ". $Class->LastErr());
}


$C = new PerlWare::NDSContext;

# buffer for reply
$OutBuf = new PerlWare::Buf_T;

$CHandle = $C->GetHandle();


# We can't do anything if we're not logged on
$Result = $C->IsDSAuthenticated();
if (!$Result){Mydie("You're not logged on, bailing out!!")};

# Get YOUR username, and try to get some values..
print "Type NDS-object to get attributes for : ";
$Object = <STDIN>;
chomp($Object);

# Alloc and initiate buffer for NDS read operation.
$Result = $OutBuf->AllocBuf();
Mydie("Could not allocated buffer, error: $Result\n") if $Result;

# Read NDS
# If you set $Iter to anything, it should be -1 or 0.
# This look a bit strange, passing our self as last
# argument. It's done this way because we are going to read ALL
# attributes and don't need a buffer for telling what we want,
# therefore we use the buffer as a reply-buffer.
# If we were to read only a few attributes we should specify those
# in one buffer (A) and call A->Read(....., B), in which case the buffer B get
# the result of query. See GetAttr.t
# The 4. arg to Read tells NDS that we want ALL attributes.

$FileSyntax = $OutBuf->GetConst("SYN_STREAM"); # eq 12
do {
	$Iter = $OutBuf->Read($CHandle, $Object, "DS_ATTRIBUTE_VALUES", 1, $Iter, $OutBuf);
   GetErrAndDie("Could not Read from NDS", $OutBuf) if (!defined($Iter));

	# Get number of attributes
	$AttrCount = $OutBuf->GetAttrCount($CHandle);
   GetErrAndDie("Could not get attribute count", $OutBuf) if (!defined($AttrCount));
	print "AttrCount: $AttrCount\n";
	$outer=0;
	while ($outer < $AttrCount) {
		($AttrName, $ValCount, $SyntaxId) = $OutBuf->GetAttrName($CHandle);
	   GetErrAndDie("GetAttrName error", $OutBuf) if (!defined($AttrName));
		print "$AttrName, $ValCount, $SyntaxId\n";
		if (!defined($AttrName)){$ok = 0;}
   	$inner = 0;
 		while ($inner < $ValCount)
		{
        $AttrVal = $OutBuf->GetAttrVal($CHandle, $SyntaxId);
        GetErrAndDie("GetAttrVal", $OutBuf) if (!defined($AttrVal));
        if ($SyntaxId == $FileSyntax) {
          $nwFile = $OutBuf->OpenStream($CHandle, $Object, $AttrName, "r");
          if(defined($nwFile)) {
            print "$AttrName :\n";
            while(<$nwFile>) { print; }
          }else {GetErrAndDie("OpenStream error", $OutBuf); }
	     }else{
     		 if (defined($AttrVal)){
            print "$AttrName: $AttrVal\n";
          }else {GetErrAndDie("OpenStream error", $OutBuf); }
        }
       $inner++;
		}
		$outer++;
	}
}while($Iter != -1);

# If we ever get here all methods worked.
print "All methods passed\n";

__END__

