package PerlWare::Audit;

use strict;
use vars qw($BIN_DEBUG $VERSION @ISA @EXPORT @EXPORT_OK);

require 5.0;
require Exporter;
require DynaLoader;

use Time::Local;

@ISA = qw(Exporter DynaLoader PerlWare);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(

);

$VERSION = '1.00';
bootstrap PerlWare::Audit $VERSION;

# Both are taken care of by PerlWare class or PerlWare::NWServer
BEGIN {   }
END {   }


sub new {
   my $proto = shift;
   my( $src, $obj) = @_;
   die('Usage: new Audit ($src, $obj);'."\n") if (!defined($src) || !defined($obj));
   my $class = ref($proto) || $proto;
   my $self  = {};
   ($self->{CONN}, $self->{AUDID}, $self->{TYPE}) = ();
   ($self->{CONN}, $self->{AUDID}, $self->{TYPE}) = $src->AuditGetObjectID($obj);
   if (!defined($self->{CONN}) || !defined($self->{AUDID}) || !defined($self->{TYPE}))
   {
      print STDERR "AuditGetObjectID($obj) failed with code ". $src->LastErr() ."\n";
      return undef;
   }
   $self->{HANDLE} = undef;
   $self->{FILEHANDLE} = undef;
   $self->{DEBUG} = 1;
	bless ($self, $class);
	$self;
}


sub IsInit {
   my $self = shift;
   return (defined($self->{CONTEXT}) && $self->{CONN} && $self->{AUDID});
}


sub GetFileList {
   my $self = shift;
   my @FileList = &NWADGetFileList($self->{CONN}, $self->{TYPE}, $self->{AUDID}, $self->{HANDLE});
   if (!defined(@FileList)) {
	   $self->{LAST_ERR} = &PerlWare::Audit::GetLastErr();
	   warn "NWADGetFileList returning <undef>\n" if $self->{DEBUG};
   }
   @FileList;
}


sub LastErr {
   my $self = shift;
   return $self->{LAST_ERR};
}


sub Open {
   my $self = shift;
   if (defined($self->{FILEHANDLE}))
   {
      &NWADCloseFile($self->{FILEHANDLE});
      $self->{FILEHANDLE} = undef;
   }
   &NWADClose($self->{HANDLE}) if (defined($self->{HANDLE}));
   $self->{HANDLE} = NWADOpen($self->{CONN}, $self->{TYPE}, $self->{AUDID});
   $self->{LAST_ERR} = &PerlWare::Audit::GetLastErr();
   if (!defined($self->{HANDLE})) {
	  warn "Open() could not create handle, error: $self->{LAST_ERR}\n" if $^W;
	}
   $self->{LAST_ERR};
}



sub Login {
	my $self = shift;
   my $passwd = shift;
   $self->{LAST_ERR} = &NWADLogin($self->{CONN}, $self->{TYPE}, $self->{AUDID}, $self->{HANDLE}, $passwd);
   if($self->{LAST_ERR}) {
	   warn "Open() could not create handle, error: $self->{LAST_ERR}\n" if $^W;
   }   
}


# $code is the index of the file in array from GetFileList;
sub OpenRecordFile {
   my $self = shift;
   my $code = shift;
   &NWADCloseFile($self->{FILEHANDLE}) if (defined($self->{FILEHANDLE}));
   $self->{FILEHANDLE} = NWADOpenRecordFile($self->{CONN}, $self->{TYPE}, $self->{AUDID}, $self->{HANDLE}, $code);
   return &PerlWare::Audit::GetLastErr();
}


sub ReadRecords {
   my $self = shift;
   my @Records;
   if (!defined($self->{FILEHANDLE})) {warn "No file opened\n"; return undef;}
   @Records = ReadAllRecords($self->{FILEHANDLE}, $self->{TYPE});
   if (!defined(@Records)) {
	   $self->{LAST_ERR} = &PerlWare::Audit::GetLastErr();
	   warn "ReadAllRecords returning <undef>\n" if $self->{DEBUG};
   }
   return sort {($a =~/^(\d+)/)[0] <=> ($b =~/^(\d+)/)[0]} @Records;
}



sub CloseRecordFile {
   my $self = shift;
   my $Ret = 0;
   if (defined($self->{FILEHANDLE}))
   {
      $Ret = &NWADCloseRecordFile($self->{FILEHANDLE}) ;
   }
   $Ret;
}



sub Close {
   my $self = shift;
   my $Ret = 0;
   if (defined($self->{FILEHANDLE}))
   {
      return $Ret if (($Ret = &NWADCloseRecordFile($self->{FILEHANDLE})));
   }else {
      $Ret = &NWADClose($self->{HANDLE}) if (defined($self->{HANDLE}));
   }
   $Ret;
}



sub DESTROY {
	my $self = shift;
   &NWADCloseRecordFile($self->{FILEHANDLE}) if (defined($self->{FILEHANDLE}));
   &NWADClose($self->{HANDLE}) if (defined($self->{HANDLE}));
}


1;

