
package PerlWare::NDSContext;
use strict;
use PerlWare;

use vars qw($BIN_DEBUG $REGUSER $REGCODE $VERSION @ISA @EXPORT @EXPORT_OK);


@ISA = qw(Exporter DynaLoader PerlWare);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(

);

*AUTOLOAD = \&PerlWare::AUTOLOAD;
*BIN_DEBUG = \$PerlWare::BIN_DEBUG;
*VERSION = \$PerlWare::VERSION;


sub AbbreviateName {
	my $self = shift;
	if (@_ < 1){ warn("AbbreviateName needs 1 param\n");return undef;}
   my ($InName) = @_;
	my $abbrev = &PerlWare::NWDSAbbreviateName($self->{CONTEXT}, $InName);
   if (!defined($abbrev)) {
	  $self->{LAST_ERR} = &PerlWare::GetLastErr();
     warn "AbbreviateName returning <undef>\n" if $self->{DEBUG};
	  undef;
	}else { $abbrev; }
        
}






sub AddSecurityEquiv {
	my $self = shift;
	my ($equalFrom, $equalTo) = @_;
	return &PerlWare::NWDSAddSecurityEquiv($self->{CONTEXT}, $equalFrom, $equalTo);
}



sub CanDSAuthenticate {
	my $self = shift;
	return &PerlWare::NWDSCanDSAuthenticate($self->{CONTEXT});
}





sub CanonicalizeName {
	my $self = shift;
	my $InName = shift;
	my $Canon = &PerlWare::NWDSCanonicalizeName($self->{CONTEXT}, $InName);
        if (!defined($Canon)) {
	  $self->{LAST_ERR} = &PerlWare::GetLastErr();
          warn "CanonicalizeName returning <undef>\n" if $self->{DEBUG};
	  undef;
	}else { $Canon; }
}




# Opt is not used in NSDK(13)
sub ChangeObjectPassword {
	my $self = shift;
	my ($foo, $Obj, $Old, $New) = @_;
	return &PerlWare::NWDSChangeObjectPassword($self->{CONTEXT}, $foo, $Obj, $Old, $New);
}






sub CreateContextHandle {
	my $self = shift;
	my $Handle = &PerlWare::NWDSCreateContextHandle();
	if (!defined($Handle)) {
	  $self->{LAST_ERR} = &PerlWare::GetLastErr();
	  warn "CreateContextHandle returning <undef>\n" if $self->{DEBUG};
	  undef;
	}else { $Handle; }
}





sub GenerateObjectKeyPair {
	my $self = shift;
	my ($ObjName, $newpass, $flag) = @_;
	return &PerlWare::NWDSGenerateObjectKeyPair($self->{CONTEXT}, $ObjName, $newpass, $flag);
}





sub GetDefNameContext {
	my $self = shift;
	my $Context =  &PerlWare::NWDSGetDefNameContext($self->{CONTEXT});	
	if (!defined($Context)) {
     $self->{LAST_ERR} = &PerlWare::GetLastErr();
	  warn "GetDefNameContext returning <undef>\n" if $self->{DEBUG};
     undef;
	}else { $Context; }
}





sub IsDSAuthenticated {
	my $self = shift;
	return &PerlWare::NWIsDSAuthenticated();
}



sub Login {
	my $self = shift;
	my ($Opt, $User, $Passwd, $Period) = @_;
   return &PerlWare::NWDSLogin($self->{CONTEXT}, 0, $User, $Passwd, 0);
}



sub Logout {
	my $self = shift;
	return &PerlWare::NWDSLogout($self->{CONTEXT});
}



sub MoveObject {
	my $self = shift;
	my ($Obj, $destParentDN, $destRDN) = @_;
	return &PerlWare::NWDSMoveObject($self->{CONTEXT}, $Obj, $destParentDN, $destRDN);
}



sub RemoveAllTypes {
	my $self = shift;
	my $Name = shift;
   my $TypeLess = &PerlWare::NWDSRemoveAllTypes($self->{CONTEXT}, $Name);
	if (!defined($TypeLess)) {
	  $self->{LAST_ERR} = &PerlWare::GetLastErr();
	  warn "RemoveAllTypes returning <undef>\n" if $self->{DEBUG};
          undef;
	}else { $TypeLess; }
}



sub RemoveObject {
	my $self = shift;
	my ($ObjectName) = @_;
	return &PerlWare::NWDSRemoveObject($self->{CONTEXT}, $ObjectName);
}




sub RemSecurityEquiv {
        my $self = shift;
	my ($equalFrom, $equalTo) = @_;
	return &PerlWare::NWDSRemSecurityEquiv($self->{CONTEXT}, $equalFrom, $equalTo);
}





sub ReplaceAttrNameAbbrev {
	my $self = shift;
	my $inStr = shift;
	my $Full = &PerlWare::NWDSReplaceAttrNameAbbrev($self->{CONTEXT}, $inStr);
	if (!defined($Full)) {
	  $self->{LAST_ERR} = &PerlWare::GetLastErr();
	  warn "ReplaceAttrNameAbbrev returning <undef>\n" if $self->{DEBUG};
     undef;
	}else { $Full; }
}





sub SetDefNameContext {
	my $self = shift;
	my ($NameContext) = @_;
	my $Len = length($NameContext);
   return &PerlWare::NWDSSetDefNameContext($self->{CONTEXT}, $Len, $NameContext);
}



sub VerifyObjectPassword {
	my $self = shift;
	my ($opt, $objectName, $Passwd) = @_;
	return &PerlWare::NWDSVerifyObjectPassword($self->{CONTEXT}, $opt, $objectName, $Passwd);
}



sub WhoAmI {
        my $self = shift;
        my $MyCN = &PerlWare::NWDSWhoAmI($self->{CONTEXT});
	if (!defined($MyCN)) {
	  $self->{LAST_ERR} = &PerlWare::GetLastErr();
	  warn "WhoAmI returning <undef>\n" if $self->{DEBUG};
          undef;
	}else { $MyCN; }
}





1;

__END__


