#if ! defined ( PAUDIT_H )
#define PAUDIT_H

#define PERL_VOLUME_AUDIT 1
#define PVA 1
#define PERL_CONTAINER_AUDIT 2
#define PCA 2

// Extra Container auditing events not defined in SDK .h file
#define ADS_RESEND_ENTRY         168
#define ADS_MUTATE_ENTRY         169
#define ADS_MERGE_ENTRIES        170
#define ADS_END_UPDATE_REPLICA   171
#define ADS_END_UPDATE_SCHEMA    172
#define ADS_CREATE_BACKLINK      173
#define ADS_MODIFY_ENTRY         174
#define ADS_NEW_SCHEMA_EPOCH     176
#define ADS_CLOSE_BINDERY_RECORDS   177
#define ADS_OPEN_BINDERYRECORDS     178

// Extra Volume auditing events not defined in SDK .h file
#define A_EVENT_REMOTE_ADD_NS    263
#define A_EVENT_REMOTE_DISMOUNT  264
#define A_EVENT_REMOTE_EXE    265
#define A_EVENT_REMOTE_LOAD   266
#define A_EVENT_REMOTE_MOUNT  267
#define A_EVENT_REMOTE_SET    268
#define A_EVENT_REMOTE_UNLOAD 269



/* The first audit version to use unicode for Container auditing */
#define AUD_CONTAINER_UNI {5, 2, 3, 0}

/* Macro to create a 32 bit value from 4 8bit */
#define FOUR_U8_TO_U32(a, b, c, d)              \
                        (                       \
         (nuint32)                                \
         ( ( ( (nuint32) (nuint8) (a) )<<24 ) |   \
         ( ( (nuint32) (nuint8) (b) )<<16 ) |     \
         ( ( (nuint32) (nuint8) (c) )<<8  ) |     \
         ( ( (nuint32) (nuint8) (d) )      )      \
         ))


#endif
