/*
        +==========================================================+
        |                                                          |
        |           Novell NDS* extension for NT Perl              |
        |           --------------------------------               |
        |           PerlWare.xs : Implements all NDS* methods.     |
        |                                                          |
        |            by Steinar Kleven <stk@ahs.hist.no>           |
        |                                                          |
        |                  version 1.0                             |
        |                                                          |
        |                                                          |
        | Copyright (c) 1997 Steinar Kleven. All rights reserved.  |
        |   This program is NOT free software, you can NOT         |
        |   redistribute it and/or modify it.                      |
        |                                                          |
        |                                                          |
        |  * NDS is a trademark of Novell INC.                     |
        +==========================================================+
*/




/* Turn of these annoying "Structure packing size .." Warnings */
#if defined(__BORLANDC__)
        #pragma warn -pck
#endif


#ifdef NLM_PLATFORM
  #define N_PLAT_NETWARE
  #define N_PLAT_NLM
  #define N_ARCH_32
  #ifndef LC_ALL
    #define LC_ALL 0
  #endif
  #undef _Windows
#endif


#define MYLOWORD(l)           ((nuint16)(l))
#define MYHIWORD(l)           ((nuint16)(((nuint32)(l) >> 16) & 0xFFFF))

#if !defined(N_PLAT_NLM)
  #define WIN32_LEAN_AND_MEAN
  #include <windows.h>
#endif // !N_PLAT_NLM

#include <fcntl.h>
#include <stdio.h>

/* Novell SDK includes */
#ifdef __cplusplus
extern "C" {
#endif
#include "nwdsapi.h"
#include "nwnet.h"
#include "nwcalls.h"
#include "nwlocale.h"
#ifdef __cplusplus
}
#endif


#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#undef _open_osfhandle


/* #include <io.h> */


/* PerlWare headers */
#include "PerlWare.h"


typedef struct _replica_type
{
   nuint16 s1;
   nuint16 s2;
} replica_type;



/* ErrCode is set to the return value of last NW* called.
   Users creating scripts based on this extension can
   retrieve this by calling LastErr at class the error aqured.
*/



NWDSCCODE N_API ErrCode = 0;



#define CONV_SIZE 8192


/* If you want to use the internal debugging you should define this.
   You can comment it out if you want this extension to go 1 ns. faster. (whitout
   possibilities of turning it on.
*/

// The different debug types OR'ed


#define DBG_ARGS 0x1
#define DBG_NWRET 0x2
#define DBG_DUMP 0x4
#define DBG_CONV 0x8
// #define NDSM_DBG (DBG_CONV|DBG_ARGS|DBG_NWRET|DBG_DUMP)
#undef NDSM_DBG
#if (NDSM_DBG > 0)
#define DBGMSG(_x_)  if (_dbglvl _x_){ printf("%s, %d: ",__FILE__,__LINE__); \
                     _dbgprint _x_; }
#else
#define DBGMSG(_x_)
#endif






/* This section handles messages of different sorts */

/* Debug, Errors aso */

#if (NDSM_DBG > 0)
bool _dbglvl(int type, char *format, ...)
{
/*   va_list ap;
   va_start(ap, format);
   va_end(ap);  */
 return (type && NDSM_DBG);
}


int _dbgprint(int type, char *format, ...)
{
   va_list ap;
   int cnt;
   va_start(ap, type);
   cnt = va_arg(ap, int);

   if (NDSM_DBG & type)
   {
      cnt = vprintf(format, ap);
   }
   va_end(ap);
   return(cnt);
}
#endif





MODULE = PerlWare  PACKAGE = PerlWare  PREFIX = ndsm_
PROTOTYPES: ENABLE


long
ndsm_constant(name, arg)
        char *          name
        int             arg
        CODE:
                RETVAL = constant(name, arg);
    OUTPUT:
                RETVAL

# /* Returns the last ErrCode */
long
ndsm_GetLastErr()
        CODE:
      RETVAL = ErrCode;
        OUTPUT:
      RETVAL


# /* Set the registration info in .LIB */
void
ndsm_SetRegInfo(Key, Code)
                char *Key;
      long Code;
        CODE:
           libSetRegInfo(Key, Code);


#/*
#Taken from service group: misc functions
#*/


# /* Implemented in *.pm         */
NWDSCCODE
ndsm_NWCallsInit(unused1,unused2)
                void * unused1
                void * unused2
        CODE:
                RETVAL = NWCallsInit(NULL, NULL);
        OUTPUT:
                RETVAL



# /* Implemented in *.pm         */
NWDSCCODE
ndsm_NWCallsTerm(unused1)
                void * unused1 = NULL;
        CODE:
                RETVAL = NWCallsTerm(unused1);
        OUTPUT:
                RETVAL




#/*
#Taken from service group: Internationalization
#*/

#/* NWLlocaleconv() is a paint in the ...
# returns a list: (code_page, country_if) containing the values of the LCONV structure. */
#/* Implemented in NDSContext.pm        */
void
ndsm_NWLlocaleconv()
        PREINIT:
                LCONV *lConvInfo;
        PPCODE:
                New(0, lConvInfo, 1, LCONV);
                NWLlocaleconv(lConvInfo);
                EXTEND(sp, 2);
                PUSHs(sv_2mortal((SV*)newSViv(lConvInfo->code_page)));
                PUSHs(sv_2mortal((SV*)newSViv(lConvInfo->country_id)));
                Safefree(lConvInfo);



#/*
#Taken from service group: Unicode
#*/

#/* Implemented in NDSContext.pm                */
NWDSCCODE
ndsm_NWInitUnicodeTables(countryCode, codePage)
                nint countryCode
                nint codePage
        CODE:
                RETVAL = NWInitUnicodeTables(countryCode, codePage);
        OUTPUT:
                RETVAL


#/* Implemented as destructor in NDSContext.pm  */
NWDSCCODE
ndsm_NWFreeUnicodeTables()
        CODE:
                RETVAL = NWFreeUnicodeTables();
        OUTPUT:
                RETVAL


#/*
#Taken from service group NDS:
#*/


#/* Returns one singe string or undef on failure */
#/* Implemented in NDSContext.pm                */
void
ndsm_NWDSAbbreviateName(NDScontext, inName)
                NWDSContextHandle NDScontext
                pnstr8 inName
        PREINIT:
                pnstr8 abbreviatedName;
        PPCODE:
                Newz(0, abbreviatedName, 2*(MAX_RDN_CHARS+1), nstr8);
                ErrCode = NWDSAbbreviateName(NDScontext, inName, abbreviatedName);
                EXTEND(sp, 1);
                if (!ErrCode)
                {
                  PUSHs(sv_2mortal((SV*)newSVpv(abbreviatedName, strlen(abbreviatedName))));
                }else{
                  PUSHs(&sv_undef);
                }
                Safefree(abbreviatedName);






#/*ndsm_NWDSAddfilterToken() NOT IMPLEMENTED */






#/* Implemented in NDSContext   */
NWDSCCODE
ndsm_NWDSAddSecurityEquiv(NDScontext, equalFrom, equalTo)
                NWDSContextHandle   NDScontext
                pnstr8             equalFrom
                pnstr8             equalTo
        CODE:
                RETVAL = NWDSAddSecurityEquiv(NDScontext, equalFrom, equalTo);
        OUTPUT:
                RETVAL




#/* ndsm_NWDSAllocFilter() is not implemented */


void
ndsm_NWDSAuditGetObjectID (context, objectName)
      NWDSContextHandle     context;
      pnstr8                objectName;
   PREINIT:
      NWCONN_HANDLE  conn;
      nuint32        objectID;
   PPCODE:
      ErrCode = NWDSAuditGetObjectID(context, objectName, &conn, &objectID);
                DBGMSG((DBG_NWRET, "NWDSAuditGetObjectID returned code: %X\n", ErrCode));
           if (!ErrCode)
        {
           EXTEND(sp, 2);
                PUSHs(sv_2mortal((SV*)newSViv(conn)));
                PUSHs(sv_2mortal((SV*)newSViv(objectID)));
           }else{
           EXTEND(sp, 1);
                PUSHs(&sv_undef);
        }


# /* Not implemented in 1.0 */
# NWDSCCODE
# ndsm_NWDSAuthenticate(conn, optionsFlag, sessionKey)
#                NWCONN_HANDLE           conn;
#                nflag32                 optionsFlag=NO_INIT;
#                pNWDS_Session_Key_T     sessionKey=NO_INIT;
#        CODE:
#                optionsFlag = 0;
#                sessionKey = NULL;
#                RETVAL = NWDSAuthenticate(conn, optionsFlag, sessionKey);
#        OUTPUT:
#                RETVAL


#/* NWDSAuthenticateConn() is moved to NWServer.xs*/

# /* Not implemented in 1.0, should be in Buf_T */
# NWDSCCODE
# ndsm_NWDSBackupObject(NDScontext, objectName, iterationHandle, objectInfo)
#                NWDSContextHandle   NDScontext
#                pnstr8              objectName
#                nint32              iterationHandle
#                pBuf_T              objectInfo
#        CODE:
#                RETVAL = NWDSBackupObject(NDScontext, objectName, &iterationHandle, objectInfo);
#        OUTPUT:
#                iterationHandle
#                objectInfo
#                RETVAL



#/* Implemented in NDSContext.pm                */
NWDSCCODE
ndsm_NWDSCanDSAuthenticate(NDScontext)
                NWDSContextHandle   NDScontext
        CODE:
                RETVAL = NWDSCanDSAuthenticate(NDScontext);
        OUTPUT:
                RETVAL


#/* Implemented in NDSContext.pm                        */
void
ndsm_NWDSCanonicalizeName(NDScontext, objectName)
                NWDSContextHandle   NDScontext
                pnstr8              objectName
        PREINIT:
                pnstr8              canonName;
        PPCODE:
                Newz(0, canonName, 2*(MAX_RDN_CHARS+1), char);
                ErrCode = NWDSCanonicalizeName(NDScontext, objectName, canonName);
                EXTEND(sp, 1);
                if (!ErrCode)
                {
                  PUSHs(sv_2mortal((SV*)newSVpv(canonName, strlen(canonName))));
                }else{
                  PUSHs(&sv_undef);
                }
                Safefree(canonName);


#/* Implemented in NDSContext.pm                        */
NWDSCCODE
ndsm_NWDSChangeObjectPassword(NDScontext, optionsFlag, objectName, oldPassword, newPassword)
                NWDSContextHandle   NDScontext
                nflag32             optionsFlag
                pnstr8              objectName
                pnstr8              oldPassword
                pnstr8              newPassword
        CODE:
                RETVAL = NWDSChangeObjectPassword(NDScontext, optionsFlag, objectName, oldPassword, newPassword);
        OUTPUT:
                RETVAL



#/* Not used in ver 1.0. Besides this is easy in perl */
# NWDSCCODE
# ndsm_NWDSCIStringsMatch(NDScontext, string1, string2, matches)
#                 NWDSContextHandle   NDScontext
#                pnstr8              string1
#                pnstr8              string2
#                nint                matches
#        CODE:
#                RETVAL = NWDSCIStringsMatch(NDScontext, string1, string2, &matches);
#        OUTPUT:
#                matches
#                RETVAL




#/* NWDSCreateContext() is obsolete 03/97) */
#/* See NWDSCreateContextHandle()        	 */
# NWDSContextHandle
# ndsm_NWDSCreateContext()
#         CODE:
#                RETVAL = NWDSCreateContext();
#        OUTPUT:
#                RETVAL



#/* Implemented in NDSContext.pm                        */
void
ndsm_NWDSCreateContextHandle()
        PREINIT:
                NWDSContextHandle       newHandle;
        PPCODE:
                ErrCode = NWDSCreateContextHandle(&newHandle);
                EXTEND(sp, 1);
                if (!ErrCode)
                {
                  PUSHs(sv_2mortal((SV*)newSViv(newHandle)));
                }else{
                  PUSHs(&sv_undef);
                }


#/* ndsm_NWDSDefineAttr() is not implemented */


#/* ndsm_NWDSDefineClass() is not implemented */


#/* ndsm_NWDSDelFilterToken() is not implemented */


#/* Not used in 1.0 */
# NWDSContextHandle
# ndsm_NWDSDuplicateContext(oldContext)
#                NWDSContextHandle   oldContext
#        CODE:
#                RETVAL = NWDSDuplicateContext(oldContext);
#        OUTPUT:
#                RETVAL


#/* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSDuplicateContextHandle(srcContextHandle, destContextHandle)
#                 NWDSContextHandle       srcContextHandle
#                NWDSContextHandle       destContextHandle
#        CODE:
#                RETVAL = NWDSDuplicateContextHandle(srcContextHandle, &destContextHandle);
#        OUTPUT:
#                destContextHandle
#                RETVAL

#/* ndsm_NWDSExtSyncList() is not implemented */


#/* ndsm_NWDSExtSyncRead() is not implemented */


#/* ndsm_NWDSExtSyncSearch() is not implemented */



#/* Implemented in NDSContext.pm                */
NWDSCCODE
ndsm_NWDSFreeContext(contextHandle)
                NWDSContextHandle contextHandle
        CODE:
                RETVAL = NWDSFreeContext(contextHandle);
        OUTPUT:
                RETVAL


#/* ndsm_NWDSFreeFilter() is not implemented */


NWDSCCODE
ndsm_NWDSGenerateObjectKeyPair(NDScontext, objectName, objectPassword, optionsFlag)
                NWDSContextHandle   NDScontext
                pnstr8              objectName
                pnstr8              objectPassword
                nflag32             optionsFlag
        CODE:
                RETVAL = NWDSGenerateObjectKeyPair(NDScontext, objectName, objectPassword, optionsFlag);
        OUTPUT:
                RETVAL





# /* Not implemented in 1.0 */
# NWDSCCODE
# ndsm_NWDSGetBinderyContext(NDScontext, conn, BinderyEmulationContext)
#                NWDSContextHandle   NDScontext
#                NWCONN_HANDLE       conn
#                pnstr8              BinderyEmulationContext
#        CODE:
#                RETVAL = NWDSGetBinderyContext(NDScontext, conn, (unsigned char*)BinderyEmulationContext);
#        OUTPUT:
#                BinderyEmulationContext
#                RETVAL


#/* Not implemented in 1.0 */
# NWDSCCODE
# ndsm_NWDSGetClassDef(NDScontext, genbuf, className, classInfo)
#                 NWDSContextHandle   NDScontext;
#                pBuf_T              genbuf;
#                pnstr8              className;
#                pClass_Info_T       classInfo;
#        CODE:
#                RETVAL = NWDSGetClassDef(NDScontext, genbuf, className, classInfo);
#        OUTPUT:
#                className
#                classInfo
#                RETVAL


#/* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSGetClassDefCount(NDScontext, genbuf, classDefCount)
#                NWDSContextHandle       NDScontext;
#                pBuf_T                  genbuf;
#                nuint32                 classDefCount;
#        CODE:
#                RETVAL = NWDSGetClassDefCount(NDScontext, genbuf, &classDefCount);
#        OUTPUT:
#                classDefCount
#                RETVAL


#/* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSGetClassItem (NDScontext, genbuf, itemName)
#                NWDSContextHandle   NDScontext;
#                pBuf_T              genbuf;
#                pnstr8              itemName;
#        CODE:
#                RETVAL = NWDSGetClassItem (NDScontext, genbuf, itemName);
#        OUTPUT:
#                itemName
#                RETVAL


#/* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSGetClassItemCount (NDScontext, genbuf, itemCount)
#                NWDSContextHandle   NDScontext;
#                pBuf_T              genbuf;
#                nuint32            itemCount;
#        CODE:
#                RETVAL = NWDSGetClassItemCount (NDScontext, genbuf, &itemCount);
#        OUTPUT:
#                itemCount
#                RETVAL






# /* Implemented in PerlWare.pm                */
void
ndsm_NWDSGetContext (NDScontext, key)
                NWDSContextHandle       NDScontext;
                nint                            key;
        PREINIT:
                SV*                                             Ret;
                nptr                            value;
                nuint32                                 MyInt;
        PPCODE:
                DBGMSG((DBG_ARGS, "NWDSGetContext got (%d, %d)\n", NDScontext, key));
                switch (key){
                case DCK_FLAGS:
                case DCK_CONFIDENCE:
                case DCK_REFERRAL_SCOPE:
                case DCK_LAST_CONNECTION:
                        value = &MyInt;
                        ErrCode = NWDSGetContext (NDScontext, key, value);
                        Ret = newSViv(MyInt);
                break;
                case DCK_NAME_CONTEXT:
                case DCK_TREE_NAME:
                        Newz(0, value, 2*(MAX_DN_CHARS+1), char);
                        ErrCode = NWDSGetContext (NDScontext, key, value);
                        Ret = newSVpv((char*)value, strlen((const char*)value));
                        Safefree(value);
                break;
                default:
                        croak("Illegal key type received in NWDSGetContext: %d.\n", key);
                };
                EXTEND(sp, 1);
                if (!ErrCode)
                {
                  PUSHs(sv_2mortal((SV*)Ret));
                }else{
                  PUSHs(&sv_undef);
                }



# /* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSGetCountByClassAndName (NDScontext, objectName, className, subordinateName, count)
#                NWDSContextHandle   NDScontext;
#                pnstr8              objectName;
#                pnstr8              className;
#                pnstr8              subordinateName;
#                nint32              count;
#        CODE:
#                RETVAL  = NWDSGetCountByClassAndName (NDScontext, objectName, className, subordinateName, &count);
#        OUTPUT:
#                count
#          RETVAL


# /* Implemented in NDSContext.pm        */
void
ndsm_NWDSGetDefNameContext (NDScontext)
                NWDSContextHandle   NDScontext;
        PREINIT:
                nuint               nameContextLen;
                pnstr8              nameContext;
        PPCODE:
                Newz(0, nameContext, 514, char);
                nameContextLen = 514;
                ErrCode = NWDSGetDefNameContext (NDScontext, nameContextLen, nameContext);
                EXTEND(sp, 1);
                if (!ErrCode)
                {
                  PUSHs(sv_2mortal((SV*)newSVpv(nameContext, strlen(nameContext))));
                }else{
                  PUSHs(&sv_undef);
                }
                Safefree(nameContext);


# /* Finnes ikke i NWNET.DLL */
# NWDSCCODE
# ndsm_NWDSGetDSIInfo (NDScontext, genbuf, bufLen, infoFlag, data)
#   NWDSContextHandle   NDScontext;
#   nptr                genbuf;
#   nuint32             bufLen;
#   nuint32             infoFlag;
#   nptr                data;
#   CODE:
#       RETVAL = NWDSGetDSIInfo (NDScontext, genbuf, bufLen, infoFlag, data);
#       OUTPUT:
#   data
#   RETVAL



# /* Not used and should be moved to NWServer.xs */
# void
# ndsm_NWDSGetDSVerInfo (conn)
#                NWCONN_HANDLE  conn;
#        PREINIT:
#                nuint32                 dsVersion;
#                nuint32                 rootMostEntryDepth;
#                pnstr8          sapName;
#                nuint32                 flags;
#                punicode        treeName;
#                pnuint8                         treeName8;
#                nptr                            ruleHandle;
#                size_t                  len;
#        PPCODE:
#                Newz(0, sapName, MAX_SAP_NAME_CHARS, char);
#                Newz(0, treeName, NW_MAX_TREE_NAME_BYTES, unicode);
#                ErrCode = NWDSGetDSVerInfo (conn, &dsVersion, &rootMostEntryDepth, sapName, &flags, treeName);
 #                if(!ErrCode)
#                {
#                  ErrCode = NWGetUnicodeToLocalHandle(&ruleHandle);
 #                  if (!ErrCode)
#                  {
#                         New(0, treeName8, NW_MAX_TREE_NAME_BYTES, unsigned char);
#                         ErrCode = NWUnicodeToLocal(ruleHandle, treeName8, (size_t)NW_MAX_TREE_NAME_BYTES, treeName, 0, &len);
 #                         if (!ErrCode)
#                         {
#                                EXTEND(sp, 5);
#                                PUSHs(sv_2mortal(newSViv(dsVersion)));
#                                PUSHs(sv_2mortal(newSViv(rootMostEntryDepth)));
#                                PUSHs(sv_2mortal(newSVpv(sapName, na)));
#                                PUSHs(sv_2mortal(newSViv(flags)));
#                                PUSHs(sv_2mortal(newSVpv((char*)treeName8, na)));
#                         }
#                         Safefree(treeName8);
#                  }
#                }
 #                if (ErrCode){
#                  PUSHs(&sv_undef);
#                }
#                Safefree(sapName);
#                Safefree(treeName);


#/* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSGetEffectiveRights (NDScontext, subjectName, objectName, attrName, privileges)
#                NWDSContextHandle   NDScontext;
#                pnstr8              subjectName;
#                pnstr8              objectName;
#                pnstr8              attrName;
#                nuint32             privileges;
#        CODE:
#                RETVAL = NWDSGetEffectiveRights (NDScontext, subjectName, objectName, attrName, &privileges);
#        OUTPUT:
#                privileges
#                RETVAL


# / *Not used in 1.0 and should be moved to NWServer */
# NWDSCCODE
# ndsm_NWDSGetMonitoredConnection(conn)
#                NWCONN_HANDLE          conn;
#        CODE:
#                RETVAL = NWDSGetMonitoredConnection(&conn);
#        OUTPUT:
#                conn
#                RETVAL


# /* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSGetMonitoredConnRef (NDScontext, connRef)
#                NWDSContextHandle   NDScontext;
#                nuint32            connRef;
#        CODE:
#                RETVAL = NWDSGetMonitoredConnRef (NDScontext, &connRef);
#        OUTPUT:
#                connRef
#                RETVAL



# /* ndsm_NWDSGetNDSStatistics ()  Not implemented */



# /* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSGetObjectHostServerAddress (NDScontext, objectName, serverName, netAddresses)
#                NWDSContextHandle   NDScontext;
#                pnstr8              objectName;
#                pnstr8              serverName;
#                pBuf_T              netAddresses;
#        CODE:
#                RETVAL = NWDSGetObjectHostServerAddress (NDScontext, objectName, serverName, netAddresses);
#        OUTPUT:
#                serverName
#                netAddresses
#                RETVAL




# /*NWDSCCODE ndsm_NWDSGetObjectNameAndInfo() not implemented */



# /* Finnes ikke i NETWIN32.DLL
# void
# ndsm_NWDSGetPartitionExtInfo (NDScontext, infoPtr, limit, infoFlag, length, data)
#      NWDSContextHandle   NDScontext;
#      pnstr8              infoPtr;
#      pnstr8              limit;
#      nflag32             infoFlag;
#   PREINIT:
#      nuint32             length;
#      nptr                data;
#   PPCODE:
#      ErrCode = NWDSGetPartitionExtInfo (NDScontext, infoPtr, limit, infoFlag, &length, data);
 #           AAA if(!ErrCode) 
#               {
#        EXTEND(sp, 2);
#                 PUSHs(sv_2mortal((SV*)newSViv(length)));
#        switch (infoFlag)
#        {
#         case DSP_PARTITION_ID:
#         case DSP_REPLICA_STATE:
#         case DSP_LOCAL_PARTITION_ID:
#         case DSP_REPLICA_TYPE:
#         case DSP_PARTITION_BUSY:
#                 PUSHs(sv_2mortal((SV*)newSViv((nuint32)data)));
#         break;
#        case DSP_MODIFICATION_TIMESTAMP:
#         case DSP_PURGE_TIME:
#         break;
#         case DSP_PARTITION_DN:
#                 PUSHs(sv_2mortal((SV*)newSVpv(data, strlen(data))));
#        }
#      }                        */



# /* Finnes ikke i NETWIN32.DLL */
# NWDSCCODE
# ndsm_NWDSGetPartitionExtInfoPtr (NDScontext, genbuf)
#      NWDSContextHandle   NDScontext;
#      pBuf_T              genbuf;
#   PREINIT:
#      ppnstr8             infoPtr;
#      ppnstr8             infoPtrEnd;
#   PPCODE:
#      ErrCode = NWDSGetPartitionExtInfoPtr (NDScontext, genbuf, infoPtr, infoPtrEnd);
 #        if (!ErrCode) 
#               {
#        EXTEND(sp, 2);
#                 PUSHs(sv_2mortal((SV*)newSViv((nuint32)infoPtr)));
#                 PUSHs(sv_2mortal((SV*)newSViv((nuint32)infoPtrEnd)));
#      }



# /* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSGetServerAddresses(NDScontext, conn, countNetAddress, netAddresses)
#                NWDSContextHandle   NDScontext;
#                NWCONN_HANDLE       conn;
#                nuint32             countNetAddress;
#                pBuf_T              netAddresses;
#        CODE:
#                RETVAL = NWDSGetServerAddresses(NDScontext, conn, &countNetAddress, netAddresses);
#        OUTPUT:
#                countNetAddress
#                netAddresses
#                RETVAL


# /* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSGetServerDN (NDScontext, conn, serverDN)
#                NWDSContextHandle   NDScontext;
#                NWCONN_HANDLE       conn;
#                pnstr8              serverDN;
#        CODE:
#                RETVAL  = NWDSGetServerDN (NDScontext, conn, serverDN);
#        OUTPUT:
#                serverDN
#                RETVAL


# /* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSGetSyntaxCount (NDScontext, genbuf, syntaxCount)
#                NWDSContextHandle   NDScontext;
#                pBuf_T              genbuf;
#                nuint32            syntaxCount;
#        CODE:
#                RETVAL = NWDSGetSyntaxCount (NDScontext, genbuf, &syntaxCount);
#        OUTPUT:
#                syntaxCount
#                RETVAL


#/* NWDSCCODE ndsm_NWDSGetSyntaxDef () not implemented */


#/* Not used in 1.0 */
# void
# ndsm_NWDSGetSyntaxID (NDScontext, attrName)
#                NWDSContextHandle   NDScontext;
#                pnstr8              attrName;
#        PREINIT:
#                nuint32             syntaxID;
#        PPCODE:
#                ErrCode = NWDSGetSyntaxID (NDScontext, attrName, &syntaxID);
#                EXTEND(sp, 1);
 #                if (!ErrCode)
#                {
#                  PUSHs(sv_2mortal(newSViv(syntaxID)));
#                }else{
#                  PUSHs(&sv_undef);
#                }



# /* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSInspectEntry (NDScontext, serverName, objectName, errBuffer)
#                NWDSContextHandle   NDScontext;
#                pnstr8              serverName;
#                pnstr8              objectName;
#                pBuf_T              errBuffer;
#        CODE:
#                RETVAL = NWDSInspectEntry (NDScontext, serverName, objectName, errBuffer);
#        OUTPUT:
#                errBuffer
#                RETVAL






# /* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSListAttrsEffectiveRights (NDScontext, objectName, subjectName, allAttrs, attrNames, iterationHandle, privilegeInfo)
#                NWDSContextHandle   NDScontext;
#                pnstr8              objectName;
#                pnstr8              subjectName;
#                nbool8              allAttrs;
#                pBuf_T              attrNames;
#                nint32              iterationHandle;
#                pBuf_T              privilegeInfo;
#        CODE:
#                RETVAL = NWDSListAttrsEffectiveRights (NDScontext, objectName, subjectName, allAttrs, attrNames, &iterationHandle, privilegeInfo);
#        OUTPUT:
#                iterationHandle
#                privilegeInfo
#                RETVAL


# /* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSListByClassAndName (NDScontext, objectName, className, subordinateName, iterationHandle, subordinates)
#                NWDSContextHandle   NDScontext;
#                pnstr8              objectName;
#                pnstr8              className;
#                pnstr8              subordinateName;
#                nint32              iterationHandle;
#                pBuf_T              subordinates;
#        CODE:
#                RETVAL = NWDSListByClassAndName (NDScontext, objectName, className, subordinateName, &iterationHandle, subordinates);
#        OUTPUT:
#                iterationHandle
#                subordinates
#                RETVAL


# /* Not used in 1.0, move to Buf_T */
# NWDSCCODE
# ndsm_NWDSListContainableClasses (NDScontext, parentObject, iterationHandle, containableClasses)
#                NWDSContextHandle   NDScontext;
#                pnstr8              parentObject;
#                nint32              iterationHandle;
#                pBuf_T              containableClasses;
#        CODE:
#                RETVAL = NWDSListContainableClasses (NDScontext, parentObject, &iterationHandle, containableClasses);
#        OUTPUT:
#                iterationHandle
#                containableClasses
#                RETVAL


# /* Not used in 1.0, move to Buf_T */
# NWDSCCODE
# ndsm_NWDSListContainers (NDScontext, object, iterationHandle, subordinates)
#                NWDSContextHandle   NDScontext;
#                pnstr8              object;
#                nint32              iterationHandle;
#                pBuf_T              subordinates;
#        CODE:
#                RETVAL = NWDSListContainers (NDScontext, object, &iterationHandle, subordinates);
#        OUTPUT:
#                iterationHandle
#                subordinates
#                RETVAL



# /* Fantes ikke i NETWIN32.DLL
# NWDSCCODE
# ndsm_NWDSListPartitionsExtInfo (NDScontext, iterationHandle, server, DSPFlags, partitions)
#   NWDSContextHandle   NDScontext;
#   pnint32             iterationHandle;
#   pnstr8              server;
#   nflag32             DSPFlags;
#   pBuf_T              partitions;
#   CODE:
#   RETVAL = NWDSListPartitionsExtInfo (NDScontext, iterationHandle, server, DSPFlags, partitions);
#   OUTPUT:
#   iterationHandle
#   partitions


#/*
#  NWDSLockConnection( ) is Obsolete 6/96
#  Call NWCCLicenseConn instead.
#*/
# NWDSCCODE
# ndsm_NWDSLockConnection (conn)
#                NWCONN_HANDLE   conn;
#        CODE:
#                RETVAL = NWDSLockConnection (conn);
#        OUTPUT:
#                RETVAL



# /* Implemented in NDSContext.pm        */
NWDSCCODE
ndsm_NWDSLogin (NDScontext, optionsFlag, objectName, password, validityPeriod)
                NWDSContextHandle   NDScontext;
                nflag32             optionsFlag;
                pnstr8              objectName;
                pnstr8              password;
                nuint32             validityPeriod;
        CODE:
                RETVAL = NWDSLogin (NDScontext, optionsFlag, objectName, password, validityPeriod);
        OUTPUT:
                RETVAL




NWDSCCODE
ndsm_LocalLogin (NDScontext)
                NWDSContextHandle   NDScontext;
        CODE:
#ifdef N_PLAT_NLM
                RETVAL = NWDSLoginAsServer (NDScontext);
#else
								RETVAL = -1;
                printf("localLogin() not supported on this platform\n");
#endif
        OUTPUT:
                RETVAL



#/* Implemented in NDSContext.pm        */
NWDSCCODE
ndsm_NWDSLogout (NDScontext)
                NWDSContextHandle   NDScontext;
        CODE:
                RETVAL = NWDSLogout (NDScontext);
        OUTPUT:
                RETVAL


# /* This is not implemented in any .pm, but included on request */
NWDSCCODE
ndsm_NWDSMapIDToName (NDScontext, conn, objectID, object)
                NWDSContextHandle   NDScontext;
                NWCONN_HANDLE       conn;
                nuint32             objectID;
                pnstr8              object;
        CODE:
                RETVAL = NWDSMapIDToName (NDScontext, conn, objectID, object);
        OUTPUT:
                object
                RETVAL


#/* NWDSMapNameToID() is moved to NWServer.pm  */

#/* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSModifyClassDef (NDScontext, className, optionalAttrs)
#                NWDSContextHandle   NDScontext;
#                pnstr8              className;
#                pBuf_T              optionalAttrs;
#        CODE:
#                RETVAL = NWDSModifyClassDef (NDScontext, className, optionalAttrs);
#        OUTPUT:
#                RETVAL


# /* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSModifyDN (NDScontext, objectName, newDN, deleteOldRDN)
#                NWDSContextHandle   NDScontext;
#                pnstr8              objectName;
#                pnstr8              newDN;
#                nbool8              deleteOldRDN;
#        CODE:
#                RETVAL = NWDSModifyDN (NDScontext, objectName, newDN, deleteOldRDN);
#        OUTPUT:
#                RETVAL


#/* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSModifyRDN (NDScontext, objectName, newDN, deleteOldRDN)
#                NWDSContextHandle   NDScontext;
#                pnstr8              objectName;
#                pnstr8              newDN;
#                nbool8              deleteOldRDN;
#        CODE:
#                RETVAL = NWDSModifyRDN (NDScontext, objectName, newDN, deleteOldRDN);
#        OUTPUT:
#                RETVAL


#/* Implemented in NDSContext.pm        */
NWDSCCODE
ndsm_NWDSMoveObject (NDScontext, objectName, destParentDN, destRDN)
                NWDSContextHandle   NDScontext;
                pnstr8              objectName;
                pnstr8              destParentDN;
                pnstr8              destRDN;
        CODE:
                RETVAL = NWDSMoveObject (NDScontext, objectName, destParentDN, destRDN);
        OUTPUT:
                RETVAL


# /* Not used in 1.0 */                
# NWDSCCODE
# ndsm_NWDSOpenConnToNDSServer (NDScontext, serverName, connHandle)
#                NWDSContextHandle   NDScontext;
#                pnstr8              serverName;
#                NWCONN_HANDLE       connHandle;
#        CODE:
#                RETVAL = NWDSOpenConnToNDSServer (NDScontext, serverName, &connHandle);
#        OUTPUT:
#                connHandle
#                RETVAL


# /* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSOpenMonitoredConn (NDScontext, connHandle)
#                NWDSContextHandle   NDScontext;
#                NWCONN_HANDLE      connHandle;
#        CODE:
#                RETVAL = NWDSOpenMonitoredConn (NDScontext, &connHandle);
#        OUTPUT:
#                connHandle
#                RETVAL





#/* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSPutClassItem (NDScontext, genbuf, itemName)
#                NWDSContextHandle   NDScontext;
#                pBuf_T              genbuf;
#                pnstr8              itemName;
#        CODE:
#                RETVAL = NWDSPutClassItem (NDScontext, genbuf, itemName);
#        OUTPUT:
#                RETVAL



#/* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSPutClassName (NDScontext, genbuf, itemName)
#                NWDSContextHandle   NDScontext;
#                pBuf_T              genbuf;
#                pnstr8              itemName;
#        CODE:
#                RETVAL = NWDSPutClassName (NDScontext, genbuf, itemName);
#        OUTPUT:
#                RETVAL


#/* NWDSCCODE ndsm_NWDSPutFilter () is not implemented */

#/* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSPutSyntaxName (NDScontext, genbuf, syntaxName)
#                NWDSContextHandle   NDScontext;
#                pBuf_T              genbuf;
#                pnstr8              syntaxName;
#        CODE:
#                RETVAL = NWDSPutSyntaxName (NDScontext, genbuf, syntaxName);
#        OUTPUT:
#                RETVAL


# /* Not used in 1.0, move to Buf_T */
# NWDSCCODE
# ndsm_NWDSReadAttrDef (NDScontext, infoType, allAttrs, attrNames, iterationHandle, attrDefs)
#                NWDSContextHandle   NDScontext;
#                nuint32             infoType;
#                nbool8              allAttrs;
#                pBuf_T              attrNames;
#                nint32              iterationHandle;
#                pBuf_T              attrDefs;
#        CODE:
#                RETVAL = NWDSReadAttrDef (NDScontext, infoType, allAttrs, attrNames, &iterationHandle, attrDefs);
#        OUTPUT:
#                iterationHandle
#                attrDefs
#                RETVAL


#/* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSReadClassDef (NDScontext, infoType, allClasses, classNames, iterationHandle, classDefs)
#                NWDSContextHandle   NDScontext;
#                nuint32             infoType;
#                nbool8              allClasses;
#                pBuf_T              classNames;
#                nint32              iterationHandle;
#                pBuf_T              classDefs;
#        CODE:
#                RETVAL = NWDSReadClassDef (NDScontext, infoType, allClasses, classNames, &iterationHandle, classDefs);
#        OUTPUT:
#                iterationHandle
#                classDefs
#                RETVAL


# /* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSReadObjectInfo (NDScontext, object, distinguishedName, objectInfo)
#                NWDSContextHandle   NDScontext;
#                pnstr8              object;
#                pnstr8              distinguishedName;
#                pObject_Info_T      objectInfo;
#        CODE:
#                RETVAL = NWDSReadObjectInfo (NDScontext, object, distinguishedName, objectInfo);
#        OUTPUT:
#                distinguishedName
#                objectInfo
#                RETVAL


#/* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSReadReferences (NDScontext, serverName, objectName, infoType, allAttrs, attrNames, timeFilter, iterationHandle, objectInfo)
#                NWDSContextHandle   NDScontext;
#                pnstr8              serverName;
#                pnstr8              objectName;
#                nuint32             infoType;
#                nbool8              allAttrs;
#                pBuf_T              attrNames;
#                uint32              timeFilter;
#                nint32              iterationHandle;
#                pBuf_T              objectInfo;
#        CODE:
#                RETVAL = NWDSReadReferences (NDScontext, serverName, objectName, infoType, allAttrs, attrNames, timeFilter, &iterationHandle, objectInfo);
#        OUTPUT:
#                iterationHandle
#                objectInfo
#                RETVAL


# /* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSReadSyntaxDef (NDScontext, syntaxID, syntaxDef)
#                NWDSContextHandle   NDScontext;
#                nuint32             syntaxID;
#                pSyntax_Info_T      syntaxDef;
#        CODE:
#                RETVAL = NWDSReadSyntaxDef (NDScontext, syntaxID, syntaxDef);
#        OUTPUT:
#                syntaxDef
#                RETVAL

# /* Not used in 1.0
# NWDSCCODE
# ndsm_NWDSReadSyntaxes (NDScontext, infoType, allSyntaxes, syntaxNames, iterationHandle, syntaxDefs)
#                NWDSContextHandle   NDScontext;
#                nuint32             infoType;
#                nbool8              allSyntaxes;
#                pBuf_T              syntaxNames;
#                nint32              iterationHandle;
#                pBuf_T              syntaxDefs;
#        CODE:
#                RETVAL = NWDSReadSyntaxes (NDScontext, infoType, allSyntaxes, syntaxNames, &iterationHandle, syntaxDefs);
#        OUTPUT:
#                iterationHandle
#                syntaxDefs
#                RETVAL   



#/* Implemented in NDSContext.pm                */
void
ndsm_NWDSRemoveAllTypes (NDScontext, name)
                NWDSContextHandle   NDScontext;
                pnstr8              name;
                PREINIT:
                pnstr8              typelessName;
        PPCODE:
                Newz(0, typelessName, 2*(MAX_DN_CHARS+1), char);
                ErrCode = NWDSRemoveAllTypes (NDScontext, name, typelessName);
                EXTEND(sp, 1);
                if (!ErrCode)
                {
                  PUSHs(sv_2mortal((SV*)newSVpv(typelessName, strlen(typelessName))));
                }else{
                  PUSHs(&sv_undef);
                }
                Safefree(typelessName);


#/* Not used in 1.0                */
# NWDSCCODE
# ndsm_NWDSRemoveAttrDef (NDScontext, attrName)
#                NWDSContextHandle   NDScontext;
#                pnstr8              attrName;
#        CODE:
#                RETVAL = NWDSRemoveAttrDef (NDScontext, attrName);
#        OUTPUT:
#                RETVAL


#/* Not used in 1.0                */
# NWDSCCODE
# ndsm_NWDSRemoveClassDef (NDScontext, className)
#                NWDSContextHandle   NDScontext;
#        pnstr8              className;
#   CODE:
#   RETVAL = NWDSRemoveClassDef (NDScontext, className);
#   OUTPUT:
#   RETVAL


#/* Implemented in NDSContext.pm                */
NWDSCCODE
ndsm_NWDSRemoveObject (NDScontext, object)
   NWDSContextHandle   NDScontext;
   pnstr8              object;
   CODE:        
   RETVAL = NWDSRemoveObject (NDScontext, object);
   OUTPUT:
   RETVAL



#/* Implemented in NDSContext.pm                */
NWDSCCODE
ndsm_NWDSRemSecurityEquiv (NDScontext, equalFrom, equalTo)
   NWDSContextHandle   NDScontext;
   pnstr8              equalFrom;
   pnstr8              equalTo;
   CODE:
   RETVAL = NWDSRemSecurityEquiv (NDScontext, equalFrom, equalTo);
   OUTPUT:
   RETVAL





#/* Implemented in NDSContext.pm                */
void
ndsm_NWDSReplaceAttrNameAbbrev (NDScontext, inStr)
   NWDSContextHandle   NDScontext;
   pnstr8              inStr;
   PREINIT:
   pnstr8              longName;
   PPCODE:
   Newz(0, longName, 2*(MAX_DN_CHARS+1), char);
   ErrCode = NWDSReplaceAttrNameAbbrev (NDScontext, inStr, longName);
   EXTEND(sp, 1);
   if (!ErrCode)
   {
     PUSHs(sv_2mortal((SV*)newSVpv(longName, strlen(longName))));
   }else{
     PUSHs(&sv_undef);
   }
   Safefree(longName);




# /* Feil i Novell's include og/eller lib
# NWDSCCODE
# ndsm_NWDSResetNDSStatistics (NDScontext, ServerName)
#   NWDSContextHandle   NDScontext;
#   pnstr8                        ServerName;
#   CODE:
#   RETVAL = NWDSResetNDSStatistics (NDScontext, ServerName);
#   OUTPUT:
#   RETVAL


# /* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSResolveName (NDScontext, objectName, conn, objectID)
#   NWDSContextHandle            NDScontext;
#   pnstr8                       objectName;
#   NWCONN_HANDLE                conn;
#   nuint32                      objectID;
#   CODE:
#   RETVAL = NWDSResolveName (NDScontext, objectName, &conn, &objectID);
#   OUTPUT:
#   conn
#   objectID
#   RETVAL


#/* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSRestoreObject (NDScontext, objectName, iterationHandle, more, size, objectInfo)
#   NWDSContextHandle   NDScontext;
#   pnstr8              objectName;
#   nint32              iterationHandle;
#   nbool8              more;
#   nuint32             size;
#   nuint8              objectInfo;
#   CODE:
#   RETVAL = NWDSRestoreObject (NDScontext, objectName, &iterationHandle, more, size, &objectInfo);
#   OUTPUT:
#   RETVAL


#/* NWDSCCODE ndsm_NWDSReturnBlockOfAvailableTrees () is not implemented */


#/* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSScanConnsForTrees (NDScontext, numOfPtrs, numOfTrees, treeBufPtrs)
#        NWDSContextHandle   NDScontext;
#        nuint               numOfPtrs;
#        nuint               numOfTrees;
#        ppnstr8              treeBufPtrs;
#        CODE:
#        RETVAL = NWDSScanConnsForTrees (NDScontext, numOfPtrs, &numOfTrees, treeBufPtrs);
#   OUTPUT:
#   numOfTrees 
#   treeBufPtrs
#   RETVAL


#/* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWDSScanForAvailableTrees (NDScontext, connHandle, scanFilter, scanIndex, treeName)
#        NWDSContextHandle   NDScontext;
#   NWCONN_HANDLE       connHandle;
#   pnstr               scanFilter;
#   nint32              scanIndex;
#   pnstr               treeName;
#   CODE:
#   RETVAL = NWDSScanForAvailableTrees (NDScontext, connHandle, scanFilter, &scanIndex, treeName);
#   OUTPUT:
#   scanIndex
#   treeName
#   RETVAL


# /* Not used in 1.0, move to Buf_T */
# NWDSCCODE
# ndsm_NWDSSearch (NDScontext, baseObjectName, NDSscope, searchAliases, filter, infoType, allAttrs, attrNames, iterationHandle, countObjectsToSearch, countObjectsSearched, objectInfo)
#   NWDSContextHandle   NDScontext;
#   pnstr8              baseObjectName;
#   nint                NDSscope;
#   nbool8              searchAliases;
#   pBuf_T              filter;
#   nuint32             infoType;
#   nbool8              allAttrs;
#   pBuf_T              attrNames;
#   nint32              iterationHandle;
#   nint32              countObjectsToSearch;
#   nint32              countObjectsSearched;
#   pBuf_T              objectInfo;
#   CODE:
#   RETVAL = NWDSSearch (NDScontext, baseObjectName, NDSscope, searchAliases, filter, infoType, allAttrs, attrNames, &iterationHandle, countObjectsToSearch, &countObjectsSearched, objectInfo);
#   OUTPUT:
#   iterationHandle
#   countObjectsSearched
#   objectInfo
#   RETVAL


#/* Implemented in PerlWare.pm */
NWDSCCODE
ndsm_NWDSSetContext (NDScontext, key, value)
   NWDSContextHandle            NDScontext;
   nint                 key;
   SV*                  value;
   PREINIT:
   nptr                                                 ptr;
   nuint32                                      MyInt;
        CODE:
   switch (key){
        case DCK_FLAGS:
        case DCK_CONFIDENCE:
        case DCK_REFERRAL_SCOPE:
        case DCK_LAST_CONNECTION:
        MyInt = SvIV(ST(2));
        ptr = &MyInt;
        break;
        case DCK_NAME_CONTEXT:
        case DCK_TREE_NAME:
        ptr = (nptr)SvPV(value, na);
        DBGMSG((DBG_ARGS, "NWDSSetContext(%d, %d, %s)\n", NDScontext, key, ptr));
        break;
                default:
                        croak("Illegal key type received in NWDSSetContext: %d.\n", key);
   };
   RETVAL = NWDSSetContext (NDScontext, key, ptr);
        DBGMSG((DBG_NWRET, "NWDSSetContext() returns %d\n", RETVAL));
   OUTPUT:
   RETVAL



#/* Implemented in NDSContext.pm                */
NWDSCCODE
ndsm_NWDSSetDefNameContext (NDScontext, nameContextLen, nameContext)
   NWDSContextHandle   NDScontext;
   nuint               nameContextLen;
   pnstr8              nameContext;
   CODE:
   RETVAL = NWDSSetDefNameContext (NDScontext, nameContextLen, nameContext);
   OUTPUT:
   RETVAL



#/* Implemented in NDSContext.pm                        */
NWDSCCODE
ndsm_NWDSVerifyObjectPassword (contextHandle, optionsFlag, objectName, password)
   NWDSContextHandle   contextHandle;
   nflag32             optionsFlag;
   pnstr8              objectName;
   pnstr8              password;
   CODE:
   RETVAL = NWDSVerifyObjectPassword (contextHandle, optionsFlag, objectName, password);
   OUTPUT:
   RETVAL


#/* Implemented in NDSContext.pm */
void
ndsm_NWDSWhoAmI (NDScontext)
   NWDSContextHandle   NDScontext;
   PREINIT:
   pnstr8              objectName;
   PPCODE:
   Newz(0, objectName, 2*(MAX_DN_CHARS+1), char);
   ErrCode = NWDSWhoAmI (NDScontext, objectName);
   EXTEND(sp, 1);
   if (!ErrCode)
   {
     PUSHs(sv_2mortal((SV*)newSVpv(objectName, strlen(objectName))));
   }else{
     PUSHs(&sv_undef);
   }
   Safefree(objectName);







#/* Not used in 1.0, and it's also totally wrong implemented */
# NWDSCCODE
# ndsm_NWGetDefaultNameContext (bufferSize, NDScontext)
#   nuint16        bufferSize = NO_INIT;
#   pnstr8         NDScontext = NO_INIT;
#   CODE:
#   bufferSize = 256;
#   NDScontext = SvGROW(ST(1), bufferSize);
#   RETVAL = NWGetDefaultNameContext (bufferSize, (unsigned char*)NDScontext);
#   OUTPUT:
#   NDScontext
#        RETVAL



# /* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWGetNumConnections (numConnections)
#        nuint16          numConnections;
#   CODE:
#        RETVAL = NWGetNumConnections (&numConnections);
#        OUTPUT:
#        numConnections
#   RETVAL


# /* Implemented in Misc.pm            */
void
ndsm_NWGetNWNetVersion (void)
        PREINIT:
   nuint8                majorVersion;
   nuint8                minorVersion;
   nuint8                revisionLevel;
        nuint8                betaReleaseLevel;
   PPCODE:
   NWGetNWNetVersion(&majorVersion, &minorVersion, &revisionLevel, &betaReleaseLevel);
   EXTEND(sp, 4);
   PUSHs(sv_2mortal(newSViv(majorVersion)));
   PUSHs(sv_2mortal(newSViv(minorVersion)));
   PUSHs(sv_2mortal(newSViv(revisionLevel)));
   PUSHs(sv_2mortal(newSViv(betaReleaseLevel)));
   


# /* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWGetPreferredConnName (preferredName, preferredType)
#   pnstr8       preferredName;
#   nuint8       preferredType;
#   CODE:
#   RETVAL = NWGetPreferredConnName ((unsigned char*)preferredName, &preferredType);
#   OUTPUT:
#   preferredName
#   preferredType
#   RETVAL


# /* Not used in 1.0, move to NWServer */
# NWDSCCODE
# ndsm_NWGetPreferredDSServer (conn)
#   NWCONN_HANDLE      conn;
#   CODE:
#   RETVAL = NWGetPreferredDSServer (&conn);
#   OUTPUT:
#   conn
#   RETVAL 


#/* Implemented in NDSContext.pm
NWDSCCODE
ndsm_NWIsDSAuthenticated()
   CODE:
   RETVAL = NWIsDSAuthenticated();
   OUTPUT:
   RETVAL


# /* Not used in 1.0 */
# NWDSCCODE
# ndsm_NWIsDSServer (conn, treeName)
#   NWCONN_HANDLE   conn;
#   pnstr8          treeName;
#   CODE:
#   RETVAL = NWIsDSServer (conn, treeName);
#   OUTPUT:
#   treeName
#   RETVAL



NWDSCCODE
ndsm_NWNetInit (in, out)
   nptr   in;
   nptr   out;
   CODE:
   RETVAL = NWNetInit (in, out);
   OUTPUT:
   RETVAL


NWDSCCODE
ndsm_NWNetTerm (reserved)
   nptr   reserved;
   CODE:
   RETVAL = NWNetTerm (reserved);
   OUTPUT:
   RETVAL


# /* Not used in 1.0, and will probably never be included, see
#    NWDSSetDefNameContext() 
# */
# NWDSCCODE
# ndsm_NWSetDefaultNameContext (contextLength, NDScontext)
#   nuint16         contextLength;
#   pnstr8          NDScontext;
#   CODE:
#   RETVAL = NWSetDefaultNameContext (contextLength, (unsigned char*)NDScontext);
#   OUTPUT:
#   RETVAL                           


# /* Not included in 1.0 */
# NWDSCCODE
# ndsm_NWSetPreferredDSTree (length, tree)
#   nuint16   length = NO_INIT;
#   pnstr8    tree;
#   CODE:
#   length = strlen(tree);
#   RETVAL = NWSetPreferredDSTree (length, (unsigned char*)tree);
#   OUTPUT:
#   RETVAL

BOOT:
  tzset();


#
# There are no more functions defined in the
# NDS service group
#

