/*
 * This file was generated automatically by xsubpp version 1.9504 from the 
 * contents of NWServer.xs. Do not edit this file, edit NWServer.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST! 
 *
 */

#line 1 "NWServer.xs"
/*
        +==========================================================+
        |                                                          |
        |           Perl extension for NDS* and Netware*	         |
        |           -------------------------------------          |
        |           NWServer.xs : Implements methods for server    |
        |                         management.                      |
        |                                                          |
        |            by Steinar Kleven <stk@ahs.hist.no>           |
        |                                                          |
        |                  version 1.00                            |
        |                                                          |
        |                                                          |
        | Copyright (c) 1997 Steinar Kleven. All rights reserved.  |
        |   This program is NOT free software, you can NOT         |
        |   redistribute it and/or modify it.                      |
        |                                                          |
        |                                                          |
        |   * NDS and Netware are trademerks of Novell Inc.				 |
        |                                                          |
        +==========================================================+
*/


#ifdef NLM_PLATFORM
  #define N_PLAT_NETWARE
  #define N_PLAT_NLM
  #define N_ARCH_32
  #ifndef LC_ALL
    #define LC_ALL 0
  #endif  
  #undef _Windows
  #undef _WIN32
#endif



/* If you want to use the internal debugging you should define this.
   You can comment it out if you want this extension to go 1 ns. faster. 
*/

// The different debug types OR'ed

#define DBG_ARGS 1
#define DBG_NWRET 2
#define DBG_DUMP 4

#define NWSERV_DBG (DBG_ARGS|DBG_NWRET|DBG_DUMP)
//#undef NWSERV_DBG

#if (NWSERV_DBG > 0)
#define DBGMSG(_x_)  if (_dbglvl _x_){ printf("%s, %d: ",__FILE__,__LINE__); \
                     _dbgprint _x_; }
#else
#define DBGMSG(_x_) 
#endif

#if defined (_Windows) || defined(_WIN32)
  #define WIN32_LEAN_AND_MEAN
  #include <windows.h>
#endif  

/* Turn of these annoying "Structure packing size .." Warnings */
#if defined(__BORLANDC__)
        #pragma warn -pck
#endif


#/* Novell SDK includes */
#include <ntypes.h>
#include <nwnet.h>
#include <nwcalls.h>
#include <nwserver.h>
#include <nwsm.h>
#include <nwclxcon.h>
#include <nwfse.h>


#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"


/* PerlWare headers */
#include "PerlWare.h"



/* ErrCode is set to the return value of last NW* called.
   Users creating scripts based on this extension can
   retrieve this by calling LastErr at class the error aqured.
*/

NWCCODE ErrCode = 0;


#ifdef NWSERV_DBG
bool _dbglvl(int type, char *format, ...)
{
 return (type && NWSERV_DBG);
}


int _dbgprint(int type, char *format, ...)
{
   va_list ap;
   int cnt;
   va_start(ap, type);
   cnt = va_arg(ap, int);

   if (NWSERV_DBG & type)
   {
      cnt = vprintf(format, ap);
   }
   va_end(ap);
   return(cnt);
}
#endif




XS(XS_PerlWare__NWServer_constant)
{
    dXSARGS;
    if (items != 2)
	croak("Usage: PerlWare::NWServer::constant(name,arg)");
    {
	char *	name = (char *)SvPV(ST(0),na);
	int	arg = (int)SvIV(ST(1));
	long	RETVAL;
#line 131 "NWServer.xs"
        RETVAL = constant(name, arg);
#line 144 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_GetLastErr)
{
    dXSARGS;
    if (items != 0)
	croak("Usage: PerlWare::NWServer::GetLastErr()");
    {
	NWCCODE	RETVAL;
#line 140 "NWServer.xs"
                RETVAL = ErrCode;
#line 160 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_SetRegInfo)
{
    dXSARGS;
    if (items != 2)
	croak("Usage: PerlWare::NWServer::SetRegInfo(Key, Code)");
    {
	char *	Key = (char *)SvPV(ST(0),na);
	long	Code = (long)SvIV(ST(1));
#line 153 "NWServer.xs"
           libSetRegInfo(Key, Code);
#line 177 "NWServer.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_PerlWare__NWServer_NWAddTrustee)
{
    dXSARGS;
    if (items != 5)
	croak("Usage: PerlWare::NWServer::NWAddTrustee(conn, dirHandle, path, objID, rightsMask)");
    {
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(0));
	NWDIR_HANDLE	dirHandle = (NWDIR_HANDLE)SvIV(ST(1));
	pnstr8	path = (pnstr8)SvPV(ST(2),na);
	nuint32	objID = (unsigned long)SvIV(ST(3));
	nuint16	rightsMask = (unsigned short)SvIV(ST(4));
	NWCCODE	RETVAL;
#line 166 "NWServer.xs"
      RETVAL = NWAddTrustee(conn, dirHandle, path, objID, rightsMask);
#ifdef NWSERV_DBG
                printf("NWAddTrustee: %d, %d, %s, %d, %X\n", conn, dirHandle, path, objID, rightsMask);
      printf("NWAddTrustee returned %d\n", RETVAL);
#endif
#line 200 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWCallsInit)
{
    dXSARGS;
    if (items != 2)
	croak("Usage: PerlWare::NWServer::NWCallsInit(unused1,unused2)");
    {
	void *	unused1 = (void *)SvIV(ST(0));
	void *	unused2 = (void *)SvIV(ST(1));
	NWDSCCODE	RETVAL;
#line 184 "NWServer.xs"
                RETVAL = NWCallsInit(NULL, NULL);
#line 218 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWCallsTerm)
{
    dXSARGS;
    if (items != 1)
	croak("Usage: PerlWare::NWServer::NWCallsTerm(unused1)");
    {
	void * unused1 = NULL;
	NWDSCCODE	RETVAL;
#line 196 "NWServer.xs"
                RETVAL = NWCallsTerm(unused1);
#line 235 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWAttachToFileServer)
{
    dXSARGS;
    if (items != 2)
	croak("Usage: PerlWare::NWServer::NWAttachToFileServer(serverName, scopeFlag)");
    SP -= items;
    {
	pnstr8	serverName = (pnstr8)SvPV(ST(0),na);
	nuint16	scopeFlag = (unsigned short)SvIV(ST(1));
#line 209 "NWServer.xs"
        NWCONN_HANDLE                           newConnID;
#line 253 "NWServer.c"
#line 211 "NWServer.xs"
                ErrCode = NWAttachToFileServer(serverName, scopeFlag, &newConnID);
           EXTEND(sp, 1);
      if (!ErrCode)
                {
                  PUSHs(sv_2mortal((SV*)newSViv(newConnID)));
                }else{
                 PUSHs(&sv_undef);
                }
#line 263 "NWServer.c"
	PUTBACK;
	return;
    }
}

XS(XS_PerlWare__NWServer_NWSMExecuteNCFFile)
{
    dXSARGS;
    if (items != 2)
	croak("Usage: PerlWare::NWServer::NWSMExecuteNCFFile(connHandle, NCFFileName)");
    {
	NWCONN_HANDLE	connHandle = (NWCONN_HANDLE)SvIV(ST(0));
	pnstr8	NCFFileName = (pnstr8)SvPV(ST(1),na);
	NWCCODE	RETVAL;
#line 228 "NWServer.xs"
      RETVAL = NWSMExecuteNCFFile (connHandle, NCFFileName);
#line 280 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWSMLoadNLM)
{
    dXSARGS;
    if (items != 2)
	croak("Usage: PerlWare::NWServer::NWSMLoadNLM(connHandle, loadCommand)");
    {
	NWCONN_HANDLE	connHandle = (NWCONN_HANDLE)SvIV(ST(0));
	pnstr8	loadCommand = (pnstr8)SvPV(ST(1),na);
	NWCCODE	RETVAL;
#line 238 "NWServer.xs"
        RETVAL = NWSMLoadNLM (connHandle, loadCommand);
#line 298 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWSMUnloadNLM)
{
    dXSARGS;
    if (items != 2)
	croak("Usage: PerlWare::NWServer::NWSMUnloadNLM(connHandle, NLMName)");
    {
	NWCONN_HANDLE	connHandle = (NWCONN_HANDLE)SvIV(ST(0));
	pnstr8	NLMName = (pnstr8)SvPV(ST(1),na);
	NWCCODE	RETVAL;
#line 248 "NWServer.xs"
                RETVAL = NWSMUnloadNLM (connHandle, NLMName);
#line 316 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWCCCloseConn)
{
    dXSARGS;
    if (items != 1)
	croak("Usage: PerlWare::NWServer::NWCCCloseConn(connHandle)");
    {
	NWCONN_HANDLE	connHandle = (NWCONN_HANDLE)SvIV(ST(0));
	NWRCODE	RETVAL;
#line 258 "NWServer.xs"
        DBGMSG((DBG_ARGS, "NWCCCloseConn(%X)\n", connHandle));
      	RETVAL = NWCCCloseConn(connHandle);
         DBGMSG((DBG_NWRET, "NWCCCloseConn returning %X\n", RETVAL));
#line 335 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWCCGetConnRefInfo)
{
    dXSARGS;
    if (items != 2)
	croak("Usage: PerlWare::NWServer::NWCCGetConnRefInfo(connRef, infoType)");
    SP -= items;
    {
	nuint32	connRef = (unsigned long)SvIV(ST(0));
	nuint	infoType = (nuint)SvIV(ST(1));
#line 270 "NWServer.xs"
                SV*         Ret;
                nptr        value;
                nuint32     MyInt;
#line 355 "NWServer.c"
#line 274 "NWServer.xs"
                switch (infoType){
                case NWCC_INFO_AUTHENT_STATE:
                case NWCC_INFO_BCAST_STATE:
                case NWCC_INFO_CONN_NUMBER:
                case NWCC_INFO_NDS_STATE:
      case NWCC_INFO_MAX_PACKET_SIZE:
      case NWCC_INFO_LICENSE_STATE:
      case NWCC_INFO_DISTANCE:
      case NWCC_INFO_CONN_REF:
      case NWCC_INFO_USER_ID:
                        value = &MyInt;
                        ErrCode = NWCCGetConnRefInfo (connRef, infoType, sizeof(nuint32), value);
                        Ret = newSViv(MyInt);
                break;
                case NWCC_INFO_SERVER_NAME:
                case NWCC_INFO_TREE_NAME:
                        Newz(0, value, 2*(MAX_DN_CHARS+1), char);
                        ErrCode = NWCCGetConnRefInfo (connRef, infoType, 2*(MAX_DN_CHARS+1), value);
                        Ret = newSVpv((char*)value, strlen((const char*)value));
                        Safefree(value);
                break;
                default:
                        croak("Illegal key type received in NWCCGetConnRefInfo: %d.\n", infoType);
                };
                EXTEND(sp, 1);
                if (!ErrCode)
                {
                  PUSHs(sv_2mortal((SV*)Ret));
                }else{
                  PUSHs(&sv_undef);
                }
#line 388 "NWServer.c"
	PUTBACK;
	return;
    }
}

XS(XS_PerlWare__NWServer_NWCCLicenseConn)
{
    dXSARGS;
    if (items != 1)
	croak("Usage: PerlWare::NWServer::NWCCLicenseConn(conn)");
    {
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(0));
	NWRCODE	RETVAL;
#line 315 "NWServer.xs"
                RETVAL = NWCCLicenseConn(conn);
#line 404 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWCCOpenConnByName)
{
    dXSARGS;
    if (items != 5)
	croak("Usage: PerlWare::NWServer::NWCCOpenConnByName(startConnHandle, name, nameFormat, openState, tranType)");
    SP -= items;
    {
	NWCONN_HANDLE	startConnHandle = (NWCONN_HANDLE)SvIV(ST(0));
	pnstr8	name = (pnstr8)SvPV(ST(1),na);
	nuint	nameFormat = (nuint)SvIV(ST(2));
	nuint	openState = (nuint)SvIV(ST(3));
	nuint	tranType = (nuint)SvIV(ST(4));
#line 330 "NWServer.xs"
        NWCONN_HANDLE     newConnID;
#line 425 "NWServer.c"
#line 332 "NWServer.xs"
        DBGMSG((DBG_ARGS, "NWCCOpenConnByName(%d, %s, %d, %d, %d)\n",startConnHandle, name, nameFormat, openState, tranType));
        ErrCode = NWCCOpenConnByName(startConnHandle, name, nameFormat, openState, tranType, &newConnID);
        DBGMSG((DBG_DUMP, "NWCCOpenConnByName() returning conn handle %X\n", newConnID));
           EXTEND(sp, 1);
      if (!ErrCode)
                {
                  PUSHs(sv_2mortal((SV*)newSViv(newConnID)));
                }else{
                 PUSHs(&sv_undef);
                }
#line 437 "NWServer.c"
	PUTBACK;
	return;
    }
}

XS(XS_PerlWare__NWServer_NWCCOpenConnByRef)
{
    dXSARGS;
    if (items != 3)
	croak("Usage: PerlWare::NWServer::NWCCOpenConnByRef(connRef, openState, reserved)");
    SP -= items;
    {
	nuint32	connRef = (unsigned long)SvIV(ST(0));
	nuint	openState = (nuint)SvIV(ST(1));
	nuint	reserved = (nuint)SvIV(ST(2));
#line 349 "NWServer.xs"
      NWCONN_HANDLE     ConnHandle;
#line 455 "NWServer.c"
#line 351 "NWServer.xs"
      ErrCode = NWCCOpenConnByRef(connRef, openState, reserved, &ConnHandle);
      EXTEND(sp, 1);
      if (!ErrCode)
                {
         DBGMSG((DBG_DUMP, "NWCCOpenConnByRef returning connection %X\n", ConnHandle));
                   PUSHs(sv_2mortal((SV*)newSViv(ConnHandle)));
                }else{
                PUSHs(&sv_undef);
                }
#line 466 "NWServer.c"
	PUTBACK;
	return;
    }
}

XS(XS_PerlWare__NWServer_NWCCScanConnRefs)
{
    dXSARGS;
    if (items != 1)
	croak("Usage: PerlWare::NWServer::NWCCScanConnRefs(scanIterator)");
    SP -= items;
    {
	nuint32	scanIterator = (unsigned long)SvIV(ST(0));
#line 366 "NWServer.xs"
      nuint32   connRef;
#line 482 "NWServer.c"
#line 368 "NWServer.xs"
      ErrCode = NWCCScanConnRefs(&scanIterator, &connRef);
      if (!ErrCode)
                {
         EXTEND(sp, 2);
                   PUSHs(sv_2mortal((SV*)newSViv(scanIterator)));
                   PUSHs(sv_2mortal((SV*)newSViv(connRef)));
                }
#line 491 "NWServer.c"
	PUTBACK;
	return;
    }
}

XS(XS_PerlWare__NWServer_NWCCUnlicenseConn)
{
    dXSARGS;
    if (items != 1)
	croak("Usage: PerlWare::NWServer::NWCCUnlicenseConn(connHandle)");
    {
	NWCONN_HANDLE	connHandle = (NWCONN_HANDLE)SvIV(ST(0));
	NWRCODE	RETVAL;
#line 380 "NWServer.xs"
   	RETVAL = NWCCUnlicenseConn(connHandle);
#line 507 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWCheckConsolePrivileges)
{
    dXSARGS;
    if (items != 1)
	croak("Usage: PerlWare::NWServer::NWCheckConsolePrivileges(conn)");
    {
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(0));
	NWCCODE	RETVAL;
#line 392 "NWServer.xs"
         RETVAL = NWCheckConsolePrivileges(conn);
#line 524 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWCLXInit)
{
    dXSARGS;
    if (items != 2)
	croak("Usage: PerlWare::NWServer::NWCLXInit(arg1, arg2)");
    {
	void *	arg1 = (void *)SvIV(ST(0));
	void *	arg2 = (void *)SvIV(ST(1));
	NWRCODE	RETVAL;
#line 403 "NWServer.xs"
        RETVAL = NWCLXInit(NULL, NULL);
#line 542 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWCLXTerm)
{
    dXSARGS;
    if (items != 0)
	croak("Usage: PerlWare::NWServer::NWCLXTerm()");
    {
	NWRCODE	RETVAL;
#line 411 "NWServer.xs"
        RETVAL = NWCLXTerm(NULL);
#line 558 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWCreateDirectory)
{
    dXSARGS;
    if (items != 4)
	croak("Usage: PerlWare::NWServer::NWCreateDirectory(conn, dirHandle, dirPath, accessMask)");
    {
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(0));
	NWDIR_HANDLE	dirHandle = (NWDIR_HANDLE)SvIV(ST(1));
	pnstr8	dirPath = (pnstr8)SvPV(ST(2),na);
	nuint8	accessMask = (nuint8)SvIV(ST(3));
	NWCCODE	RETVAL;
#line 426 "NWServer.xs"
      RETVAL = NWCreateDirectory (conn, dirHandle, dirPath, accessMask);
#line 578 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWDeleteDirectory)
{
    dXSARGS;
    if (items != 3)
	croak("Usage: PerlWare::NWServer::NWDeleteDirectory(conn, dirHandle, dirPath)");
    {
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(0));
	NWDIR_HANDLE	dirHandle = (NWDIR_HANDLE)SvIV(ST(1));
	pnstr8	dirPath = (pnstr8)SvPV(ST(2),na);
	NWCCODE	RETVAL;
#line 439 "NWServer.xs"
      RETVAL = NWDeleteDirectory (conn, dirHandle, dirPath);
#line 597 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWDeleteTrustee)
{
    dXSARGS;
    if (items != 4)
	croak("Usage: PerlWare::NWServer::NWDeleteTrustee(conn, dirHandle, dirPath, ObjectID)");
    {
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(0));
	NWDIR_HANDLE	dirHandle = (NWDIR_HANDLE)SvIV(ST(1));
	pnstr8	dirPath = (pnstr8)SvPV(ST(2),na);
	nuint32	ObjectID = (unsigned long)SvIV(ST(3));
	NWCCODE	RETVAL;
#line 454 "NWServer.xs"
      RETVAL = NWDeleteTrustee(conn, dirHandle, dirPath, ObjectID);
#line 617 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWDisableFileServerLogin)
{
    dXSARGS;
    if (items != 1)
	croak("Usage: PerlWare::NWServer::NWDisableFileServerLogin(conn)");
    {
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(0));
	NWCCODE	RETVAL;
#line 467 "NWServer.xs"
         RETVAL = NWDisableFileServerLogin(conn);
#line 634 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWDownFileServer)
{
    dXSARGS;
    if (items != 2)
	croak("Usage: PerlWare::NWServer::NWDownFileServer(conn, forceFlag)");
    {
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(0));
	nuint8	forceFlag = (nuint8)SvIV(ST(1));
	NWCCODE	RETVAL;
#line 480 "NWServer.xs"
         RETVAL = NWDownFileServer(conn, forceFlag);
#line 652 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWDSAuthenticateConn)
{
    dXSARGS;
    if (items != 2)
	croak("Usage: PerlWare::NWServer::NWDSAuthenticateConn(context, connHandle)");
    {
	NWDSContextHandle	context = (NWDSContextHandle)SvIV(ST(0));
	NWCONN_HANDLE	connHandle = (NWCONN_HANDLE)SvIV(ST(1));
	NWDSCCODE	RETVAL;
#line 492 "NWServer.xs"
                RETVAL = NWDSAuthenticateConn(context, connHandle);
#line 670 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWDSGetConnectionInfo)
{
    dXSARGS;
    if (items != 1)
	croak("Usage: PerlWare::NWServer::NWDSGetConnectionInfo(conn)");
    SP -= items;
    {
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(0));
#line 503 "NWServer.xs"
                nuint8                              connStatus ;
                nuint8                              connType ;
                nuint8                              serverFlags;
                nuint8                              serverName;
                nuint8                              transType;
                nuint32                             transLen;
                nuint8                              transBuf;
                nuint16                             distance;
                nuint16                             maxPacketSize;
#line 695 "NWServer.c"
#line 513 "NWServer.xs"
                ErrCode = NWDSGetConnectionInfo(conn, &connStatus, &connType, &serverFlags, &serverName, &transType, &transLen, &transBuf, &distance, &maxPacketSize);
                if (!ErrCode){
                  EXTEND(sp, 9);
                  PUSHs(sv_2mortal((SV*)newSViv(connStatus)));
                  PUSHs(sv_2mortal((SV*)newSViv(connType)));
                  PUSHs(sv_2mortal((SV*)newSViv(serverFlags)));
                  PUSHs(sv_2mortal((SV*)newSViv(serverName)));
                  PUSHs(sv_2mortal((SV*)newSViv(transType)));
                  PUSHs(sv_2mortal((SV*)newSViv(transLen)));
                  PUSHs(sv_2mortal((SV*)newSViv(transBuf)));
                  PUSHs(sv_2mortal((SV*)newSViv(distance)));
                  PUSHs(sv_2mortal((SV*)newSViv(maxPacketSize)));
                }else{
                  EXTEND(sp, 1);
                  PUSHs(&sv_undef);
                }
#line 713 "NWServer.c"
	PUTBACK;
	return;
    }
}

XS(XS_PerlWare__NWServer_NWDSGetConnectionSlot)
{
    dXSARGS;
    if (items != 5)
	croak("Usage: PerlWare::NWServer::NWDSGetConnectionSlot(connType, transType, transLen, transBuf, conn)");
    {
	nuint8	connType = (nuint8)SvIV(ST(0));
	nuint8	transType = (nuint8)SvIV(ST(1));
	nuint32	transLen = (unsigned long)SvIV(ST(2));
	nuint8	transBuf = (nuint8)SvIV(ST(3));
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(4));
	NWDSCCODE	RETVAL;
#line 540 "NWServer.xs"
                RETVAL = NWDSGetConnectionSlot(connType, transType, transLen, &transBuf, &conn);
#line 733 "NWServer.c"
	sv_setiv(ST(3), (IV)transBuf);
	sv_setiv(ST(4), (IV)conn);
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWDSMapNameToID)
{
    dXSARGS;
    if (items != 3)
	croak("Usage: PerlWare::NWServer::NWDSMapNameToID(context, conn, object)");
    SP -= items;
    {
	NWDSContextHandle	context = (NWDSContextHandle)SvIV(ST(0));
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(1));
	pnstr8	object = (pnstr8)SvPV(ST(2),na);
#line 557 "NWServer.xs"
                nuint32             objectID;
#line 754 "NWServer.c"
#line 559 "NWServer.xs"
                ErrCode = NWDSMapNameToID (context, conn, object, &objectID);
           EXTEND(sp, 1);
      if (!ErrCode)
                {
                  PUSHs(sv_2mortal((SV*)newSViv(objectID)));
                }else{
                 PUSHs(&sv_undef);
                }
#line 764 "NWServer.c"
	PUTBACK;
	return;
    }
}

XS(XS_PerlWare__NWServer_NWEnableFileServerLogin)
{
    dXSARGS;
    if (items != 1)
	croak("Usage: PerlWare::NWServer::NWEnableFileServerLogin(conn)");
    {
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(0));
	NWCCODE	RETVAL;
#line 596 "NWServer.xs"
         RETVAL = NWEnableFileServerLogin(conn);
#line 780 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWGetConnectionHandle)
{
    dXSARGS;
    if (items != 3)
	croak("Usage: PerlWare::NWServer::NWGetConnectionHandle(serverName, reserved1, reserved2)");
    SP -= items;
    {
	pnstr8	serverName = (pnstr8)SvPV(ST(0),na);
	nuint16 reserved1 = NULL;
	pnuint16 reserved2 = NULL;
#line 609 "NWServer.xs"
        NWCONN_HANDLE   conn;
#line 799 "NWServer.c"
#line 611 "NWServer.xs"
      ErrCode = NWGetConnectionHandle((unsigned char*)serverName, reserved1, &conn, reserved2);
           EXTEND(sp, 1);
           if(!ErrCode)
           {
         DBGMSG((DBG_NWRET, "NWGetConnectionHandle returning %u\n", conn));
              PUSHs(sv_2mortal((SV*)newSViv(conn)));
           }else{
              PUSHs(&sv_undef);
           }
#line 810 "NWServer.c"
	PUTBACK;
	return;
    }
}

XS(XS_PerlWare__NWServer_NWGetExtendedVolumeInfo)
{
    dXSARGS;
    if (items != 2)
	croak("Usage: PerlWare::NWServer::NWGetExtendedVolumeInfo(conn, volNum)");
    SP -= items;
    {
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(0));
	nuint16	volNum = (unsigned short)SvIV(ST(1));
#line 629 "NWServer.xs"
        NWVolExtendedInfo *volinfo;
#line 827 "NWServer.c"
#line 631 "NWServer.xs"
                New(0, volinfo, 1, NWVolExtendedInfo);
#ifdef NWSERV_DBG
      printf ("XS_NWGetExtendedVolumeInfo(%d, %d\n", conn, volNum);
#endif
      ErrCode = NWGetExtendedVolumeInfo(conn, volNum, volinfo);
#ifdef NWSERV_DBG
      printf ("XS_NWGetExtendedVolumeInfo, ReturnCode: %lu\n", ErrCode);
#endif
      if (!ErrCode)
        {
        EXTEND(sp, 33);
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->volType)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->statusFlag)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->sectorSize)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->sectorsPerCluster)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->volSizeInClusters)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->freeClusters)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->subAllocFreeableClusters)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->freeableLimboSectors)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->nonfreeableLimboSectors)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->availSubAllocSectors)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->nonuseableSubAllocSectors)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->subAllocClusters)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->numDataStreams)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->numLimboDataStreams)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->oldestDelFileAgeInTicks)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->numCompressedDataStreams)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->numCompressedLimboDataStreams)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->numNoncompressibleDataStreams)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->precompressedSectors)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->compressedSectors)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->numMigratedDataStreams)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->migratedSectors)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->clustersUsedByFAT)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->clustersUsedByDirs)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->clustersUsedByExtDirs)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->totalDirEntries)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->unusedDirEntries)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->totalExtDirExtants)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->unusedExtDirExtants)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->extAttrsDefined)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->extAttrExtantsUsed)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->DirectoryServicesObjectID)));
        PUSHs(sv_2mortal((SV*)newSViv(volinfo->volLastModifiedDateAndTime)));
                }else{
        EXTEND(sp, 1);
                PUSHs(&sv_undef);
        }
      Safefree(volinfo);
#line 878 "NWServer.c"
	PUTBACK;
	return;
    }
}

XS(XS_PerlWare__NWServer_NWGetFileServerUTCTime)
{
    dXSARGS;
    if (items != 2)
	croak("Usage: PerlWare::NWServer::NWGetFileServerUTCTime(conn, time)");
    {
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(0));
	nuint32	time = (unsigned long)SvIV(ST(1));
	NWDSCCODE	RETVAL;
#line 688 "NWServer.xs"
        RETVAL = NWGetFileServerUTCTime (conn, &time);
#line 895 "NWServer.c"
	sv_setiv(ST(1), (IV)time);
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWGetNextConnectionID)
{
    dXSARGS;
    if (items != 1)
	croak("Usage: PerlWare::NWServer::NWGetNextConnectionID(conn)");
    {
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(0));
	NWDSCCODE	RETVAL;
#line 702 "NWServer.xs"
        RETVAL = NWGetNextConnectionID (&conn);
#line 913 "NWServer.c"
	sv_setiv(ST(0), (IV)conn);
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWGetObjDiskRestrictions)
{
    dXSARGS;
    if (items != 3)
	croak("Usage: PerlWare::NWServer::NWGetObjDiskRestrictions(conn, volNumber, objectID)");
    SP -= items;
    {
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(0));
	nuint8	volNumber = (nuint8)SvIV(ST(1));
	nuint32	objectID = (unsigned long)SvIV(ST(2));
#line 716 "NWServer.xs"
        nuint32        restriction;
        nuint32        inUse;
#line 934 "NWServer.c"
#line 719 "NWServer.xs"
        ErrCode = NWGetObjDiskRestrictions(conn, volNumber, objectID, &restriction, &inUse);
           if (!ErrCode)
        {
                        EXTEND(sp, 2);
        PUSHs(sv_2mortal((SV*)newSViv(restriction)));
                PUSHs(sv_2mortal((SV*)newSViv(inUse)));
                }else{
         EXTEND(sp, 1);
                PUSHs(&sv_undef);
        }
#line 946 "NWServer.c"
	PUTBACK;
	return;
    }
}

XS(XS_PerlWare__NWServer_NWGetSetCommandValue)
{
    dXSARGS;
    if (items != 2)
	croak("Usage: PerlWare::NWServer::NWGetSetCommandValue(conn, setCommand)");
    SP -= items;
    {
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(0));
	pnstr8	setCommand = (pnstr8)SvPV(ST(1),na);
#line 738 "NWServer.xs"
        NWFSE_SERVER_SET_CMDS_INFO CmdInfo;
      nuint32           startNum = 0;
      bool                                      found = 0;
#line 965 "NWServer.c"
#line 742 "NWServer.xs"
        CmdInfo.numberOfSetCommands = 1; //Just to enter the while()
      ErrCode = 0;
      while(!found && !ErrCode && (startNum < CmdInfo.numberOfSetCommands))
      {
        ErrCode = NWGetServerSetCommandsInfo (conn, startNum, &CmdInfo);
                        DBGMSG((DBG_DUMP, "%s\n", CmdInfo.setNameAndValueInfo));
        if (!stricmp((const char*)CmdInfo.setNameAndValueInfo, setCommand))
                found = TRUE;
                startNum++;
      }
      EXTEND(sp, 1);
                if (!ErrCode && found)
                {
                        DBGMSG((DBG_DUMP, "SET varable %s, type:%d\n",CmdInfo.setNameAndValueInfo, CmdInfo.setCmdType));
                        if (CmdInfo.setCmdType == FSE_TYPE_STRING)
                        {
                PUSHs(sv_2mortal((SV*)newSVpv((char*)&(CmdInfo.setNameAndValueInfo[strlen((const char*)&CmdInfo.setNameAndValueInfo)+1]), 0)));
                        }
                        else
                        {
                                DBGMSG((DBG_NWRET, "Value is %ld\n", CmdInfo.setNameAndValueInfo[strlen((const char*)CmdInfo.setNameAndValueInfo)+1]));
                        PUSHs(sv_2mortal((SV*)newSViv((long)CmdInfo.setNameAndValueInfo[strlen((const char*)CmdInfo.setNameAndValueInfo)+1])));
                        }
                }else{
                        PUSHs(&sv_undef);
                }
#line 993 "NWServer.c"
	PUTBACK;
	return;
    }
}

XS(XS_PerlWare__NWServer_NWGetVolumeNumber)
{
    dXSARGS;
    if (items != 2)
	croak("Usage: PerlWare::NWServer::NWGetVolumeNumber(conn, volName)");
    SP -= items;
    {
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(0));
	pnstr8	volName = (pnstr8)SvPV(ST(1),na);
#line 778 "NWServer.xs"
        nuint16        volNum;
#line 1010 "NWServer.c"
#line 780 "NWServer.xs"
        ErrCode = NWGetVolumeNumber(conn, volName, &volNum);
                EXTEND(sp, 1);
           if (!ErrCode)
        {
        PUSHs(sv_2mortal((SV*)newSViv(volNum)));
                }else{
                PUSHs(&sv_undef);
        }
#line 1020 "NWServer.c"
	PUTBACK;
	return;
    }
}

XS(XS_PerlWare__NWServer_NWGetVolumeName)
{
    dXSARGS;
    if (items != 2)
	croak("Usage: PerlWare::NWServer::NWGetVolumeName(conn, volNum)");
    SP -= items;
    {
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(0));
	nuint16	volNum = (unsigned short)SvIV(ST(1));
#line 797 "NWServer.xs"
                pnstr8          volName;
#line 1037 "NWServer.c"
#line 799 "NWServer.xs"
        Newz(0, volName, 17, char);
           ErrCode = NWGetVolumeName (conn, volNum, volName);
        EXTEND(sp, 1);
           if (!ErrCode && *volName != '\0')
        {
                PUSHs(sv_2mortal((SV*)newSVpv(volName, strlen(volName))));
        }else{
                PUSHs(&sv_undef);
        }
        Safefree(volName);
#line 1049 "NWServer.c"
	PUTBACK;
	return;
    }
}

XS(XS_PerlWare__NWServer_NWSetObjectVolSpaceLimit)
{
    dXSARGS;
    if (items != 4)
	croak("Usage: PerlWare::NWServer::NWSetObjectVolSpaceLimit(conn, volNum, objectID, Max)");
    {
	NWCONN_HANDLE	conn = (NWCONN_HANDLE)SvIV(ST(0));
	nuint16	volNum = (unsigned short)SvIV(ST(1));
	nuint32	objectID = (unsigned long)SvIV(ST(2));
	nuint32	Max = (unsigned long)SvIV(ST(3));
	NWCCODE	RETVAL;
#line 821 "NWServer.xs"
#ifdef NWSERV_DBG
        printf("XS_NWSetObjectVolSpaceLimit, 4000 bytes Units: %lu\n", Max);
#endif
      RETVAL = NWSetObjectVolSpaceLimit(conn, volNum, objectID, Max);
#line 1071 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWSMSetDynamicCmdIntValue)
{
    dXSARGS;
    if (items != 3)
	croak("Usage: PerlWare::NWServer::NWSMSetDynamicCmdIntValue(connHandle, setCommandName, cmdValue)");
    {
	NWCONN_HANDLE	connHandle = (NWCONN_HANDLE)SvIV(ST(0));
	pnstr8	setCommandName = (pnstr8)SvPV(ST(1),na);
	nuint32	cmdValue = (unsigned long)SvIV(ST(2));
	NWCCODE	RETVAL;
#line 837 "NWServer.xs"
      RETVAL = NWSMSetDynamicCmdIntValue(connHandle, setCommandName, cmdValue);
#line 1090 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_PerlWare__NWServer_NWSMSetDynamicCmdStrValue)
{
    dXSARGS;
    if (items != 3)
	croak("Usage: PerlWare::NWServer::NWSMSetDynamicCmdStrValue(connHandle, setCommandName, cmdValue)");
    {
	NWCONN_HANDLE	connHandle = (NWCONN_HANDLE)SvIV(ST(0));
	pnstr8	setCommandName = (pnstr8)SvPV(ST(1),na);
	pnstr8	cmdValue = (pnstr8)SvPV(ST(2),na);
	NWCCODE	RETVAL;
#line 850 "NWServer.xs"
           DBGMSG((DBG_ARGS, "NWSMSetDynamicCmdStrValue(%lu, %s, %s)\n", connHandle,
                        setCommandName, cmdValue));
      RETVAL = NWSMSetDynamicCmdStrValue(connHandle, setCommandName, cmdValue);
           DBGMSG((DBG_NWRET, "NWSMSetDynamicCmdStrValue() returned %X\n", RETVAL));
#line 1112 "NWServer.c"
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_PerlWare__NWServer)
{
    dXSARGS;
    char* file = __FILE__;

    XS_VERSION_BOOTCHECK ;

        newXSproto("PerlWare::NWServer::constant", XS_PerlWare__NWServer_constant, file, "$$");
        newXSproto("PerlWare::NWServer::GetLastErr", XS_PerlWare__NWServer_GetLastErr, file, "");
        newXSproto("PerlWare::NWServer::SetRegInfo", XS_PerlWare__NWServer_SetRegInfo, file, "$$");
        newXSproto("PerlWare::NWServer::NWAddTrustee", XS_PerlWare__NWServer_NWAddTrustee, file, "$$$$$");
        newXSproto("PerlWare::NWServer::NWCallsInit", XS_PerlWare__NWServer_NWCallsInit, file, "$$");
        newXSproto("PerlWare::NWServer::NWCallsTerm", XS_PerlWare__NWServer_NWCallsTerm, file, "$");
        newXSproto("PerlWare::NWServer::NWAttachToFileServer", XS_PerlWare__NWServer_NWAttachToFileServer, file, "$$");
        newXSproto("PerlWare::NWServer::NWSMExecuteNCFFile", XS_PerlWare__NWServer_NWSMExecuteNCFFile, file, "$$");
        newXSproto("PerlWare::NWServer::NWSMLoadNLM", XS_PerlWare__NWServer_NWSMLoadNLM, file, "$$");
        newXSproto("PerlWare::NWServer::NWSMUnloadNLM", XS_PerlWare__NWServer_NWSMUnloadNLM, file, "$$");
        newXSproto("PerlWare::NWServer::NWCCCloseConn", XS_PerlWare__NWServer_NWCCCloseConn, file, "$");
        newXSproto("PerlWare::NWServer::NWCCGetConnRefInfo", XS_PerlWare__NWServer_NWCCGetConnRefInfo, file, "$$");
        newXSproto("PerlWare::NWServer::NWCCLicenseConn", XS_PerlWare__NWServer_NWCCLicenseConn, file, "$");
        newXSproto("PerlWare::NWServer::NWCCOpenConnByName", XS_PerlWare__NWServer_NWCCOpenConnByName, file, "$$$$$");
        newXSproto("PerlWare::NWServer::NWCCOpenConnByRef", XS_PerlWare__NWServer_NWCCOpenConnByRef, file, "$$$");
        newXSproto("PerlWare::NWServer::NWCCScanConnRefs", XS_PerlWare__NWServer_NWCCScanConnRefs, file, "$");
        newXSproto("PerlWare::NWServer::NWCCUnlicenseConn", XS_PerlWare__NWServer_NWCCUnlicenseConn, file, "$");
        newXSproto("PerlWare::NWServer::NWCheckConsolePrivileges", XS_PerlWare__NWServer_NWCheckConsolePrivileges, file, "$");
        newXSproto("PerlWare::NWServer::NWCLXInit", XS_PerlWare__NWServer_NWCLXInit, file, "$$");
        newXSproto("PerlWare::NWServer::NWCLXTerm", XS_PerlWare__NWServer_NWCLXTerm, file, "");
        newXSproto("PerlWare::NWServer::NWCreateDirectory", XS_PerlWare__NWServer_NWCreateDirectory, file, "$$$$");
        newXSproto("PerlWare::NWServer::NWDeleteDirectory", XS_PerlWare__NWServer_NWDeleteDirectory, file, "$$$");
        newXSproto("PerlWare::NWServer::NWDeleteTrustee", XS_PerlWare__NWServer_NWDeleteTrustee, file, "$$$$");
        newXSproto("PerlWare::NWServer::NWDisableFileServerLogin", XS_PerlWare__NWServer_NWDisableFileServerLogin, file, "$");
        newXSproto("PerlWare::NWServer::NWDownFileServer", XS_PerlWare__NWServer_NWDownFileServer, file, "$$");
        newXSproto("PerlWare::NWServer::NWDSAuthenticateConn", XS_PerlWare__NWServer_NWDSAuthenticateConn, file, "$$");
        newXSproto("PerlWare::NWServer::NWDSGetConnectionInfo", XS_PerlWare__NWServer_NWDSGetConnectionInfo, file, "$");
        newXSproto("PerlWare::NWServer::NWDSGetConnectionSlot", XS_PerlWare__NWServer_NWDSGetConnectionSlot, file, "$$$$$");
        newXSproto("PerlWare::NWServer::NWDSMapNameToID", XS_PerlWare__NWServer_NWDSMapNameToID, file, "$$$");
        newXSproto("PerlWare::NWServer::NWEnableFileServerLogin", XS_PerlWare__NWServer_NWEnableFileServerLogin, file, "$");
        newXSproto("PerlWare::NWServer::NWGetConnectionHandle", XS_PerlWare__NWServer_NWGetConnectionHandle, file, "$$$");
        newXSproto("PerlWare::NWServer::NWGetExtendedVolumeInfo", XS_PerlWare__NWServer_NWGetExtendedVolumeInfo, file, "$$");
        newXSproto("PerlWare::NWServer::NWGetFileServerUTCTime", XS_PerlWare__NWServer_NWGetFileServerUTCTime, file, "$$");
        newXSproto("PerlWare::NWServer::NWGetNextConnectionID", XS_PerlWare__NWServer_NWGetNextConnectionID, file, "$");
        newXSproto("PerlWare::NWServer::NWGetObjDiskRestrictions", XS_PerlWare__NWServer_NWGetObjDiskRestrictions, file, "$$$");
        newXSproto("PerlWare::NWServer::NWGetSetCommandValue", XS_PerlWare__NWServer_NWGetSetCommandValue, file, "$$");
        newXSproto("PerlWare::NWServer::NWGetVolumeNumber", XS_PerlWare__NWServer_NWGetVolumeNumber, file, "$$");
        newXSproto("PerlWare::NWServer::NWGetVolumeName", XS_PerlWare__NWServer_NWGetVolumeName, file, "$$");
        newXSproto("PerlWare::NWServer::NWSetObjectVolSpaceLimit", XS_PerlWare__NWServer_NWSetObjectVolSpaceLimit, file, "$$$$");
        newXSproto("PerlWare::NWServer::NWSMSetDynamicCmdIntValue", XS_PerlWare__NWServer_NWSMSetDynamicCmdIntValue, file, "$$$");
        newXSproto("PerlWare::NWServer::NWSMSetDynamicCmdStrValue", XS_PerlWare__NWServer_NWSMSetDynamicCmdStrValue, file, "$$$");
    ST(0) = &sv_yes;
    XSRETURN(1);
}
