package PerlWare::NWServer;

use strict;
use PerlWare::Reg;
use vars qw($BIN_DEBUG $VERSION @ISA @EXPORT @EXPORT_OK);

require 5.0;
require Exporter;
require DynaLoader;

@ISA = qw(Exporter DynaLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(

);

$VERSION = '1.00';
bootstrap PerlWare::NWServer $VERSION;

&SetRegInfo($PerlWare::Reg::REGUSER, $PerlWare::Reg::REGCODE);

# Preloaded methods go here.

my $InitStatus = &NWCallsInit(0, 0);
die("Init failed, error: #$InitStatus\n") if ($InitStatus);
&NWCLXInit(0, 0);


END {
        &NWCallsTerm(0);
   &NWCLXTerm();
}


sub new {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = {};
        undef $self->{CONN};
        $self->{SERVER_NAME} = shift;
        $self->{IS_AUTH} = undef;
   $self->{UNLIC} = 0;   # Use in later versions to unlicense conn if we licensed it
   $self->{CLOSE} = 0;  # Use in later versions to detach is we attached.
        $self->{DEBUG} = 0;
        die("Usage: new NWServer(ServerName);\n") if (!defined($self->{SERVER_NAME}));
        bless ($self, $class);
        $self->_Init();
        $self = undef if (!defined($self->{CONN}));
   $self;
}


sub DESTROY {
        my $self = shift;
        &NWCCUnlicenseConn($self->{CONN});
        &NWCCCloseConn($self->{CONN});
}




sub Debug {
        my $self = shift;
        $self->{DEBUG} = shift;
}


#Tries several ways of getting a connection to the server
sub _Init {
   my $self = shift;
   my ($connRef, $iter, $srvName);
   $self->{CLOSE} = 1; # Defaults to close the connection after use
        if(!defined($self->{CONN})){
        # First see if we already have an connection to this server
      $iter = 0;
      while (defined($iter) && $iter != -1 && !defined($self->{CONN}))
      {
         ($iter, $connRef) = &PerlWare::NWServer::NWCCScanConnRefs($iter);
         if (defined($iter))
         {
            $srvName = &PerlWare::NWServer::NWCCGetConnRefInfo($connRef, &PerlWare::NWServer::constant("NWCC_INFO_SERVER_NAME", 0));
            if (defined($srvName) && (lc($srvName) eq lc($self->{SERVER_NAME})))
            {
               $self->{CONN} = &PerlWare::NWServer::NWCCOpenConnByRef($connRef, &constant("NWCC_OPEN_UNLICENSED", 0),
                              &constant("NWCC_RESERVED", 0));
            }
         }
      }
   }
	if (!defined($self->{CONN})){

        # We wasn't connected, and try nds server name format.
        $self->{CONN} = &NWCCOpenConnByName(0, $self->{SERVER_NAME},
        &constant("NWCC_NAME_FORMAT_NDS", 0),
         &constant("NWCC_OPEN_UNLICENSED", 0),
         &constant("NWCC_TRAN_TYPE_WILD", 0));
        }
   if (!defined($self->{CONN})){
        # We wasn't connected, and try to open a new connection.
        $self->{CONN} = &NWAttachToFileServer($self->{SERVER_NAME}, 0);

        }
   # GetConnectionHandle is obsolete, but we try it when the above fails
   if (!defined($self->{CONN})){
      $self->{CONN} = &PerlWare::NWServer::NWGetConnectionHandle($self->{SERVER_NAME}, 0, 0);
      if (defined($self->{CONN}))
      {
	   	$self->{CLOSE} = 0; # This is opened by another app.
      }
   }

   if (!defined($self->{CONN})) {
	   $self->{LAST_ERR} = &PerlWare::NWServer::GetLastErr();
      warn "_Init could not make a connection\n" if $^W;
   }
}




sub AddTrustee {
   my $self = shift;
   my ($not_used, $Path, $ObjectID, $MaskStr) = @_;
   my $Mask = &constant("TR_NONE", 0);
   if (defined($MaskStr)) {
      $Mask |= &constant("TR_SUPERVISOR", 0) if ($MaskStr =~ /S/i);
      $Mask |= &constant("TR_READ", 0) if ($MaskStr =~ /R/i);
      $Mask |= &constant("TR_WRITE", 0) if ($MaskStr =~ /W/i);
      $Mask |= &constant("TR_ERASE", 0) if ($MaskStr =~ /E/i);
      $Mask |= &constant("TR_CREATE", 0) if ($MaskStr =~ /C/i);
      $Mask |= &constant("TR_MODIFY", 0) if ($MaskStr =~ /M/i);
      $Mask |= &constant("TR_FILE_SCAN", 0) if ($MaskStr =~ /F/i);
      $Mask |= &constant("TR_ACCESS_CTRL", 0) if ($MaskStr =~ /A/i);
   }
      print "Mask: $MaskStr = $Mask\n" if $self->{DEBUG};
   return &NWAddTrustee($self->{CONN}, 0, $Path, $ObjectID, $Mask);
}


sub AuditGetObjectID {
   my $self = shift;
   my $obj = shift;
   my $audid = NWGetVolumeNumber($self->{CONN}, $obj);
   if (!defined($self->{CONN}) || !defined($audid)) {
     $self->{LAST_ERR} = PerlWare::NWServer::GetLastErr();
          warn "AuditGetObjectID returning <undef>\n" if $self->{DEBUG};
     undef;
        }else {
        my @ret = ($self->{CONN}, $audid, 0);@ret;
        }
}



sub AuthenticateConn {
        my $self = shift;
        my $Context = shift;
        if (!defined($self->{IS_AUTH})) {
          $self->{IS_AUTH} = &NWDSAuthenticateConn($Context, $self->{CONN}) ? undef : 1;
   }
   (defined($self->{IS_AUTH})) ? 0 : 1;
}




sub CheckConsolePrivileges {
          my $self = shift;
          return &NWCheckConsolePrivileges($self->{CONN});
}


sub CloseConn {
	       my $self = shift;
          if ($self->{CONN}){
          	return &NWCCCloseConn($self->{CONN});
          }
          undef $self;
          return 0;
}


sub CreateDirectory {
      my $self = shift;
      my ($dirHandle, $dirPath, $MaskStr) = @_;
                my $Mask = &constant("TA_NONE", 0);
        if (defined($MaskStr)) {
                        $Mask |= &constant("TA_READ", 0) if ($MaskStr =~ /READ/i);
           $Mask |= &constant("TA_WRITE", 0) if ($MaskStr =~ /WRITE/i);
        $Mask |= &constant("TA_OPEN", 0) if ($MaskStr =~ /OPEN/i);
        $Mask |= &constant("TA_CREATE", 0) if ($MaskStr =~ /CREATE/i);
              $Mask |= &constant("TA_DELETE", 0) if ($MaskStr =~ /DELETE/i);
           $Mask |= &constant("TA_OWNERSHIP", 0) if ($MaskStr =~ /OWNER/i);
        $Mask |= &constant("TA_SEARCH", 0) if ($MaskStr =~ /SEARCH/i);
        $Mask |= &constant("TA_MODIFY", 0) if ($MaskStr =~ /MODIFY/i);
                        $Mask |= &constant("TA_ALL", 0) if ($MaskStr =~ /ALL/i);
                }
      return &NWCreateDirectory($self->{CONN}, $dirHandle, $dirPath, $Mask);
}


sub DeleteDirectory {
      my $self = shift;
      my ($dirHandle, $dirPath) = @_;
      return &NWDeleteDirectory($self->{CONN}, $dirHandle, $dirPath);
}


sub DeleteTrustee {
      my $self = shift;
      my ($dirHandle, $dirPath, $ObjectID) = @_;
      return &NWDeleteTrustee($self->{CONN}, $dirHandle, $dirPath, $ObjectID);
}



sub DisableFileServerLogin {
      my $self = shift;
           return &NWDisableFileServerLogin($self->{CONN});
}


sub DownFileServer {
          my $self = shift;
          my ($forceFlag) = @_;
          return &NWDownFileServer($self->{CONN}, $forceFlag);
}


sub EnableFileServerLogin {
                my $self = shift;
                return &NWEnableFileServerLogin($self->{CONN});
}



sub ExecuteNCFFile {
                my $self = shift;
                my $NCFFile = shift;
                return &NWSMExecuteNCFFile($self->{CONN}, $NCFFile);
}



sub GetExtendedVolumeInfo {
                my $self = shift;
      my $volNum = shift;
                my @volinfo = &NWGetExtendedVolumeInfo($self->{CONN}, $volNum);
      if (!defined(@volinfo)) {
             $self->{LAST_ERR} = &PerlWare::NWServer::GetLastErr();
             warn "GetExtendedVolumeInfo returning <undef>\n" if $self->{DEBUG};
      }
      @volinfo;
}


sub GetHandle{
        my $self = shift;
        return $self->{CONN};
}



sub GetObjDiskRestrictions {
                my $self = shift;
      my ($volNum, $objID) = @_;
      my @volinfo = &NWGetExtendedVolumeInfo($self->{CONN}, $volNum);
      if (!defined(@volinfo)){ return &PerlWare::NWServer::GetLastErr(); }
                my @DiskRestriction = &NWGetObjDiskRestrictions($self->{CONN}, $volNum, $objID);
      if (!defined(@DiskRestriction)) {
             $self->{LAST_ERR} = &PerlWare::NWServer::GetLastErr();
             warn "GetObjDiskRestrictions returning <undef>\n" if $self->{DEBUG};
      }
                $DiskRestriction[0]/=250; $DiskRestriction[1]/=250;
      @DiskRestriction;
}



sub GetSetCommandValue {
                my $self = shift;
                my $setCommand = shift;
                my $setValue = &NWGetSetCommandValue($self->{CONN}, $setCommand);
                if (!defined($setValue)) {
             $self->{LAST_ERR} = &PerlWare::NWServer::GetLastErr();
             warn "GetSetCommandValue returning <undef>\n" if $self->{DEBUG};
      }
      $setValue;
}


sub GetVolumeName {
                my $self = shift;
                my $VolumeNum = shift;
                my $VolName = &NWGetVolumeName($self->{CONN}, $VolumeNum);
                if (!defined($VolName)) {
             $self->{LAST_ERR} = &PerlWare::NWServer::GetLastErr();
             warn "GetVolumeName returning <undef>\n" if $self->{DEBUG};
      }
      $VolName;
}


sub GetVolumeNumber {
                my $self = shift;
      my $VolumeName = shift;
      my $VolNum = NWGetVolumeNumber($self->{CONN}, $VolumeName);
      if (!defined($VolNum)) {
             $self->{LAST_ERR} = &PerlWare::NWServer::GetLastErr();
             warn "GetVolumeNumber returning <undef>\n" if $self->{DEBUG};
      }
      $VolNum;
}


sub IsInit {
        my $self=shift;
        return defined($self->{CONN});
}


sub LastErr {
                my $self = shift;
        return $self->{LAST_ERR};
}


sub LicenseConn {
                my $self = shift;
                return &NWCCLicenseConn($self->{CONN});
}


sub LoadNLM {
                my $self = shift;
                my $LoadCmd = shift;
                return &NWSMLoadNLM($self->{CONN}, $LoadCmd);
}


sub MapNameToID {
      my $self = shift;
      my ($Context, $ObjectName) = @_;
      my $IdNum = &NWDSMapNameToID($Context, $self->{CONN}, $ObjectName);
      if (!defined($IdNum)) {
             $self->{LAST_ERR} = &PerlWare::NWServer::GetLastErr();
             warn "MapNameToID returning <undef>\n" if $self->{DEBUG};
      }
      $IdNum;
}


sub SetDynamicCmdIntValue {
      my $self = shift;
      my ($commandName, $commandValue) = @_;
      return &NWSMSetDynamicCmdIntValue($self->{CONN}, $commandName, $commandValue);
}


sub SetDynamicCmdStrValue {
      my $self = shift;
      my ($commandName, $commandValue) = @_;
      return &NWSMSetDynamicCmdStrValue($self->{CONN}, $commandName, $commandValue);
}


sub SetObjectVolSpaceLimit {
      my $self = shift;
      my ($volNum, $ObjectID, $Max) = @_;
      my @volinfo = &NWGetExtendedVolumeInfo($self->{CONN}, $volNum);
      if (!defined(@volinfo)){ return &PerlWare::NWServer::GetLastErr(); }
      my $Units = ($Max*1000)/4;
      return &NWSetObjectVolSpaceLimit($self->{CONN}, $volNum, $ObjectID, $Units);
}



sub UnloadNLM {
                my $self = shift;
                my $Nlm = shift;
                return &NWSMUnloadNLM($self->{CONN}, $Nlm);
}


1;
__END__


# Autoload methods go after =cut, and are processed by the autosplit program.



