@rem = '--*-Perl-*--
@echo off
perl -x -S %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
@rem ';
#!.\perl\bin\perl
#line 8
#
# Install Perl binary distribution.
# Takes care of munging a Config.pm template.
#

use Cwd;
use Config;
use ExtUtils::Command;
use ExtUtils::Install;
use vars(%MYOPT);

print <<EOT;
This script is created to help you configure, compile and
install the Netware perl extension on your system.

EOT

if ($Config{'cc'} =~ /^cl/)
{
	$MYOPT{'CCFLAGS'} = '';
	$MYOPT{'my_libpath'} = 'Constlib\\mscvc';
   $MYOPT{'pathext'} = 'msvc';
}
elsif($Config{'cc'} =~ /^bc/)
{
# Optimizing a bit, -4 = 486 code, -R- Browser info OFF
	$MYOPT{'CCFLAGS'} = '-4 -R-';
	$MYOPT{'my_libpath'} = 'Constlib\\borland';
   $MYOPT{'pathext'} = 'bc';
}

CC:
if (yes_or_no("Do you want to compile PerlWare yourself?"))
{
   $MYOPT{'nwsdk_path'} = ask_for_it("Where is the Netware SDK installed?","c:\\nwsdk");
   warn("Sorry, `$MYOPT{'nwsdk_path'}' doesn't exist.\n"), try_again("CC") unless (-d $MYOPT{'nwsdk_path'});
	$MYOPT{'nwinc_path'} = ask_for_it("Netware SDK include files are in...",
			 "$MYOPT{'nwsdk_path'}\\include");
   warn("Sorry, `$MYOPT{'nwinc_path'}' doesn't exist.\n"), try_again("CC") unless (-d $MYOPT{'nwinc_path'});

	if ($Config{'cc'} =~ /^cl/)
	{
	$MYOPT{'nwlib_path'} = ask_for_it("The Netware SDK libraries are in...",
			 "$MYOPT{'nwsdk_path'}\\lib\\win32\\mscvc");
      warn("Sorry, `$MYOPT{'nwlib_path'}' doesn't exist.\n"), try_again("CC") unless (-d $MYOPT{'nwlib_path'});
	}
   elsif($Config{'cc'} =~ /^bc/)
   {
      $MYOPT{'nwlib_path'} = ask_for_it("The Netware SDK libraries are in...",
			 "$MYOPT{'nwsdk_path'}\\lib\\win32\\borland");
      warn("Sorry, `$MYOPT{'nwlib_path'}' doesn't exist.\n"), try_again("CC") unless (-d $MYOPT{'nwlib_path'});
   }
   else
   {
	die("Netware SDK does not have libraries for $Config{'cc'}\n");
   }
   create_mfile(".\\Makefile.PL", "PerlWare", "PerlWare.pm");
   create_mfile(".\\Buf_T\\Makefile.PL", "PerlWare::Buf_T", "..\\PerlWare.pm");
   create_mfile(".\\PerlWare\\Makefile.PL", "PerlWare::NWServer", "..\\PerlWare.pm");
   create_mfile(".\\Audit\\Makefile.PL", "PerlWare::Audit", "..\\PerlWare.pm");
	if (yes_or_no("Makefile.PLs created, build extension?"))
	{
		system('perl Makefile.PL');
		system($Config {'make'});
	if (yes_or_no("Install PerlWare?")){
			system($Config {'make'} . ' install');
      }else {
	print "\n\nRun '$Config{'make'} install' to install PerlWare\n";
	 exit;
      }
   }else {
	print "\n\nRun:\n'perl Makefile.PL'\n'$Config{'make'}'\n'$Config{'make'} install'\nto install PerlWare\n";
      exit;
   }
}
else
{
	$MYOPT{'apiversion'} = $Config{'PATCHLEVEL'};
	print "Ok, you want to install the precompiled binaries..\n";
   if($Config{'ccflags'} =~ /PERL_OBJECT/)
   {
   	$IsObject = "_object";
   }
   else
   {
   	$IsObject = "";
   }   
   $blib_dir = $Config{'baserev'}."_".$Config{'PATCHLEVEL'}."_".$MYOPT{'pathext'}.$IsObject;
   print "Looking for directory $blib_dir\n";
   if (! -d $blib_dir)
   {
		print "Sorry, no binaries for perl $Config{'baserev'} patchlevel $MYOPT{'apiversion'} $IsObject compiled with\n";
      print "$Config{'cc'}\n";
      die("Down/upgrade perl or compile PerlWare yourself\n");
   }
   elsif (yes_or_no("Found a compatible precompiled PerlWare, install it? "))
   {
	system("xcopy /s /r $blib_dir blib\\");
      &install_default("PerlWare");
   }else {exit;}
}

print <<EOT;

*******************************************************************
	Congratulations, you have completed the installation and is
	ready to start developing your own NDS and Netware utilities
	with the power of perl scripting.

	Remember to register this software if you want to use it after
	the 60 day trial period has expired.
*******************************************************************

EOT



sub yes_or_no {
    my $m = shift || "Which?";
    print "$m [y] ";
    return 1 if scalar(<STDIN>) =~ /^\s*(y|$)/i;
}

sub ask_for_it {
    my $m = shift || "Enter value";
    my $def = shift;
    $def = "" unless defined $def;
    print "$m \[$def\] ";
    my $v = <STDIN>;
    chomp $v;
    return ($v =~ /^\s*$/ ? $def : $v);
}

sub try_again {
    print "Let's try this again.\n";
    goto shift;
}

sub create_mfile {
	my $path = shift;
   my $mname = shift;
   my $ver_from = shift;
	open (MFILE, ">".$path);
	print MFILE "# Do not edit, use setup.bat\n\n\n";
   print MFILE "use ExtUtils::MakeMaker;\n";
	print MFILE "WriteMakefile(\n";
   print MFILE "\t'NAME'          => '$mname',\n";
	print MFILE "\t'VERSION_FROM'  => '$ver_from',\n";
   if ($mname eq "PerlWare"){
		print MFILE "\t'DIR'           => [qw(Buf_T Audit PerlWare)],\n";
		print MFILE "\t'LIBS'          => ['-L$MYOPT{'nwlib_path'} -L$MYOPT{'my_libpath'} -lnetwin32 -lcalwin32 -lclxwin32 -laudwin32 -llocwin32 -lConstlib'],\n";
   }else{
		print MFILE "\t'LIBS'          => ['-L$MYOPT{'nwlib_path'} -L..\\$MYOPT{'my_libpath'} -lnetwin32 -lcalwin32 -lclxwin32 -laudwin32 -llocwin32 -lConstlib'],\n";
   }
	print MFILE "\t'CCFLAGS'          => '$MYOPT{'CCFLAGS'}',\n";
	print MFILE "\t'DEFINE'        => '-DN_PLAT_WNT -DN_ARCH_32',\n";
	print MFILE "\t'INC'           => '-I$MYOPT{'nwinc_path'} -I.\\..',\n";
	print MFILE ");\n";
   close MFILE or warn("Error closing file $path");
}



__END__
:endofperl


