#!/bin/bash
#
#
# (C) 2003 Herd Software Development http://www.herdsoft.com/
# This program is free software; you can redistribute it and/or    
# modify it under the terms of the GNU General Public License as   
# published by the Free Software Foundation; either version 2 of   
# the License.              
#                                                                  
# This program is distributed in the hope that it will be useful,  
# but WITHOUT ANY WARRANTY; without even the implied warranty of   
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    
# GNU General Public License for more details.                     
#                                                                  
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software      
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        

src=`dirname $0`                # Verzeichnis mit den Sourcecodes und diesem Skript
if [ "$src" == "." ] ; then
      src=$PWD
fi

. $src/cross_nlm_parameters

download=$src/downloads
#PREFIX=/tmp/cross               #(directory in which you wish the
				# cross compiler to be installed)
copied_tmp=/tmp/copied
rm -Rf $copied_tmp
mkdir $copied_tmp

if [ ! -d "$PREFIX" ] ; then
  echo "Need to create the target dir $PREFIX"
  su -c "mkdir -p $PREFIX; chown $USER $PREFIX"
fi

tar -C $copied_tmp     --extract --gzip --file $download/libc_all.tar.gz

# --- Modify structure of libraries and header files
chmod -R u+w $copied_tmp

mkdir $copied_tmp/ndk/libc/include/netware
mv $copied_tmp/ndk/libc/include/stddef.h \
   $copied_tmp/ndk/libc/include/netware/

mkdir -p $PREFIX/$TARGET
cp -a $copied_tmp/ndk/libc/imports $PREFIX/$TARGET

# remove mmap, it is not working and should not be detected by configure scripts
mkdir -p $copied_tmp/ndk/libc/include/experimental/sys
mv $copied_tmp/ndk/libc/include/sys/mman.h \
   $copied_tmp/ndk/libc/include/experimental/sys/

if [ -x /usr/bin/recode ] &&
   ([ -x /usr/bin/sed ] || [ -x /bin/sed ]) ; then
   recode cr-lf..data <$PREFIX/$TARGET/imports/libc.imp |
   sed \
     -e "s/^\(.*mmap.*\)/#\1 # mmap does not work on Netware yet, avoid misleading configure scripts/"  \
     -e "s/^\(.*munmap.*\)/#\1 # mmap does not work on Netware yet, avoid misleading configure scripts/" \
    >$PREFIX/$TARGET/imports/libc.imp~

   mv -f $PREFIX/$TARGET/imports/libc.imp~ \
         $PREFIX/$TARGET/imports/libc.imp
fi

# --- Prepare build environments
headers=$copied_tmp/ndk/libc/include 	#(directory into which you copied the
			                # system header files)
libs=$copied_tmp/ndk/libc/lib          #(directories into which you copied the system library files)


mkdir -p $src/cross/binutils/ $src/cross/gcc/ $src/cross/gdb

if false ; then

tar -C $src --extract --gzip --file $download/gcc-${GCC_VERSION}.tar.gz
tar -C $src --extract --bzip --file $download/binutils-${BINUTILS_VERSION}.tar.bz2
tar -C $src --extract --bzip --file $download/gdb-${GDB_VERSION}.tar.bz2

# patch the binutils
(
 cd binutils-${BINUTILS_VERSION}
 patch -p1 <../binutils-netware.patch
)

# patch the gcc
(
 cd gcc-${GCC_VERSION}
 patch -p1 <../gcc-${GCC_VERSION}-netware-crosscompile.patch
)

# patch the gdb
(
 cd gdb-5.3
 patch -p1 <../gdb-5.3-nlm.patch
)

# On cygwin need one more patch to gcc
case $(uname) in
  CYGWIN*)
    (
       cd gcc-${GCC_VERSION}
       patch -p1 <../cygwin_hack.patch
    )
 ;;
esac

fi

# --- binutils

cd $src/cross/binutils

#/hdc/open_source/cvs_checkouts/binutils/cvs/src/configure \
../../binutils-${BINUTILS_VERSION}/configure \
  --target=$TARGET      --with-headers=$headers --with-libs=$libs --prefix=$PREFIX -v

make \
   all install

# --- gcc

cd $src/cross/gcc

../../gcc-${GCC_VERSION}/configure --target=$TARGET \
     --with-headers=$headers --with-libs=$libs --with-gnu-as \
     --with-ld=$PREFIX/$TARGET/bin/nlmld \
     --enable-shared \
     --prefix=$PREFIX -v

export PATH=$PATH:$PREFIX/bin

make \
   CFLAGS_FOR_TARGET="-D_POSIX_SOURCE -O2 -g" \
   all install

# create a dummy libm.a, needed so g++ configure test will work
echo "/* dummy  file */" >dummy.cpp
$TARGET-gcc -o dummy.o dummy.cpp
$TARGET-ar rcs $PREFIX/$TARGET/lib/libm.a dummy.o
rm dummy.cpp dummy.o


# --- gdb
cd $src/cross/gdb

../../gdb-${GDB_VERSION}/configure \
  --target=$TARGET      --with-headers=$headers --with-libs=$libs --prefix=$PREFIX -v

make \
   all install

# --- build mkxdc from mkxdc.c
cd $src/tools/mkxdc
rm mkxdc
make mkxdc
./mkxdc -n $PREFIX/$TARGET/imports/default.xdc

install -m 0755 --strip $src/tools/mkxdc/mkxdc $PREFIX/$TARGET/bin/mkxdc
install -m 0755 --strip $src/tools/mkxdc/mkxdc $PREFIX/bin/$TARGET-mkxdc

# --- prepare the ld wrapper
cp -p $src/cross_nlm_parameters

# --- Remove i586-netware-strip, since using it would break NLMs
rm -f "$PREFIX/$TARGET/bin/strip" "$PREFIX/bin/$TARGET-strip"

# --- Ask to compile libs
echo "Do you want to download and compile various pre-configured libraries now (y/n) ?"
read answer
if [ $answer == "y" ] ; then
   cd $src/libs
   ./compile.sh


   echo "Do you want to download and compile some example programs now (y/n) ?"
   read answer
   if [ $answer == "y" ] ; then
     cd $src/examples
     ./compile.sh
   fi
fi

# rm -Rf binutils-2.13 gdb-5.3 gcc-3.2.2 \
#      cross/gcc cross/binutils cross/gdb /tmp/copied
