#!/bin/bash
#
# This scripts builds a native GCC compiler running on netware
# based on a cross-compiler running on linux
#
# (C) 2003 Herd Software Development http://www.herdsoft.com/
# This program is free software; you can redistribute it and/or    
# modify it under the terms of the GNU General Public License as   
# published by the Free Software Foundation; either version 2 of   
# the License.              
#                                                                  
# This program is distributed in the hope that it will be useful,  
# but WITHOUT ANY WARRANTY; without even the implied warranty of   
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    
# GNU General Public License for more details.                     
#                                                                  
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software      
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

src=`dirname $0`                # Verzeichnis mit den Sourcecodes und diesem Skript
if [ "$src" == "." ] ; then
      src=$PWD
fi

. $src/cross_nlm_parameters

host=i586-netware
build=i686-pc-linux-gnu

download=$src/downloads
netware_prefix=sys:/usr              # Target prefix on the netware server
netware_image=/tmp/netware_build/usr # Temporary directory used to "install" 
copied_tmp=/tmp/copied
rm -Rf $copied_tmp
mkdir $copied_tmp



# run make transfering a lot of environment variables
function make_env ()
{
   make \
        CC_FOR_BUILD="$CC_FOR_BUILD" \
        CXX_FOR_BUILD="$CXX_FOR_BUILD" \
        CC="$CC" \
        AR="$AR" \
        RANLIB="$RANLIB" \
        GCC_FOR_TARGET="$CC_FOR_TARGET" \
        CC_FOR_TARGET="$CC_FOR_TARGET" \
        CXX_FOR_TARGET="$CC_FOR_TARGET" \
        AS_FOR_TARGET=$AS_FOR_TARGET \
        LD_FOR_TARGET=$LD_FOR_TARGET \
        AR_FOR_TARGET=$AR_FOR_TARGET \
        NM_FOR_TARGET=$NM_FOR_TARGET \
        RANLIB_FOR_TARGET=$RANLIB_FOR_TARGET \
        LDFLAGS="-s" \
        LDFLAGS_FOR_TARGET="-s" \
        "$@"
}










if false ; then
tar -C $copied_tmp     --extract --gzip --file $download/libc_all.tar.gz

# --- Modify structure of libraries and header files
chmod -R u+w $copied_tmp

mkdir $copied_tmp/ndk/libc/include/netware
mv $copied_tmp/ndk/libc/include/stddef.h \
   $copied_tmp/ndk/libc/include/netware/

mkdir -p $netware_prefix/$TARGET
cp -a $copied_tmp/ndk/libc/imports $netware_prefix/$TARGET

# remove mmap, it is not working and should not be detected by configure scripts
mkdir -p $copied_tmp/ndk/libc/include/experimental/sys
mv $copied_tmp/ndk/libc/include/sys/mman.h \
   $copied_tmp/ndk/libc/include/experimental/sys/

if [ -x /usr/bin/recode ] &&
   ([ -x /usr/bin/sed ] || [ -x /bin/sed ]) ; then
   recode cr-lf..data <$netware_prefix/$TARGET/imports/libc.imp |
   sed \
     -e "s/^\(.*mmap.*\)/#\1 # mmap does not work on Netware yet, avoid misleading configure scripts/"  \
     -e "s/^\(.*munmap.*\)/#\1 # mmap does not work on Netware yet, avoid misleading configure scripts/" \
    >$netware_prefix/$TARGET/imports/libc.imp~

   mv -f $netware_prefix/$TARGET/imports/libc.imp~ \
         $netware_prefix/$TARGET/imports/libc.imp
fi

# --- Prepare build environments
headers=$copied_tmp/ndk/libc/include 	#(directory into which you copied the
			                # system header files)
libs=$copied_tmp/ndk/libc/lib          #(directories into which you copied the system library files)
fi

mkdir -p $src/native/binutils/ $src/native/gcc/

if false; then
tar -C $src --extract --gzip --file $download/gcc-${GCC_VERSION}.tar.gz
tar -C $src --extract --bzip --file $download/binutils-${BINUTILS_VERSION}.tar.bz2
tar -C $src --extract --bzip --file $download/gdb-${GDB_VERSION}.tar.bz2

# patch the binutils
(
 cd binutils-${BINUTILS_VERSION}
 patch -p1 <../binutils-netware.patch
)

# patch the gcc
(
 cd gcc-${GCC_VERSION}
 patch -p1 <../gcc-${GCC_VERSION}-netware-crosscompile.patch
)

# patch the gdb
(
 cd gdb-5.3
 patch -p1 <../gdb-5.3-nlm.patch
)

# On cygwin need one more patch to gcc
case $(uname) in
  CYGWIN*)
    (
       cd gcc-${GCC_VERSION}
       patch -p1 <../cygwin_hack.patch
    )
 ;;
esac

fi

CC_FOR_BUILD=gcc 
CXX_FOR_BUILD=gcc 
CC="$host-gcc  -D_POSIX_SOURCE"
AR=$host-ar 
RANLIB=$host-ranlib 

CC_FOR_TARGET="$TARGET-gcc -D_POSIX_SOURCE"
GCC_FOR_TARGET="$CC_FOR_TARGET" 
AS_FOR_TARGET=$TARGET-as
LD_FOR_TARGET=$TARGET-ld
NM_FOR_TARGET=$TARGET-nm
AR_FOR_TARGET=$TARGET-ar
RANLIB_FOR_TARGET=$TARGET-ranlib

export NLM_COPYRIGHT="(C)2002 Free Software Foundation, ported by Bernd Herd http://www.herdsoft.com/"

# --- binutils

cd $src/native/binutils

if false  ; then
CC="$CC" AR="$AR" RANLIB="$RANLIB" \
../../binutils-${BINUTILS_VERSION}/configure \
     --host=$host \
     --target=$TARGET \
     --build=$build \
     --prefix=$netware_prefix -v \
     --program-suffix=.nlm
fi

#

if true ; then
   # Compile it with /usr as prefix
   make_env \
        NLM_VERSION="2,13" \
        NLM_DESCRIPTION='Component of GNU Binutils' \
        NMNEW_NLM_DESCRIPTION="Enumerate symbols in NLM object or static library" \
        NMNEW_NLM_MODULENAME="NM" \
        ASNEW_NLM_DESCRIPTION="GNU assembler" \
        ASNEW_NLM_MODULENAME="AS" \
        LDNEW_NLM_DESCRIPTION="GNU linker" \
        LDNEW_NLM_MODULENAME="LD" \
        NLMLD_NLM_DESCRIPTION="NLM linker driver" \
        NLMLD_NLM_COPYRIGHT="(C)2003 FSF, written by Bernd Herd http://www.herdsoft.com/" \
        NLMCONV_NLM_DESCRIPTION="ELF to NLM converter" \
        AR_NLM_DESCRIPTION="Static library maintainance program" \
        RANLIB_NLM_DESCRIPTION="Static library indexer" \
   all

   # but do the install with the temp dir as the prefix
   make_env \
        NLM_VERSION="2,13" \
        NLM_DESCRIPTION="Component of GNU Binutils" \
        NMNEW_NLM_DESCRIPTION="Enumerate symbols in NLM object or static library" \
        NMNEW_NLM_MODULENAME="NM" \
        ASNEW_NLM_DESCRIPTION="GNU assembler" \
        ASNEW_NLM_MODULENAME="AS" \
        LDNEW_NLM_DESCRIPTION="GNU linker" \
        LDNEW_NLM_MODULENAME="LD" \
        NLMLD_NLM_DESCRIPTION="NLM linker driver" \
        NLMLD_NLM_COPYRIGHT="(C)2003 FSF, written by Bernd Herd http://www.herdsoft.com/" \
        NLMCONV_NLM_DESCRIPTION="ELF to NLM converter" \
        AR_NLM_DESCRIPTION="Static library maintainance program" \
        RANLIB_NLM_DESCRIPTION="Static library indexer" \
        prefix=$netware_image \
   install
fi

# --- gcc

cd $src/native/gcc

if true ; then
CC="$CC" AR="$AR" RANLIB="$RANLIB" \
ac_cv_func_mmap_dev_zero=no \
ac_cv_func_mmap_anon=no \
ac_cv_func_mmap_file=no \
../../gcc-${GCC_VERSION}/configure --target=$TARGET \
     --with-gnu-as \
     --with-ld=$netware_prefix/bin/nlmld.nlm \
     --enable-shared \
     --host=$host \
     --build=$build \
     --prefix=$netware_prefix -v
fi

export PATH=$PATH:$PREFIX/bin

if true ; then
   # Compile it with /usr as prefix
   make_env \
        NLM_VERSION="3,23" \
        NLM_DESCRIPTION="Component of GNU Compiler Collection" \
        TCOLLECT2_NLM_MODULENAME="COLLECT2" \
        TCOLLECT2_NLM_DESCRIPTION="Linker tool for static constructors" \
        XGCC_NLM_DESCRIPTION="GNU C Compiler driver" \
        XGCC_NLM_MODULENAME="GCC" \
        G_NLM_DESCRIPTION="GNU C Compiler driver" \
        CC1_NLM_DESCRIPTION="C to Assembler compiler" \
        CC1PLUS_NLM_DESCRIPTION="C++ to Assembler compiler" \
        CPP_NLM_DESCRIPTION="C preprocessor" \
   all

   # but do the install with the temp dir as the prefix
   make_env \
        NLM_VERSION="3,23" \
        NLM_DESCRIPTION="Component of GNU Compiler Collection" \
        TCOLLECT2_NLM_MODULENAME="COLLECT2" \
        TCOLLECT2_NLM_DESCRIPTION="Linker tool for static constructors" \
        XGCC_NLM_DESCRIPTION="GNU C Compiler driver" \
        XGCC_NLM_MODULENAME="GCC" \
        G_NLM_DESCRIPTION="GNU C Compiler driver" \
        CC1_NLM_DESCRIPTION="C to Assembler compiler" \
        CC1PLUS_NLM_DESCRIPTION="C++ to Assembler compiler" \
        CPP_NLM_DESCRIPTION="C preprocessor" \
        prefix=$netware_image \
   install
fi

# create a dummy libm.a, needed so g++ configure test will work
echo "/* dummy  file */" >dummy.cpp
$TARGET-gcc -o dummy.o dummy.cpp
$TARGET-ar rcs $netware_image/$TARGET/lib/libm.a dummy.o
rm dummy.cpp dummy.o


# --- build mkxdc.nlm from mkxdc.c
cd $src/tools/mkxdc
rm mkxdc
make_env mkxdc

install -m 0755 $src/tools/mkxdc/mkxdc $netware_image/$TARGET/bin/mkxdc.nlm
install -m 0755 $src/tools/mkxdc/mkxdc $netware_image/bin/$TARGET-mkxdc.nlm


# --- Copy the header files
tar -C $PREFIX/$TARGET/sys-include \
   --exclude "i586-netware" --exclude "zlib" --exclude "gcc" --exclude "libiberty" --exclude "Makefile" --exclude "mt-frag" --exclude "*~" \
   --create \
    . |
   tar -C $netware_image/include \
    --extract

rm $netware_image/lib/gcc-lib/$TARGET/${GCC_VERSION}/include/limits.h
cp -p $netware_image/bin/as.nlm $netware_image/lib/gcc-lib/$TARGET/${GCC_VERSION}/


mkdir $netware_image/imports
tar -C $PREFIX/$TARGET/imports \
   --create \
    . |
   tar -C $netware_image/imports \
    --extract


# --- prepare the ld wrapper
#if [ ! -f "$netware_image/$TARGET/bin/gld" ] ; then
  
#   BIN_DIR="$netware_image/$TARGET/bin"
#   mv $BIN_DIR/ld $BIN_DIR/gld

#   cp -p $src/cross_nlm_parameters $BIN_DIR/
#   cp -p $src/scripts/ld $BIN_DIR/ld
#fi
