/* Script for ld --shared: link shared library */
OUTPUT_FORMAT("elf32-i386", "elf32-i386",
	      "elf32-i386")
OUTPUT_ARCH(i386)
SEARCH_DIR("c"); SEARCH_DIR("/usr/i586-netware/lib");
/* Do we need any of these for elf?
   __DYNAMIC = 0;    */
SECTIONS
{
  /* Read-only sections, merged into text segment: */
  . = SIZEOF_HEADERS;
  .hash          : { *(.hash)		}
  .dynsym        : { *(.dynsym)		}
  .dynstr        : { *(.dynstr)		}
  .rel.text      : { *(.rel.text .rel.text.* .rel.gnu.linkonce.t.*) }
  .rela.text     : { *(.rela.text) 	}
  .rel.data      : { *(.rel.data .rel.data.* .rel.gnu.linkonce.d.*) }
  .rela.data     : { *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*) }
  .rel.rodata    : { *(.rel.rodata .rel.rodata.* .rel.gnu.linkonce.r.*) }
  .rela.rodata   : { *(.rela.rodata) 	}
  .rel.got       : { *(.rel.got)		}
  .rela.got      : { *(.rela.got)		}
  .rel.ctors     : { *(.rel.ctors)	}
  .rela.ctors    : { *(.rela.ctors)	}
  .rel.dtors     : { *(.rel.dtors)	}
  .rela.dtors    : { *(.rela.dtors)	}
  .rel.bss       : { *(.rel.bss)		}
  .rela.bss      : { *(.rela.bss)		}
  .rel.plt       : { *(.rel.plt)		}
  .rela.plt      : { *(.rela.plt)		}
  .init          : { *(.init)	} =0x90909090
  .plt      : { *(.plt)	}
  .text      :
  {
    *(.text .stub  .text.* .gnu.linkonce.t.*)
    	. = ALIGN(4);
    	__CTOR_LIST__ = .;
    	LONG((__CTOR_END__ - __CTOR_LIST__) / 4 - 2)
    	*(.ctors)
    	LONG(0)
    	__CTOR_END__ = .;
    	__DTOR_LIST__ = .;
    	LONG((__DTOR_END__ - __DTOR_LIST__) / 4 - 2)
    	*(.dtors)
    	LONG(0)
    	__DTOR_END__ = .;
  }
  _etext = .;
  PROVIDE (etext = .);
  .fini      : { *(.fini)    } =0x90909090
  .ctors     : { *(.ctors)   }
  .dtors     : { *(.dtors)   }
  .rodata    : { *(.rodata .rodata.* .gnu.linkonce.r.*) }
  .rodata1   : { *(.rodata1) }
  .eh_frame_hdr : { *(.eh_frame_hdr) }
  /* Read-write section, merged into data segment: */
  . =  ALIGN(8) + 0x1000;
  .data    :
  {
    *(.data .data.* .gnu.linkonce.d.*)
    CONSTRUCTORS
    	. = ALIGN(4);
    *(.gcc_exc*)
    	. = ALIGN(4);
    __EH_FRAME_BEGIN__ = . ;
    *(.eh_fram*)
    __EH_FRAME_END__ = . ;
    LONG(0);
  }
  .data1   : { *(.data1) }
  .tdata	  : { *(.tdata .tdata.* .gnu.linkonce.td.*) }
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }
/*  .eh_frame       : { KEEP (*(.eh_frame)) } */
/*  .gcc_except_table   : { *(.gcc_except_table) } */
  .got           : { *(.got.plt) *(.got) }
  .dynamic       : { *(.dynamic) }
  /* We want the small data sections together, so single-instruction offsets
     can access them all, and initialized data all before uninitialized, so
     we can shorten the on-disk segment size.  */
  .sdata     : { *(.sdata) }
  _edata  =  .;
  PROVIDE (edata = .);
  __bss_start = .;
  .sbss      : { *(.sbss) *(.scommon) }
  .bss       :
  {
   *(.dynbss)
   *(.bss .bss.* .gnu.linkonce.b.*)
   *(COMMON)
   /* Align here to ensure that the .bss section occupies space up to
      _end.  Align after .bss to ensure correct alignment even if the
      .bss section disappears because there are no input sections.  */
   . = ALIGN(4);
  }
  _end = . ;
  PROVIDE (end = .);
  /* Stabs debugging sections.  */
  .stab          0 : { *(.stab) }
  .stabstr       0 : { *(.stabstr) }
  .stab.excl     0 : { *(.stab.excl) }
  .stab.exclstr  0 : { *(.stab.exclstr) }
  .stab.index    0 : { *(.stab.index) }
  .stab.indexstr 0 : { *(.stab.indexstr) }
  .comment       0 : { *(.comment) }
  /* DWARF debug sections.
     Symbols in the DWARF debugging sections are relative to the beginning
     of the section so we begin them at 0.  */
  /* DWARF 1 */
  .debug          0 : { *(.debug) }
  .line           0 : { *(.line) }
  /* GNU DWARF 1 extensions */
  .debug_srcinfo  0 : { *(.debug_srcinfo) }
  .debug_sfnames  0 : { *(.debug_sfnames) }
  /* DWARF 1.1 and DWARF 2 */
  .debug_aranges  0 : { *(.debug_aranges) }
  .debug_pubnames 0 : { *(.debug_pubnames) }
  /* DWARF 2 used by -ggdb */
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }
  .debug_abbrev   0 : { *(.debug_abbrev) }
  .debug_line     0 : { *(.debug_line) }
  .debug_frame    0 : { *(.debug_frame) }
  .debug_str      0 : { *(.debug_str) }
  .debug_loc      0 : { *(.debug_loc) }
  .debug_macinfo  0 : { *(.debug_macinfo) }
  /* SGI/MIPS DWARF 2 extensions */
  .debug_weaknames 0 : { *(.debug_weaknames) }
  .debug_funcnames 0 : { *(.debug_funcnames) }
  .debug_typenames 0 : { *(.debug_typenames) }
  .debug_varnames  0 : { *(.debug_varnames) }
}
