#ifndef __arpa_inet_h__
#define __arpa_inet_h__
/*============================================================================
=  Novell Software Development Kit
=
=  Copyright (C) 1999-2002 Novell, Inc. All Rights Reserved.
=
=  This work is subject to U.S. and international copyright laws and treaties.
=  Use and redistribution of this work is subject  to  the  license  agreement
=  accompanying  the  software  development kit (SDK) that contains this work.
=  However, no part of this work may be revised and/or  modified  without  the
=  prior  written consent of Novell, Inc. Any use or exploitation of this work
=  without authorization could subject the perpetrator to criminal  and  civil
=  liability.
=
=  Source(s): Berkeley, Various UNICES, Novell header
=
=  arpa/inet.h
==============================================================================
=  Copyright (c) 1980 Regents of the University of California. All rights
=  reserved. The Berkeley software License Agreement specifies the terms and
=  conditions for redistribution.
==============================================================================
*/
#include <netinet/in.h>


#ifdef __cplusplus
extern "C"
{
#endif

unsigned long  inet_addr    ( const char *string );
int            inet_aton    ( const char *cp, struct in_addr *addr );
struct in_addr inet_makeaddr( struct in_addr net_num, struct in_addr loc_addr );
struct in_addr inet_network ( const char *string );
char          *inet_ntoa    ( struct in_addr addr );
const char    *inet_ntop    ( int af , const void *src , char *dst,
                               size_t size );
int            inet_pton    ( long af, const char *cp, void *ap );


#ifdef __cplusplus
}
#endif

#endif
